/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.BusManagementStatusStruct;
import com.mathworks.toolbox.instrument.Gpib;
import com.mathworks.toolbox.instrument.HandshakeStatusStruct;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.IniProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

abstract class GpibDll
extends Gpib
implements ActionListener,
AutoConvertStringToMatlabChar {
    private static final int LOW = 0;
    private static final int HIGH = 1;
    private static final int DAV = 1;
    private static final int NDAC = 2;
    private static final int NRFD = 3;
    private static final int IFC = 3;
    private static final int REN = 4;
    private static final int SRQ = 5;
    private static final int ATN = 6;
    private static final int EOI = 7;
    private static final int EOIMODE = 1;
    private static final int EOSMODE = 2;
    private static final int EOSCHAR = 3;
    private static final int COMPAREBITS = 4;
    private static final int TIMEOUT = 5;
    private static final int SUCCESS = 1;
    private static final String[] gpibAdaptors = new String[]{"mwagilentgpib", "mwcbigpib", "mwcecgpib", "mwiotechgpib", "mwkeithleygpib", "mwnigpib"};
    private static final String[] gpibName = new String[]{"agilent", "cbi", "cec", "iotech", "keithley", "ni"};
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription"};
    protected static final String POWERON = "Timeout occurred during FOPEN. Make sure the instrument is powered on," + Instrument.LINESEP + "connected to the bus and at the primary " + "address specified.";
    protected static final String INUSE = "The specified configuration is not available. " + Instrument.LINESEP + "Use INSTRFIND " + "to determine if other instrument objects " + "are connected" + Instrument.LINESEP + "to the requested " + "instrument.";
    private BusManagementStatusStruct busManagementStatus = new BusManagementStatusStruct();
    private HandshakeStatusStruct handshakeStatus = new HandshakeStatusStruct();
    private Object[] info = new Object[5];
    private boolean objectPolls = false;
    private int oldTransferStatus = 0;
    private static final Object[] comVals = new Object[]{new Double(7.0), new Double(8.0)};
    private static final Object[] comVals8 = new Object[]{new Double(8.0)};
    private static final Object[] SadVals = new Object[]{new Double(0.0), new Double(96.0), new Double(97.0), new Double(98.0), new Double(99.0), new Double(100.0), new Double(101.0), new Double(102.0), new Double(103.0), new Double(104.0), new Double(105.0), new Double(106.0), new Double(107.0), new Double(108.0), new Double(109.0), new Double(110.0), new Double(111.0), new Double(112.0), new Double(113.0), new Double(114.0), new Double(115.0), new Double(116.0), new Double(117.0), new Double(118.0), new Double(119.0), new Double(120.0), new Double(121.0), new Double(122.0), new Double(123.0), new Double(124.0), new Double(125.0), new Double(126.0)};
    private static final HandshakeStatusStruct hss = new HandshakeStatusStruct();
    private static final BusManagementStatusStruct bmss = new BusManagementStatusStruct();
    static IniProp[] objectIniProps = new IniProp[]{new IniProp("BoardIndex", "double", "none", "", "", "whileopen", 1), new IniProp("BusManagementStatus", "struct", "none", "", bmss, "always", 1), new IniProp("ByteOrder", "string", "enum", Instrument.byteOVals, "littleEndian", "never", 0), new IniProp("BytesAvailable", "double", "none", "", new Integer(0), "always", 0), new IniProp("BytesAvailableAction", "action", "action", "", "", "never", 0), new IniProp("BytesAvailableActionCount", "double", "none", "", new Integer(48), "whileOpen", 0), new IniProp("BytesAvailableActionMode", "string", "enum", Gpib.dModeVals, "eosCharCode", "whileOpen", 0), new IniProp("BytesToOutput", "double", "none", "", new Integer(0), "always", 0), new IniProp("CompareBits", "double", "bounded", comVals, new Integer(8), "never", 1), new IniProp("EOIMode", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("EOSCharCode", "double", "bounded", Gpib.eosCVals, new Integer(10), "never", 1), new IniProp("EOSMode", "string", "enum", Gpib.EOSMVals, "none", "never", 1), new IniProp("ErrorAction", "action", "action", "", "", "never", 0), new IniProp("HandshakeStatus", "struct", "none", "", hss, "always", 1), new IniProp("InputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("Name", "string", "none", "", "", "never", 0), new IniProp("OutputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("OutputEmptyAction", "action", "action", "", "", "never", 0), new IniProp("PrimaryAddress", "double", "bounded", Gpib.PadVals, "", "whileOpen", 1), new IniProp("RecordDetail", "string", "enum", Instrument.RDetVals, "compact", "never", 0), new IniProp("RecordMode", "string", "enum", Instrument.RModeVals, "overwrite", "whileRecording", 0), new IniProp("RecordName", "string", "none", "", "record.txt", "whileRecording", 0), new IniProp("RecordStatus", "string", "enum", Instrument.boolVals, "off", "always", 0), new IniProp("SecondaryAddress", "double", "enum", SadVals, new Integer(0), "whileOpen", 1), new IniProp("Status", "string", "enum", Instrument.StatVals, "closed", "always", 0), new IniProp("Tag", "string", "none", "", "", "never", 0), new IniProp("Timeout", "double", "none", "", new Integer(10), "never", 0), new IniProp("TimerAction", "action", "action", "", "", "never", 0), new IniProp("TimerPeriod", "double", "none", "", new Integer(1), "whileOpen", 0), new IniProp("TransferStatus", "string", "enum", Gpib.TranSVals, "idle", "always", 0), new IniProp("Type", "string", "none", "", "gpib", "always", 0), new IniProp("UserData", "any", "none", "", new double[0], "never", 0), new IniProp("ValuesReceived", "double", "none", "", new Integer(0), "always", 0), new IniProp("ValuesSent", "double", "none", "", new Integer(0), "always", 0)};
    static final int FBOARDINDEX = 0;
    static final int FCOMPARE_BITS = 8;
    static final int FNAME = 15;
    static final int FPRIMARYADDRESS = 18;
    static final int FSECONDARYADDRESS = 23;

    public final void setBusManagementStatus(BusManagementStatusStruct busManagementStatusStruct) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("BusManagementStatus"));
    }

    public final BusManagementStatusStruct getBusManagementStatus() {
        if (this.status == 1) {
            this.busManagementStatus.setInterfaceClear(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 3)));
            this.busManagementStatus.setRemoteEnable(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 4)));
            this.busManagementStatus.setServiceRequest(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 5)));
            this.busManagementStatus.setAttention(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 6)));
            this.busManagementStatus.setEndOrIdentify(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 7)));
        }
        return this.busManagementStatus;
    }

    public final void setHandshakeStatus(HandshakeStatusStruct handshakeStatusStruct) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("HandshakeStatus"));
    }

    public final HandshakeStatusStruct getHandshakeStatus() {
        if (this.status == 1) {
            this.handshakeStatus.setDataValid(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 1)));
            this.handshakeStatus.setNotDataAccepted(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 2)));
            this.handshakeStatus.setNotReadyForData(this.int2OnOff(this.Lines(this.handle, this.boardIndex, 3)));
        }
        return this.handshakeStatus;
    }

    protected void nameStandardFormat() {
        if (this.name.equals("GPIB" + this.boardIndex + "-" + this.primaryAddress)) {
            this.nameStandardFormat = true;
            return;
        }
        if (this.name.equals("GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress)) {
            this.nameStandardFormat = true;
            return;
        }
        this.nameStandardFormat = false;
    }

    protected final void updateNameProperties() {
        if (this.nameStandardFormat) {
            if (this.secondaryAddress == 0) {
                this.name = "GPIB" + this.boardIndex + "-" + this.primaryAddress;
                return;
            }
            this.name = "GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress;
        }
    }

    protected final void setHardwareCompareBits(int n) throws IniException {
        int n2 = this.Set(this.handle, 4, n);
        if (n2 < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
        }
    }

    protected final void setHardwareEOIMode(boolean bl) throws IniException {
        int n = this.Set(this.handle, 1, this.bool2int(bl));
        if (n < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    protected final void setHardwareEOSChar(int n) throws IniException {
        int n2 = this.Set(this.handle, 3, n);
        if (n2 < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
        }
    }

    protected final void setHardwareEOSMode(int n) throws IniException {
        int n2 = this.Set(this.handle, 2, n);
        if (n2 < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
        }
    }

    protected final int[] getValidSecondaryAddress() {
        int[] nArray = new int[]{96, 126};
        return nArray;
    }

    protected void setHardwareTimeout(double d) throws IniException {
        int n = this.SetDouble(this.handle, 5, d);
        if (n < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    protected double getHardwareTimeout() {
        return this.GetDouble(this.handle, 5);
    }

    public GpibDll() throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'gpib'.");
        }
        this.objectProps = objectIniProps;
    }

    public void configureProps(String string, String string2, int n, int n2, boolean bl) {
        this.boardIndex = n;
        this.primaryAddress = n2;
        this.updateNameProperties();
        this.type = "gpib";
        this.objectPolls = bl;
        this.info[0] = string;
        this.info[2] = string2;
        this.info[1] = Instrument.jarVersion();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        this.executeEvent(6, "Timer", this.eventTime, new IniEvent("Timer", Instrument.constructClockVector(this.eventTime)));
    }

    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "GpibDllTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    protected void openHardware() throws IniException {
        if (this.isInUse()) {
            this.displayError(INUSE);
        }
        this.handle = this.Create(this.boardIndex, this.primaryAddress, this.secondaryAddress, this.timeout, this.eoiMode, false);
        if (this.handle < 1) {
            String string = this.TranslateErrorCode(this.handle, this.handle);
            if (string.indexOf("timeout") != -1) {
                string = POWERON;
            }
            this.displayError("GPIB: " + string);
        }
    }

    protected void addToPoller() {
        if (this.objectPolls) {
            Poller.addInstrument(this);
        }
        if (this.timerAction != Instrument.ACTION) {
            if (!this.wasTimerStarted) {
                this.createTimer();
                return;
            }
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    protected void closeHardware() throws IniException {
        int n;
        if (this.objectPolls) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if ((n = this.Close(this.handle)) < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    protected void hardwareStopAsync() throws IniException {
        int n;
        this.oldTransferStatus = this.transferStatus;
        this.hardwareFlushOutputVector();
        if (this.status == 1 && (n = this.StopAsync(this.handle)) < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
        this.transferStatus = 0;
    }

    public final Object[] constructorargs() {
        Object[] objectArray = new Object[]{(String)this.info[0], new Integer(this.boardIndex), new Integer(this.primaryAddress)};
        return objectArray;
    }

    protected void hardwareFlushOutput() throws IniException {
        int n;
        this.oldTransferStatus = this.transferStatus;
        this.hardwareFlushOutputVector();
        if (this.status == 1 && this.oldTransferStatus == 2 && (n = this.StopAsync(this.handle)) < 1) {
            this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
        this.transferStatus = 0;
    }

    protected void hardwareFlushOutputVector() {
        try {
            this.flushOutputVector();
        }
        catch (Exception exception) {}
        this.bytesToOutput = 0;
        this.transferStatus = 0;
    }

    protected void verifyWriteOperation() throws IniException {
        if (this.transferStatus == 2) {
            this.displayError("An asynchronous write is already in progress.");
            return;
        }
        if (this.transferStatus == 1) {
            this.displayError("An asynchronous read is already in progress.");
        }
    }

    protected void verifyReadOperation() throws IniException {
        if (this.transferStatus == 2) {
            this.displayError("An asynchronous write is already in progress.");
        } else if (this.transferStatus == 1) {
            this.displayError("An asynchronous read is already in progress.");
        }
        this.transferStatus = 1;
    }

    public final void poll() {
        try {
            if (this.readAsyncCount > 0 && !this.readingFromHardware) {
                this.pollingRead();
            }
            if (this.dataAvailableOutputVector()) {
                this.pollingWrite();
            }
            if (this.isActionAvailable()) {
                int n = this.getNextAction();
                int n2 = this.getNextAction();
                if (n == 1) {
                    if (this.transferStatus == 2) {
                        n = 2;
                    } else if (this.transferStatus == 1) {
                        n = 1;
                    } else if (this.oldTransferStatus == 2) {
                        n = 2;
                    } else if (this.oldTransferStatus == 1) {
                        n = 1;
                    } else {
                        return;
                    }
                }
                switch (n) {
                    case 0: {
                        this.pollingReadActionSuccess(n2);
                        break;
                    }
                    case 1: {
                        this.pollingReadActionSize(n2);
                        break;
                    }
                    case 2: {
                        this.pollingWriteAction();
                    }
                }
            }
            this.checkForAsynchronousTimeouts();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private final void pollingRead() {
        int n;
        int n2;
        this.transferStatus = 1;
        this.readingFromHardware = true;
        if (this.bytesAvailableActionMode == 1) {
            n2 = this.bytesAvailableActionCount - this.bytesAvailable % this.bytesAvailableActionCount;
            if (n2 > this.readAsyncCount) {
                n2 = this.readAsyncCount;
            }
        } else {
            n2 = this.readAsyncCount;
        }
        if ((n = this.ReadBinaryByteAsync(this, this.handle, n2)) < 1) {
            this.transferStatus = 0;
            this.readAsyncCount = 0;
            this.readingFromHardware = false;
            this.readAsyncStopTime = 0.0;
            this.executeErrorEvent(Calendar.getInstance(), "GPIB: " + this.TranslateErrorCode(this.handle, n));
        }
    }

    private final void pollingWrite() throws Exception {
        try {
            this.getDoubleFromOutputVector();
            int n = this.getIntFromOutputVector();
            Object object = this.getObjectFromOutputVector();
            byte[] byArray = null;
            byArray = Instrument.platform != this.byteOrder ? BinarySwapBytes.breakdownToBytesAndSwap(object, n) : BinarySwapBytes.breakdownToBytes(object, n);
            int n2 = this.WriteBinaryByteAsync(this, this.handle, byArray, byArray.length);
            if (n2 < 1) {
                this.transferStatus = 0;
                this.bytesToOutput = 0;
                this.valuesSent += this.valuesToOutput;
                this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
                return;
            }
            this.writeStopTime = (double)System.currentTimeMillis() + this.timeout * 1000.0;
            this.valuesToOutput = byArray.length / Instrument.DATASIZE[n];
            return;
        }
        catch (Exception exception) {
            this.hardwareFlushOutput();
            this.executeErrorEvent(Calendar.getInstance(), "VISA: Error while writing data.");
            return;
        }
    }

    protected int writeAsciiToHardware(String string) {
        return this.Write(this.handle, string, string.length(), this.bool2int(this.eoiMode));
    }

    protected int writeSwappedBytes(Object object, int n, int n2) {
        Object object2 = null;
        try {
            object2 = BinarySwapBytes.swap(object, n2, n);
        }
        catch (Exception exception) {
            return -1;
        }
        switch (n2) {
            case 0: 
            case 5: {
                return this.WriteBinaryByte(this.handle, (byte[])object2, n, this.bool2int(this.eoiMode));
            }
            case 1: {
                return this.WriteBinaryShort(this.handle, (short[])object2, n, this.bool2int(this.eoiMode));
            }
            case 2: {
                return this.WriteBinaryInt(this.handle, (int[])object2, n, this.bool2int(this.eoiMode));
            }
            case 3: {
                return this.WriteBinaryFloat(this.handle, (float[])object2, n, this.bool2int(this.eoiMode));
            }
            case 4: {
                return this.WriteBinaryDouble(this.handle, (double[])object2, n, this.bool2int(this.eoiMode));
            }
        }
        return -1;
    }

    protected int writeBytes(Object object, int n, int n2) {
        if (object instanceof byte[]) {
            return this.WriteBinaryByte(this.handle, (byte[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Byte) {
            return this.WriteBinaryByte(this.handle, Instrument.object2byteArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof short[]) {
            return this.WriteBinaryShort(this.handle, (short[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Short) {
            return this.WriteBinaryShort(this.handle, this.object2shortArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof int[]) {
            return this.WriteBinaryInt(this.handle, (int[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Integer) {
            return this.WriteBinaryInt(this.handle, this.object2intArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof float[]) {
            return this.WriteBinaryFloat(this.handle, (float[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Float) {
            return this.WriteBinaryFloat(this.handle, this.object2floatArray(object), n, this.bool2int(this.eoiMode));
        }
        if (object instanceof double[]) {
            return this.WriteBinaryDouble(this.handle, (double[])object, n, this.bool2int(this.eoiMode));
        }
        if (object instanceof Double) {
            return this.WriteBinaryDouble(this.handle, this.object2doubleArray(object), n, this.bool2int(this.eoiMode));
        }
        return -1;
    }

    protected Object[] readAsciiFromHardware(int n) {
        return this.Read(this.handle, n);
    }

    protected Object[] readBinaryFromHardware(int n) {
        return this.ReadBinary(this.handle, n, 0);
    }

    protected byte[] readAsynchronousDataFromHardware(int n) {
        return this.GetAsyncReadData(this.handle, n);
    }

    protected String getErrorMessageFromHardware(int n) {
        return "GPIB: " + this.TranslateErrorCode(this.handle, n);
    }

    protected int getSuccessValue() {
        return 1;
    }

    protected void hardwareGPIBTrigger() throws IniException {
        int n = this.Trigger(this.handle);
        if (n < 1) {
            this.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    protected void hardwareGPIBClear() throws IniException {
        int n = this.Clear(this.handle);
        if (n < 1) {
            this.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    public int spoll(int n) throws IniException {
        switch (n) {
            case 0: {
                int n2 = this.SPoll(this.handle);
                if (n2 < 1) {
                    this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n2));
                }
                return n2;
            }
            case 1: {
                double d;
                double d2 = d = (double)System.currentTimeMillis();
                double d3 = d + this.timeout * 1000.0;
                while (d2 < d3) {
                    int n3 = this.SPoll(this.handle);
                    if (n3 < 1) {
                        this.displayError("GPIB: " + this.TranslateErrorCode(this.handle, n3));
                    }
                    if (n3 == 2) {
                        return 2;
                    }
                    d2 = System.currentTimeMillis();
                }
                break;
            }
        }
        return 1;
    }

    public Object[] hardwareInfo(String string, String string2) {
        Object[] objectArray = new Object[]{string, Instrument.jarVersion(), string2, "gpib('" + string2 + "', <BID>, <PR>)", this.HwInfo(3), this.HwInfo(4)};
        return objectArray;
    }

    public static String[] findValidAdaptors(String string) throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            throw new IniException("Undefined function or variable 'instrhwinfo'.");
        }
        String[] stringArray = new String[6];
        int n = 0;
        String string2 = Instrument.platform == 0 ? ".dll" : ".so";
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                System.load(String.valueOf(string) + Instrument.FILESEP + gpibAdaptors[n2] + string2);
                stringArray[n++] = gpibName[n2];
            }
            catch (SecurityException securityException) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            ++n2;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public Object[] ObjectHardwareInfo() {
        this.info[3] = this.HwInfo(3);
        this.info[4] = this.HwInfo(4);
        return this.info;
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws IniException {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.findPropertyCompleteName(stringArray[n].toLowerCase(), HWINFO_FIELDS, stringArray[n]);
            if (this.info[n2] == null) {
                this.ObjectHardwareInfo();
            }
            objectArray[n] = this.info[n2];
            ++n;
        }
        return objectArray;
    }

    protected void updateObjectSpecificProperties(IniProp[] iniPropArray) {
        if (this.secondaryAddress == 0) {
            iniPropArray[15].setDefaultValue("GPIB" + this.boardIndex + "-" + this.primaryAddress);
        } else {
            iniPropArray[15].setDefaultValue("GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
        }
        iniPropArray[0].setDefaultValue(new Integer(this.boardIndex));
        iniPropArray[18].setDefaultValue(new Integer(this.primaryAddress));
        iniPropArray[23].setDefaultValue(new Integer(this.secondaryAddress));
        int[] nArray = this.getValidCompareBits();
        if (nArray[0] == 8) {
            iniPropArray[8].setConstraintValue(comVals8);
        }
    }

    public String display() {
        if (!this.isvalid()) {
            return this.invalidDisplay();
        }
        return String.valueOf(Instrument.LINESEP) + "   GPIB Object Using " + this.info[2] + " Adaptor : " + this.name + Instrument.LINESEP + Instrument.LINESEP + this.gpibDisplay();
    }

    public String setDisplay() throws Exception {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + Instrument.LINESEP + "    BytesAvailableAction" + Instrument.LINESEP + "    BytesAvailableActionCount" + Instrument.LINESEP + "    BytesAvailableActionMode: [ {eosCharCode} | byte ]" + Instrument.LINESEP + "    ErrorAction" + Instrument.LINESEP + "    InputBufferSize" + Instrument.LINESEP + "    Name" + Instrument.LINESEP + "    OutputBufferSize" + Instrument.LINESEP + "    OutputEmptyAction" + Instrument.LINESEP + "    RecordDetail: [ {compact} | verbose ]" + Instrument.LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + Instrument.LINESEP + "    RecordName" + Instrument.LINESEP + "    Tag" + Instrument.LINESEP + "    Timeout" + Instrument.LINESEP + "    TimerAction" + Instrument.LINESEP + "    TimerPeriod" + Instrument.LINESEP + "    UserData" + Instrument.LINESEP + "    " + Instrument.LINESEP + "    GPIB specific properties:" + Instrument.LINESEP + "    BoardIndex" + Instrument.LINESEP + "    CompareBits" + Instrument.LINESEP + "    EOIMode: [ {on} | off ]" + Instrument.LINESEP + "    EOSCharCode" + Instrument.LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + Instrument.LINESEP + "    PrimaryAddress" + Instrument.LINESEP + "    SecondaryAddress" + Instrument.LINESEP + " " + Instrument.LINESEP;
    }

    abstract int Create(int var1, int var2, int var3, double var4, boolean var6, boolean var7);

    abstract int Close(int var1);

    abstract int Clear(int var1);

    abstract int Set(int var1, int var2, int var3);

    abstract int SetDouble(int var1, int var2, double var3);

    abstract double GetDouble(int var1, int var2);

    abstract int Write(int var1, String var2, int var3, int var4);

    abstract int WriteBinaryByte(int var1, byte[] var2, int var3, int var4);

    abstract int WriteBinaryShort(int var1, short[] var2, int var3, int var4);

    abstract int WriteBinaryInt(int var1, int[] var2, int var3, int var4);

    abstract int WriteBinaryFloat(int var1, float[] var2, int var3, int var4);

    abstract int WriteBinaryDouble(int var1, double[] var2, int var3, int var4);

    abstract int WriteBinaryChar(int var1, char[] var2, int var3, int var4);

    abstract Object[] Read(int var1, int var2);

    abstract Object[] ReadBinary(int var1, int var2, int var3);

    abstract int WriteBinaryByteAsync(Instrument var1, int var2, byte[] var3, int var4);

    abstract int ReadBinaryByteAsync(Instrument var1, int var2, int var3);

    abstract byte[] GetAsyncReadData(int var1, int var2);

    abstract int StopAsync(int var1);

    abstract int Trigger(int var1);

    abstract int Lines(int var1, int var2, int var3);

    abstract String HwInfo(int var1);

    abstract int[] FindBoards();

    abstract int SPoll(int var1);

    abstract String TranslateErrorCode(int var1, int var2);
}

