/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.GpibDll;
import com.mathworks.toolbox.instrument.GpibVisa;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.Instrument;
import java.io.IOException;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.Vector;

abstract class Gpib
extends Instrument {
    protected static final int NONE = 0;
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int READWRITE = 3;
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final int VENDOR_DRIVER_NAME = 3;
    protected static final int VENDOR_DRIVER_DESCRIPTION = 4;
    protected static final int VENDOR_DRIVER_VERSION = 5;
    protected int boardIndex;
    protected int compareBits = 8;
    protected boolean eoiMode = true;
    protected int eosCharCode = 10;
    protected int eosMode = 0;
    protected int primaryAddress;
    protected int secondaryAddress;
    protected byte[] eosCharByteArray = new byte[1];
    protected Vector dataReadLength = new Vector();
    protected int previousReadAction = 0;
    protected boolean readingFromHardware = false;
    protected int valuesToOutput;
    protected double writeStopTime;
    protected static final String[] dModeVals = new String[]{"eosCharCode", "byte"};
    protected static final Object[] eosCVals = new Object[]{new Double(0.0), new Double(255.0)};
    protected static final Object[] PadVals = new Object[]{new Double(0.0), new Double(30.0)};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write"};
    protected static final String[] EOSMVals = new String[]{"none", "read", "write", "read&write"};

    public final void setBoardIndex(int n) throws IniException {
        if (this.status == 1) {
            this.displayError("BoardIndex cannot be set while OBJ is open.");
        }
        this.boardIndex = n;
        this.updateNameProperties();
    }

    public final int getBoardIndex() {
        return this.boardIndex;
    }

    public final void setCompareBits(int n) throws IniException {
        int[] nArray = this.getValidCompareBits();
        if (!this.verifySetRange(n, nArray[0], nArray[1])) {
            this.displayError("CompareBits could not be set to the specified value.");
        }
        if (this.status == 0) {
            this.compareBits = n;
            return;
        }
        try {
            this.setHardwareCompareBits(n);
            this.compareBits = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getCompareBits() {
        return this.compareBits;
    }

    public final void setEOIMode(boolean bl) throws IniException {
        if (this.status == 0) {
            this.eoiMode = bl;
            return;
        }
        try {
            this.setHardwareEOIMode(bl);
            this.eoiMode = bl;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final boolean getEOIMode() {
        return this.eoiMode;
    }

    public final void setEOSCharCode(int n) throws IniException {
        if (!this.verifySetRange(n, 0, 255)) {
            this.displayError("EOSCharCode must range between 0 and 255.");
        }
        if (this.status == 0) {
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)n;
            return;
        }
        try {
            this.setHardwareEOSChar(n);
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)this.eosCharCode;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getEOSCharCode() {
        return this.eosCharCode;
    }

    public final void setEOSMode(int n) throws IniException {
        if (this.status == 0) {
            this.eosMode = n;
            return;
        }
        try {
            this.setHardwareEOSMode(n);
            this.eosMode = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getEOSMode() {
        return this.eosMode;
    }

    public final void setPrimaryAddress(int n) throws IniException {
        if (!this.verifySetRange(n, 0, 30)) {
            this.displayError("PrimaryAddress must range between 0 and 30.");
        }
        if (this.status == 1) {
            this.displayError("PrimaryAddress cannot be set while OBJ is open.");
        }
        this.primaryAddress = n;
        this.updateNameProperties();
    }

    public final int getPrimaryAddress() {
        return this.primaryAddress;
    }

    public final void setSecondaryAddress(int n) throws IniException {
        int[] nArray = this.getValidSecondaryAddress();
        if (n != 0 && !this.verifySetRange(n, nArray[0], nArray[1])) {
            this.displayError("SecondaryAddress could not be set to specified value.");
        }
        if (this.status == 1) {
            this.displayError("SecondaryAddress cannot be set while OBJ is open.");
        }
        this.secondaryAddress = n;
        this.updateNameProperties();
    }

    public final int getSecondaryAddress() {
        return this.secondaryAddress;
    }

    protected void updatePropsOnOpen() throws IniException {
        this.eosCharByteArray[0] = (byte)this.eosCharCode;
        this.setHardwareEOIMode(this.eoiMode);
        this.setHardwareEOSMode(this.eosMode);
        this.setHardwareCompareBits(this.compareBits);
        this.setHardwareEOSChar(this.eosCharCode);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
    }

    protected boolean isInUse() {
        int n = 0;
        while (n < Instrument.allInstrumentObjects.size()) {
            Gpib gpib;
            Object e = Instrument.allInstrumentObjects.elementAt(n);
            if (e instanceof GpibDll) {
                gpib = (GpibDll)e;
                if (gpib.boardIndex == this.boardIndex && gpib.primaryAddress == this.primaryAddress && gpib.secondaryAddress == this.secondaryAddress && gpib.status == 1) {
                    return true;
                }
            } else if (e instanceof GpibVisa) {
                gpib = (GpibVisa)e;
                if (gpib.boardIndex == this.boardIndex && gpib.primaryAddress == this.primaryAddress && gpib.secondaryAddress == this.secondaryAddress && gpib.status == 1) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    protected void updateWriteTransferStatus(boolean bl) {
        if (bl) {
            this.transferStatus = 2;
            return;
        }
        this.transferStatus = 0;
    }

    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
    }

    protected void hardwareFlushInput() {
        this.dataReadLength.removeAllElements();
    }

    protected void pollingReadActionSuccess(int n) {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {}
        byte[] byArray = this.readAsynchronousDataFromHardware(n);
        this.fillInBuffer(byArray, this.eosCharByteArray, byArray.length);
        if (this.previousReadAction == 0 || this.dataReadLength.size() == 0) {
            this.dataReadLength.addElement(new Integer(byArray.length));
        } else {
            int n2 = (Integer)this.dataReadLength.lastElement();
            this.dataReadLength.setElementAt(new Integer(n2 + byArray.length), this.dataReadLength.size() - 1);
        }
        this.previousReadAction = 0;
        this.transferStatus = 0;
        this.readAsyncCount = 0;
        this.readingFromHardware = false;
        this.readAsyncStopTime = 0.0;
    }

    protected void pollingReadActionSize(int n) {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {}
        byte[] byArray = this.readAsynchronousDataFromHardware(n);
        this.fillInBuffer(byArray, this.eosCharByteArray, byArray.length);
        if (this.previousReadAction == 0 || this.dataReadLength.size() == 0) {
            this.dataReadLength.addElement(new Integer(byArray.length));
        } else {
            int n2 = (Integer)this.dataReadLength.lastElement();
            this.dataReadLength.setElementAt(new Integer(n2 + byArray.length), this.dataReadLength.size() - 1);
        }
        this.previousReadAction = 1;
        if (this.readAsyncCount == 0) {
            this.transferStatus = 0;
            this.readAsyncStopTime = 0.0;
        }
        this.readingFromHardware = false;
    }

    protected void pollingWriteAction() {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {}
        this.bytesToOutput = 0;
        this.valuesSent += this.valuesToOutput;
        if (!this.outputEmptyAction.equals(Instrument.ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new IniEvent("OutputEmpty", Instrument.constructClockVector(this.eventTime)));
        }
        this.transferStatus = 0;
    }

    protected void checkForAsynchronousTimeouts() {
        if ((double)System.currentTimeMillis() > this.readAsyncStopTime && this.transferStatus == 1) {
            try {
                this.hardwareStopAsync();
            }
            catch (Exception exception) {}
            this.readAsyncCount = 0;
            this.transferStatus = 0;
            this.readingFromHardware = false;
            this.executeErrorEvent(Calendar.getInstance(), "The asynchronous read operation timed out.");
        }
        if ((double)System.currentTimeMillis() > this.writeStopTime && this.transferStatus == 2) {
            try {
                this.hardwareStopAsync();
            }
            catch (Exception exception) {}
            this.bytesToOutput = 0;
            this.transferStatus = 0;
            this.executeErrorEvent(Calendar.getInstance(), "The asynchronous write operation timed out.");
        }
    }

    protected String getAsciiMessage(Object[] objectArray) {
        String string = "";
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof String) {
                string = String.valueOf(string) + (String)objectArray[n];
            } else if (objectArray[n] instanceof Character) {
                string = String.valueOf(string) + (Character)objectArray[n];
            } else {
                switch (this.eosMode) {
                    case 2: 
                    case 3: {
                        string = String.valueOf(string) + new Character((char)this.eosCharCode);
                    }
                }
            }
            ++n;
        }
        return string;
    }

    protected Object[] writeHardwareAscii(String string) throws IniException {
        switch (this.writeTransferMode) {
            case 1: {
                return this.writeHardwareAsciiAsync(string);
            }
            case 0: {
                return this.writeHardwareAsciiSync(string);
            }
        }
        throw new IniException("Invalid TransferMode specified.");
    }

    protected Object[] writeHardwareAsciiAsync(String string) throws IniException {
        byte[] byArray = string.getBytes();
        try {
            this.putDataInOutputVector(byArray, byArray.length, 0);
        }
        catch (IOException iOException) {
            this.hardwareFlushOutput();
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{string, new Integer(0), ""};
        return objectArray;
    }

    protected Object[] writeHardwareAsciiSync(String string) {
        Object[] objectArray = new Object[3];
        int n = this.writeAsciiToHardware(string);
        if (n < this.getSuccessValue()) {
            objectArray[0] = "";
            objectArray[1] = Instrument.INTEGER_ZERO;
            objectArray[2] = this.getErrorMessageFromHardware(n);
        } else {
            objectArray[0] = string;
            objectArray[1] = new Integer(n);
            objectArray[2] = "";
        }
        return objectArray;
    }

    protected Object[] writeHardwareBinary(Object object, int n, int n2) throws IniException {
        switch (this.writeTransferMode) {
            case 1: {
                return this.writeHardwareBinaryAsync(object, n, n2);
            }
            case 0: {
                return this.writeHardwareBinarySync(object, n, n2);
            }
        }
        throw new IniException("Invalid TransferMode specified.");
    }

    protected Object[] writeHardwareBinaryAsync(Object object, int n, int n2) throws IniException {
        try {
            this.putDataInOutputVector(object, n, n2);
        }
        catch (IOException iOException) {
            this.hardwareFlushOutput();
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{Instrument.INTEGER_ZERO, ""};
        return objectArray;
    }

    protected Object[] writeHardwareBinarySync(Object object, int n, int n2) throws IniException {
        int n3 = 0;
        n3 = Instrument.platform != this.byteOrder ? this.writeSwappedBytes(object, n, n2) : this.writeBytes(object, n, n2);
        Object[] objectArray = new Object[2];
        if (n3 < this.getSuccessValue()) {
            objectArray[0] = Instrument.INTEGER_ZERO;
            objectArray[1] = this.getErrorMessageFromHardware(n3);
        } else {
            objectArray[0] = new Integer(n3);
            objectArray[1] = "";
        }
        return objectArray;
    }

    protected Object[] readHardwareAscii(int n) throws Exception {
        Object[] objectArray = new Object[2];
        String string = "";
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        int n2 = n;
        if (n == 0) {
            n2 = this.readAsyncCount;
        }
        if (this.dataReadLength.size() == 0) {
            while (this.readAsyncCount > 0 && this.bytesAvailable < n2 && (double)System.currentTimeMillis() < d) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        if (this.dataReadLength.size() != 0) {
            objectArray = this.readAsciiDataFromBuffer(objectArray, "", n);
            if (this.dataReadLength.size() >= 1 || this.dataReadLength.size() == 0 && this.previousReadAction == 0) {
                return objectArray;
            }
            string = (String)objectArray[0];
        }
        int n3 = 0;
        n3 = n == 0 ? this.inputBufferSize - string.length() : n - string.length();
        while (this.readAsyncCount > 0 && this.bytesAvailable < n3 && (double)System.currentTimeMillis() < d) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (this.dataReadLength.size() != 0) {
            objectArray = this.readAsciiDataFromBuffer(objectArray, string, n);
            if (this.dataReadLength.size() >= 1 || this.dataReadLength.size() == 0 && this.previousReadAction == 0) {
                return objectArray;
            }
            string = (String)objectArray[0];
        }
        if ((double)System.currentTimeMillis() > d) {
            objectArray[0] = string;
            objectArray[1] = this.reportTimeout(n);
            return objectArray;
        }
        n3 = 0;
        n3 = n == 0 ? this.inputBufferSize - string.length() : n - string.length();
        if (n3 == 0) {
            objectArray[1] = this.wasAsciiReadSuccessful((String)objectArray[0], n, this.getSuccessValue());
            return objectArray;
        }
        Object[] objectArray2 = this.readAsciiFromHardware(n3);
        if (!(objectArray2[0] instanceof String)) {
            Calendar.getInstance();
            objectArray[0] = string;
            objectArray[1] = this.getErrorMessageFromHardware((Integer)objectArray2[0]);
            return objectArray;
        }
        objectArray[0] = String.valueOf(string) + (String)objectArray2[0];
        objectArray[1] = this.wasAsciiReadSuccessful(String.valueOf(string) + (String)objectArray2[0], n, (Integer)objectArray2[1]);
        return objectArray;
    }

    protected Object[] readAsciiDataFromBuffer(Object[] objectArray, String string, int n) throws Exception {
        int n2 = (Integer)this.dataReadLength.firstElement();
        if (n == 0) {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n2);
            objectArray[1] = "";
            this.dataReadLength.removeElementAt(0);
        } else if (n2 < n) {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n2);
            objectArray[1] = this.wasAsciiReadSuccessful((String)objectArray[0], n, 1);
            this.dataReadLength.removeElementAt(0);
        } else if (n2 == n) {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n);
            objectArray[1] = "";
            this.dataReadLength.removeElementAt(0);
        } else {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n);
            objectArray[1] = "";
            this.dataReadLength.setElementAt(new Integer(n2 - n), 0);
        }
        return objectArray;
    }

    protected Object[] readHardwareBinary(int n, int n2) throws Exception {
        int n3 = Instrument.DATASIZE[n2];
        int n4 = n * n3;
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        Object[] objectArray = new Object[3];
        String string = "";
        while (this.readAsyncCount > 0 && this.bytesAvailable < n4 && (double)System.currentTimeMillis() < d) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (this.dataReadLength.size() > 1 || this.dataReadLength.size() == 1 && this.previousReadAction == 0) {
            int n5 = (Integer)this.dataReadLength.firstElement();
            int n6 = 0;
            if (n5 >= n4) {
                n6 = n4;
            } else {
                int n7 = n5 / n3;
                n6 = n7 * n3;
            }
            byte[] byArray = this.readBinaryDataFromBuffer(n6);
            objectArray[0] = this.convertBinaryData(byArray, n2, n6);
            objectArray[1] = new Integer(n6 / n3);
            objectArray[2] = this.wasBinaryReadSuccessful(n6 / n3, n, string);
            return objectArray;
        }
        int n8 = 0;
        n8 = this.bytesAvailable >= n4 ? 0 : n4 - this.bytesAvailable;
        if (n8 != 0) {
            Object[] objectArray2 = this.readBinaryFromHardware(n8);
            if (objectArray2.length != 1) {
                byte[] byArray = (byte[])objectArray2[0];
                int n9 = (Integer)objectArray2[1];
                int n10 = (Integer)objectArray2[2];
                this.fillInBuffer(byArray, n9);
                if (this.previousReadAction == 0 || this.dataReadLength.size() == 0) {
                    this.dataReadLength.addElement(new Integer(n9));
                } else {
                    int n11 = (Integer)this.dataReadLength.lastElement();
                    this.dataReadLength.setElementAt(new Integer(n11 + n9), this.dataReadLength.size() - 1);
                }
                this.previousReadAction = n10 == 1 ? 0 : 1;
            } else {
                string = this.getErrorMessageFromHardware((Integer)objectArray2[0]);
            }
        }
        int n12 = 0;
        if (this.bytesAvailable >= n4) {
            n12 = n4;
        } else {
            int n13 = this.bytesAvailable / n3;
            n12 = n13 * n3;
        }
        byte[] byArray = this.readBinaryDataFromBuffer(n12);
        objectArray[0] = this.convertBinaryData(byArray, n2, n12);
        objectArray[1] = new Integer(n12 / n3);
        objectArray[2] = this.wasBinaryReadSuccessful(n12 / n3, n, string);
        return objectArray;
    }

    protected byte[] readBinaryDataFromBuffer(int n) throws Exception {
        byte[] byArray = null;
        try {
            int n2 = (Integer)this.dataReadLength.firstElement();
            if (n2 <= n) {
                byArray = this.readInBuffer(n2);
                this.dataReadLength.removeElementAt(0);
            } else {
                byArray = this.readInBuffer(n);
                this.dataReadLength.setElementAt(new Integer(n2 - n), 0);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return byArray;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        if (Instrument.platform == this.byteOrder) {
            switch (Instrument.platform) {
                case 1: {
                    return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
                }
                case 0: {
                    return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
                }
                default: {
                    throw new IniException("Invalid ByteOrder specified.");
                }
            }
        }
        switch (Instrument.platform) {
            case 1: {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            case 0: {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        }
        throw new IniException("Invalid ByteOrder specified.");
    }

    protected String removeTerminator(String string) {
        switch (this.eosMode) {
            case 1: 
            case 3: {
                Character c = new Character((char)this.eosCharCode);
                if (string.endsWith(c.toString())) {
                    return string.substring(0, string.length() - 1);
                }
                return string;
            }
        }
        return string;
    }

    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        String string2 = new Character((char)this.eosCharCode).toString();
        String string3 = "";
        switch (n) {
            case 0: {
                if (n2 != this.getSuccessValue() || string.length() != this.inputBufferSize) break;
                if (this.eosMode == 1 || this.eosMode == 3) {
                    string3 = "The input buffer was filled before the EOI line was asserted or the EOSCharCode was detected.";
                    break;
                }
                string3 = "The input buffer was filled before the EOI line was asserted.";
                break;
            }
            default: {
                if (string.length() == n) break;
                if (string.endsWith(string2)) {
                    if (this.eosMode == 1 || this.eosMode == 3) {
                        string3 = "The EOSCharCode was detected before SIZE values were available.";
                        break;
                    }
                    string3 = "The EOI line was asserted before SIZE values were available.";
                    break;
                }
                string3 = "The EOI line was asserted before SIZE values were available.";
            }
        }
        return string3;
    }

    protected String wasBinaryReadSuccessful(int n, int n2, String string) {
        if (!string.equals("")) {
            return string;
        }
        if (n < n2) {
            if (this.eosMode == 1 || this.eosMode == 3) {
                return "The EOI line was asserted or the EOSCharCode was detected before SIZE values were available.";
            }
            return "The EOI line was asserted before SIZE values were available.";
        }
        return "";
    }

    protected String reportTimeout(int n) {
        if (n == 0) {
            return "A timeout occurred before the EOI line was asserted.";
        }
        if (this.eosMode == 1 || this.eosMode == 3) {
            return "A timeout occurred before the EOI line was asserted, EOSCharCode was read" + Instrument.LINESEP + " or SIZE values " + "were available.";
        }
        return "A timeout occurred before the EOI line was asserted or SIZE values were available.";
    }

    public void trigger() throws IniException {
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        try {
            this.hardwareGPIBTrigger();
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public void clrdevice() throws IniException {
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        try {
            this.hardwareGPIBClear();
            return;
        }
        catch (IniException iniException) {
            this.displayError(iniException.getMessage());
            return;
        }
    }

    protected String gpibDisplay() {
        return "   Communication Address " + Instrument.LINESEP + "      BoardIndex:         " + this.boardIndex + Instrument.LINESEP + "      PrimaryAddress:     " + this.primaryAddress + Instrument.LINESEP + "      SecondaryAddress:   " + this.secondaryAddress + Instrument.LINESEP + Instrument.LINESEP + "   Communication State " + Instrument.LINESEP + "      Status:             " + Instrument.STATUS_ENUM[this.status] + Instrument.LINESEP + "      RecordStatus:       " + Instrument.RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + Instrument.LINESEP + Instrument.LINESEP + "   Read/Write State  " + Instrument.LINESEP + "      TransferStatus:     " + Instrument.TRANSFER_STATUS_ENUM[this.transferStatus] + Instrument.LINESEP + "      BytesAvailable:     " + this.bytesAvailable + Instrument.LINESEP + "      ValuesReceived:     " + this.valuesReceived + Instrument.LINESEP + "      ValuesSent:         " + this.valuesSent + Instrument.LINESEP + " " + Instrument.LINESEP;
    }

    abstract void setHardwareEOIMode(boolean var1) throws IniException;

    abstract void setHardwareEOSMode(int var1) throws IniException;

    abstract void setHardwareCompareBits(int var1) throws IniException;

    abstract void setHardwareEOSChar(int var1) throws IniException;

    abstract void updateNameProperties();

    abstract int[] getValidSecondaryAddress();

    abstract int[] getValidCompareBits();

    abstract void hardwareGPIBTrigger() throws IniException;

    abstract void hardwareGPIBClear() throws IniException;

    abstract int writeAsciiToHardware(String var1);

    abstract int writeSwappedBytes(Object var1, int var2, int var3);

    abstract int writeBytes(Object var1, int var2, int var3);

    abstract Object[] readAsciiFromHardware(int var1);

    abstract Object[] readBinaryFromHardware(int var1);

    abstract byte[] readAsynchronousDataFromHardware(int var1);

    abstract String getErrorMessageFromHardware(int var1);

    abstract int getSuccessValue();

    Gpib() {
    }
}

