/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.Instrument;

public final class BinarySwapBytes {
    private static byte[] singleByteMessage = new byte[1];
    private static short[] singleShortMessage = new short[1];
    private static int[] singleIntegerMessage = new int[1];
    private static float[] singleFloatMessage = new float[1];
    private static double[] singleDoubleMessage = new double[1];
    private static char[] singleCharacterMessage = new char[1];

    protected static synchronized Object swap(Object object, int n, int n2) throws Exception {
        int n3 = 0;
        switch (n) {
            case 0: 
            case 5: {
                byte[] byArray = object instanceof Byte ? Instrument.object2byteArray(object) : (byte[])object;
                return byArray;
            }
            case 1: {
                short[] sArray;
                if (object instanceof Short) {
                    sArray = new short[1];
                    Short s = (Short)object;
                    sArray[0] = BinarySwapBytes.swapShort(s);
                } else {
                    sArray = new short[n2];
                    short[] sArray2 = (short[])object;
                    n3 = 0;
                    while (n3 < n2) {
                        sArray[n3] = BinarySwapBytes.swapShort(sArray2[n3]);
                        ++n3;
                    }
                }
                return sArray;
            }
            case 2: {
                int[] nArray;
                if (object instanceof Integer) {
                    nArray = new int[1];
                    Integer n4 = (Integer)object;
                    nArray[0] = BinarySwapBytes.swapInt(n4);
                } else {
                    nArray = new int[n2];
                    int[] nArray2 = (int[])object;
                    n3 = 0;
                    while (n3 < n2) {
                        nArray[n3] = BinarySwapBytes.swapInt(nArray2[n3]);
                        ++n3;
                    }
                }
                return nArray;
            }
            case 3: {
                float[] fArray;
                if (object instanceof Float) {
                    fArray = new float[1];
                    Float f = (Float)object;
                    fArray[0] = BinarySwapBytes.swapFloat(f.floatValue());
                } else {
                    fArray = new float[n2];
                    float[] fArray2 = (float[])object;
                    n3 = 0;
                    while (n3 < n2) {
                        fArray[n3] = BinarySwapBytes.swapFloat(fArray2[n3]);
                        ++n3;
                    }
                }
                return fArray;
            }
            case 4: {
                double[] dArray;
                if (object instanceof Double) {
                    dArray = new double[1];
                    Double d = (Double)object;
                    dArray[0] = BinarySwapBytes.swapDouble(d);
                } else {
                    dArray = new double[n2];
                    double[] dArray2 = (double[])object;
                    n3 = 0;
                    while (n3 < n2) {
                        dArray[n3] = BinarySwapBytes.swapDouble(dArray2[n3]);
                        ++n3;
                    }
                }
                return dArray;
            }
        }
        throw new IniException("Invalid FORMAT specified.");
    }

    public static synchronized byte swapByte(Byte by) {
        return by;
    }

    public static synchronized short swapShort(short s) {
        int n = s & 0xFF;
        int n2 = s >> 8 & 0xFF;
        return (short)(n << 8 | n2);
    }

    protected static synchronized int swapInt(int n) {
        int n2 = n & 0xFF;
        int n3 = n >>> 8 & 0xFF;
        int n4 = n >>> 16 & 0xFF;
        int n5 = n >>> 24 & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public static synchronized float swapFloat(float f) {
        int n = Float.floatToIntBits(f);
        int n2 = n & 0xFF;
        int n3 = n >>> 8 & 0xFF;
        int n4 = n >>> 16 & 0xFF;
        int n5 = n >>> 24 & 0xFF;
        return Float.intBitsToFloat((n2 << 24) + (n3 << 16) + (n4 << 8) + n5);
    }

    public static synchronized double swapDouble(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = l & 0xFFL;
        long l3 = l >>> 8 & 0xFFL;
        long l4 = l >>> 16 & 0xFFL;
        long l5 = l >>> 24 & 0xFFL;
        long l6 = l >>> 32 & 0xFFL;
        long l7 = l >>> 40 & 0xFFL;
        long l8 = l >>> 48 & 0xFFL;
        long l9 = l >>> 56 & 0xFFL;
        return Double.longBitsToDouble((l2 << 56) + (l3 << 48) + (l4 << 40) + (l5 << 32) + (l6 << 24) + (l7 << 16) + (l8 << 8) + l9);
    }

    public static synchronized char swapCharacter(Character c) {
        return c.charValue();
    }

    public static synchronized Object convertToLittlePrecision(byte[] byArray, int n, int n2) throws Exception {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: 
            case 5: {
                return byArray;
            }
            case 1: {
                short[] sArray = new short[n2 / 2];
                n3 = 0;
                while (n3 < byArray.length) {
                    byte by = byArray[n3];
                    byte by2 = byArray[n3 + 1];
                    short s = by;
                    short s2 = by2;
                    s2 = (short)(s2 << 8);
                    s = (short)(s & 0xFF);
                    s2 = (short)(s2 & 0xFF00);
                    sArray[n4] = (short)(s | s2);
                    ++n4;
                    n3 += 2;
                }
                return sArray;
            }
            case 2: {
                int[] nArray = new int[n2 / 4];
                n3 = 0;
                while (n3 < byArray.length) {
                    int n5 = byArray[n3];
                    int n6 = byArray[n3 + 1];
                    int n7 = byArray[n3 + 2];
                    int n8 = byArray[n3 + 3];
                    int n9 = n5;
                    int n10 = n6;
                    int n11 = n7;
                    int n12 = n8;
                    n10 <<= 8;
                    n11 <<= 16;
                    n12 <<= 24;
                    nArray[n4] = (n9 &= 0xFF) | (n10 &= 0xFF00) | (n11 &= 0xFF0000) | (n12 &= 0xFF000000);
                    ++n4;
                    n3 += 4;
                }
                return nArray;
            }
            case 3: {
                float[] fArray = new float[n2 / 4];
                n3 = 0;
                while (n3 < byArray.length) {
                    int n13 = byArray[n3];
                    int n14 = byArray[n3 + 1];
                    int n15 = byArray[n3 + 2];
                    int n16 = byArray[n3 + 3];
                    int n17 = n13;
                    int n18 = n14;
                    int n19 = n15;
                    int n20 = n16;
                    n18 <<= 8;
                    n19 <<= 16;
                    n20 <<= 24;
                    fArray[n4] = Float.intBitsToFloat((n17 &= 0xFF) | (n18 &= 0xFF00) | (n19 &= 0xFF0000) | (n20 &= 0xFF000000));
                    ++n4;
                    n3 += 4;
                }
                return fArray;
            }
            case 4: {
                double[] dArray = new double[n2 / 8];
                n3 = 0;
                while (n3 < byArray.length) {
                    byte by = byArray[n3];
                    byte by3 = byArray[n3 + 1];
                    byte by4 = byArray[n3 + 2];
                    byte by5 = byArray[n3 + 3];
                    byte by6 = byArray[n3 + 4];
                    byte by7 = byArray[n3 + 5];
                    byte by8 = byArray[n3 + 6];
                    byte by9 = byArray[n3 + 7];
                    long l = by;
                    long l2 = by3;
                    long l3 = by4;
                    long l4 = by5;
                    long l5 = by6;
                    long l6 = by7;
                    long l7 = by8;
                    long l8 = by9;
                    l2 <<= 8;
                    l3 <<= 16;
                    l4 <<= 24;
                    l5 <<= 32;
                    l6 <<= 40;
                    l7 <<= 48;
                    l8 <<= 56;
                    dArray[n4] = Double.longBitsToDouble((l &= 0xFFL) | (l2 &= 0xFF00L) | (l3 &= 0xFF0000L) | (l4 &= 0xFF000000L) | (l5 &= 0xFF00000000L) | (l6 &= 0xFF0000000000L) | (l7 &= 0xFF000000000000L) | (l8 &= 0xFF00000000000000L));
                    ++n4;
                    n3 += 8;
                }
                return dArray;
            }
        }
        throw new IniException("Invalid PRECISION specified.");
    }

    public static synchronized Object convertToBigPrecision(byte[] byArray, int n, int n2) throws Exception {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: 
            case 5: {
                return byArray;
            }
            case 1: {
                short[] sArray = new short[n2 / 2];
                n3 = 0;
                while (n3 < byArray.length) {
                    byte by = byArray[n3];
                    byte by2 = byArray[n3 + 1];
                    short s = by;
                    short s2 = by2;
                    s = (short)(s << 8);
                    s = (short)(s & 0xFF00);
                    s2 = (short)(s2 & 0xFF);
                    sArray[n4] = (short)(s | s2);
                    ++n4;
                    n3 += 2;
                }
                return sArray;
            }
            case 2: {
                int[] nArray = new int[n2 / 4];
                n3 = 0;
                while (n3 < byArray.length) {
                    int n5 = byArray[n3];
                    int n6 = byArray[n3 + 1];
                    int n7 = byArray[n3 + 2];
                    int n8 = byArray[n3 + 3];
                    int n9 = n5;
                    int n10 = n6;
                    int n11 = n7;
                    int n12 = n8;
                    n9 <<= 24;
                    n10 <<= 16;
                    n11 <<= 8;
                    nArray[n4] = (n9 &= 0xFF000000) | (n10 &= 0xFF0000) | (n11 &= 0xFF00) | (n12 &= 0xFF);
                    ++n4;
                    n3 += 4;
                }
                return nArray;
            }
            case 3: {
                float[] fArray = new float[n2 / 4];
                n3 = 0;
                while (n3 < byArray.length) {
                    byte by = byArray[n3];
                    byte by3 = byArray[n3 + 1];
                    byte by4 = byArray[n3 + 2];
                    byte by5 = byArray[n3 + 3];
                    int n13 = by << 24 & 0xFF000000;
                    int n14 = by3 << 16 & 0xFF0000;
                    int n15 = by4 << 8 & 0xFF00;
                    int n16 = by5 & 0xFF;
                    fArray[n4] = Float.intBitsToFloat(n13 | n14 | n15 | n16);
                    ++n4;
                    n3 += 4;
                }
                return fArray;
            }
            case 4: {
                double[] dArray = new double[n2 / 8];
                n3 = 0;
                while (n3 < byArray.length) {
                    byte by = byArray[n3];
                    byte by6 = byArray[n3 + 1];
                    byte by7 = byArray[n3 + 2];
                    byte by8 = byArray[n3 + 3];
                    byte by9 = byArray[n3 + 4];
                    byte by10 = byArray[n3 + 5];
                    byte by11 = byArray[n3 + 6];
                    byte by12 = byArray[n3 + 7];
                    long l = by;
                    long l2 = by6;
                    long l3 = by7;
                    long l4 = by8;
                    long l5 = by9;
                    long l6 = by10;
                    long l7 = by11;
                    long l8 = by12;
                    l <<= 56;
                    l2 <<= 48;
                    l3 <<= 40;
                    l4 <<= 32;
                    l5 <<= 24;
                    l6 <<= 16;
                    l7 <<= 8;
                    dArray[n4] = Double.longBitsToDouble((l &= 0xFF00000000000000L) | (l2 &= 0xFF000000000000L) | (l3 &= 0xFF0000000000L) | (l4 &= 0xFF00000000L) | (l5 &= 0xFF000000L) | (l6 &= 0xFF0000L) | (l7 &= 0xFF00L) | (l8 &= 0xFFL));
                    ++n4;
                    n3 += 8;
                }
                return dArray;
            }
        }
        throw new IniException("Invalid PRECISION specified.");
    }

    public static synchronized byte[] breakdownToBytes(Object object, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: 
            case 5: {
                if (object instanceof Byte) {
                    return BinarySwapBytes.object2byteArray(object);
                }
                return (byte[])object;
            }
            case 1: {
                short[] sArray = object instanceof Short ? BinarySwapBytes.object2shortArray(object) : (short[])object;
                byte[] byArray = new byte[sArray.length * 2];
                n2 = 0;
                while (n2 < sArray.length) {
                    byArray[n3++] = (byte)(sArray[n2] & 0xFF);
                    byArray[n3++] = (byte)(sArray[n2] >>> 8 & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 2: {
                int[] nArray = object instanceof Integer ? BinarySwapBytes.object2intArray(object) : (int[])object;
                byte[] byArray = new byte[nArray.length * 4];
                n2 = 0;
                while (n2 < nArray.length) {
                    byArray[n3++] = (byte)(nArray[n2] & 0xFF);
                    byArray[n3++] = (byte)(nArray[n2] >>> 8 & 0xFF);
                    byArray[n3++] = (byte)(nArray[n2] >>> 16 & 0xFF);
                    byArray[n3++] = (byte)(nArray[n2] >>> 24 & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 3: {
                float[] fArray = object instanceof Float ? BinarySwapBytes.object2floatArray(object) : (float[])object;
                byte[] byArray = new byte[fArray.length * 4];
                n2 = 0;
                while (n2 < fArray.length) {
                    int n4 = Float.floatToIntBits(fArray[n2]);
                    byArray[n3++] = (byte)(n4 & 0xFF);
                    byArray[n3++] = (byte)(n4 >>> 8 & 0xFF);
                    byArray[n3++] = (byte)(n4 >>> 16 & 0xFF);
                    byArray[n3++] = (byte)(n4 >>> 24 & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 4: {
                double[] dArray = object instanceof Double ? BinarySwapBytes.object2doubleArray(object) : (double[])object;
                byte[] byArray = new byte[dArray.length * 8];
                n2 = 0;
                while (n2 < dArray.length) {
                    long l = Double.doubleToLongBits(dArray[n2]);
                    byArray[n3++] = (byte)(l & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 8 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 16 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 24 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 32 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 40 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 48 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 56 & 0xFFL);
                    ++n2;
                }
                return byArray;
            }
        }
        throw new IniException("Invalid format.");
    }

    public static synchronized byte[] breakdownToBytesAndSwap(Object object, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: 
            case 5: {
                if (object instanceof Byte) {
                    return BinarySwapBytes.object2byteArray(object);
                }
                return (byte[])object;
            }
            case 1: {
                short[] sArray = object instanceof Short ? BinarySwapBytes.object2shortArray(object) : (short[])object;
                byte[] byArray = new byte[sArray.length * 2];
                n2 = 0;
                while (n2 < sArray.length) {
                    byArray[n3++] = (byte)(sArray[n2] >>> 8 & 0xFF);
                    byArray[n3++] = (byte)(sArray[n2] & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 2: {
                int[] nArray = object instanceof Integer ? BinarySwapBytes.object2intArray(object) : (int[])object;
                byte[] byArray = new byte[nArray.length * 4];
                n2 = 0;
                while (n2 < nArray.length) {
                    byArray[n3++] = (byte)(nArray[n2] >>> 24 & 0xFF);
                    byArray[n3++] = (byte)(nArray[n2] >>> 16 & 0xFF);
                    byArray[n3++] = (byte)(nArray[n2] >>> 8 & 0xFF);
                    byArray[n3++] = (byte)(nArray[n2] & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 3: {
                float[] fArray = object instanceof Float ? BinarySwapBytes.object2floatArray(object) : (float[])object;
                byte[] byArray = new byte[fArray.length * 4];
                n2 = 0;
                while (n2 < fArray.length) {
                    int n4 = Float.floatToIntBits(fArray[n2]);
                    byArray[n3++] = (byte)(n4 >>> 24 & 0xFF);
                    byArray[n3++] = (byte)(n4 >>> 16 & 0xFF);
                    byArray[n3++] = (byte)(n4 >>> 8 & 0xFF);
                    byArray[n3++] = (byte)(n4 & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 4: {
                double[] dArray = object instanceof Double ? BinarySwapBytes.object2doubleArray(object) : (double[])object;
                byte[] byArray = new byte[dArray.length * 8];
                n2 = 0;
                while (n2 < dArray.length) {
                    long l = Double.doubleToLongBits(dArray[n2]);
                    byArray[n3++] = (byte)(l >>> 56 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 48 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 40 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 32 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 24 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 16 & 0xFFL);
                    byArray[n3++] = (byte)(l >>> 8 & 0xFFL);
                    byArray[n3++] = (byte)(l & 0xFFL);
                    ++n2;
                }
                return byArray;
            }
        }
        throw new IniException("Invalid format specified.");
    }

    protected static final synchronized byte[] object2byteArray(Object object) {
        Byte by = (Byte)object;
        BinarySwapBytes.singleByteMessage[0] = by;
        return singleByteMessage;
    }

    protected static final synchronized short[] object2shortArray(Object object) {
        Short s = (Short)object;
        BinarySwapBytes.singleShortMessage[0] = s;
        return singleShortMessage;
    }

    protected static final synchronized int[] object2intArray(Object object) {
        Integer n = (Integer)object;
        BinarySwapBytes.singleIntegerMessage[0] = n;
        return singleIntegerMessage;
    }

    protected static final synchronized float[] object2floatArray(Object object) {
        Float f = (Float)object;
        BinarySwapBytes.singleFloatMessage[0] = f.floatValue();
        return singleFloatMessage;
    }

    protected static final synchronized double[] object2doubleArray(Object object) {
        Double d = (Double)object;
        BinarySwapBytes.singleDoubleMessage[0] = d;
        return singleDoubleMessage;
    }
}

