/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.workspace;

import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.ide.workspace.WorkspaceBrowser;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.DesktopFontPicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.util.ResourceBundle;

public class WorkspacePrefsPanel
extends MWPanel {
    private static WorkspacePrefsPanel sPrefsPanel = null;
    private MWCheckbox fClearCheck;
    private boolean fClearConfirm;
    private int fExpandLimit;
    private DesktopFontPicker fFontPicker;
    private static boolean sUseDesktopFont = true;
    private static Font sFont = new Font("Monospaced", 0, 12);
    protected static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.workspace.resources.RES_VarTV");

    private WorkspacePrefsPanel() {
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        this.readPanelPrefsFromDisk();
        MWGroupbox mWGroupbox = new MWGroupbox(sRes.getString("prefs.font"), 0);
        mWGroupbox.setName("FontGroupbox");
        mWGroupbox.setLayout(new BorderLayout());
        this.fFontPicker = new DesktopFontPicker(sUseDesktopFont, sFont);
        this.fClearCheck = new MWCheckbox(sRes.getString("prefs.comfirmDelete"));
        this.fClearCheck.setState(this.fClearConfirm);
        this.fClearCheck.setName("ClearConfirmCheckbox");
        mWGroupbox.add((Component)this.fFontPicker, "West");
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)this.fClearCheck);
    }

    private void readPanelPrefsFromDisk() {
        this.fClearConfirm = Prefs.getBooleanPref((String)"WorkspaceBrowserClearConfirmation", (boolean)true);
        sUseDesktopFont = Prefs.getBooleanPref((String)"WorkspaceBrowserUseDesktopFont", (boolean)true);
        if (sUseDesktopFont) {
            sFont = new Font("Monospaced", 0, 12);
            return;
        }
        sFont = Prefs.getFontPref((String)"WorkspaceBrowserFont", (Font)new Font("Monospaced", 0, 12));
    }

    public Insets getInsets() {
        return new Insets(5, 5, 0, 5);
    }

    private void apply() {
        Prefs.setBooleanPref((String)"WorkspaceBrowserClearConfirmation", (boolean)this.fClearCheck.getState());
        Prefs.setBooleanPref((String)"WorkspaceBrowserUseDesktopFont", (boolean)this.fFontPicker.getUseDesktopFont());
        Prefs.setFontPref((String)"WorkspaceBrowserFont", (Font)this.fFontPicker.getSelectedFont());
        WorkspaceBrowser.preferenceChangeNotify();
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel == null) {
            sPrefsPanel = new WorkspacePrefsPanel();
        }
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.apply();
        }
    }
}

