/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.workspace;

import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.workspace.StackDisplay;
import com.mathworks.ide.workspace.VariableTreeView;
import com.mathworks.ide.workspace.VariableTreeViewMenubar;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class WorkspaceBrowser
extends VariableTreeView
implements DTApplication,
PrefListener {
    private static final String TITLE = VariableTreeView.sRes.getString("workspace.title");
    private WorkspaceBrowserWindowOwner fOwner;
    private MWFrameProxy fFrame;
    private VariableTreeViewMenubar fMenubar;
    private StackDisplay fStackPopup;
    private static WorkspaceBrowser sWSB = null;
    protected static final String DT_FONT_KEY = "GeneralFont";
    private boolean fIsVisible = false;

    private MWFrameProxy getMWFrameProxy() {
        return this.fFrame;
    }

    public static WorkspaceBrowser getWorkspaceBrowser() {
        MLDesktop mLDesktop = MLDesktop.getMLDesktop();
        if (sWSB == null) {
            sWSB = new WorkspaceBrowser();
        }
        if (mLDesktop == null) {
            WorkspaceBrowser.sWSB.fFrame.setVisible(true);
        } else {
            mLDesktop.showClient(TITLE);
        }
        return sWSB;
    }

    public static WorkspaceBrowser getWorkspaceBrowserIfExists() {
        return sWSB;
    }

    public WorkspaceBrowser() {
        Prefs.addListener((PrefListener)this, (String)"WorkspaceBrowser");
        Prefs.addListener((PrefListener)this, (String)DT_FONT_KEY);
        this.fOwner = new WorkspaceBrowserWindowOwner();
        this.fFrame = new MWFrameProxy((MWWindowOwner)this.fOwner, TITLE);
        this.fFrame.setLayout(new BorderLayout());
        this.fFrame.setFrameSize(400, 400);
        this.fFrame.setFrameLocation(50, 50);
        this.createToolbar();
        this.fFrame.add((Component)((Object)this));
        this.fMenubar = new VariableTreeViewMenubar(this.fFrame, this);
        MWMenuBar mWMenuBar = this.fMenubar.getMenubar();
        this.fFrame.setMenuBar(mWMenuBar);
        sWSB = this;
    }

    public void prefChanged(PrefEvent prefEvent) {
        VariableTreeView.sUseDesktopFont = Prefs.getBooleanPref((String)"WorkspaceBrowserUseDesktopFont", (boolean)true);
        VariableTreeView.sFont = Prefs.getFontPref((String)"WorkspaceBrowserFont", (Font)VariableTreeView.sFont);
        if (VariableTreeView.sUseDesktopFont) {
            this.setFont(Prefs.getFontPref((String)DT_FONT_KEY));
            return;
        }
        this.setFont(VariableTreeView.sFont);
    }

    public boolean isVisible() {
        return this.fIsVisible;
    }

    public void addNotify() {
        super.addNotify();
        this.fIsVisible = true;
    }

    public void removeNotify() {
        super.removeNotify();
        this.fIsVisible = false;
    }

    public DTMenu getViewMenu() {
        if (this.fMenubar != null && this.fIsVisible) {
            return this.fMenubar.getViewMenu();
        }
        return null;
    }

    public int desktopSaveAction() {
        return 1;
    }

    public void restoreState(DataInputStream dataInputStream) {
    }

    public void saveState(DataOutputStream dataOutputStream) {
        this.saveNonPanelPrefsToDisk();
    }

    public String getSplayConstraint() {
        return "";
    }

    public int getApplicationType() {
        return 1;
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        return this.fMenubar.mergeMenus(mWMenuBar);
    }

    public void setDesktop(Desktop desktop) {
    }

    protected static void preferenceChangeNotify() {
        if (sWSB != null) {
            sWSB.readAllPrefsFromDisk();
            sWSB.buildList();
        }
    }

    private void createToolbar() {
        MWToolbar mWToolbar = new MWToolbar();
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/open.gif", 205, VariableTreeView.sRes.getString("toolbar.load"), this.fCommand);
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/save.gif", -106, VariableTreeView.sRes.getString("toolbar.save_all"), this.fCommand);
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/ide/arrayeditor/resources/ArrayView.gif", 140, VariableTreeView.sRes.getString("toolbar.edit"), this.fCommand);
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/ide/workspace/resources/clearvariable.gif", 1070, VariableTreeView.sRes.getString("toolbar.clear"), this.fCommand);
        this.fStackPopup = new StackDisplay(this.fMatlab);
        mWToolbar.add((Component)((Object)this.fStackPopup));
        this.fFrame.add((Component)mWToolbar, "North");
    }

    public synchronized void refresh() {
        this.fStackPopup.refresh();
    }

    public static void refreshListing() {
        if (sWSB != null) {
            sWSB.refresh();
            sWSB.buildList();
        }
    }

    public String getShortName() {
        return TITLE;
    }

    static /* synthetic */ WorkspaceBrowser access$2() {
        return sWSB;
    }

    private class WorkspaceBrowserWindowOwner
    implements MWWindowOwner {
        public void setActive(boolean bl) {
        }

        public String getShortName() {
            return TITLE;
        }

        public String getLongName() {
            return TITLE;
        }

        public boolean close() {
            return this.closeWindow() == 0;
        }

        public int closeWindow() {
            WorkspaceBrowser.this.saveNonPanelPrefsToDisk();
            WorkspaceBrowser.this.fFrame.dispose();
            sWSB = null;
            return 0;
        }

        WorkspaceBrowserWindowOwner() {
            WorkspaceBrowser.this = WorkspaceBrowser.this;
        }
    }
}

