/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.workspace;

import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.desktop.MenuUtils;
import com.mathworks.ide.workspace.VariableTreeView;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.command.MWCommandCenter;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class VariableTreeViewMenubar
implements ItemListener {
    public static final int IDEDITSEL = 140;
    public static final int IDSAVESEL = 320;
    public static final int IDCLEARALL = 9909;
    private MWMenuBar fMenubar;
    private MWCommandCenter fCommandCenter;
    private VariableTreeView fVTV;
    private MWMenu fViewMenu;
    private MWCheckboxMenuItem fSortByName;
    private MWCheckboxMenuItem fSortBySize;
    private MWCheckboxMenuItem fSortByBytes;
    private MWCheckboxMenuItem fSortByClass;
    private MWCheckboxMenuItem fShowSize;
    private MWCheckboxMenuItem fShowBytes;
    private MWCheckboxMenuItem fShowClass;
    private MWCheckboxMenuItem fSortAscending;
    private DTMenu fMainFrameViewMenu;
    private MWCheckboxMenuItem fMainFrameSortByName;
    private MWCheckboxMenuItem fMainFrameSortBySize;
    private MWCheckboxMenuItem fMainFrameSortByBytes;
    private MWCheckboxMenuItem fMainFrameSortByClass;
    private MWCheckboxMenuItem fMainFrameShowSize;
    private MWCheckboxMenuItem fMainFrameShowBytes;
    private MWCheckboxMenuItem fMainFrameShowClass;
    private MWCheckboxMenuItem fMainFrameSortAscending;
    private static final String RESDIR = "com.mathworks.ide.workspace.resources.";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.workspace.resources.RES_VarTV");

    VariableTreeViewMenubar(MWFrameProxy mWFrameProxy, VariableTreeView variableTreeView) {
        this.fVTV = variableTreeView;
        this.fCommandCenter = variableTreeView.getMWCommandCenter();
        this.fVTV.addItemListener(this);
        DTMenuBar dTMenuBar = DTMenuBar.createComponentMenubar(mWFrameProxy);
        this.fMenubar = dTMenuBar.getMenubar();
        this.fViewMenu = new MWMenu(sRes.getString("menu.view.options"));
        this.fMainFrameViewMenu = new DTMenu(sRes.getString("menu.view.options"), this.fCommandCenter);
        this.createViewMenu();
        this.fMenubar = this.mergeMenus(this.fMenubar);
        dTMenuBar.autoAddSeparators();
    }

    public MWMenuBar getMenubar() {
        return this.fMenubar;
    }

    public DTMenu getViewMenu() {
        return this.fMainFrameViewMenu;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.fVTV != null && itemEvent.getSource().equals(this.fVTV)) {
            switch (itemEvent.getStateChange()) {
                case 99: {
                    this.resetSortStates();
                    return;
                }
                case 199: {
                    this.resetShowStates();
                    return;
                }
            }
        }
    }

    private void resetShowStates() {
        this.fShowSize.setState(this.fVTV.getColumnWidth(1) != 0);
        this.fShowBytes.setState(this.fVTV.getColumnWidth(2) != 0);
        this.fShowClass.setState(this.fVTV.getColumnWidth(3) != 0);
        this.fMainFrameShowSize.setState(this.fVTV.getColumnWidth(1) != 0);
        this.fMainFrameShowBytes.setState(this.fVTV.getColumnWidth(2) != 0);
        this.fMainFrameShowClass.setState(this.fVTV.getColumnWidth(3) != 0);
    }

    private void resetSortStates() {
        int n = this.fVTV.getSortColumn();
        this.fSortByName.setState(false);
        this.fSortBySize.setState(false);
        this.fSortByBytes.setState(false);
        this.fSortByClass.setState(false);
        this.fMainFrameSortByName.setState(false);
        this.fMainFrameSortBySize.setState(false);
        this.fMainFrameSortByBytes.setState(false);
        this.fMainFrameSortByClass.setState(false);
        switch (n) {
            case 0: {
                this.fSortByName.setState(true);
                this.fMainFrameSortByName.setState(true);
                break;
            }
            case 1: {
                this.fSortBySize.setState(true);
                this.fMainFrameSortBySize.setState(true);
                break;
            }
            case 2: {
                this.fSortByBytes.setState(true);
                this.fMainFrameSortByBytes.setState(true);
                break;
            }
            case 3: {
                this.fSortByClass.setState(true);
                this.fMainFrameSortByClass.setState(true);
                break;
            }
        }
        this.fSortAscending.setState(this.fVTV.isSortAscending());
        this.fMainFrameSortAscending.setState(this.fVTV.isSortAscending());
    }

    protected String getMenuLabel(int n) {
        switch (n) {
            case 140: {
                return sRes.getString("menu.file.edit");
            }
            case 205: {
                return sRes.getString("menu.file.load");
            }
            case 320: {
                return sRes.getString("menu.file.save");
            }
            case -106: {
                return sRes.getString("menu.file.save_all");
            }
            case 1060: {
                return sRes.getString("menu.edit.select_all");
            }
            case 1070: {
                return sRes.getString("menu.edit.clear");
            }
            case 2237: {
                return sRes.getString("menu.view.show.size");
            }
            case 2238: {
                return sRes.getString("menu.view.show.bytes");
            }
            case 2239: {
                return sRes.getString("menu.view.show.class");
            }
            case 2230: {
                return sRes.getString("menu.view.sort.name");
            }
            case 2231: {
                return sRes.getString("menu.view.sort.size");
            }
            case 2232: {
                return sRes.getString("menu.view.sort.bytes");
            }
            case 2233: {
                return sRes.getString("menu.view.sort.class");
            }
            case 2234: {
                return sRes.getString("menu.view.sort.ascending");
            }
        }
        return "";
    }

    private void doShortcuts(MWMenu mWMenu) {
        int n = mWMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MWMenuComponent mWMenuComponent = mWMenu.getItem(n2);
            if (mWMenuComponent instanceof MWMenuItem) {
                MWMenuItem mWMenuItem = (MWMenuItem)mWMenuComponent;
                int n3 = mWMenuItem.getCommand();
                mWMenuItem.setKey(this.getKbdAcc(n3));
            }
            ++n2;
        }
    }

    private int getKbdAcc(int n) {
        int n2 = 0;
        switch (n) {
            case -106: {
                n2 = 83;
                break;
            }
            case 1070: {
                n2 = 88;
                break;
            }
            case 1060: {
                n2 = 65;
                break;
            }
            case 205: {
                n2 = 76;
                break;
            }
        }
        return n2;
    }

    private void createViewMenu() {
        this.fShowSize = this.addViewMenuItem(this.fViewMenu, 2237);
        this.fShowBytes = this.addViewMenuItem(this.fViewMenu, 2238);
        this.fShowClass = this.addViewMenuItem(this.fViewMenu, 2239);
        this.fMainFrameShowSize = this.addViewMenuItem(this.fMainFrameViewMenu, 2237);
        this.fMainFrameShowBytes = this.addViewMenuItem(this.fMainFrameViewMenu, 2238);
        this.fMainFrameShowClass = this.addViewMenuItem(this.fMainFrameViewMenu, 2239);
        this.fShowSize.setToggle(false);
        this.fShowBytes.setToggle(false);
        this.fShowClass.setToggle(false);
        this.fMainFrameShowSize.setToggle(false);
        this.fMainFrameShowBytes.setToggle(false);
        this.fMainFrameShowClass.setToggle(false);
        MenuUtils.addMenuItem(this.fCommandCenter, this.fViewMenu, "SEPARATOR", -1, -1);
        MenuUtils.addMenuItem(this.fCommandCenter, this.fMainFrameViewMenu, "SEPARATOR", -1, -1);
        this.fSortByName = this.addViewMenuItem(this.fViewMenu, 2230);
        this.fSortBySize = this.addViewMenuItem(this.fViewMenu, 2231);
        this.fSortByBytes = this.addViewMenuItem(this.fViewMenu, 2232);
        this.fSortByClass = this.addViewMenuItem(this.fViewMenu, 2233);
        this.fMainFrameSortByName = this.addViewMenuItem(this.fMainFrameViewMenu, 2230);
        this.fMainFrameSortBySize = this.addViewMenuItem(this.fMainFrameViewMenu, 2231);
        this.fMainFrameSortByBytes = this.addViewMenuItem(this.fMainFrameViewMenu, 2232);
        this.fMainFrameSortByClass = this.addViewMenuItem(this.fMainFrameViewMenu, 2233);
        this.fSortByName.setToggle(false);
        this.fSortBySize.setToggle(false);
        this.fSortByBytes.setToggle(false);
        this.fSortByClass.setToggle(false);
        this.fMainFrameSortByName.setToggle(false);
        this.fMainFrameSortBySize.setToggle(false);
        this.fMainFrameSortByBytes.setToggle(false);
        this.fMainFrameSortByClass.setToggle(false);
        MenuUtils.addMenuItem(this.fCommandCenter, this.fViewMenu, "SEPARATOR", -1, -1);
        MenuUtils.addMenuItem(this.fCommandCenter, this.fMainFrameViewMenu, "SEPARATOR", -1, -1);
        this.fSortAscending = this.addViewMenuItem(this.fViewMenu, 2234);
        this.fMainFrameSortAscending = this.addViewMenuItem(this.fMainFrameViewMenu, 2234);
        this.resetShowStates();
        this.resetSortStates();
    }

    private MWCheckboxMenuItem addViewMenuItem(MWMenu mWMenu, int n) {
        return MenuUtils.addCheckboxMenuItem(this.fCommandCenter, mWMenu, this.getMenuLabel(n), n);
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        boolean bl = false;
        int n = 0;
        while (n < mWMenuBar.getMenuCount()) {
            MWMenu mWMenu = mWMenuBar.getMenu(n);
            if (mWMenu instanceof DTMenu) {
                DTMenu dTMenu = (DTMenu)mWMenu;
                if (dTMenu.getLabel().equals(sRes.getString("menu.edit")) || dTMenu.getLabel().equals(sRes.getString("menu.edit_noamper"))) {
                    dTMenu.addMenuItem(this.fCommandCenter, 1060);
                    dTMenu.addMenuItem(this.fCommandCenter, 1070);
                } else if (dTMenu.getLabel().equals(sRes.getString("menu.view")) || dTMenu.getLabel().equals(sRes.getString("menu.view_noamper"))) {
                    int n2 = 0;
                    while (n2 < dTMenu.getItemCount()) {
                        MWMenuComponent mWMenuComponent = dTMenu.getItem(n2);
                        if (mWMenuComponent.getLabel().equals(sRes.getString("menu.view.options")) || mWMenuComponent.getLabel().equals(sRes.getString("menu.view.options_noamper"))) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        dTMenu.add((MWMenuComponent)this.fViewMenu);
                        bl = true;
                    }
                }
            }
            ++n;
        }
        if (!bl) {
            this.fViewMenu.setLabel(sRes.getString("menu.view"));
            mWMenuBar.insert((MWMenuComponent)this.fViewMenu, 2);
        }
        return mWMenuBar;
    }
}

