/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.workspace;

import com.mathworks.ide.arrayeditor.ArrayEditor;
import com.mathworks.ide.workspace.VariableNameProvider;
import com.mathworks.ide.workspace.WhosParser;
import com.mathworks.ide.workspace.WorkspaceBrowser;
import com.mathworks.ide.workspace.WorkspacePlotter;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWTreeView;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWFileDialog;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.services.Prefs;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class VariableTreeView
extends MWTreeView
implements KeyListener,
MWCommandTarget,
MouseListener,
VariableNameProvider {
    public static final int NAME_COLUMN = 0;
    public static final int SIZE_COLUMN = 1;
    public static final int BYTES_COLUMN = 2;
    public static final int CLASS_COLUMN = 3;
    public static final int SORT_OCCURRED = 99;
    public static final int SORT_NAME = 2230;
    public static final int SORT_SIZE = 2231;
    public static final int SORT_BYTES = 2232;
    public static final int SORT_CLASS = 2233;
    public static final int SORT_ASCENDING = 2234;
    public static final int SHOW_OCCURRED = 199;
    public static final int SHOW_SIZE = 2237;
    public static final int SHOW_BYTES = 2238;
    public static final int SHOW_CLASS = 2239;
    public static final int LOAD = 205;
    public static final int SELECTED = -10;
    public static final int ALL = -20;
    private static final String NAMEWIDTH = "NameWidth";
    private static final String SIZEWIDTH = "SizeWidth";
    private static final String BYTESWIDTH = "BytesWidth";
    private static final String CLASSWIDTH = "ClassWidth";
    private static final int SHOW_COL_DIFF = 2236;
    protected static final boolean DEF_CLEAR_CONFIRM = true;
    static boolean sUseDesktopFont = true;
    static Font sFont = new Font("Monospaced", 0, 12);
    private static final boolean DEF_SORT_ASCENDING = true;
    private static final int DEF_SORT_COLUMN = 0;
    private int fLoadedNameWidth = 128;
    private int fLoadedSizeWidth = 64;
    private int fLoadedBytesWidth = 64;
    private int fLoadedClassWidth = 64;
    private int lastNameWidth;
    private int lastSizeWidth;
    private int lastBytesWidth = 40;
    private int lastClassWidth;
    private int fSortColumn;
    private boolean fIsSortAscending = true;
    private ItemListener fItemListener;
    private static final Style sDefaultStyle = new Style(32);
    private static final Style sEditableStyle = new Style(1024);
    private Object fInterestCookieScope;
    private Object fInterestCookieAdd;
    private Object fInterestCookieClear;
    private Object fInterestCookieDelete;
    private Object fInterestCookieArrayAll;
    protected Matlab fMatlab;
    private static final int WHOS_REPLY = 1;
    private static final int WORKSPACE_REPLY = 2;
    private WhosParser fWP;
    private boolean fShowFullClassNames = false;
    private WhosCallback fWhosCallback;
    private WorkspaceCallback fCallback;
    private String[] fClassFilter;
    private MWMenu fBrowserPopupMenu;
    protected MWCommandCenter fCommand;
    private WorkspacePlotter fWSP;
    private MWCommandCenter fGraphCommand;
    private boolean fArrayEditorAllowed = true;
    private boolean fShowIcons = true;
    private boolean fClearAllowed = true;
    private boolean fSaveAllowed = true;
    private boolean fContextMenuAllowed = true;
    private boolean fClearConfirm = true;
    private int fMinAutoExpandWidth = ((Component)((Object)this)).getFontMetrics(sFont).stringWidth("double array");
    private int fNumOfOldElements;
    private long fLastHashCode;
    private static final String RESDIR = "/com/mathworks/ide/workspace/resources/";
    protected static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.workspace.resources.RES_VarTV");
    static /* synthetic */ Class class$java$lang$Integer;

    public VariableTreeView() {
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab = new Matlab(new MWLooper("WorkspaceList - workspace info."));
        }
        this.fWhosCallback = new WhosCallback(1);
        this.fCallback = new WorkspaceCallback(2);
        this.getData().setWidth(4);
        this.getColumnOptions().setHeaderVisible(true);
        this.getColumnOptions().setResizable(true);
        this.getTableStyle().setCustomHilite(false);
        this.getSelectionOptions().setMode(3);
        if (this.getRowOptions().getDefaultHeight() < 19) {
            this.getRowOptions().setDefaultHeight(19);
        }
        this.setColumnHeaderData(0, sRes.getString("column.name"));
        this.setColumnHeaderData(1, sRes.getString("column.size"));
        this.setColumnHeaderData(2, sRes.getString("column.bytes"));
        this.setColumnHeaderData(3, sRes.getString("column.class"));
        this.setColumnStyle(0, sDefaultStyle);
        this.setColumnStyle(1, sDefaultStyle);
        this.setColumnStyle(2, sDefaultStyle);
        this.setColumnStyle(3, sDefaultStyle);
        if (this instanceof WorkspaceBrowser) {
            this.readAllPrefsFromDisk();
        }
        this.setColumnWidth(1, this.fLoadedSizeWidth);
        this.setColumnWidth(2, this.fLoadedBytesWidth);
        this.setColumnWidth(3, this.fLoadedClassWidth);
        this.setResizeZeroWidthColumns(false);
        this.setAutoExpandColumn(-2);
        this.setMinAutoExpandColumnWidth(this.fMinAutoExpandWidth);
        this.setShowRootlines(false);
        this.setContextTriggerAware(true);
        this.setColumnWidth(0, this.fLoadedNameWidth);
        if (sUseDesktopFont) {
            try {
                this.setFont(Prefs.getFontPref((String)"GeneralFont"));
            }
            catch (Exception exception) {
                this.setFont(sFont);
            }
        } else {
            this.setFont(sFont);
        }
        ((Component)((Object)this)).addKeyListener(this);
        ((Component)((Object)this)).addMouseListener(this);
        this.fWP = new WhosParser();
        this.fCommand = new MWCommandCenter((MWCommandTarget)this);
        this.createPopupMenu();
    }

    protected void saveNonPanelPrefsToDisk() {
        Prefs.setIntegerPref((String)"WorkspaceBrowserNameWidth", (int)this.getColumnWidth(0));
        Prefs.setIntegerPref((String)"WorkspaceBrowserSizeWidth", (int)this.getColumnWidth(1));
        Prefs.setIntegerPref((String)"WorkspaceBrowserBytesWidth", (int)this.getColumnWidth(2));
        Prefs.setIntegerPref((String)"WorkspaceBrowserClassWidth", (int)this.getColumnWidth(3));
        Prefs.setIntegerPref((String)"WorkspaceBrowserSortColumn", (int)this.fSortColumn);
        Prefs.setBooleanPref((String)"WorkspaceBrowserSortAscending", (boolean)this.fIsSortAscending);
    }

    protected void readAllPrefsFromDisk() {
        this.fLoadedNameWidth = Prefs.getIntegerPref((String)"WorkspaceBrowserNameWidth", (int)this.fLoadedNameWidth);
        this.fLoadedSizeWidth = Prefs.getIntegerPref((String)"WorkspaceBrowserSizeWidth", (int)this.fLoadedSizeWidth);
        this.fLoadedBytesWidth = Prefs.getIntegerPref((String)"WorkspaceBrowserBytesWidth", (int)this.fLoadedBytesWidth);
        this.fLoadedClassWidth = Prefs.getIntegerPref((String)"WorkspaceBrowserClassWidth", (int)this.fLoadedClassWidth);
        this.fSortColumn = Prefs.getIntegerPref((String)"WorkspaceBrowserSortColumn", (int)0);
        this.fIsSortAscending = Prefs.getBooleanPref((String)"WorkspaceBrowserSortAscending", (boolean)true);
        this.fClearConfirm = Prefs.getBooleanPref((String)"WorkspaceBrowserClearConfirmation", (boolean)true);
        sUseDesktopFont = Prefs.getBooleanPref((String)"WorkspaceBrowserUseDesktopFont", (boolean)true);
        sFont = Prefs.getFontPref((String)"WorkspaceBrowserFont", (Font)sFont);
    }

    public void setGraphCommandCenter(MWCommandCenter mWCommandCenter) {
        this.fGraphCommand = mWCommandCenter;
    }

    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
        super.addItemListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
        super.removeItemListener(itemListener);
    }

    public void notifyItemListeners(int n) {
        if (this.fItemListener != null) {
            this.fItemListener.itemStateChanged(new ItemEvent((ItemSelectable)((Object)this), n, null, n));
        }
    }

    public boolean isColumnShowing(int n) {
        return this.getColumnWidth(n) != 0;
    }

    public void restoreColumn(int n) {
        int n2 = this.getAutoExpandColumn();
        if (n > n2) {
            this.setAutoExpandColumn(n);
            this.setColumnWidth(n2, this.getColumnWidth(n2) / 2);
        } else {
            int n3 = 0;
            switch (n) {
                case 1: {
                    n3 = this.lastSizeWidth;
                    break;
                }
                case 2: {
                    n3 = this.lastBytesWidth;
                    break;
                }
                case 3: {
                    n3 = this.lastClassWidth;
                    break;
                }
            }
            this.setColumnWidth(n, n3);
        }
        this.notifyItemListeners(199);
    }

    public void setColumnWidth(int n, int n2) {
        if (n2 < 1) {
            if (n == this.getAutoExpandColumn()) {
                if (this.isColumnShowing(3) & n != 3) {
                    this.setAutoExpandColumn(3);
                } else if (this.isColumnShowing(2) & n != 2) {
                    this.setAutoExpandColumn(2);
                } else if (this.isColumnShowing(1) & n != 1) {
                    this.setAutoExpandColumn(1);
                } else {
                    this.setAutoExpandColumn(0);
                }
            }
            switch (n) {
                case 1: {
                    this.lastSizeWidth = this.getColumnWidth(n);
                    break;
                }
                case 2: {
                    this.lastBytesWidth = this.getColumnWidth(n);
                    break;
                }
                case 3: {
                    this.lastClassWidth = this.getColumnWidth(n);
                    break;
                }
            }
            super.setColumnWidth(n, n2);
            ((Component)((Object)this)).repaint();
            this.notifyItemListeners(199);
        } else {
            super.setColumnWidth(n, n2);
        }
        ((Component)((Object)this)).repaint();
    }

    private void toggleShow(int n) {
        if (!this.isColumnShowing(n - 2236)) {
            this.restoreColumn(n - 2236);
            return;
        }
        this.setColumnWidth(n - 2236, 0);
    }

    public static LabeledImageResource getIcon(String string, String string2) {
        String string3 = "/com/mathworks/ide/workspace/resources/matrixicon.gif";
        if (string2.equals("double") || string2.startsWith("double ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.equals("char") || string2.startsWith("char ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/stringicon.gif", string);
        }
        if (string2.equals("cell") || string2.startsWith("cell ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/cellicon.gif", string);
        }
        if (string2.equals("sparse") || string2.startsWith("sparse ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/sparseicon.gif", string);
        }
        if (string2.equals("struct") || string2.startsWith("struct ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/structicon.gif", string);
        }
        if (string2.indexOf(" object") != -1) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/objecticon.gif", string);
        }
        if (string2.equals("uint8") || string2.startsWith("uint8 ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.equals("uint16") || string2.startsWith("uint16 ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.equals("uint32") || string2.startsWith("uint32 ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.equals("int8") || string2.startsWith("int8 ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.equals("int16") || string2.startsWith("int16 ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.equals("int32") || string2.startsWith("int32 ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.equals("single") || string2.startsWith("single ")) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/matrixicon.gif", string);
        }
        if (string2.indexOf(" ") == -1) {
            return new LabeledImageResource("/com/mathworks/ide/workspace/resources/genericjavaicon.gif", string);
        }
        return new LabeledImageResource(string3, string);
    }

    private Object getIconOrString(String string, String string2) {
        if (this.fShowIcons) {
            return VariableTreeView.getIcon(string, string2);
        }
        return string;
    }

    private boolean isInPlaceEditable(String string, String string2) {
        if (string2.equals("cell array") || string2.equals("sparse array") || string2.equals("struct array") || string2.indexOf(" ") == -1 || string2.indexOf(" object") == -1) {
            return false;
        }
        if (string2.equals("char array") && string.startsWith("1x")) {
            return true;
        }
        return string.equals("1x1");
    }

    public void doCommand(int n) {
        switch (n) {
            case 140: {
                this.editSelectedRows();
                return;
            }
            case 1060: {
                this.selectAllRows();
                return;
            }
            case 320: {
                this.saveSelectedVariables();
                return;
            }
            case 1070: {
                this.clearSelectedVariables();
                return;
            }
            case 9909: {
                this.clearAllVariables();
                return;
            }
            case -106: {
                this.saveAllVariables();
                return;
            }
            case 205: {
                this.loadData();
                return;
            }
            case 2237: {
                this.toggleShow(n);
                return;
            }
            case 2238: {
                this.toggleShow(n);
                return;
            }
            case 2239: {
                this.toggleShow(n);
                return;
            }
            case 2230: {
                this.setSortColumn(0);
                return;
            }
            case 2231: {
                this.setSortColumn(1);
                return;
            }
            case 2232: {
                this.setSortColumn(2);
                return;
            }
            case 2233: {
                this.setSortColumn(3);
                return;
            }
            case 2234: {
                this.toggleSortAscending();
                return;
            }
        }
    }

    public boolean isSortAscending() {
        return this.fIsSortAscending;
    }

    public void setSortAscending(boolean bl) {
        this.fIsSortAscending = bl;
        this.fWP.setSortAscending(bl);
    }

    private void toggleSortAscending() {
        this.setSortAscending(!this.isSortAscending());
        this.buildTable();
        this.notifyItemListeners(99);
    }

    public void removeNotify() {
        super.removeNotify();
        this.unregisterWorkspaceInterests();
    }

    public void addNotify() {
        super.addNotify();
        this.registerWorkspaceInterests();
        this.buildList();
    }

    private void registerWorkspaceInterests() {
        if (this.fMatlab != null) {
            this.fInterestCookieScope = this.fMatlab.registerInterest(3, Integer.MIN_VALUE, (CompletionObserver)this.fCallback);
            this.fInterestCookieAdd = this.fMatlab.registerInterest(3, 0x40000000, (CompletionObserver)this.fCallback);
            this.fInterestCookieClear = this.fMatlab.registerInterest(3, 0x20000000, (CompletionObserver)this.fCallback);
            this.fInterestCookieDelete = this.fMatlab.registerInterest(3, 0x10000000, (CompletionObserver)this.fCallback);
            this.fInterestCookieArrayAll = this.fMatlab.registerInterest(3, 1, (CompletionObserver)this.fCallback);
        }
    }

    private void unregisterWorkspaceInterests() {
        if (this.fMatlab != null) {
            this.fMatlab.unregisterInterest(this.fInterestCookieScope);
            this.fMatlab.unregisterInterest(this.fInterestCookieAdd);
            this.fMatlab.unregisterInterest(this.fInterestCookieClear);
            this.fMatlab.unregisterInterest(this.fInterestCookieDelete);
            this.fMatlab.unregisterInterest(this.fInterestCookieArrayAll);
            this.fInterestCookieScope = null;
            this.fInterestCookieAdd = null;
            this.fInterestCookieClear = null;
            this.fInterestCookieDelete = null;
            this.fInterestCookieArrayAll = null;
        }
    }

    protected void buildList() {
        if (this.fMatlab != null) {
            this.fMatlab.eval("whos", (CompletionObserver)this.fWhosCallback);
        }
    }

    private void buildListReply(String string) {
        this.fWP.setWhosString(string);
        this.buildTable();
    }

    private synchronized void buildTable() {
        boolean bl = false;
        try {
            bl = ((Component)((Object)this)).getParent().getParent() instanceof MWGroupbox;
        }
        catch (Exception exception) {}
        String[] stringArray = this.fWP.getNames();
        if (stringArray == null) {
            this.getData().setHeight(0);
            this.fNumOfOldElements = 0;
            this.enableDisableEvents();
            return;
        }
        ((Component)((Object)this)).setVisible(false);
        int n = stringArray.length;
        if (n == 0) {
            int n2 = this.fNumOfOldElements - 1;
            while (n2 >= 0) {
                this.removeItem(this.getItemId(n2));
                --n2;
            }
        } else {
            int n3;
            String[] stringArray2 = this.fWP.getSizes();
            String[] stringArray3 = this.fWP.getBytes();
            String[] stringArray4 = this.fWP.getClasses();
            int n4 = 0;
            while (n4 < n) {
                Object[] objectArray;
                n3 = this.getItemId(n4);
                if (n4 < this.fNumOfOldElements) {
                    if (!(stringArray[n4].equals(((LabeledImageResource)this.getTreeData().getItem(n3, 0)).getLabel()) && stringArray2[n4].equals((String)this.getTreeData().getItem(n3, 1)) && stringArray4[n4].equals((String)this.getTreeData().getItem(n3, 3)))) {
                        objectArray = new Object[]{this.getIconOrString(stringArray[n4], stringArray4[n4]), stringArray2[n4], stringArray3[n4], this.trimClassName(stringArray4[n4])};
                        this.setItem(this.getItemId(n4), objectArray);
                    }
                } else {
                    objectArray = new Object[]{this.getIconOrString(stringArray[n4], stringArray4[n4]), stringArray2[n4], stringArray3[n4], this.trimClassName(stringArray4[n4])};
                    this.addItem(-1, objectArray, false);
                }
                ++n4;
            }
            if (this.fNumOfOldElements > n) {
                n3 = this.fNumOfOldElements - 1;
                while (n3 >= n) {
                    this.removeItem(this.getItemId(n3));
                    --n3;
                }
            }
        }
        this.fNumOfOldElements = n;
        ((Component)((Object)this)).setVisible(true);
        this.enableDisableEvents();
    }

    private boolean satisfiesClassFilter(String string) {
        if (this.fClassFilter == null) {
            return true;
        }
        int n = 0;
        while (n < this.fClassFilter.length) {
            if (string.startsWith(this.fClassFilter[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String trimClassName(String string) {
        if (this.fShowFullClassNames) {
            return string;
        }
        if (string.lastIndexOf(46) != -1) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return string;
    }

    public void editSelectedRows() {
        if (this.isAnythingSelected() && this.isArrayEditingAllowed()) {
            int[] nArray = this.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                String string = "";
                int n2 = this.getItemId(nArray[n]);
                while (n2 != -1) {
                    string = String.valueOf(this.getVariableName(n2)) + string;
                    n2 = this.getTreeData().getParent(n2);
                }
                ArrayEditor.invoke(string, this.getFrame());
                ++n;
            }
        }
    }

    private String getVariableName(int n) {
        String string = "";
        int n2 = n;
        while (n2 != -1) {
            Object object = this.getTreeData().getItem(n2, 0);
            if (object instanceof LabeledImageResource) {
                string = String.valueOf(((LabeledImageResource)object).getLabel()) + string;
            } else if (object instanceof String) {
                string = String.valueOf((String)object) + string;
            }
            n2 = this.getTreeData().getParent(n2);
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public void setClassFilter(String[] stringArray) {
        this.fClassFilter = stringArray;
    }

    public String[] getClassFilter() {
        return this.fClassFilter;
    }

    public void setArrayEditingAllowed(boolean bl) {
        this.fArrayEditorAllowed = bl;
    }

    public boolean isArrayEditingAllowed() {
        return this.fArrayEditorAllowed;
    }

    public String[] getAllVariables() {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        int[] nArray = this.getChildren(-1);
        if (nArray.length > 0) {
            int n = 0;
            while (n < nArray.length) {
                vector.addElement(this.getVariableName(nArray[n]));
                ++n;
            }
            stringArray = new String[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
        return stringArray;
    }

    public String[] getSelectedVariables() {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        int[] nArray = this.getSelectedRows();
        if (nArray.length > 0) {
            int n;
            int n2 = 0;
            while (n2 < nArray.length) {
                try {
                    String string;
                    n = this.getItemId(nArray[n2]);
                    if (this.getTreeData().getParent(n) == -1 && (string = this.getVariableName(n)) != null) {
                        vector.addElement(this.getVariableName(this.getItemId(nArray[n2])));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n2;
            }
            if (vector.size() > 0) {
                stringArray = new String[vector.size()];
                n = 0;
                while (n < vector.size()) {
                    stringArray[n] = (String)vector.elementAt(n);
                    ++n;
                }
            }
        }
        return stringArray;
    }

    public String[] getVariableNames() {
        return this.getSelectedEntities();
    }

    public String getVariableName() {
        String[] stringArray = this.getVariableNames();
        String string = null;
        if (stringArray != null & stringArray.length > 0) {
            string = stringArray[0];
        }
        return string;
    }

    public String[] getVariableClasses() {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        int[] nArray = this.getSelectedRows();
        if (nArray.length > 0) {
            int n = 0;
            while (n < nArray.length) {
                try {
                    String string = (String)this.getTreeData().getItem(this.getItemId(nArray[n]), 3);
                    if (string != null) {
                        vector.addElement(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n;
            }
            if (vector.size() > 0) {
                stringArray = new String[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    stringArray[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
            }
        }
        return stringArray;
    }

    public String getVariableClass() {
        String[] stringArray = this.getVariableClasses();
        String string = null;
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        return string;
    }

    public String[] getSelectedEntities() {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        int[] nArray = this.getSelectedRows();
        if (nArray.length > 0) {
            int n = 0;
            while (n < nArray.length) {
                try {
                    String string = this.getVariableName(this.getItemId(nArray[n]));
                    if (string != null) {
                        vector.addElement(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n;
            }
            if (vector.size() > 0) {
                stringArray = new String[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    stringArray[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
            }
        }
        return stringArray;
    }

    public void clearSelectedVariables() {
        this.clearVariables(this.getSelectedVariables());
    }

    public void clearAllVariables() {
        if (this.fMatlab != null && this.isClearAllowed() && this.proceedWithClear(-20)) {
            this.fMatlab.evalNoOutput("clear variables;");
        }
    }

    private void clearVariables(String[] stringArray) {
        if (this.fMatlab != null && this.isClearAllowed() && stringArray != null && this.proceedWithClear(-10)) {
            StringBuffer stringBuffer = new StringBuffer("");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(String.valueOf(stringArray[n]) + " ");
                ++n;
            }
            this.fMatlab.evalNoOutput("clear " + stringBuffer + ";");
        }
    }

    public void saveSelectedVariables() {
        this.saveSelectedVariables(null);
    }

    public void saveSelectedVariables(String string) {
        this.saveVariables(this.getSelectedVariables(), string);
    }

    public void saveAllVariables() {
        this.saveAllVariables(null);
    }

    public void saveAllVariables(String string) {
        this.saveVariables(this.getAllVariables(), string);
    }

    private void saveVariables(String[] stringArray, String string) {
        if (this.fMatlab != null && this.isSaveAllowed() && stringArray != null) {
            if (string == null) {
                string = this.getMATFileName();
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer("");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(", '" + stringArray[n] + "'");
                    ++n;
                }
                String string2 = "save('" + StringUtils.quoteSingleQuotes((String)string) + "'" + stringBuffer + ");";
                this.fMatlab.evalNoOutput(string2);
            }
        }
    }

    private void loadData() {
        this.fMatlab.evalNoOutput("uiload;");
    }

    protected boolean isTopLevelVariableSelected() {
        return this.getSelectedVariables() != null;
    }

    protected boolean isTopLevelVariableAvailable() {
        int n = this.getData().getHeight();
        return n > 0;
    }

    private boolean proceedWithClear(int n) {
        if (this.fClearConfirm) {
            int n2;
            String string = sRes.getString("alert.clear.selection");
            if (n == -20) {
                string = sRes.getString("alert.clear.all");
            }
            return (n2 = new MWAlert(this.getFrame(), sRes.getString("alert.clear.title"), string, 3).getReply()) == 1;
        }
        return true;
    }

    protected boolean isAnythingSelected() {
        return this.getFirstSelectedRow() != -2;
    }

    public void setShowIcons(boolean bl) {
        this.fShowIcons = bl;
    }

    public boolean getShowIcons() {
        return this.fShowIcons;
    }

    public void setSortColumn(int n) {
        this.fSortColumn = n;
        this.fWP.setSortColumn(n);
        this.buildTable();
        this.notifyItemListeners(99);
    }

    public int getSortColumn() {
        return this.fWP.getSortColumn();
    }

    public boolean isClearAllowed() {
        return this.fClearAllowed;
    }

    public void setClearAllowed(boolean bl) {
        this.fClearAllowed = bl;
    }

    public boolean isSaveAllowed() {
        return this.fSaveAllowed;
    }

    public void setSaveAllowed(boolean bl) {
        this.fSaveAllowed = bl;
    }

    public boolean isContextMenuAllowed() {
        return this.fContextMenuAllowed;
    }

    public void setContextMenuAllowed(boolean bl) {
        this.fContextMenuAllowed = bl;
    }

    public void setAdvancedOptions(boolean bl) {
        this.setArrayEditingAllowed(bl);
        this.setClearAllowed(bl);
        this.setSaveAllowed(bl);
        this.setContextMenuAllowed(bl);
        if (bl) {
            this.getSelectionOptions().setMode(3);
            return;
        }
        this.getSelectionOptions().setMode(1);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.enableDisableEvents();
        switch (keyEvent.getKeyCode()) {
            case 127: {
                this.clearSelectedVariables();
                keyEvent.consume();
                return;
            }
            case 39: {
                this.getTreeData().expandItem(this.getItemId(this.getFirstSelectedRow()));
                keyEvent.consume();
                return;
            }
            case 37: {
                this.getTreeData().collapseItem(this.getItemId(this.getFirstSelectedRow()));
                keyEvent.consume();
                return;
            }
            case 10: {
                this.editSelectedRows();
                keyEvent.consume();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void createPopupMenu() {
        this.fBrowserPopupMenu = new MWMenu("", this.fCommand);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("popup.edit"), 140);
        if (Matlab.isMatlabAvailable() & this instanceof WorkspaceBrowser) {
            this.fWSP = new WorkspacePlotter(this, this.fMatlab);
            this.fBrowserPopupMenu.add((MWMenuComponent)this.fWSP.getMenu());
        }
        this.fBrowserPopupMenu.addSeparator();
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("popup.select_all"), 1060);
        this.fBrowserPopupMenu.addSeparator();
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("popup.import"), 205);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("popup.save"), 320);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("popup.save_all"), -106);
        this.fBrowserPopupMenu.addSeparator();
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("popup.clear"), 1070);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("popup.clearall"), 9909);
        this.fBrowserPopupMenu.attachTo((Component)((Object)this));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (PlatformInfo.getPlatform() == 2) {
            this.enableDisableEvents();
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                this.editSelectedRows();
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.processPopup(mouseEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (PlatformInfo.getPlatform() != 2) {
            this.enableDisableEvents();
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                this.editSelectedRows();
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.processPopup(mouseEvent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void processPopup(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
            this.fWSP.refresh();
            this.fBrowserPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void enableDisableEvents() {
        this.fCommand.setCommandEnabled(140, this.isAnythingSelected() && this.isArrayEditingAllowed());
        this.fCommand.setCommandEnabled(1060, this.isTopLevelVariableAvailable());
        this.fCommand.setCommandEnabled(320, this.isTopLevelVariableSelected() && this.isSaveAllowed());
        this.fCommand.setCommandEnabled(-106, this.isTopLevelVariableAvailable() && this.isSaveAllowed());
        this.fCommand.setCommandEnabled(1070, this.isTopLevelVariableSelected() && this.isClearAllowed());
    }

    public MWCommandCenter getMWCommandCenter() {
        return this.fCommand;
    }

    private String getMATFileName() {
        String string = null;
        boolean bl = true;
        boolean bl2 = true;
        while (bl) {
            string = this.presentSaveDialog();
            if (string != null) {
                if (this.isFileReadOnly(string)) {
                    int n = this.handleSaveReadOnly(string, sRes.getString("dialog.save.title"));
                    if (n == 2) {
                        bl = false;
                    }
                    if (n != 3) continue;
                    bl = false;
                    bl2 = false;
                    continue;
                }
                bl = false;
                bl2 = true;
                continue;
            }
            bl2 = false;
            bl = false;
        }
        if (!bl2) {
            return null;
        }
        return string;
    }

    private boolean isFileReadOnly(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file != null && file.getParent() != null) {
            File file2 = new File(file.getParent());
            bl = file2.canWrite();
        }
        if (bl && file.exists()) {
            bl = file.canWrite();
        }
        return !bl;
    }

    private String presentSaveDialog() {
        String string = null;
        Frame frame = this.getFrame();
        MWFileDialog mWFileDialog = new MWFileDialog(frame, sRes.getString("dialog.save.title"), 1, 2);
        mWFileDialog.setFile("matlab.mat");
        mWFileDialog.show();
        if (mWFileDialog.getFile() != null) {
            String string2 = mWFileDialog.getFile();
            if (!string2.endsWith(".mat") && string2.indexOf(".") == -1) {
                if (PlatformInfo.getPlatform() == 1) {
                    string2 = String.valueOf(string2) + ".mat";
                } else {
                    int n = new MWAlert(frame, sRes.getString("alert.add_mat.title"), sRes.getString("alert.add_mat.message"), 3).getReply();
                    if (n == 1) {
                        string2 = String.valueOf(string2) + ".mat";
                    }
                }
            }
            File file = new File(mWFileDialog.getDirectory(), string2);
            string = StringUtils.fromJavaPath((String)file.getAbsolutePath());
        }
        return string;
    }

    private int handleSaveReadOnly(String string, String string2) {
        Object[] objectArray = new Object[]{string};
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(Locale.getDefault());
        File file = new File(string);
        boolean bl = file.exists();
        if (bl) {
            messageFormat.applyPattern(sRes.getString("dialog.readonly.message"));
        } else {
            messageFormat.applyPattern(sRes.getString("dialog.readonlydir.message"));
        }
        String string3 = messageFormat.format(objectArray);
        int n = 0;
        n = bl ? new MWAlert(this.getFrame(), string2, string3, 6).getReply() : new MWAlert(this.getFrame(), string2, string3, 3).getReply();
        if (n == 3 || n == 1) {
            return 1;
        }
        if (n == 2) {
            NativeJava.changeFileAttribute((String)string);
            return 2;
        }
        return 3;
    }

    public void selectAllRows() {
        this.select(new Rectangle(0, 0, 1, this.getData().getHeight()));
        this.enableDisableEvents();
    }

    public void testListAllVariables() {
        String[] stringArray = this.getAllVariables();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
    }

    public void testListSelectedVariables() {
        String[] stringArray = this.getSelectedVariables();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
    }

    public void test() {
        MWFrame mWFrame = new MWFrame("TreeView Test");
        mWFrame.add((Component)((Object)this), "Center");
        mWFrame.pack();
        mWFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$0() {
        return 1;
    }

    class WhosCallback
    implements CompletionObserver {
        int fReplyType;

        public WhosCallback(int n) {
            VariableTreeView.this = VariableTreeView.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            long l;
            if (this.fReplyType == VariableTreeView.access$0() && (l = StringUtils.hashCode((String)((String)object))) != VariableTreeView.this.fLastHashCode) {
                VariableTreeView.this.fLastHashCode = l;
                VariableTreeView.this.buildListReply(StringUtils.stripSLDebugInfo((String)((String)object)));
            }
        }
    }

    class WorkspaceCallback
    implements CompletionObserver {
        int fReplyType;

        public WorkspaceCallback(int n) {
            VariableTreeView.this = VariableTreeView.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            MWMessage mWMessage = (MWMessage)object;
            Integer n2 = (Integer)mWMessage.findData("familyid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = VariableTreeView.class$("java.lang.Integer")));
            if (n2 == 3) {
                VariableTreeView.this.buildList();
            }
        }
    }
}

