/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.workspace;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class StackDisplay
extends MWPanel
implements ItemListener {
    private static final int STACK_REPLY = 1;
    private static final int WORKSPACE_REPLY = 2;
    private Matlab fMatlab;
    private MWChoice fStackPopup;
    private MWLabel fLabel;
    private int fPlatform;
    private int fOldStackLevel;
    private Object fInterestCookie;
    private WorkspaceCallback fCallback;
    private StackCallback fStackCallback;
    private static final String RESDIR = "com.mathworks.ide.workspace.resources.";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.workspace.resources.RES_VarTV");
    static /* synthetic */ Class class$java$lang$Integer;

    public StackDisplay(Matlab matlab) {
        Font font = new Font("Dialog", 0, 10);
        ((Container)((Object)this)).setLayout(new FlowLayout(0, 4, 0));
        this.fMatlab = matlab;
        this.fPlatform = PlatformInfo.getPlatform();
        this.fLabel = new MWLabel(sRes.getString("stack.label"));
        this.fLabel.setName("StackLabel");
        this.fLabel.setFont(font);
        ((Container)((Object)this)).add((Component)this.fLabel);
        this.fStackPopup = new MWChoice();
        this.fStackPopup.setFont(font);
        this.fStackPopup.addItemListener((ItemListener)this);
        ((Container)((Object)this)).add((Component)this.fStackPopup);
        this.fStackCallback = new StackCallback(1);
        this.fCallback = new WorkspaceCallback(2);
        this.refresh();
    }

    public void addNotify() {
        if (this.fMatlab != null && this.fInterestCookie == null) {
            this.fInterestCookie = this.fMatlab.registerInterest(3, Integer.MIN_VALUE, (CompletionObserver)this.fCallback);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.fInterestCookie != null && this.fMatlab != null) {
            this.fMatlab.unregisterInterest(this.fInterestCookie);
            this.fInterestCookie = null;
        }
    }

    public void setEnabled(boolean bl) {
        this.fStackPopup.setEnabled(bl);
    }

    private void buildPopup() {
        if (this.fMatlab != null) {
            this.fMatlab.eval("dbstack", (CompletionObserver)this.fStackCallback);
        }
    }

    private void buildPopupReply(String string) {
        string = StringUtils.stripSLDebugInfo((String)string);
        this.fStackPopup.removeAll();
        if (string == null || string.length() < 5) {
            this.fStackPopup.add("Base");
            boolean bl = false;
            try {
                Container container = this.fStackPopup.getParent();
                while (container != null) {
                    if (!((container = container.getParent()) instanceof MWFrameProxy)) continue;
                    if (container.getParent() != null) {
                        bl = true;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                return;
            }
            if (!bl) {
                this.setEnabled(false);
                return;
            }
            ((Container)((Object)this)).validate();
            this.fStackPopup.repaint(5L);
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        char c = this.fPlatform == 0 ? (char)':' : (this.fPlatform == 1 ? (char)'\\' : '/');
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        do {
            String string2;
            ++n;
            if (string.charAt(n3) == '>') {
                n2 = n;
            }
            while (n3 < string.length() && string.charAt(n3) != '\n' && string.charAt(n3) != '\r') {
                ++n3;
            }
            int n4 = n3;
            while (string.charAt(n4) != c && string.charAt(n4) != '(') {
                --n4;
            }
            if (string.charAt(n4) == '(') {
                int n5 = ++n4;
                while (string.charAt(n5) != ')') {
                    ++n5;
                }
                string2 = string.substring(n4, n5);
            } else {
                string2 = null;
            }
            int n6 = n3;
            while (n3 > 0 && string.charAt(n3) != c) {
                --n3;
            }
            int n7 = n3 + 1;
            while (n3 < string.length() && string.charAt(n3) != '.') {
                ++n3;
            }
            String string3 = string2 != null ? string2 : string.substring(n7, n3);
            this.fStackPopup.add(string3);
            n3 = n6;
            while (n3 < string.length() && (string.charAt(n3) == '\n' || string.charAt(n3) == '\r')) {
                ++n3;
            }
        } while (n3 < string.length());
        this.fStackPopup.add("Base");
        if (n2 == 0) {
            n2 = n + 1;
        }
        this.fOldStackLevel = n2 - 1;
        this.fStackPopup.select(this.fOldStackLevel);
        this.grow();
    }

    private void grow() {
        if (((Component)((Object)this)).isShowing()) {
            Container container = ((Component)((Object)this)).getParent();
            this.fStackPopup.invalidate();
            ((Component)((Object)this)).setSize(((Container)((Object)this)).getPreferredSize());
            if (container != null) {
                ((Component)container).validate();
            }
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void handlePopup() {
        String string = "";
        int n = this.fStackPopup.getSelectedIndex() - this.fOldStackLevel;
        if (n < 0) {
            n = -n;
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + "dbdown;";
                ++n2;
            }
        } else if (n > 0) {
            int n3 = 0;
            while (n3 < n) {
                string = String.valueOf(string) + "dbup;";
                ++n3;
            }
        }
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput(string);
        }
        this.fOldStackLevel = this.fStackPopup.getSelectedIndex();
    }

    public void refresh() {
        this.buildPopup();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.fStackPopup) {
            this.handlePopup();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$1() {
        return 1;
    }

    class StackCallback
    implements CompletionObserver {
        int fReplyType;

        public StackCallback(int n) {
            StackDisplay.this = StackDisplay.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == StackDisplay.access$1()) {
                StackDisplay.this.buildPopupReply((String)object);
            }
        }
    }

    class WorkspaceCallback
    implements CompletionObserver {
        int fReplyType;

        public WorkspaceCallback(int n) {
            StackDisplay.this = StackDisplay.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            MWMessage mWMessage = (MWMessage)object;
            Integer n2 = (Integer)mWMessage.findData("familyid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = StackDisplay.class$("java.lang.Integer")));
            if (n2 == 3) {
                StackDisplay.this.refresh();
            }
        }
    }

    class ComboboxListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            StackDisplay.this.handlePopup();
        }

        ComboboxListener() {
            StackDisplay.this = StackDisplay.this;
        }
    }
}

