/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.ide.widgets.HighlighterFactory;
import com.mathworks.ide.widgets.Indenter;
import com.mathworks.ide.widgets.IndenterFactory;
import com.mathworks.ide.widgets.MHighlighterFactory;
import com.mathworks.ide.widgets.MIndenterFactory;
import com.mathworks.ide.widgets.SimpleIndenter;
import com.mathworks.ide.widgets.SimpleIndenterFactory;
import com.mathworks.mwt.MWTextArea;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextListener;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Range;
import com.mathworks.util.Timer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

public class SyntaxTextArea
extends MWTextArea {
    public static final String M_FILE_TYPE = "M-code";
    public static final String TEXT_FILE_TYPE = "Text";
    public static final String INDENTERTYPE_NONE = "NoIndent";
    public static final String INDENTERTYPE_BLOCK = "BlockIndent";
    public static final String INDENTERTYPE_SMART = "SmartIndent";
    static TimerGuy sTimer;
    private String fFileType;
    private Highlighter fHighlighter;
    private boolean fSyntaxHighlightingEnabled = false;
    private boolean fSyntaxHighlightingOn = false;
    private Indenter fIndenter;
    private String fIndenterType;
    private int fSpacesPerIndent = 4;
    private int fSpacesPerTab = 4;
    private int fTabSpaces = 4;
    private boolean fTabUsingSpaces = false;
    private boolean fEmacsStyleTab = false;
    private KissyKeyListener fKeyFilter;
    private Range fOldSelection;
    private static Hashtable fHighlighters;
    private static Hashtable fIndenters;

    public SyntaxTextArea() {
        this.getView().overrideCommand(31, (ActionListener)new InsertCharAndIndent());
        this.getView().overrideCommand(30, (ActionListener)new InsertLineBreakAndIndent());
        this.getView().overrideCommand(2, (ActionListener)new CharLeftDeleteAndIndent());
        this.getView().overrideCommand(5, (ActionListener)new CharRightDeleteAndIndent());
        if (!PlatformInfo.isMacintosh()) {
            this.getView().setBlackHighlight(true);
        }
        this.getView().setColorMode(1);
        if (PlatformInfo.isMicrosoftVM()) {
            this.setFont(new Font("Courier", 0, 12));
        } else {
            this.setFont(new Font("Monospaced", 0, 12));
        }
        this.setFileType(TEXT_FILE_TYPE);
        this.setSyntaxHighlightingEnabled(true);
        this.setIndenterType(INDENTERTYPE_BLOCK);
        this.getModel().addTextListener((MWTextListener)new TextEventHandler());
        this.getView().addMouseListener((MouseListener)new BalanceClickListener());
        this.fKeyFilter = new KissyKeyListener();
        this.getView().addKeyFilter((KeyListener)this.fKeyFilter);
        this.fOldSelection = new Range(-1, -1);
    }

    public String getFileType() {
        return this.fFileType;
    }

    public void setFileType(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals(this.fFileType)) {
            return;
        }
        this.fFileType = string;
        this.fHighlighter = SyntaxTextArea.createHighlighter(string);
        this.updateSyntaxHighlightingOn();
        if (this.fFileType.equals(M_FILE_TYPE)) {
            this.setIndenterType(INDENTERTYPE_SMART);
            return;
        }
        this.setIndenterType(INDENTERTYPE_BLOCK);
    }

    public void setAutoIndentEnabled(boolean bl) {
    }

    public void setSmartIndentEnabled(boolean bl) {
    }

    public String getIndenterType() {
        return this.fIndenterType;
    }

    public void setIndenterType(String string) {
        if (string == null) {
            string = INDENTERTYPE_BLOCK;
        }
        if (string.equals(INDENTERTYPE_NONE)) {
            this.fIndenter = null;
        } else if (!string.equals(this.fIndenterType)) {
            if (fIndenters.get(string) == null) {
                string = INDENTERTYPE_BLOCK;
            }
            this.fIndenter = SyntaxTextArea.createIndenter(string);
            this.fIndenter.setModel(this.getModel());
        }
        this.fIndenterType = string;
    }

    public void setSpacesPerIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.fSpacesPerIndent = n;
    }

    public int getSpacesPerIndent() {
        return this.fSpacesPerIndent;
    }

    public void setSpacesPerTab(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.fSpacesPerTab = n;
        this.getModel().setSpacesPerTab(n);
        if (!this.fTabUsingSpaces) {
            this.fTabSpaces = n;
        }
    }

    public int getSpacesPerTab() {
        return this.fSpacesPerTab;
    }

    public void setEmacsStyleTabEnabled(boolean bl) {
        this.fEmacsStyleTab = bl;
    }

    public boolean isEmacsStyleTabEnabled() {
        return this.fEmacsStyleTab;
    }

    public void setTabUsingSpaces(boolean bl) {
        this.fTabUsingSpaces = bl;
        if (bl) {
            this.fTabSpaces = 0;
            return;
        }
        this.fTabSpaces = this.fSpacesPerTab;
    }

    public boolean isTabUsingSpaces() {
        return this.fTabUsingSpaces;
    }

    public void setSyntaxHighlightingEnabled(boolean bl) {
        this.fSyntaxHighlightingEnabled = bl;
        this.updateSyntaxHighlightingOn();
    }

    public boolean isSyntaxHighlightingEnabled() {
        return this.fSyntaxHighlightingEnabled;
    }

    private void updateSyntaxHighlightingOn() {
        boolean bl;
        boolean bl2 = bl = this.fSyntaxHighlightingEnabled && this.fHighlighter != null;
        if (bl != this.fSyntaxHighlightingOn) {
            if (this.fSyntaxHighlightingEnabled && this.fHighlighter != null) {
                this.doHighlighting(0, this.getModel().getNumLines() - 1);
            } else {
                this.getModel().setStyle(0, this.getModel().length(), this.getModel().getDefaultStyle());
            }
            this.fSyntaxHighlightingOn = bl;
        }
    }

    protected void doHighlighting(int n, int n2) {
        MWTextModel mWTextModel = this.getModel();
        mWTextModel.deferStyleChangeNotification();
        try {
            this.fHighlighter.highlight(mWTextModel, n, n2);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mWTextModel.resumeStyleChangeNotification();
            throw throwable;
        }
        Object var5_4 = null;
        mWTextModel.resumeStyleChangeNotification();
    }

    public static String[] getHighlightCategories(String string) {
        Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
        if (highlighter == null) {
            return new String[0];
        }
        return highlighter.getCategories();
    }

    public static MWStyle[] getHighlightStyles(String string) {
        Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
        if (highlighter == null) {
            return new MWStyle[0];
        }
        return highlighter.getStyles();
    }

    public static MWStyle[] getDefaultHighlightStyles(String string) {
        Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
        if (highlighter == null) {
            return new MWStyle[0];
        }
        return highlighter.getDefaultStyles();
    }

    public void setHighlightStyle(String string, String string2, MWStyle mWStyle) {
        if (string == this.fFileType) {
            if (this.fHighlighter != null) {
                this.fHighlighter.setStyle(string2, mWStyle);
                if (this.fSyntaxHighlightingEnabled) {
                    this.doHighlighting(0, this.getModel().getNumLines() - 1);
                    return;
                }
            }
        } else {
            Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
            if (highlighter != null) {
                highlighter.setStyle(string2, mWStyle);
            }
        }
    }

    public void setHighlightStyles(String string, MWStyle[] mWStyleArray) {
        if (string == this.fFileType) {
            if (this.fHighlighter != null) {
                this.fHighlighter.setStyles(mWStyleArray);
                if (this.fSyntaxHighlightingEnabled) {
                    this.doHighlighting(0, this.getModel().getNumLines() - 1);
                    return;
                }
            }
        } else {
            Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
            if (highlighter != null) {
                highlighter.setStyles(mWStyleArray);
            }
        }
    }

    public void setTextStyle(MWStyle mWStyle) {
        if (this.fHighlighter != null) {
            this.fHighlighter.setTextStyle(mWStyle);
            if (mWStyle.isAutoColor()) {
                this.getView().setColorMode(0);
                return;
            }
            this.setTextColor(mWStyle.getColor());
        }
    }

    public void setBackgroundStyle(MWStyle mWStyle) {
        if (mWStyle.isAutoColor()) {
            this.setBackground(Decorations.getColor((int)0));
            return;
        }
        this.setBackground(mWStyle.getColor());
    }

    public void setTextColor(Color color) {
        this.setForeground(color);
        this.getView().setColorMode(2);
    }

    public void setKeyBindingScheme(int n) {
        this.getView().setKeyBindingScheme(n);
    }

    public int getKeyBindingScheme() {
        return this.getView().getKeyBindingScheme();
    }

    public void indentSel() {
        MWTextModel mWTextModel = this.getModel();
        MWTextView mWTextView = this.getView();
        Range range = (Range)mWTextView.getSel().clone();
        int n = mWTextView.getTopLine();
        int n2 = mWTextView.getHScrollAmount();
        int n3 = this.getModel().lineFromPos(range.getStart());
        int n4 = this.getModel().lineFromPos(range.getEnd());
        mWTextModel.startCommand("Indent");
        try {
            this.indentLines(n3, n4, range);
            mWTextView.setSel(range);
            mWTextView.setTopLine(n);
            mWTextView.setHScrollAmount(n2);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            mWTextModel.endCommand();
            throw throwable;
        }
        Object var9_8 = null;
        mWTextModel.endCommand();
    }

    public void indentLines(int n, int n2) {
        this.indentLines(n, n2, null);
    }

    public void indentLines(int n, int n2, Range range) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (this.fIndenter != null) {
            this.fIndenter.indent(n3, n4, this.fSpacesPerIndent, this.fTabSpaces, range);
        }
    }

    private void doTabProcessing(char c) {
        if (this.fEmacsStyleTab) {
            boolean bl = false;
            if (this.fIndenter == null) {
                bl = true;
                this.setIndenterType(INDENTERTYPE_SMART);
            }
            this.indentSel();
            if (bl) {
                this.setIndenterType(INDENTERTYPE_NONE);
                return;
            }
        } else if (this.fTabUsingSpaces) {
            if (this.fSpacesPerTab > 0) {
                int n = this.getView().getSel().getMin();
                int n2 = this.getModel().lineFromPos(n);
                int n3 = this.getModel().getLineStart(n2);
                int n4 = this.getModel().expandedWidthInChars(n3, n, 0);
                int n5 = this.fSpacesPerTab - n4 % this.fSpacesPerTab;
                int n6 = 0;
                while (n6 < n5) {
                    this.getView().insertChar(' ');
                    ++n6;
                }
                return;
            }
        } else {
            this.getView().insertChar(c);
        }
    }

    public void insertCharAndIndent(char c) {
        if (c == '\t') {
            this.doTabProcessing(c);
            return;
        }
        if (this.fIndenter != null) {
            block4: {
                this.getModel().startCommand("Typing");
                try {
                    int n = this.getView().getSel().getMin();
                    int n2 = this.getModel().lineFromPos(n);
                    int n3 = this.fIndenter.contributionToCurr(n2);
                    this.getView().insertChar(c);
                    int n4 = this.fIndenter.contributionToCurr(n2);
                    if (n3 == n4) break block4;
                    Range range = (Range)this.getView().getSel().clone();
                    this.fIndenter.indent(n2, n2, this.fSpacesPerIndent, this.fTabSpaces, range);
                    this.getView().setSel(range);
                }
                catch (Throwable throwable) {
                    Object var3_8 = null;
                    this.getModel().endCommand();
                    throw throwable;
                }
            }
            Object var3_7 = null;
            this.getModel().endCommand();
            return;
        }
        this.getView().insertChar(c);
    }

    public void charLeftDeleteAndIndent() {
        if (this.getView().getSel().isEmpty() && this.fIndenter != null) {
            block4: {
                this.getModel().startCommand("Typing");
                try {
                    int n = this.getView().getSel().getMin();
                    int n2 = this.getModel().lineFromPos(n);
                    if (n2 > 0 && this.getModel().colFromPos(n) == 0) {
                        --n2;
                    }
                    int n3 = this.fIndenter.contributionToCurr(n2);
                    this.getView().charLeftDelete();
                    int n4 = this.getModel().lineFromPos(this.getView().getSel().getMin());
                    int n5 = this.fIndenter.contributionToCurr(n4);
                    if (n3 == n5) break block4;
                    Range range = (Range)this.getView().getSel().clone();
                    this.fIndenter.indent(n2, n2, this.fSpacesPerIndent, this.fTabSpaces, range);
                    this.getView().setSel(range);
                }
                catch (Throwable throwable) {
                    Object var2_8 = null;
                    this.getModel().endCommand();
                    throw throwable;
                }
            }
            Object var2_7 = null;
            this.getModel().endCommand();
            return;
        }
        this.getView().charLeftDelete();
    }

    public void charRightDeleteAndIndent() {
        if (this.getView().getSel().isEmpty() && this.fIndenter != null) {
            block3: {
                this.getModel().startCommand("Delete");
                try {
                    int n = this.getView().getSel().getMin();
                    int n2 = this.getModel().lineFromPos(n);
                    int n3 = this.fIndenter.contributionToCurr(n2);
                    this.getView().charRightDelete();
                    int n4 = this.getModel().lineFromPos(this.getView().getSel().getMin());
                    int n5 = this.fIndenter.contributionToCurr(n4);
                    if (n3 == n5) break block3;
                    Range range = (Range)this.getView().getSel().clone();
                    this.fIndenter.indent(n2, n2, this.fSpacesPerIndent, this.fTabSpaces, range);
                    this.getView().setSel(range);
                }
                catch (Throwable throwable) {
                    Object var2_8 = null;
                    this.getModel().endCommand();
                    throw throwable;
                }
            }
            Object var2_7 = null;
            this.getModel().endCommand();
            return;
        }
        this.getView().charRightDelete();
    }

    public void insertLineBreakAndIndent() {
        if (this.fIndenter == null) {
            this.getView().insertLineBreak();
            return;
        }
        int n = this.getView().getSel().getMin();
        int n2 = this.getModel().lineFromPos(n);
        int n3 = this.fIndenter.contributionToCurr(n2);
        this.getView().insertLineBreak();
        this.getModel().startCommand("Typing");
        try {
            int n4 = this.fIndenter.contributionToCurr(n2);
            int n5 = n3 == n4 ? n2 + 1 : n2;
            Range range = (Range)this.getView().getSel().clone();
            this.fIndenter.indent(n5, n2 + 1, this.fSpacesPerIndent, this.fTabSpaces, range);
            this.getView().setSel(range);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.getModel().endCommand();
            throw throwable;
        }
        Object var8_7 = null;
        this.getModel().endCommand();
    }

    public static Highlighter createHighlighter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        HighlighterFactory highlighterFactory = (HighlighterFactory)fHighlighters.get(string);
        if (highlighterFactory == null) {
            return null;
        }
        return highlighterFactory.create();
    }

    public static void registerHighlighter(String string, HighlighterFactory highlighterFactory) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        fHighlighters.put(string, highlighterFactory);
    }

    public static Indenter createIndenter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        IndenterFactory indenterFactory = (IndenterFactory)fIndenters.get(string);
        if (indenterFactory == null) {
            return new SimpleIndenter();
        }
        return indenterFactory.create();
    }

    public static void registerIndenter(String string, IndenterFactory indenterFactory) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        fIndenters.put(string, indenterFactory);
    }

    public void doBalance() {
        int n;
        MWTextView mWTextView = this.getView();
        MWTextModel mWTextModel = this.getModel();
        int n2 = mWTextView.getSelStart();
        int n3 = mWTextView.getSelEnd();
        if (n3 < n2) {
            n = n3;
            n3 = n2;
            n2 = n;
        }
        int n4 = mWTextModel.length();
        char c = ' ';
        char c2 = ' ';
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n = n2;
        while (n < n4) {
            c = mWTextModel.charAt(n);
            if (c == ')') {
                --n7;
            } else if (c == ']') {
                --n6;
            } else if (c == '}') {
                --n5;
            } else if (c == '(') {
                ++n7;
            } else if (c == '[') {
                ++n6;
            } else if (c == '{') {
                ++n5;
            }
            if (n7 < 0) {
                c2 = '(';
                break;
            }
            if (n6 < 0) {
                c2 = '[';
                break;
            }
            if (n5 < 0) {
                c2 = '{';
                break;
            }
            ++n;
        }
        if (n < n4) {
            int n8 = n;
            int n9 = 1;
            n = n8 - 1;
            while (n >= 0) {
                if (mWTextModel.charAt(n) == c) {
                    ++n9;
                } else if (mWTextModel.charAt(n) == c2) {
                    --n9;
                }
                if (n9 == 0) {
                    mWTextView.setSel(n + 1, n8);
                    break;
                }
                --n;
            }
            if (n < 0) {
                ((Component)((Object)this)).getToolkit().beep();
                return;
            }
        } else {
            ((Component)((Object)this)).getToolkit().beep();
        }
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    static {
        fHighlighters = new Hashtable();
        fIndenters = new Hashtable();
        SyntaxTextArea.registerHighlighter(M_FILE_TYPE, new MHighlighterFactory());
        SyntaxTextArea.registerIndenter(INDENTERTYPE_SMART, new MIndenterFactory());
        SyntaxTextArea.registerIndenter(INDENTERTYPE_BLOCK, new SimpleIndenterFactory());
    }

    class InsertCharAndIndent
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.insertCharAndIndent(((KeyEvent)actionEvent.getSource()).getKeyChar());
        }

        InsertCharAndIndent() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }
    }

    class CharLeftDeleteAndIndent
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.charLeftDeleteAndIndent();
        }

        CharLeftDeleteAndIndent() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }
    }

    class CharRightDeleteAndIndent
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.charRightDeleteAndIndent();
        }

        CharRightDeleteAndIndent() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }
    }

    class InsertLineBreakAndIndent
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.insertLineBreakAndIndent();
        }

        InsertLineBreakAndIndent() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }
    }

    class TextEventHandler
    extends MWTextAdapter {
        public void textInserted(MWTextEvent mWTextEvent) {
            if (SyntaxTextArea.this.fSyntaxHighlightingEnabled && SyntaxTextArea.this.fHighlighter != null) {
                SyntaxTextArea.this.doHighlighting(mWTextEvent.getMinLine(), mWTextEvent.getMaxLine());
            }
        }

        public void textDeleted(MWTextEvent mWTextEvent) {
            if (SyntaxTextArea.this.fSyntaxHighlightingEnabled && SyntaxTextArea.this.fHighlighter != null) {
                SyntaxTextArea.this.doHighlighting(mWTextEvent.getMinLine(), mWTextEvent.getMinLine());
            }
        }

        TextEventHandler() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }
    }

    private class BalanceClickListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            SyntaxTextArea.this.fKeyFilter.actionPerformed(null);
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && (n = SyntaxTextArea.this.getView().posFromPixel(mouseEvent.getPoint())) > -1) {
                switch (SyntaxTextArea.this.getModel().charAt(n)) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++n;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        SyntaxTextArea.this.getView().setSel(n, n);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && (n = SyntaxTextArea.this.getView().posFromPixel(mouseEvent.getPoint())) > -1) {
                switch (SyntaxTextArea.this.getModel().charAt(n)) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++n;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        SyntaxTextArea.this.doBalance();
                    }
                }
            }
        }

        BalanceClickListener() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }
    }

    private class TimerGuy
    implements ActionListener {
        private ActionListener fActionListener;
        private Timer fTimer = new Timer(250, (ActionListener)this, 2, "SyntaxTextArea token kissing");

        public TimerGuy() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }

        public void start() {
            this.fTimer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fActionListener != null) {
                this.fActionListener.actionPerformed(actionEvent);
            }
        }

        public void setActionListener(ActionListener actionListener) {
            this.fActionListener = actionListener;
        }
    }

    private class KissyKeyListener
    extends KeyAdapter
    implements ActionListener {
        public void keyPressed(KeyEvent keyEvent) {
            this.actionPerformed(null);
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == ')') {
                this.kissToken('(', ')');
                return;
            }
            if (c == ']') {
                this.kissToken('[', ']');
                return;
            }
            if (c == '}') {
                this.kissToken('{', '}');
                return;
            }
            SyntaxTextArea.this.fOldSelection.setStart(-1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SyntaxTextArea.this.fOldSelection.getStart() != -1) {
                SyntaxTextArea.this.getView().setSel(SyntaxTextArea.this.fOldSelection);
                SyntaxTextArea.this.fOldSelection.setStart(-1);
            }
            SyntaxTextArea.this.getView().setSelectionNotification(true);
        }

        private void kissToken(char c, char c2) {
            MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
            MWTextView mWTextView = SyntaxTextArea.this.getView();
            Range range = mWTextView.getSel();
            int n = range.getMin();
            int n2 = 1;
            int n3 = n - 2;
            while (n3 >= 0) {
                if (mWTextModel.charAt(n3) == c2) {
                    ++n2;
                } else if (mWTextModel.charAt(n3) == c) {
                    --n2;
                }
                if (n2 == 0) {
                    mWTextView.setSelectionNotification(false);
                    mWTextView.setSel(n3, n3 + 1);
                    if (sTimer == null) {
                        sTimer = new TimerGuy();
                    }
                    sTimer.setActionListener(this);
                    sTimer.start();
                    SyntaxTextArea.this.fOldSelection.setValues(n, n);
                    break;
                }
                --n3;
            }
            if (n3 < 0) {
                ((Component)((Object)SyntaxTextArea.this)).getToolkit().beep();
            }
        }

        KissyKeyListener() {
            SyntaxTextArea.this = SyntaxTextArea.this;
        }
    }

    private static class Test
    extends Frame {
        private Panel fPanel = new TestPanel();
        private Component fComponent;

        public Test() {
            super("SyntaxText Example");
            this.fPanel.setLayout(new BorderLayout());
            this.add((Component)this.fPanel, "Center");
            SyntaxTextArea syntaxTextArea = new SyntaxTextArea();
            syntaxTextArea.setFileType(SyntaxTextArea.M_FILE_TYPE);
            syntaxTextArea.setFont(new Font("Courier", 0, 12));
            syntaxTextArea.setGutterWidth(10);
            this.fComponent = syntaxTextArea;
            this.fPanel.add(this.fComponent, "Center");
            this.addWindowListener(new TestWindowEventHandler());
            ((Component)this).setSize(500, 500);
            ((Component)this).setVisible(true);
        }

        class TestWindowEventHandler
        extends WindowAdapter {
            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent windowEvent) {
                Test.this.dispose();
            }

            public void windowActivated(WindowEvent windowEvent) {
                Test.this.fPanel.requestFocus();
                Test.this.fComponent.requestFocus();
            }

            TestWindowEventHandler() {
                Test.this = Test.this;
            }
        }

        class TestPanel
        extends Panel {
            TestPanel() {
                Test.this = Test.this;
                this.setBackground(Decorations.getColor((int)0));
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        }
    }
}

