/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.CommandHistory;
import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.prefs.CmdWinPrefsColorPanel;
import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.ide.widgets.CommandWindowMenubar;
import com.mathworks.ide.widgets.SyntaxTextArea;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.LeesCharBuffer;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabLooper;
import com.mathworks.mwt.MWClipboardListener;
import com.mathworks.mwt.MWClipboardMonitor;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWFindDialog;
import com.mathworks.mwt.dnd.DragItem;
import com.mathworks.mwt.dnd.DragMessage;
import com.mathworks.mwt.message.MWHandler;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.mwt.text.MWTextViewAdapter;
import com.mathworks.mwt.text.MWTextViewEvent;
import com.mathworks.mwt.text.MWTextViewListener;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.MWWindowResizer;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Range;
import com.mathworks.util.XSelection;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ResourceBundle;

public class MatlabCommandWidget
extends SyntaxTextArea
implements MWCommandCenterOwner,
MWCommandTarget,
MWWindowOwner,
DTApplication,
MWClipboardListener {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.widgets.resources.RES_Widgets");
    private static final int CMD_REPLY = 1;
    private static final int POST_KEY = -13;
    private static final String DEFAULT_PROMPT_STRING = ">> ";
    private static final String DEBUG_PROMPT_STRING = "K>> ";
    private static final String STUDENT_PROMPT_STRING = "EDU>> ";
    private static final String NO_PROMPT_STRING = "";
    private static final int SYNTAX_HILITE = 1;
    private static final int NO_HILITE = 2;
    private static final int ERROR_HILITE = 3;
    private static final int MAX_HISTORY_LENGTH = 6000;
    private static String fPromptStr = ">> ";
    private static String fFindString = "";
    private static int fFindOptions;
    private static Matlab sMatlab;
    private static boolean sStudent;
    private static MatlabCommandWidget sCmdWidget;
    private static MWLooper sCmdLooper;
    private int fPromptMode;
    private int fPromptPos;
    private CommandCallback fCommandCallback;
    private PauseCallback fPauseCallback;
    private MWCommandCenter fCenter;
    private MWMenu fContextMenu;
    private String fHistoryLine = "";
    private int fHistoryMatch = -1;
    private int fHilitingType;
    private int fParkCnt;
    private int fPauseCallbackPending;
    private boolean fPaused;
    private boolean fWaitingForResponse;
    private boolean fInputMode;
    private boolean fPromptPad;
    private boolean fFirstTab;
    private boolean fFirstPaint = true;
    private static boolean fPassThru;
    private static boolean fWasPassingThru;
    private static int fPassThruPromptPos;
    private CharBuffer fKeyBuffer;
    private KeyEventHandler fKeyHandler;
    private KeyEvent fKeyEvent;
    private MWMessage fReplyMsg;
    private LeesCharBuffer fCharBuffer;
    private int fMaxTextSize = Short.MAX_VALUE;
    private int fDiscardTextSize = 8192;
    private CommandWindowMenubar fMenubar;
    private MWFrameProxy fFrame;
    private static final byte[] WIPE_LINE;
    private static final int WIPE_LEN = 8;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$mathworks$jmi$LeesCharBuffer;

    private static void startMatlabLooper() {
        if (sMatlab == null && Matlab.isMatlabAvailable()) {
            sCmdLooper = new MWLooper("MatlabCommandWidget");
            sMatlab = new Matlab(sCmdLooper);
            sStudent = Matlab.isStudentVersion();
        }
    }

    public MatlabCommandWidget(MWCommandCenter mWCommandCenter) {
        InterestHandler interestHandler;
        MWMessage mWMessage;
        if (Matlab.isRuntimeVersion()) {
            sCmdLooper = null;
            sMatlab = null;
            throw new IllegalStateException("Cannot create a MATLAB Command Window.");
        }
        this.setFileType("M-code");
        this.setAutoIndentEnabled(false);
        this.setSmartIndentEnabled(false);
        this.getModel().getCharBuffer().setGrowthFactor(1024);
        this.getView().setGutterWidth(2);
        this.fCenter = mWCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fFrame = sStudent ? new MWFrameProxy((MWWindowOwner)this, this.getLongName()) : new MWFrameProxy((MWWindowOwner)this, this.getShortName());
        this.fMenubar = new CommandWindowMenubar(this.fFrame, this.fCenter);
        MWMenuBar mWMenuBar = this.fMenubar.getMenubar();
        this.fFrame.setMenuBar(mWMenuBar);
        this.fFrame.add((Component)((Object)this));
        this.fCommandCallback = new CommandCallback(1);
        this.fPauseCallback = new PauseCallback();
        if (sMatlab != null) {
            mWMessage = new MWMessage(-8);
            mWMessage.addInteger("familyid", 5);
            mWMessage.addInteger("eventid", 0);
            mWMessage.addInteger("flags", 2);
            interestHandler = new InterestHandler(this.fCommandCallback);
            MatlabLooper.postMatlabMessage((MWMessage)mWMessage, (MWHandler)interestHandler);
        }
        this.fCenter.addCommand(900, true, 88);
        this.fCenter.addCommand(910, true, 67);
        this.fCenter.addCommand(920, true, 86);
        this.fCenter.addCommand(1000, true, 12);
        this.getView().overrideCommand(31, (ActionListener)new InsertChar());
        this.getView().overrideCommand(34, (ActionListener)new Paste());
        mWMessage = this.getKeyMap();
        mWMessage.setKeyBinding(37, 0, 10);
        mWMessage.setKeyBinding(37, 0, 8);
        mWMessage.setKeyBinding(37, 0, 127);
        mWMessage.setKeyBinding(37, 0, 38);
        mWMessage.setKeyBinding(37, 0, 40);
        mWMessage.setKeyBinding(37, 0, 37);
        mWMessage.setKeyBinding(37, 0, 36);
        mWMessage.setKeyBinding(37, 0, 35);
        mWMessage.setKeyBinding(37, 1, 36);
        mWMessage.setKeyBinding(37, 1, 35);
        mWMessage.setKeyBinding(37, 2, 65);
        mWMessage.setKeyBinding(37, 2, 66);
        mWMessage.setKeyBinding(37, 2, 67);
        mWMessage.setKeyBinding(37, 2, 68);
        mWMessage.setKeyBinding(37, 2, 69);
        mWMessage.setKeyBinding(37, 2, 70);
        mWMessage.setKeyBinding(37, 2, 72);
        mWMessage.setKeyBinding(37, 2, 75);
        mWMessage.setKeyBinding(37, 2, 76);
        mWMessage.setKeyBinding(37, 2, 78);
        mWMessage.setKeyBinding(37, 2, 80);
        mWMessage.setKeyBinding(37, 2, 82);
        mWMessage.setKeyBinding(37, 2, 85);
        mWMessage.setKeyBinding(37, 2, 87);
        mWMessage.setKeyBinding(37, 2, 89);
        this.fKeyHandler = new KeyEventHandler();
        this.getView().addKeyFilter((KeyListener)this.fKeyHandler);
        this.fKeyEvent = new KeyEvent((Component)((Object)this), 401, 0L, 0, 10, '\n');
        this.getView().addTextViewListener((MWTextViewListener)new TextViewEventHandler());
        this.getView().addMouseListener((MouseListener)new ContextListener());
        this.getView().setCtrlCKeyHandler((KeyListener)new KeyEventFilter());
        this.setCommandWindowFont();
        this.setCommandWindowTabSize();
        this.setSyntaxHighlightingEnabled(CmdWinPrefsColorPanel.isSyntaxHighlightingEnabled());
        this.setHighlightColors();
        interestHandler = CmdWinPrefsColorPanel.getBackgroundColor();
        this.setBackground(interestHandler.getColor());
        this.setTextStyle(CmdWinPrefsColorPanel.getTextColor());
        int n = Prefs.getIntegerPref((String)"CommandWindowSessionSize", (int)0);
        this.setCommandSessionSize(n);
        PrefsChangeListener prefsChangeListener = new PrefsChangeListener();
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"CommandWindowFont");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"CommandWindowUseDesktopFont");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"CommandWindowBackgroundColor");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"CommandWindowTextColor");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"CommandWindowSyntaxHighlighting");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"CommandWindowSpacesPerTab");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"CommandWindowSessionSize");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"GeneralFont");
        Prefs.addListener((PrefListener)prefsChangeListener, (String)"Syncolor");
        this.fKeyBuffer = new CharBuffer();
        this.fHilitingType = 1;
        this.fReplyMsg = new MWMessage(-2);
        this.fCharBuffer = new LeesCharBuffer(4096, 4096);
        this.fReplyMsg.addObject("result", (Object)this.fCharBuffer);
        this.createContextMenu();
        fPromptStr = MatlabCommandWidget.basePromptString();
        this.addPrompt(true);
        this.fPaused = false;
        this.getModel().startCommand("Nothing");
        this.getModel().endCommand();
        this.enableSelectionDependentCommands();
        this.enableUndoRedo();
        if (!PlatformInfo.isUnix()) {
            MWClipboardMonitor.addListener((MWClipboardListener)this);
            this.clipboardContentTypeChanged(((Component)((Object)this)).getToolkit().getSystemClipboard().getContents(this));
        }
        sCmdWidget = this;
        ((Component)((Object)this)).addComponentListener(new SizeChangeListener());
    }

    public MatlabCommandWidget() {
        this(null);
    }

    public static void executeCommand(String string) {
        if (sMatlab == null) {
            return;
        }
        if (string == null || string.length() == 0) {
            return;
        }
        if (sCmdWidget != null) {
            MWTextView mWTextView = sCmdWidget.getView();
            MWTextModel mWTextModel = sCmdWidget.getModel();
            if (!(MatlabCommandWidget.sCmdWidget.fPromptPos != mWTextModel.length() || sCmdWidget.isWaitingForResponse() || MatlabCommandWidget.sCmdWidget.fInputMode || MatlabCommandWidget.sCmdWidget.fPaused)) {
                mWTextModel.insert(mWTextModel.length(), string);
                sCmdWidget.sendCommand();
                return;
            }
            int n = mWTextView.getSelStart();
            int n2 = mWTextView.getSelEnd();
            int n3 = MatlabCommandWidget.sCmdWidget.fHilitingType;
            int n4 = string.length();
            int n5 = MatlabCommandWidget.sCmdWidget.fPromptPos;
            int n6 = fPromptStr.length();
            MatlabCommandWidget.sCmdWidget.fPromptPos += n6;
            MatlabCommandWidget.sCmdWidget.fHilitingType = 2;
            mWTextModel.insert(n5 - n6, fPromptStr);
            MatlabCommandWidget.sCmdWidget.fHilitingType = 1;
            mWTextModel.insert(n5, string);
            MatlabCommandWidget.sCmdWidget.fPromptPos += n4;
            MatlabCommandWidget.sCmdWidget.fPromptPad = false;
            if (n4 > 0) {
                MatlabCommandWidget.sCmdWidget.fHilitingType = 2;
                if (string.charAt(--n4) == '\n' && n4 - 1 > 0 && string.charAt(n4 - 1) == '\r') {
                    --MatlabCommandWidget.sCmdWidget.fPromptPos;
                    mWTextModel.delete(n5 += --n4, n5 + 1);
                } else if (!string.endsWith("\n") && !string.endsWith("\r")) {
                    ++MatlabCommandWidget.sCmdWidget.fPromptPos;
                    mWTextModel.insert(n5 + ++n4, '\n');
                }
                MatlabCommandWidget.sCmdWidget.fHilitingType = n3;
                ++n4;
            }
            mWTextView.setSel(n += (n4 += n6), n2 += n4);
            CommandHistory.addLine(string);
        }
        sMatlab.evalConsoleOutput(string);
    }

    private static String basePromptString() {
        if (sStudent) {
            return STUDENT_PROMPT_STRING;
        }
        return DEFAULT_PROMPT_STRING;
    }

    private String promptString(int n) {
        String string = n == 0 || n == 7 ? MatlabCommandWidget.basePromptString() : (n == 1 || n == 3 ? DEBUG_PROMPT_STRING : NO_PROMPT_STRING);
        return string;
    }

    private synchronized void setWaitingForResponse(boolean bl) {
        this.fWaitingForResponse = bl;
    }

    private synchronized boolean isWaitingForResponse() {
        return this.fWaitingForResponse;
    }

    protected void doHighlighting(int n, int n2) {
        if (this.fHilitingType == 2) {
            return;
        }
        if (this.fHilitingType == 1) {
            int n3 = this.fPromptPos > this.getModel().length() ? this.getModel().lineFromPos(this.getModel().length()) : this.getModel().lineFromPos(this.fPromptPos);
            if (n < n3) {
                n = n3;
            }
            if (n2 < n3) {
                n2 = n3;
            }
            super.doHighlighting(n, n2);
            return;
        }
        if (this.fHilitingType == 3) {
            this.errorHilite(n, n2 - 1);
        }
    }

    private void errorHilite(int n, int n2) {
        MWTextModel mWTextModel;
        block3: {
            if (n2 < n) {
                n2 = n;
            }
            mWTextModel = this.getModel();
            mWTextModel.deferStyleChangeNotification();
            try {
                int n3 = mWTextModel.getLineStart(n);
                int n4 = mWTextModel.getLineEndNoEOL(n2);
                MWStyle mWStyle = GeneralPrefsColorPanel.getErrorHighlightingStyle();
                if (mWStyle == null) break block3;
                mWTextModel.setStyle(n3, n4, mWStyle);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                mWTextModel.resumeStyleChangeNotification();
                throw throwable;
            }
        }
        Object var8_7 = null;
        mWTextModel.resumeStyleChangeNotification();
    }

    private int hasPrompt(String string) {
        int n = 0;
        int n2 = this.getModel().length();
        int n3 = string.length();
        if (n3 > 0 && this.fPromptPos == n2) {
            String string2;
            if (n2 >= n3 && (string2 = this.getModel().getText(n2 - n3, n2)).equals(string)) {
                n = 1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    private synchronized void addPrompt(boolean bl) {
        block22: {
            boolean bl2 = false;
            int n = this.getModel().length();
            int n2 = this.hasPrompt(fPromptStr);
            if (n2 == 1 && fPromptStr.equals(MatlabCommandWidget.basePromptString()) && this.hasPrompt(DEBUG_PROMPT_STRING) == 1) {
                n2 = 0;
            }
            try {
                char[] cArray;
                this.getModel().suspendTextEventNotification();
                if (n2 == 1) {
                    bl2 = true;
                } else if (n2 == 0) {
                    if (fPromptStr.equals(DEBUG_PROMPT_STRING)) {
                        if (this.hasPrompt(MatlabCommandWidget.basePromptString()) == 1) {
                            int n3 = MatlabCommandWidget.basePromptString().length();
                            this.fPromptPos += fPromptStr.length() - n3;
                            this.getModel().replace(n - n3, n, fPromptStr);
                            bl2 = true;
                        }
                    } else if (this.hasPrompt(DEBUG_PROMPT_STRING) == 1) {
                        int n4 = DEBUG_PROMPT_STRING.length();
                        this.fPromptPos += fPromptStr.length() - n4;
                        this.getModel().replace(n - n4, n, fPromptStr);
                        bl2 = true;
                    }
                } else if (!bl && fPromptStr.length() == 0) {
                    int n5 = 0;
                    if (this.hasPrompt(DEBUG_PROMPT_STRING) == 1) {
                        n5 = DEBUG_PROMPT_STRING.length();
                    } else if (this.hasPrompt(MatlabCommandWidget.basePromptString()) == 1) {
                        n5 = MatlabCommandWidget.basePromptString().length();
                    }
                    if (n5 > 0) {
                        if (this.fPromptPad) {
                            ++n5;
                            this.fPromptPad = false;
                        }
                        this.fPromptPos -= n5;
                        this.getModel().replace(n - n5, n, fPromptStr);
                        bl2 = true;
                        if (this.fPauseCallbackPending == 0 && !this.fInputMode) {
                            ++this.fPauseCallbackPending;
                            if (sMatlab != null) {
                                sMatlab.eval(NO_PROMPT_STRING, (CompletionObserver)this.fPauseCallback);
                            }
                        }
                    } else if (this.fPromptPad && this.fPromptPos == n && n > 0) {
                        --this.fPromptPos;
                        this.fPromptPad = false;
                        this.getModel().delete(this.fPromptPos, this.fPromptPos + 1);
                    }
                }
                if (bl2) break block22;
                n = this.getModel().length();
                if (n > 0 && fPromptStr.length() > 0 && (cArray = this.getModel().getRawCharBuf())[n - 1] != '\n') {
                    this.getModel().insert(n++, '\n');
                }
                this.getModel().insert(n, fPromptStr);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.getModel().resumeTextEventNotification();
                throw throwable;
            }
        }
        Object var7_9 = null;
        this.getModel().resumeTextEventNotification();
        this.fPromptPos = this.getModel().length();
    }

    private void resetPrompt() {
        this.getModel().insert(this.getModel().length(), '\n');
        this.fPromptPos = this.getModel().length();
        this.addPrompt(true);
        this.getModel().clearUndoHistory();
        this.enableUndoRedo();
    }

    private void insertLine(char[] cArray, int n, int n2) {
        int n3 = this.getView().getSelStart();
        int n4 = this.getView().getSelEnd();
        int n5 = WIPE_LINE.length;
        if (n >= n5) {
            int n6 = 0;
            while (n6 < n5) {
                if (WIPE_LINE[n6] != cArray[n6]) break;
                ++n6;
            }
            if (n6 >= n5) {
                MWTextModel mWTextModel = this.getModel();
                this.fPromptPos -= 8;
                mWTextModel.startCommand("Delete");
                mWTextModel.delete(n2 - 8, n2);
                mWTextModel.endCommand();
                n3 -= 8;
                n4 -= 8;
                System.arraycopy(cArray, n5, cArray, 0, n - n5);
                n -= n5;
                n2 -= 8;
            }
        }
        this.fPromptPos += n;
        if (n > 0) {
            boolean bl = this.getView().setHScrollLock(true);
            try {
                this.getModel().insert(n2, cArray, n);
            }
            finally {
                Object var10_10 = null;
                this.getView().setHScrollLock(bl);
            }
        }
        this.getView().setSel(n3 += n, n4 += n);
    }

    private void insertReplyText(LeesCharBuffer leesCharBuffer) {
        if (leesCharBuffer.length() > 0) {
            int n = this.fPromptPos - fPromptStr.length();
            if (n < 0) {
                n = 0;
            }
            char[] cArray = leesCharBuffer.getRawBuf();
            int n2 = leesCharBuffer.length() - 1;
            if (this.fPromptPad) {
                if (cArray[n2] == '\n') {
                    if (--n2 >= 0 && cArray[n2] == '\r') {
                        --n2;
                    }
                    this.fPromptPad = false;
                } else if (cArray[n2] == '\r') {
                    --n2;
                    this.fPromptPad = false;
                }
                --n;
            } else if (cArray[n2] != '\n' && cArray[n2] != '\r' && n != this.getModel().length()) {
                this.fPromptPad = true;
                ++this.fPromptPos;
                int n3 = this.getView().getSelStart() + 1;
                int n4 = this.getView().getSelEnd() + 1;
                this.getModel().insert(n, '\n');
                this.getView().setSel(n3, n4);
            } else if (cArray[n2] == '\n' && n2 - 1 > 0 && cArray[n2 - 1] == '\r') {
                cArray[--n2] = 10;
            } else if (cArray[n2] == '\r') {
                cArray[n2] = 10;
            }
            this.insertLine(cArray, ++n2, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doCommandReply(LeesCharBuffer leesCharBuffer, int n, boolean bl) {
        try {
            boolean bl2 = leesCharBuffer != null ? leesCharBuffer.getChars() != null : false;
            MatlabCommandWidget matlabCommandWidget = this;
            synchronized (matlabCommandWidget) {
                block35: {
                    block32: {
                        block31: {
                            int n2;
                            block33: {
                                block30: {
                                    block34: {
                                        n2 = Matlab.getInputRequester((int)n);
                                        if (n2 == 33) break block31;
                                        if (bl) break block33;
                                        if (Matlab.getExecutionStatus((int)n) == 33 || Matlab.getCodeBlockStatus((int)n) != 0) break block34;
                                        if (this.fParkCnt == 0) {
                                            fPromptStr = this.promptString(n2);
                                            this.fPromptMode = n2;
                                            break block30;
                                        } else if (this.fPromptMode == 1 || this.fPromptMode == 3) {
                                            fPromptStr = DEBUG_PROMPT_STRING;
                                            break block30;
                                        } else {
                                            fPromptStr = NO_PROMPT_STRING;
                                            this.fPromptMode = -1;
                                        }
                                        break block30;
                                    }
                                    if (Matlab.getExecutionStatus((int)n) == 33 && fPromptStr.equals(DEBUG_PROMPT_STRING)) {
                                        fPromptStr = DEBUG_PROMPT_STRING;
                                        this.fPromptMode = 1;
                                    } else {
                                        fPromptStr = NO_PROMPT_STRING;
                                        this.fPromptMode = -1;
                                    }
                                }
                                if (n2 == 4 || n2 == 5) {
                                    this.fPaused = true;
                                    this.fPromptMode = n2;
                                }
                                this.fInputMode = n2 == 2;
                                MatlabLooper.setMatlabWaitingForCommandInput((boolean)this.fInputMode);
                                if (Matlab.getExecutionStatus((int)n) == 4) {
                                    this.fPaused = false;
                                    if (this.fPromptMode != 1 && this.fPromptMode != 3) {
                                        this.fPromptMode = 0;
                                    }
                                    fPromptStr = this.promptString(this.fPromptMode);
                                    this.resetPrompt();
                                    break block31;
                                } else {
                                    this.addPrompt(!this.fPaused && !this.fInputMode);
                                }
                                break block31;
                            }
                            if (Matlab.getExecutionStatus((int)n) == 34 || Matlab.getExecutionStatus((int)n) == 35) {
                                this.fParkCnt = Matlab.getExecutionStatus((int)n) == 34 ? ++this.fParkCnt : --this.fParkCnt;
                                this.setWaitingForResponse(Matlab.getExecutionStatus((int)n) == 35);
                                Object var9_7 = null;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 3] lbl45 : MonitorExitStatement: MONITOREXIT : var8_5
                                Object var7_9 = null;
                                if (leesCharBuffer == null) return;
                                leesCharBuffer.releaseChars();
                                return;
                            }
                            if (n2 == 7) {
                                if (!this.isWaitingForResponse() && this.fParkCnt == 0 || this.fParkCnt == 1 && (this.fPromptMode == 1 || this.fPromptMode == 3)) {
                                    this.fPaused = false;
                                    this.fInputMode = false;
                                    MatlabLooper.setMatlabWaitingForCommandInput((boolean)false);
                                    if (this.fPromptMode != 1 && this.fPromptMode != 3) {
                                        this.fPromptMode = 0;
                                    }
                                    fPromptStr = this.promptString(this.fPromptMode);
                                    this.resetPrompt();
                                }
                                Object var9_8 = null;
                                // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 3] lbl62 : MonitorExitStatement: MONITOREXIT : var8_5
                                Object var7_10 = null;
                                if (leesCharBuffer == null) return;
                                leesCharBuffer.releaseChars();
                                return;
                            }
                            if (n2 == 4 || n2 == 5) {
                                this.fPaused = true;
                            }
                            if (n2 == 6) {
                                this.fPaused = true;
                            }
                            if (leesCharBuffer == null) {
                                this.fPromptMode = n2;
                                String string = this.promptString(n2);
                                this.fInputMode = n2 == 2;
                                MatlabLooper.setMatlabWaitingForCommandInput((boolean)this.fInputMode);
                                if (!fPromptStr.equals(string)) {
                                    fPromptStr = string;
                                    this.addPrompt(!this.fPaused && !this.fInputMode && n2 != -1);
                                }
                            }
                        }
                        if (leesCharBuffer == null) break block35;
                        if (Matlab.getExecutionStatus((int)n) == 1 || Matlab.getExecutionStatus((int)n) == 2) {
                            this.fHilitingType = 3;
                        } else {
                            this.fHilitingType = 2;
                            this.getModel().suspendTextEventNotification();
                        }
                        try {
                            if (!bl2) break block32;
                            this.insertReplyText(leesCharBuffer);
                        }
                        catch (Throwable throwable) {
                            Object var11_16 = null;
                            if (this.fHilitingType != 2) throw throwable;
                            this.getModel().resumeTextEventNotification();
                            throw throwable;
                        }
                    }
                    Object var11_15 = null;
                    if (this.fHilitingType == 2) {
                        this.getModel().resumeTextEventNotification();
                    }
                    this.enforceTextSize();
                    this.fHilitingType = 1;
                }
                if (!bl && Matlab.getExecutionStatus((int)n) != 33) {
                    this.setWaitingForResponse(false);
                    this.resetMoreCount();
                }
                if (!fPromptStr.equals(NO_PROMPT_STRING)) {
                    this.unbufferKeys();
                }
            }
            Object var7_11 = null;
            if (leesCharBuffer == null) return;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (leesCharBuffer == null) throw throwable;
            leesCharBuffer.releaseChars();
            throw throwable;
        }
        leesCharBuffer.releaseChars();
    }

    private void resetMoreCount() {
        sMatlab.setWindowSize(-1, 0, 0);
    }

    private void setCommandSessionSize(int n) {
        int n2;
        int n3;
        switch (n) {
            case 0: {
                n3 = Short.MAX_VALUE;
                n2 = 16384;
                break;
            }
            case 1: {
                n3 = 131071;
                n2 = 16384;
                break;
            }
            case 2: {
                n3 = 524287;
                n2 = 65536;
                break;
            }
            case 3: {
                n3 = 0x1FFFFF;
                n2 = 65536;
                break;
            }
            case 4: {
                n3 = 0x7FFFFF;
                n2 = 65536;
                break;
            }
            default: {
                n3 = this.fMaxTextSize;
                n2 = 0;
            }
        }
        if (n3 != this.fMaxTextSize) {
            int n4 = this.fMaxTextSize;
            this.fMaxTextSize = n3;
            this.getModel().getCharBuffer().setCapacityIncrement(n2);
            this.enforceTextSize();
            if (n3 < n4) {
                this.getModel().getCharBuffer().reduceCapacity(n3 + 1);
            }
        }
    }

    private void enforceTextSize() {
        MWTextModel mWTextModel = this.getModel();
        if (mWTextModel.length() > this.fMaxTextSize) {
            int n = this.fDiscardTextSize + (mWTextModel.length() - this.fMaxTextSize);
            int n2 = mWTextModel.length();
            while (n < n2 && mWTextModel.charAt(n) != '\n' && mWTextModel.charAt(n) != '\r') {
                ++n;
            }
            if (n < n2) {
                if (mWTextModel.charAt(n) == '\r') {
                    ++n;
                }
                if (mWTextModel.charAt(n) == '\n') {
                    ++n;
                }
            } else {
                n = this.fDiscardTextSize + (mWTextModel.length() - this.fMaxTextSize);
            }
            this.fPromptPos -= n;
            int n3 = this.getView().getSelStart() - n;
            int n4 = this.getView().getSelEnd() - n;
            try {
                mWTextModel.suspendTextEventNotification();
                mWTextModel.startCommand("Delete");
                mWTextModel.delete(0, n);
                mWTextModel.endCommand();
            }
            finally {
                Object var7_6 = null;
                mWTextModel.resumeTextEventNotification();
            }
            this.getView().setSel(n3, n4);
        }
    }

    private synchronized void sendCommand() {
        if (sMatlab == null) {
            return;
        }
        this.setWaitingForResponse(true);
        String string = this.getModel().getText(this.fPromptPos, this.getModel().length());
        if (!string.endsWith("\n") && !string.endsWith("\r")) {
            this.getModel().insert(this.getModel().length(), '\n');
        }
        this.fPromptPos = this.getModel().length();
        fPromptStr = NO_PROMPT_STRING;
        this.fPromptPad = false;
        if (string.length() < 6000) {
            CommandHistory.addLine(string);
        }
        if (string.length() == 0) {
            string = new String("\n");
        }
        this.getModel().clearUndoHistory();
        this.enableUndoRedo();
        sMatlab.evalStreamOutput(string, (CompletionObserver)this.fCommandCallback, this.fReplyMsg);
    }

    private void doBackspace() {
        Range range = this.getView().getSel();
        if (range.getMin() > this.fPromptPos || range.getMin() == this.fPromptPos && !range.isEmpty()) {
            this.getView().charLeftDelete();
        }
    }

    private void doDelete() {
        Range range = this.getView().getSel();
        if (range.getMin() >= this.fPromptPos) {
            this.getView().charRightDelete();
        }
    }

    private void doKill() {
        Range range = this.getView().getSel();
        if (range.getMin() >= this.fPromptPos && range.getMin() < this.getModel().length()) {
            this.getView().setSel(range.getMin(), this.getModel().length());
            this.getView().copy();
            this.getView().setSel(range);
            this.getModel().startCommand("Delete");
            this.getModel().delete(this.getView().getSelStart(), this.getModel().length());
            this.getModel().endCommand();
        }
    }

    private void doCmdHome() {
        int n = this.getModel().lineFromPos(this.getModel().length());
        this.getView().setTopLine(n);
    }

    private void doClc() {
        this.fPromptPad = false;
        this.getModel().delete(0, this.getModel().length());
        this.addPrompt(true);
    }

    /*
     * Unable to fully structure code
     */
    private String stripPrompts(String var1_1) {
        var3_2 = MatlabCommandWidget.basePromptString().length();
        var4_3 = "K>> ".length();
        var2_4 = 0;
        while (var2_4 < var1_1.length()) {
            if (var1_1.regionMatches(var2_4, MatlabCommandWidget.basePromptString(), 0, var3_2)) {
                var1_1 = String.valueOf(var1_1.substring(0, var2_4)) + var1_1.substring(var2_4 + var3_2, var1_1.length());
                continue;
            }
            if (!var1_1.regionMatches(var2_4, "K>> ", 0, var4_3)) ** GOTO lbl12
            var1_1 = String.valueOf(var1_1.substring(0, var2_4)) + var1_1.substring(var2_4 + var4_3, var1_1.length());
            continue;
lbl-1000:
            // 1 sources

            {
                ++var2_4;
lbl12:
                // 2 sources

                ** while (var2_4 < var1_1.length() && var1_1.charAt((int)var2_4) != '\n' && var1_1.charAt((int)var2_4) != '\r')
            }
lbl13:
            // 2 sources

            while (var2_4 < var1_1.length() && (var1_1.charAt(var2_4) == '\n' || var1_1.charAt(var2_4) == '\r')) {
                ++var2_4;
            }
        }
        return var1_1;
    }

    private boolean doMFileError() {
        int n;
        String string = sRes.getString("msg.Errorin");
        String string2 = sRes.getString("msg.Errorusing");
        String string3 = sRes.getString("msg.ErrorFile");
        String string4 = sRes.getString("msg.Line");
        String string5 = sRes.getString("msg.Syntaxerrorin");
        String string6 = sRes.getString("msg.Online");
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.getModel().lineFromPos(this.getView().getSel().getMin());
        String string7 = this.getModel().getText(this.getModel().getLineStart(n2), this.getModel().getLineEndNoEOL(n2));
        if (string7.startsWith(string2)) {
            string7 = this.getModel().getText(this.getModel().getLineStart(n2), this.getModel().getLineEndNoEOL(n2));
        } else if (string7.startsWith(string3)) {
            string7 = this.getModel().getText(this.getModel().getLineStart(n2), this.getModel().getLineEndNoEOL(n2));
        } else if (string7.startsWith("??? ")) {
            string7 = this.getModel().getText(this.getModel().getLineStart(++n2), this.getModel().getLineEndNoEOL(n2));
            if (string7.length() == 0) {
                string7 = this.getModel().getText(this.getModel().getLineStart(++n2), this.getModel().getLineEndNoEOL(n2));
            }
        } else if (string7.startsWith(string6)) {
            string7 = this.getModel().getText(this.getModel().getLineStart(--n2), this.getModel().getLineEndNoEOL(n2));
        }
        if (string7.startsWith(string)) {
            n = string.length();
        } else if (string7.startsWith(string3)) {
            n = string3.length();
            bl2 = true;
        } else if (string7.startsWith(string2)) {
            n = string2.length();
            bl = true;
        } else if (string7.startsWith(string5)) {
            n = string5.length();
        } else {
            return false;
        }
        String string8 = string7.substring(n, string7.length());
        n = string8.length();
        if (string8.charAt(n - 1) == ')') {
            --n;
            while (string8.charAt(n) != '(') {
                --n;
            }
            string8 = string8.substring(0, n - 1).trim();
        }
        string7 = this.getModel().getText(this.getModel().getLineStart(++n2), this.getModel().getLineEndNoEOL(n2));
        if (bl) {
            sMatlab.evalConsoleOutput("edit('" + string8 + "');");
            return true;
        }
        if (bl2) {
            int n3 = string8.indexOf(string4);
            String string9 = string8.substring(0, n3 - 1);
            String string10 = string8.substring(n3 + string4.length());
            string10 = string10.substring(0, string10.indexOf(" "));
            EditorApplication.openDocumentToLine(string9, Integer.parseInt(string10));
            return true;
        }
        if (!string7.startsWith(string6)) {
            return false;
        }
        n = string6.length();
        while (n < string7.length() && Character.isDigit(string7.charAt(n))) {
            ++n;
        }
        String string11 = string7.substring(string6.length(), n);
        EditorApplication.openDocumentToLine(string8, Integer.parseInt(string11));
        return true;
    }

    private void doEnter() {
        Range range = this.getView().getSel();
        String string = this.getModel().getText(range);
        if (!string.endsWith("\r") && !string.endsWith("\n")) {
            string = String.valueOf(string) + "\n";
        }
        string = this.stripPrompts(string);
        this.getView().setSel(this.getModel().length());
        this.getModel().replace(this.getView().getSel(), string);
        this.sendCommand();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doPaste() {
        boolean bl;
        block8: {
            block9: {
                bl = false;
                Range range = this.getView().getSel();
                if (range.getMin() < this.fPromptPos) {
                    this.getView().setSel(this.getModel().length());
                }
                this.getModel().startCommand("Paste");
                try {
                    if (PlatformInfo.isUnix()) {
                        bl = this.doActualPaste(XSelection.getSelection());
                        break block8;
                    }
                    Transferable transferable = ((Component)((Object)this)).getToolkit().getSystemClipboard().getContents(this);
                    if (transferable == null) break block8;
                    if (transferable.getTransferDataFlavors() == null) {
                        Object var4_4 = null;
                        break block9;
                    }
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            bl = this.doActualPaste((String)transferable.getTransferData(DataFlavor.stringFlavor));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.getModel().endCommand();
                    if (!bl) throw throwable;
                    this.getModel().clearUndoHistory();
                    this.enableUndoRedo();
                    throw throwable;
                }
            }
            this.getModel().endCommand();
            if (!bl) return;
            this.getModel().clearUndoHistory();
            this.enableUndoRedo();
            return;
        }
        Object var4_5 = null;
        this.getModel().endCommand();
        if (!bl) return;
        this.getModel().clearUndoHistory();
        this.enableUndoRedo();
    }

    private boolean doActualPaste(String string) {
        boolean bl = false;
        string = this.stripPrompts(string);
        this.getModel().replace(this.getView().getSel(), string);
        if (string.endsWith("\n") || string.endsWith("\r")) {
            this.sendCommand();
            bl = true;
        }
        return bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.fFirstPaint) {
            this.fFirstPaint = false;
            if (sMatlab != null) {
                sMatlab.setWindowSize(this.getView().numCompleteLinesHigh(), this.getView().getTextCanvasSize().width / this.getModel().getFontWidth(), -51);
            }
        }
        super.paint(graphics);
    }

    private synchronized void bufferKey(KeyEvent keyEvent) {
        this.fKeyBuffer.append(keyEvent.getKeyChar());
        keyEvent.consume();
    }

    private synchronized void unbufferKeys() {
        int n = 0;
        int n2 = this.fKeyBuffer.length();
        while (n < n2) {
            char c = this.fKeyBuffer.getAt(n);
            ++n;
            if (c == '\n' || c == '\r') {
                this.fKeyHandler.keyPressed(new KeyEvent((Component)((Object)this), 401, 0L, 0, 10, '\n'));
                break;
            }
            this.fKeyEvent.setKeyChar(c);
            this.doKey(this.fKeyEvent);
        }
        this.fKeyBuffer.delete(0, n);
    }

    protected synchronized void doKey(KeyEvent keyEvent) {
        if (this.endPause(keyEvent)) {
            return;
        }
        if (this.isWaitingForResponse()) {
            this.bufferKey(keyEvent);
            return;
        }
        Range range = this.getView().getSel();
        if (range.getMin() < this.fPromptPos) {
            this.getView().setSel(this.getModel().length());
        }
        this.getView().insertChar(keyEvent.getKeyChar());
        this.enableSelectionDependentCommands();
        this.enableUndoRedo();
        this.fHistoryMatch = -1;
    }

    private void enableSelectionDependentCommands() {
        boolean bl;
        Range range = this.getView().getSel();
        boolean bl2 = bl = !range.isEmpty();
        if (bl && range.getMin() >= this.fPromptPos) {
            this.fCenter.setCommandEnabled(900, true);
            this.fCenter.setCommandEnabled(1000, true);
        } else {
            this.fCenter.setCommandEnabled(900, false);
            this.fCenter.setCommandEnabled(1000, false);
        }
        this.fCenter.setCommandEnabled(910, bl);
        this.fCenter.setCommandEnabled(1502, bl);
        this.fCenter.setCommandEnabled(132, bl);
        this.fCenter.setCommandEnabled(123, bl);
        this.fCenter.setCommandEnabled(560, bl);
        this.fCenter.setCommandEnabled(1103, bl);
        this.fCenter.setCommandEnabled(1105, bl);
    }

    private void enableUndoRedo() {
        this.fCenter.setCommandEnabled(800, this.getModel().canUndo());
        this.fCenter.setCommandEnabled(810, this.getModel().canRedo());
    }

    private void doHistory(int n) {
        boolean bl;
        boolean bl2 = bl = n == 38;
        if (this.fHistoryMatch == -1) {
            this.fHistoryLine = this.getModel().getText(this.fPromptPos, this.getModel().length());
        }
        this.fHistoryMatch = bl ? CommandHistory.getPriorHistoryMatch(this.fHistoryLine, this.fHistoryMatch) : CommandHistory.getNextHistoryMatch(this.fHistoryLine, this.fHistoryMatch);
        if (this.fHistoryMatch != -1) {
            this.getModel().delete(this.fPromptPos, this.getModel().length());
            this.getModel().insert(this.getModel().length(), CommandHistory.getHistoryLine(this.fHistoryMatch));
            return;
        }
        this.getModel().delete(this.fPromptPos, this.getModel().length());
        this.getModel().insert(this.getModel().length(), this.fHistoryLine);
    }

    private void doCtlU() {
        this.getModel().startCommand("Delete");
        this.getModel().delete(this.fPromptPos, this.getModel().length());
        this.getModel().endCommand();
    }

    private boolean doTabCompletion() {
        if (sMatlab != null && sMatlab.maxTabCompletions() > 0) {
            int n = this.getView().getSelEnd();
            if (n <= this.fPromptPos) {
                return true;
            }
            String string = this.getModel().getText(this.fPromptPos, n);
            this.setWaitingForResponse(true);
            if (this.fFirstTab) {
                TabFindHandler tabFindHandler = new TabFindHandler(string);
                Matlab.whenMatlabReady((Runnable)tabFindHandler);
            } else {
                TabShowHandler tabShowHandler = new TabShowHandler();
                Matlab.whenMatlabReady((Runnable)tabShowHandler);
            }
            return true;
        }
        return false;
    }

    private void doLeft() {
        Range range = this.getView().getSel();
        if (!range.isEmpty() || range.getMin() != this.fPromptPos) {
            this.getView().charLeft();
            return;
        }
        this.getView().borderBeep();
    }

    private void doShiftHome() {
        Range range = this.getView().getSel();
        if (range.getMin() > this.fPromptPos) {
            this.getView().setSel(range.getStart(), this.fPromptPos);
        }
    }

    private void doShiftEnd() {
        Range range = this.getView().getSel();
        if (range.getMax() < this.getModel().length()) {
            this.getView().setSel(range.getStart(), this.getModel().length());
        }
    }

    private boolean endPause(KeyEvent keyEvent) {
        boolean bl = false;
        if (this.PassingThrough()) {
            this.fPaused = true;
        }
        if (this.WasPassingThrough()) {
            this.fPaused = false;
        }
        if (this.fPromptMode == 6) {
            this.fPaused = true;
        }
        if (this.fPaused || this.fPromptMode == 5 || this.fPromptMode == 4) {
            MWMessage mWMessage = new MWMessage(-13);
            mWMessage.addInteger("arguments", (int)keyEvent.getKeyChar());
            MatlabLooper.interruptMatlab((MWMessage)mWMessage);
            keyEvent.consume();
            if (!this.PassingThrough()) {
                this.fPaused = false;
            }
            bl = true;
        }
        return bl;
    }

    private void doEnterKey() {
        Range range = this.getView().getSel();
        if (range.getMin() < this.fPromptPos) {
            if (!range.isEmpty()) {
                this.doEnter();
            } else {
                this.sendCommand();
            }
        } else {
            this.sendCommand();
        }
        this.fHistoryMatch = -1;
    }

    public static void setPassThrough(boolean bl) {
        fPassThru = bl;
        boolean bl2 = fWasPassingThru = !bl;
        if (!bl) {
            fPassThruPromptPos = -1;
        }
    }

    private boolean PassingThrough() {
        return fPassThru;
    }

    private boolean WasPassingThrough() {
        boolean bl = fWasPassingThru;
        fWasPassingThru = false;
        return bl;
    }

    public void trackDrag(DragMessage dragMessage) {
    }

    public boolean willReceiveDrag(Transferable transferable, MouseEvent mouseEvent, Rectangle rectangle) {
        if (transferable.isDataFlavorSupported(DragItem.STRING_FLAVOR) || transferable.isDataFlavorSupported(DragItem.STRINGS_FLAVOR)) {
            Rectangle rectangle2 = ((Component)((Object)this)).getBounds();
            rectangle2.y = 1;
            rectangle2.x = 1;
            rectangle2.width -= 3;
            rectangle2.height -= 3;
            rectangle.setBounds(rectangle2);
            return true;
        }
        return false;
    }

    public void receiveDrop(Transferable transferable) {
        this.getModel().startCommand("Drop");
        try {
            try {
                String string;
                Range range = this.getView().getSel();
                if (range.getMin() < this.fPromptPos) {
                    this.getView().setSel(this.getModel().length());
                }
                if (transferable.isDataFlavorSupported(DragItem.STRING_FLAVOR)) {
                    string = (String)transferable.getTransferData(DragItem.STRING_FLAVOR);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray = (String[])transferable.getTransferData(DragItem.STRINGS_FLAVOR);
                    int n = 0;
                    while (n < stringArray.length) {
                        string = stringArray[n];
                        stringBuffer.append(string);
                        if (n < stringArray.length - 1 && !string.endsWith("\n") && !string.endsWith("\r")) {
                            stringBuffer.append("\n");
                        }
                        ++n;
                    }
                    string = stringBuffer.toString();
                }
                string = this.stripPrompts(string);
                this.getModel().replace(this.getView().getSel(), string);
                if (string.endsWith("\n") || string.endsWith("\r")) {
                    this.sendCommand();
                }
            }
            catch (Exception exception) {
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.getModel().endCommand();
            throw throwable;
        }
        this.getModel().endCommand();
        this.enableUndoRedo();
        this.enableSelectionDependentCommands();
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    public void doCommand(int n) {
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 132: {
                    this.openSelection();
                    break;
                }
                case 1502: {
                    this.doEnter();
                    break;
                }
                case 123: {
                    this.helpOnSelection();
                    break;
                }
                case 550: {
                    this.doPrint(null);
                    break;
                }
                case 560: {
                    this.doPrint(this.getView().getSel());
                    break;
                }
                case 800: {
                    this.getView().undo();
                    break;
                }
                case 810: {
                    this.getView().redo();
                    break;
                }
                case 900: {
                    if (this.getView().getSelMin() < this.fPromptPos) break;
                    this.getView().cut();
                    break;
                }
                case 910: {
                    this.getView().copy();
                    break;
                }
                case 1000: {
                    if (this.getView().getSelMin() < this.fPromptPos) break;
                    this.getModel().delete(this.getView().getSel());
                    break;
                }
                case 920: {
                    this.doPaste();
                    break;
                }
                case 1060: {
                    this.selectAll();
                    break;
                }
                case 1001: {
                    this.doClc();
                    break;
                }
                case 1101: {
                    this.doFind();
                    break;
                }
                case 1102: {
                    this.doFindAgain();
                    break;
                }
                case 1103: {
                    this.doFindSel();
                    break;
                }
                case 1104: {
                    this.doFindAgainBack();
                    break;
                }
                case 1105: {
                    this.doFindSelBack();
                    break;
                }
            }
            this.enableUndoRedo();
            this.enableSelectionDependentCommands();
        }
    }

    private String doubleTheSingleQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\'') {
                stringBuffer.insert(n++, "'");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void openSelection() {
        if (sMatlab == null) {
            return;
        }
        String string = this.getSelText();
        sMatlab.evalConsoleOutput("edit('" + this.doubleTheSingleQuotes(string) + "');");
    }

    private void helpOnSelection() {
        if (sMatlab == null) {
            return;
        }
        String string = this.getSelText();
        sMatlab.evalConsoleOutput("doc('" + string + "');");
    }

    private void doContextMenu(MouseEvent mouseEvent) {
        Point point;
        MWTextView mWTextView = this.getView();
        int n = mWTextView.selectionPosFromPoint(point = mouseEvent.getPoint());
        if (n < 0) {
            mWTextView.setSel(-n);
            Graphics graphics = mWTextView.getGraphics();
            if (graphics != null) {
                mWTextView.paint(graphics);
                graphics.dispose();
            }
        }
        this.fContextMenu.show((Component)mWTextView, point.x + mWTextView.getGutterWidth(), point.y);
    }

    private void createContextMenu() {
        this.fContextMenu = new MWMenu(this.getShortName());
        MWMenuItem mWMenuItem = new MWMenuItem(sRes.getString("action.EvaluateSelection"));
        this.fCenter.addCommandSource((MWCommandSource)mWMenuItem, 1502);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("action.OpenSelection"));
        this.fCenter.addCommandSource((MWCommandSource)mWMenuItem, 132);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("action.HelponSelection"));
        this.fCenter.addCommandSource((MWCommandSource)mWMenuItem, 123);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        this.fContextMenu.addSeparator();
        mWMenuItem = new MWMenuItem(sRes.getString("action.Cut"));
        this.fCenter.addCommandSource((MWCommandSource)mWMenuItem, 900);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("action.Copy"));
        this.fCenter.addCommandSource((MWCommandSource)mWMenuItem, 910);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("action.Paste"));
        this.fCenter.addCommandSource((MWCommandSource)mWMenuItem, 920);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        this.fContextMenu.attachTo((Component)((Object)this));
    }

    private void doFind() {
        Frame frame = this.getFrame();
        String string = this.getView().getSelText();
        if (!string.equals(NO_PROMPT_STRING)) {
            fFindString = string;
        }
        MWFindDialog mWFindDialog = new MWFindDialog(frame, fFindString, fFindOptions);
        fFindString = mWFindDialog.getText();
        fFindOptions = mWFindDialog.getOptions();
        if (!fFindString.equals(NO_PROMPT_STRING)) {
            this.getView().findString(fFindString, fFindOptions, false);
            this.fCenter.setCommandEnabled(1102, true);
            this.fCenter.setCommandEnabled(1104, true);
            return;
        }
        this.fCenter.setCommandEnabled(1102, false);
        this.fCenter.setCommandEnabled(1104, false);
    }

    private void doFindAgain() {
        if (fFindString.equals(NO_PROMPT_STRING)) {
            return;
        }
        this.getView().findString(fFindString, fFindOptions, false);
    }

    private void doFindAgainBack() {
        if (fFindString.equals(NO_PROMPT_STRING)) {
            return;
        }
        this.getView().findString(fFindString, fFindOptions + 8, false);
    }

    private void doFindSel() {
        fFindString = this.getView().getSelText();
        if (!fFindString.equals(NO_PROMPT_STRING)) {
            this.getView().findString(fFindString, fFindOptions, false);
            this.fCenter.setCommandEnabled(1102, true);
            this.fCenter.setCommandEnabled(1104, true);
            return;
        }
        this.fCenter.setCommandEnabled(1102, false);
        this.fCenter.setCommandEnabled(1104, false);
    }

    private void doFindSelBack() {
        fFindString = this.getView().getSelText();
        if (!fFindString.equals(NO_PROMPT_STRING)) {
            this.getView().findString(fFindString, fFindOptions + 8, false);
            this.fCenter.setCommandEnabled(1102, true);
            this.fCenter.setCommandEnabled(1104, true);
            return;
        }
        this.fCenter.setCommandEnabled(1102, false);
        this.fCenter.setCommandEnabled(1104, false);
    }

    private void doPrint(Range range) {
        Font font;
        if (PlatformInfo.isMacintosh()) {
            font = null;
        } else {
            Font font2 = this.getModel().getDefaultFont();
            int n = font2.getSize();
            if (n > 8) {
                n -= 2;
            }
            font = new Font(font2.getName(), font2.getStyle(), n);
        }
        int n = 9;
        this.printDocument("MATLAB Command Window", n, null, range, font);
    }

    public void setFont(Font font) {
        super.setFont(font);
        ((Component)((Object)this)).repaint();
    }

    public void finalize() {
    }

    public static void main(String[] stringArray) {
        MWFrame mWFrame = new MWFrame("Testing MATLAB Command Window");
        mWFrame.setSize(500, 300);
        MatlabCommandWidget matlabCommandWidget = new MatlabCommandWidget();
        mWFrame.add((Component)((Object)matlabCommandWidget), "Center");
        mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)matlabCommandWidget)));
        mWFrame.addComponentListener((ComponentListener)new MWWindowResizer(300, 120));
        mWFrame.show();
    }

    private void setCommandWindowFont() {
        this.setFont(CmdWinPrefsColorPanel.getCommandWindowFont());
    }

    private void setCommandWindowTabSize() {
        int n = PlatformInfo.isUnix() ? 8 : 4;
        n = Prefs.getIntegerPref((String)"CommandWindowSpacesPerTab", (int)n);
        this.setSpacesPerIndent(n);
        this.getModel().setSpacesPerTab(n);
    }

    private void setHighlightColors() {
        MWStyle[] mWStyleArray = GeneralPrefsColorPanel.getSyntaxHighlightingStyles();
        this.setHighlightStyles("M-code", mWStyleArray);
    }

    private void highlightPreviousText() {
        MWStyle[] mWStyleArray = GeneralPrefsColorPanel.getSyntaxHighlightingStyles();
        MWStyle[] mWStyleArray2 = new MWStyle[mWStyleArray.length];
        int n = 0;
        while (n < mWStyleArray.length) {
            mWStyleArray2[n] = mWStyleArray[0];
            ++n;
        }
        this.setHighlightStyles("M-code", mWStyleArray2);
        super.doHighlighting(0, this.getModel().getNumLines() - 1);
        this.setHighlightStyles("M-code", GeneralPrefsColorPanel.getSyntaxHighlightingStyles());
        int n2 = 0;
        while (n2 < this.getModel().getNumLines()) {
            if (this.getModel().getLineText(n2).startsWith(">>")) {
                super.doHighlighting(n2, n2);
            }
            ++n2;
        }
    }

    public void setActive(boolean bl) {
    }

    public int closeWindow() {
        this.fFrame.dispose();
        sCmdWidget = null;
        return 0;
    }

    public String getShortName() {
        if (sStudent) {
            return String.valueOf(sRes.getString("StudentVersion")) + " " + sRes.getString("CommandWindow");
        }
        return sRes.getString("CommandWindow");
    }

    public String getLongName() {
        if (sStudent) {
            return String.valueOf(sRes.getString("StudentVersion")) + " " + sRes.getString("MATLABCommandWindow");
        }
        return sRes.getString("MATLABCommandWindow");
    }

    public int desktopSaveAction() {
        return 1;
    }

    public void restoreState(DataInputStream dataInputStream) {
    }

    public void saveState(DataOutputStream dataOutputStream) {
    }

    public String getSplayConstraint() {
        return NO_PROMPT_STRING;
    }

    public int getApplicationType() {
        return 1;
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        return this.fMenubar.mergeMenus(mWMenuBar);
    }

    public void clipboardContentTypeChanged(Transferable transferable) {
        boolean bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        this.fCenter.setCommandEnabled(920, bl);
    }

    static /* synthetic */ boolean access$7(MatlabCommandWidget matlabCommandWidget) {
        return matlabCommandWidget.fFirstTab;
    }

    static /* synthetic */ boolean access$9(MatlabCommandWidget matlabCommandWidget) {
        return matlabCommandWidget.PassingThrough();
    }

    static /* synthetic */ boolean access$10(MatlabCommandWidget matlabCommandWidget, KeyEvent keyEvent) {
        return matlabCommandWidget.endPause(keyEvent);
    }

    static /* synthetic */ boolean access$11(MatlabCommandWidget matlabCommandWidget) {
        return matlabCommandWidget.isWaitingForResponse();
    }

    static /* synthetic */ int access$12() {
        return fPassThruPromptPos;
    }

    static /* synthetic */ void access$14(int n) {
        fPassThruPromptPos = n;
    }

    static /* synthetic */ void access$15(MatlabCommandWidget matlabCommandWidget, int n) {
        matlabCommandWidget.fPromptPos = n;
    }

    static /* synthetic */ void access$16(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doBackspace();
    }

    static /* synthetic */ void access$17(MatlabCommandWidget matlabCommandWidget, KeyEvent keyEvent) {
        matlabCommandWidget.bufferKey(keyEvent);
    }

    static /* synthetic */ void access$18(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doEnterKey();
    }

    static /* synthetic */ int access$19(MatlabCommandWidget matlabCommandWidget) {
        return matlabCommandWidget.fHistoryMatch;
    }

    static /* synthetic */ void access$20(MatlabCommandWidget matlabCommandWidget, int n) {
        matlabCommandWidget.fHistoryMatch = n;
    }

    static /* synthetic */ void access$21(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doDelete();
    }

    static /* synthetic */ void access$22(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doCtlU();
    }

    static /* synthetic */ void access$23(MatlabCommandWidget matlabCommandWidget, int n) {
        matlabCommandWidget.doHistory(n);
    }

    static /* synthetic */ void access$24(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doLeft();
    }

    static /* synthetic */ boolean access$25(MatlabCommandWidget matlabCommandWidget) {
        return matlabCommandWidget.doTabCompletion();
    }

    static /* synthetic */ boolean access$26(MatlabCommandWidget matlabCommandWidget) {
        return matlabCommandWidget.doMFileError();
    }

    static /* synthetic */ void access$28(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doKill();
    }

    static /* synthetic */ void access$30(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doShiftHome();
    }

    static /* synthetic */ void access$31(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.doShiftEnd();
    }

    static /* synthetic */ void access$32(MatlabCommandWidget matlabCommandWidget) {
        matlabCommandWidget.enableUndoRedo();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$43() {
        return 2;
    }

    static /* synthetic */ boolean access$45(MatlabCommandWidget matlabCommandWidget) {
        return matlabCommandWidget.fPromptPad;
    }

    static /* synthetic */ int access$48() {
        return 1;
    }

    static {
        fPassThruPromptPos = -1;
        MatlabCommandWidget.startMatlabLooper();
        WIPE_LINE = "\b\b\b\b\b\b\b\b        \b\b\b\b\b\b\b\b".getBytes();
    }

    private class CommandCallback
    implements CompletionObserver {
        int fReplyType;

        public CommandCallback(int n) {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            MWMessage mWMessage;
            Integer n2;
            if (object == null || object instanceof LeesCharBuffer) {
                if (this.fReplyType == MatlabCommandWidget.access$48()) {
                    MatlabCommandWidget.this.doCommandReply(MatlabCommandWidget.this.fCharBuffer, n, false);
                    return;
                }
            } else if (object instanceof MWMessage && (n2 = (Integer)(mWMessage = (MWMessage)object).findData("familyid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = MatlabCommandWidget.class$("java.lang.Integer")))) == 5) {
                LeesCharBuffer leesCharBuffer = (LeesCharBuffer)mWMessage.findData("result", class$com$mathworks$jmi$LeesCharBuffer != null ? class$com$mathworks$jmi$LeesCharBuffer : (class$com$mathworks$jmi$LeesCharBuffer = MatlabCommandWidget.class$("com.mathworks.jmi.LeesCharBuffer")));
                Integer n3 = (Integer)mWMessage.findData("status", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = MatlabCommandWidget.class$("java.lang.Integer")));
                if (n3 != null && n3 != 0) {
                    if (n3 == -1) {
                        MatlabCommandWidget.this.doClc();
                    } else if (n3 == -2) {
                        MatlabCommandWidget.this.doCmdHome();
                    } else {
                        MatlabCommandWidget.this.doCommandReply(null, n3, true);
                    }
                    if (leesCharBuffer != null) {
                        leesCharBuffer.unlock();
                        return;
                    }
                } else {
                    MatlabCommandWidget.this.doCommandReply(leesCharBuffer, n, true);
                }
            }
        }
    }

    private class PauseCallback
    implements CompletionObserver {
        public void completed(int n, Object object) {
            fPromptStr = MatlabCommandWidget.this.promptString(Matlab.getInputRequester((int)n));
            MatlabCommandWidget.this.addPrompt(true);
            MatlabCommandWidget matlabCommandWidget = MatlabCommandWidget.this;
            matlabCommandWidget.fPauseCallbackPending = matlabCommandWidget.fPauseCallbackPending - 1;
        }

        PauseCallback() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class TextViewEventHandler
    extends MWTextViewAdapter {
        public void selectionChanged(MWTextViewEvent mWTextViewEvent) {
            MatlabCommandWidget.this.enableSelectionDependentCommands();
        }

        TextViewEventHandler() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class KeyEventHandler
    extends KeyAdapter {
        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        public void keyPressed(KeyEvent var1_1) {
            var2_2 = var1_1.getModifiers();
            var3_3 = var1_1.getKeyCode();
            v0 = var4_4 = var3_3 == 67 && var2_2 == 2;
            if (var3_3 != 9 || var2_2 != 0) {
                MatlabCommandWidget.access$8(MatlabCommandWidget.this, true);
            }
            if (!var4_4 && !MatlabCommandWidget.access$9(MatlabCommandWidget.this) && MatlabCommandWidget.access$10(MatlabCommandWidget.this, var1_1)) {
                return;
            }
            if (MatlabCommandWidget.access$11(MatlabCommandWidget.this)) {
                if (MatlabCommandWidget.access$9(MatlabCommandWidget.this)) {
                    if (MatlabCommandWidget.access$12() == -1) {
                        MatlabCommandWidget.access$14(MatlabCommandWidget.access$13(MatlabCommandWidget.this));
                    }
                    if (var3_3 == 10) {
                        MatlabCommandWidget.access$15(MatlabCommandWidget.this, MatlabCommandWidget.this.getModel().length());
                        MatlabCommandWidget.access$14(-1);
                    }
                    if (var3_3 == 8) {
                        if (MatlabCommandWidget.access$12() < MatlabCommandWidget.access$13(MatlabCommandWidget.this)) {
                            v1 = MatlabCommandWidget.this;
                            MatlabCommandWidget.access$15(v1, MatlabCommandWidget.access$13(v1) - 1);
                        }
                        MatlabCommandWidget.access$16(MatlabCommandWidget.this);
                        MatlabCommandWidget.access$10(MatlabCommandWidget.this, var1_1);
                    }
                    if (var4_4) {
                        MatlabCommandWidget.access$10(MatlabCommandWidget.this, var1_1);
                        return;
                    }
                }
                if (var3_3 == 10 && !MatlabCommandWidget.access$10(MatlabCommandWidget.this, var1_1)) {
                    MatlabCommandWidget.access$17(MatlabCommandWidget.this, var1_1);
                }
                if (!var4_4) {
                    return;
                }
            }
            if (var2_2 != 0) ** GOTO lbl70
            switch (var3_3) {
                case 226: {
                    if (!System.getProperty("os.name").equals("Irix")) break;
                    MatlabCommandWidget.access$18(MatlabCommandWidget.this);
                    break;
                }
                case 10: {
                    MatlabCommandWidget.access$18(MatlabCommandWidget.this);
                    break;
                }
                case 8: {
                    MatlabCommandWidget.access$16(MatlabCommandWidget.this);
                    MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                    break;
                }
                case 127: {
                    MatlabCommandWidget.access$21(MatlabCommandWidget.this);
                    MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                    break;
                }
                case 27: {
                    MatlabCommandWidget.access$22(MatlabCommandWidget.this);
                    MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                    break;
                }
                case 38: {
                    MatlabCommandWidget.access$23(MatlabCommandWidget.this, 38);
                    break;
                }
                case 40: {
                    MatlabCommandWidget.access$23(MatlabCommandWidget.this, 40);
                    break;
                }
                case 37: {
                    MatlabCommandWidget.access$24(MatlabCommandWidget.this);
                    break;
                }
                case 36: {
                    MatlabCommandWidget.this.getView().setSel(MatlabCommandWidget.access$13(MatlabCommandWidget.this));
                    break;
                }
                case 35: {
                    MatlabCommandWidget.this.getView().setSel(MatlabCommandWidget.this.getModel().length());
                    break;
                }
                case 9: {
                    if (!MatlabCommandWidget.access$25(MatlabCommandWidget.this)) break;
                    var1_1.consume();
                    break;
                }
lbl70:
                // 1 sources

                if (var2_2 != 2) ** GOTO lbl131
                block13 : switch (var3_3) {
                    case 10: {
                        var5_5 = MatlabCommandWidget.this.getView().getSel();
                        if (var5_5.getMin() >= MatlabCommandWidget.access$13(MatlabCommandWidget.this) || !var5_5.isEmpty()) break;
                        MatlabCommandWidget.access$26(MatlabCommandWidget.this);
                        break;
                    }
                    case 65: {
                        MatlabCommandWidget.this.getView().setSel(MatlabCommandWidget.access$13(MatlabCommandWidget.this));
                        break;
                    }
                    case 66: {
                        MatlabCommandWidget.this.getView().charLeft();
                        break;
                    }
                    case 67: {
                        if (MatlabCommandWidget.access$27() == null) break;
                        MatlabCommandWidget.access$27().interrupt();
                        break;
                    }
                    case 68: {
                        MatlabCommandWidget.access$21(MatlabCommandWidget.this);
                        MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                        break;
                    }
                    case 69: {
                        MatlabCommandWidget.this.getView().setSel(MatlabCommandWidget.this.getModel().length());
                        break;
                    }
                    case 70: {
                        MatlabCommandWidget.this.getView().charRight();
                        break;
                    }
                    case 72: {
                        MatlabCommandWidget.access$16(MatlabCommandWidget.this);
                        MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                        break;
                    }
                    case 74: {
                        MatlabCommandWidget.access$18(MatlabCommandWidget.this);
                        break;
                    }
                    case 75: {
                        MatlabCommandWidget.access$28(MatlabCommandWidget.this);
                        MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                        break;
                    }
                    case 76: {
                        MatlabCommandWidget.this.getView().wordLeft();
                        break;
                    }
                    case 77: {
                        MatlabCommandWidget.access$18(MatlabCommandWidget.this);
                        break;
                    }
                    case 78: {
                        MatlabCommandWidget.access$23(MatlabCommandWidget.this, 40);
                        break;
                    }
                    case 80: {
                        MatlabCommandWidget.access$23(MatlabCommandWidget.this, 38);
                        break;
                    }
                    case 82: {
                        MatlabCommandWidget.this.getView().wordRight();
                        break;
                    }
                    case 85: {
                        MatlabCommandWidget.access$22(MatlabCommandWidget.this);
                        MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                        break;
                    }
                    case 89: {
                        MatlabCommandWidget.access$29(MatlabCommandWidget.this);
                        break;
                    }
lbl131:
                    // 1 sources

                    if (var2_2 != 1) break;
                    switch (var3_3) {
                        case 8: {
                            MatlabCommandWidget.access$16(MatlabCommandWidget.this);
                            MatlabCommandWidget.access$20(MatlabCommandWidget.this, -1);
                            var1_1.consume();
                            break block13;
                        }
                        case 36: {
                            MatlabCommandWidget.access$30(MatlabCommandWidget.this);
                            break block13;
                        }
                        case 35: {
                            MatlabCommandWidget.access$31(MatlabCommandWidget.this);
                            break block13;
                        }
                    }
                }
                break;
            }
            MatlabCommandWidget.access$32(MatlabCommandWidget.this);
            MatlabCommandWidget.access$6(MatlabCommandWidget.this);
        }

        KeyEventHandler() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class InsertChar
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MatlabCommandWidget.this.doKey((KeyEvent)actionEvent.getSource());
        }

        InsertChar() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class Paste
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MatlabCommandWidget.this.doPaste();
        }

        Paste() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    class ContextListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MatlabCommandWidget.this.doContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MatlabCommandWidget.this.doContextMenu(mouseEvent);
            }
        }

        ContextListener() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class InterestHandler
    extends MWHandler {
        private CompletionObserver fObserver;

        InterestHandler(CompletionObserver completionObserver) {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
            this.fObserver = completionObserver;
            sCmdLooper.addHandler((MWHandler)this);
        }

        protected void messageReceived(MWMessage mWMessage) {
            Integer n = (Integer)mWMessage.findData("familyid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = MatlabCommandWidget.class$("java.lang.Integer")));
            if (n != null && n == 5) {
                this.fObserver.completed(0, (Object)mWMessage);
            }
        }
    }

    private class KeyEventFilter
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            int n2 = keyEvent.getKeyCode();
            if (n2 == 67) {
                if (n == 2 && !MatlabCommandWidget.this.fCenter.getCommandEnabled(910)) {
                    keyEvent.consume();
                    return;
                }
                if (n == 0 && Character.getNumericValue(keyEvent.getKeyChar()) == -1) {
                    keyEvent.setModifiers(2);
                    keyEvent.setKeyChar('c');
                    if (!MatlabCommandWidget.this.fCenter.getCommandEnabled(910)) {
                        keyEvent.consume();
                        return;
                    }
                }
            } else if (n2 == 3 && PlatformInfo.isWindows() && (n == 2 || n == 0 && Character.getNumericValue(keyEvent.getKeyChar()) == -1) && !MatlabCommandWidget.this.fCenter.getCommandEnabled(910)) {
                keyEvent.setKeyChar('c');
                keyEvent.setKeyCode(67);
                keyEvent.setModifiers(2);
                keyEvent.consume();
            }
        }

        KeyEventFilter() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class PrefsChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                String string = prefEvent.getPrefKey();
                if (string.equals("CommandWindowFont") || string.equals("CommandWindowUseDesktopFont")) {
                    MatlabCommandWidget.this.setCommandWindowFont();
                    return;
                }
                if (string.equals("CommandWindowTextColor")) {
                    MatlabCommandWidget.this.setTextStyle(CmdWinPrefsColorPanel.getTextColor());
                    MatlabCommandWidget.this.highlightPreviousText();
                    return;
                }
                if (string.equals("CommandWindowBackgroundColor")) {
                    MatlabCommandWidget.this.setBackgroundStyle(CmdWinPrefsColorPanel.getBackgroundColor());
                    ((Component)((Object)MatlabCommandWidget.this)).repaint();
                    return;
                }
                if (string.equals("CommandWindowSyntaxHighlighting")) {
                    MatlabCommandWidget.this.highlightPreviousText();
                    MatlabCommandWidget.this.setSyntaxHighlightingEnabled(CmdWinPrefsColorPanel.isSyntaxHighlightingEnabled());
                    return;
                }
                if (string.equals("Syncolor")) {
                    MatlabCommandWidget.this.highlightPreviousText();
                    MatlabCommandWidget.this.setHighlightColors();
                    return;
                }
                if (string.equals("GeneralFont")) {
                    if (CmdWinPrefsColorPanel.getUseDesktopFont()) {
                        MatlabCommandWidget.this.setCommandWindowFont();
                        return;
                    }
                } else {
                    if (string.equals("CommandWindowSpacesPerTab")) {
                        MatlabCommandWidget.this.setCommandWindowTabSize();
                        return;
                    }
                    if (string.equals("CommandWindowSessionSize")) {
                        MatlabCommandWidget.this.setCommandSessionSize(Prefs.getIntegerPref((String)"CommandWindowSessionSize"));
                    }
                }
            }
        }

        PrefsChangeListener() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class SizeChangeListener
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            if (sMatlab != null) {
                sMatlab.setWindowSize(MatlabCommandWidget.this.getView().numCompleteLinesHigh(), MatlabCommandWidget.this.getView().getTextCanvasSize().width / MatlabCommandWidget.this.getModel().getFontWidth(), 0);
            }
            if (MatlabCommandWidget.this.getView().getSelMax() >= MatlabCommandWidget.this.fPromptPos) {
                MatlabCommandWidget.this.getView().scrollLineToBottom(MatlabCommandWidget.this.getModel().getNumLines() - 1);
                return;
            }
            MatlabCommandWidget.this.getView().scrollPosIntoView(MatlabCommandWidget.this.getView().getSelMax());
        }

        SizeChangeListener() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }

    private class TabFindHandler
    implements Runnable {
        String fCompletionString;

        public TabFindHandler(String string) {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
            this.fCompletionString = string;
        }

        public void run() {
            String string;
            int n = MatlabCommandWidget.this.getView().getSelEnd();
            try {
                string = sMatlab.findTabCompletion(this.fCompletionString);
            }
            catch (Exception exception) {
                string = new String(MatlabCommandWidget.NO_PROMPT_STRING);
                exception.printStackTrace();
            }
            if (string.length() > 0) {
                MatlabCommandWidget.this.getModel().insert(n, string);
            } else {
                MatlabCommandWidget.this.getView().beep();
                MatlabCommandWidget.this.fFirstTab = false;
            }
            MatlabCommandWidget.this.setWaitingForResponse(false);
        }
    }

    private class TabShowHandler
    implements Runnable {
        public void run() {
            int n = MatlabCommandWidget.this.fPromptPos - fPromptStr.length();
            if (n < 0) {
                n = 0;
            }
            char[] cArray = MatlabCommandWidget.this.getModel().getText(n, MatlabCommandWidget.this.getModel().length()).toCharArray();
            int n2 = MatlabCommandWidget.this.fHilitingType;
            MatlabCommandWidget.this.fHilitingType = MatlabCommandWidget.access$43();
            MatlabCommandWidget.this.fPromptPad = false;
            MatlabCommandWidget.this.insertLine(cArray, cArray.length, n);
            try {
                sMatlab.showTabCompletions();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            MatlabCommandWidget.this.fHilitingType = n2;
            MatlabCommandWidget.this.setWaitingForResponse(false);
        }

        TabShowHandler() {
            MatlabCommandWidget.this = MatlabCommandWidget.this;
        }
    }
}

