/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

class MScannerState {
    private char[] fInputBuf;
    private int fInputPos;
    private int fEndOfFilePos;
    private boolean fAtEndOfFile;
    private boolean fInitialized = false;
    private int fLinePosition;
    private int fParenDepth;
    private boolean fInString = false;
    private int fLastNonWhiteTokenType;
    private int fTokenStart;
    private int fTokenEnd;
    private int fTokenType;

    public MScannerState() {
    }

    public MScannerState(char[] cArray, int n, int n2) {
        this.init(cArray, n, n2);
    }

    void init(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new IllegalArgumentException("null inputBuf not allowed.");
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n2 > cArray.length) {
            throw new IllegalArgumentException("inputPos or endOfFilePos out of range");
        }
        if (n > n2) {
            throw new IllegalArgumentException("inputPos > endOfFilePos");
        }
        this.fInputBuf = cArray;
        this.fInputPos = n;
        this.fEndOfFilePos = n2;
        this.fAtEndOfFile = false;
        this.fInitialized = true;
        this.fLinePosition = 0;
        this.fParenDepth = 0;
        this.fInString = false;
        this.fLastNonWhiteTokenType = 0;
        this.fTokenStart = 0;
        this.fTokenEnd = 0;
        this.fTokenType = 0;
    }

    public char[] getInputBuf() {
        this.checkInitialized();
        return this.fInputBuf;
    }

    public int getInputPos() {
        this.checkInitialized();
        return this.fInputPos;
    }

    protected void setInputPos(int n) {
        if (n < 0 || n > this.fInputBuf.length) {
            throw new IllegalArgumentException("position out of range");
        }
        this.fInputPos = n;
    }

    public int getEndOfFilePos() {
        this.checkInitialized();
        return this.fEndOfFilePos;
    }

    public boolean isAtEndOfFile() {
        this.checkInitialized();
        return this.fAtEndOfFile;
    }

    protected void setAtEndOfFile(boolean bl) {
        this.fAtEndOfFile = bl;
    }

    protected int getTokenLength() {
        return this.getInputPos() - this.getTokenStart();
    }

    protected int getLinePosition() {
        this.checkInitialized();
        return this.fLinePosition;
    }

    protected void setLinePosition(int n) {
        this.fLinePosition = n;
    }

    protected int getParenDepth() {
        this.checkInitialized();
        return this.fParenDepth;
    }

    protected void setParenDepth(int n) {
        this.fParenDepth = n;
    }

    protected boolean isInString() {
        this.checkInitialized();
        return this.fInString;
    }

    protected void setInString(boolean bl) {
        this.fInString = bl;
    }

    protected int getLastNonWhiteTokenType() {
        this.checkInitialized();
        return this.fLastNonWhiteTokenType;
    }

    protected void setLastNonWhiteTokenType(int n) {
        this.fLastNonWhiteTokenType = n;
    }

    protected int getTokenStart() {
        this.checkInitialized();
        return this.fTokenStart;
    }

    protected void setTokenStart(int n) {
        this.fTokenStart = n;
    }

    protected int getTokenEnd() {
        this.checkInitialized();
        return this.fTokenEnd;
    }

    protected void setTokenEnd(int n) {
        this.fTokenEnd = n;
    }

    protected int getTokenType() {
        this.checkInitialized();
        return this.fTokenType;
    }

    protected void setTokenType(int n) {
        this.fTokenType = n;
    }

    protected void copyFrom(Object object) {
        if (!(object instanceof MScannerState)) {
            throw new IllegalArgumentException();
        }
        MScannerState mScannerState = (MScannerState)object;
        mScannerState.checkInitialized();
        this.fInputBuf = mScannerState.fInputBuf;
        this.fInputPos = mScannerState.fInputPos;
        this.fEndOfFilePos = mScannerState.fEndOfFilePos;
        this.fAtEndOfFile = mScannerState.fAtEndOfFile;
        this.fInitialized = true;
        this.fLinePosition = mScannerState.fLinePosition;
        this.fParenDepth = mScannerState.fParenDepth;
        this.fInString = mScannerState.fInString;
        this.fLastNonWhiteTokenType = mScannerState.fLastNonWhiteTokenType;
        this.fTokenStart = mScannerState.fTokenStart;
        this.fTokenEnd = mScannerState.fTokenEnd;
        this.fTokenType = mScannerState.fTokenType;
    }

    private void checkInitialized() {
        if (!this.fInitialized) {
            throw new IllegalStateException("Attempt to use uninitialized state");
        }
    }
}

