/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.ide.widgets.HighlighterState;
import com.mathworks.ide.widgets.HighlighterSupport;
import com.mathworks.ide.widgets.HighlighterToken;
import com.mathworks.ide.widgets.MHighlighterState;
import com.mathworks.ide.widgets.MScanner;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.util.Assert;

class MHighlighter
implements Highlighter {
    private static int[] sCategories;
    private static MWStyle[] sDefaultStyles;
    private static MWStyle[] sStyles;
    private MWStyle fTextStyle;

    public String[] getCategories() {
        String[] stringArray = new String[sCategories.length];
        int n = 0;
        while (n < sCategories.length) {
            stringArray[n] = Highlighter.CATEGORIES[sCategories[n]];
            ++n;
        }
        return stringArray;
    }

    public MWStyle[] getStyles() {
        MWStyle[] mWStyleArray = new MWStyle[sCategories.length];
        int n = 0;
        while (n < sCategories.length) {
            mWStyleArray[n] = (MWStyle)sStyles[n].clone();
            ++n;
        }
        return mWStyleArray;
    }

    public MWStyle[] getDefaultStyles() {
        MWStyle[] mWStyleArray = new MWStyle[sCategories.length];
        int n = 0;
        while (n < sCategories.length) {
            mWStyleArray[n] = (MWStyle)sDefaultStyles[n].clone();
            ++n;
        }
        return mWStyleArray;
    }

    public void setStyle(String string, MWStyle mWStyle) {
        if (mWStyle == null) {
            throw new IllegalArgumentException();
        }
        int n = HighlighterSupport.indexFromCategory(string);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        MHighlighter.sStyles[n] = (MWStyle)mWStyle.clone();
    }

    public void setStyles(MWStyle[] mWStyleArray) {
        if (mWStyleArray.length != sCategories.length) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < sCategories.length) {
            if (mWStyleArray[n] == null) {
                throw new IllegalArgumentException();
            }
            ++n;
        }
        MWStyle[] mWStyleArray2 = new MWStyle[sCategories.length];
        int n2 = 0;
        while (n2 < sCategories.length) {
            mWStyleArray2[n2] = (MWStyle)mWStyleArray[n2].clone();
            ++n2;
        }
        sStyles = mWStyleArray2;
    }

    public HighlighterState createState() {
        return new MHighlighterState();
    }

    public HighlighterState createState(char[] cArray, int n, int n2) {
        return new MHighlighterState(cArray, n, n2);
    }

    public void getNextToken(HighlighterState highlighterState, HighlighterToken highlighterToken, HighlighterState highlighterState2) {
        if (highlighterToken == null) {
            throw new IllegalArgumentException();
        }
        if (!(highlighterState instanceof MHighlighterState) || !(highlighterState instanceof MHighlighterState)) {
            throw new IllegalArgumentException();
        }
        MHighlighterState mHighlighterState = (MHighlighterState)highlighterState;
        MHighlighterState mHighlighterState2 = (MHighlighterState)highlighterState2;
        mHighlighterState2.copyFrom(mHighlighterState);
        MScanner.getNextToken(mHighlighterState2.getMScannerState());
        int n = this.categoryFromType(mHighlighterState2.getTokenType());
        if (n == 0 && this.fTextStyle != null) {
            highlighterToken.setStyle(this.fTextStyle);
        } else {
            highlighterToken.setStyle(sStyles[n]);
        }
        highlighterToken.setStart(mHighlighterState2.getTokenStart());
        highlighterToken.setEnd(mHighlighterState2.getTokenEnd());
    }

    public void setTextStyle(MWStyle mWStyle) {
        this.fTextStyle = mWStyle;
    }

    public void highlight(MWTextModel mWTextModel, int n, int n2) {
        MWTextModel mWTextModel2 = mWTextModel;
        synchronized (mWTextModel2) {
            HighlighterSupport.highlight(this, mWTextModel, n, n2);
            return;
        }
    }

    private int categoryFromType(int n) {
        switch (n) {
            case 36: {
                return 3;
            }
            case 55: 
            case 63: {
                return 2;
            }
            case 33: {
                return 5;
            }
            case 60: {
                return 4;
            }
            case 58: 
            case 59: 
            case 61: {
                return 6;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 64: 
            case 65: {
                return 1;
            }
            case 34: {
                return 0;
            }
        }
        return 0;
    }

    MHighlighter() {
    }

    static {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        sCategories = nArray;
        sDefaultStyles = new MWStyle[]{Highlighter.PALETTE[0], Highlighter.PALETTE[6], Highlighter.PALETTE[4], Highlighter.PALETTE[8], Highlighter.PALETTE[7], Highlighter.PALETTE[9], Highlighter.PALETTE[1]};
        sStyles = sDefaultStyles;
        Assert.assert((sCategories.length == sStyles.length ? 1 : 0) != 0);
    }
}

