/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.widgets.CwdDisplay;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSizeComponentToFit;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class CwdDisplayPanel
extends MWPanel
implements MWSizeComponentToFit {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.widgets.resources.RES_Widgets");
    private CwdDisplay fCwdDisplay;
    private MWButton fCwdButton;
    private Matlab fMatlab;

    public CwdDisplayPanel(boolean bl) {
        this(bl, null);
    }

    public CwdDisplayPanel(boolean bl, MWCommandCenter mWCommandCenter) {
        ((Container)((Object)this)).setLayout(new BorderLayout(5, 5));
        this.fCwdDisplay = new CwdDisplay(null, mWCommandCenter, false, bl);
        this.fCwdDisplay.setFont(new Font("SanSerif", 0, 11));
        ((Container)((Object)this)).add((Component)((Object)this.fCwdDisplay), "Center");
        if (PlatformInfo.isWindows()) {
            this.fCwdButton = new CWDButton("...");
            this.fCwdButton.addActionListener((ActionListener)new CWDButtonListener());
            new MWToolTip((Component)this.fCwdButton, sRes.getString("BrowseforFolder"));
            ((Container)((Object)this)).add((Component)this.fCwdButton, "East");
        }
        this.fMatlab = new Matlab(new MWLooper("Cwd Browse Button"));
    }

    public CwdDisplay getCwdDisplay() {
        return this.fCwdDisplay;
    }

    public void setFont(Font font) {
        this.fCwdDisplay.setFont(font);
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        int n = 0;
        while (n < mWMenuBar.getMenuCount()) {
            DTMenu dTMenu;
            MWMenu mWMenu = mWMenuBar.getMenu(n);
            if (mWMenu instanceof DTMenu && ((dTMenu = (DTMenu)mWMenu).getLabel().equals(DTMenuBar.sRes.getString("menu.Edit")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.EditNoAmpersand")))) {
                dTMenu.addMenuItem(this.fCwdDisplay.getCommandCenter(), 900);
                dTMenu.addMenuItem(this.fCwdDisplay.getCommandCenter(), 910);
                dTMenu.addMenuItem(this.fCwdDisplay.getCommandCenter(), 920);
                dTMenu.addMenuItem(this.fCwdDisplay.getCommandCenter(), 1060);
                break;
            }
            ++n;
        }
        return mWMenuBar;
    }

    private class CWDButton
    extends MWButton {
        public CWDButton(String string) {
            super(string);
            CwdDisplayPanel.this = CwdDisplayPanel.this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getMinimumSize();
            dimension.height = 1;
            return dimension;
        }
    }

    private class CWDButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getID() == 1001) {
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 1) {
                    CwdDisplayPanel.this.fMatlab.evalConsoleOutput("cd('" + CwdDisplay.quoteQuotes(string) + "');");
                    return;
                }
            } else if (actionEvent.getSource() == CwdDisplayPanel.this.fCwdButton) {
                NativeJava.browseForFolder((MWComponent)CwdDisplayPanel.this.fCwdButton, (String)sRes.getString("SelectDirectory"), (ActionListener)this);
            }
        }

        CWDButtonListener() {
            CwdDisplayPanel.this = CwdDisplayPanel.this;
        }
    }
}

