/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.browsers.CurrentDirectoryPrefs;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWClipboardListener;
import com.mathworks.mwt.MWClipboardMonitor;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWRightJustifiedIcon;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.mwt.text.MWTextViewAdapter;
import com.mathworks.mwt.text.MWTextViewEvent;
import com.mathworks.mwt.text.MWTextViewListener;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowResizer;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.util.ResourceBundle;
import java.util.Vector;

public class CwdDisplay
extends MWPanel
implements ActionListener,
MWRightJustifiedIcon,
MWCommandCenterOwner,
MWCommandTarget,
MWClipboardListener {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.widgets.resources.RES_Widgets");
    private static final int INTEREST_REPLY = 1;
    private static final int CWD_REPLY = 2;
    private static final String HISTORY_FILE_NAME = "cwdhistory.m";
    private static final int HISTORY_SIZE = 1200;
    private static Vector sCwdDisplays = new Vector();
    private Matlab fMatlab;
    private MWCommandCenter fCenter;
    private CwdCallback fInterestCallback;
    private CwdCallback fCwdCallback;
    private CwdCombobox fCombo;
    private MWLabel fLabel;
    private boolean fIsVertical;
    private boolean fShowLabel;
    private boolean fCanPaste;
    static /* synthetic */ Class class$java$lang$Integer;

    public void removeNotify() {
        super.removeNotify();
        if (this.fMatlab != null) {
            this.fMatlab.unregisterAll();
            this.fMatlab = null;
        }
        this.saveCwdHistory();
    }

    public void addNotify() {
        super.addNotify();
        if (this.fMatlab == null && Matlab.isMatlabAvailable()) {
            this.fMatlab = new Matlab(new MWLooper("CwdDisplay"));
            this.fMatlab.registerInterest(2, 0x40000000, (CompletionObserver)this.fInterestCallback);
        }
        this.refresh();
    }

    public void refresh() {
        if (this.fMatlab != null) {
            this.fMatlab.eval("cd", (CompletionObserver)this.fCwdCallback);
        }
    }

    private void getCwdReply(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        string = string.trim();
        if (PlatformInfo.isUnix() && string.equals("")) {
            string = "/";
        }
        this.fCombo.setText(string);
        if (PlatformInfo.getPlatform() == 1) {
            if (this.fCombo.contains(string, true)) {
                this.fCombo.removeItem(string, true);
            }
        } else if (this.fCombo.contains(string)) {
            this.fCombo.removeItem(string);
        }
        String[] stringArray = this.fCombo.getItems();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 1] = stringArray[n];
            ++n;
        }
        this.fCombo.setItems(stringArray2);
        ((Container)((Object)this)).invalidate();
        this.fCombo.setSel(0, 0);
        Object object = this;
        while ((object = ((Component)object).getParent()) != null) {
            ((Component)object).validate();
        }
    }

    private File getCwdFile() {
        return new File(Prefs.getPropertyDirectory(), HISTORY_FILE_NAME);
    }

    private void loadCwdHistory() {
        File file = this.getCwdFile();
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.fCombo.addItem(string);
                }
                bufferedReader.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void saveCwdHistory() {
        File file = this.getCwdFile();
        try {
            file.delete();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            String[] stringArray = this.fCombo.getItems();
            int n = CurrentDirectoryPrefs.getNumDirectoriesToSave();
            if (n > stringArray.length) {
                n = stringArray.length;
            }
            int n2 = 0;
            while (n2 < n) {
                bufferedWriter.write(stringArray[n2]);
                bufferedWriter.newLine();
                ++n2;
            }
            bufferedWriter.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void clearCwdHistory() {
        this.fCombo.removeAllItems();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fMatlab != null) {
            String string = this.fCombo.getText();
            this.fMatlab.evalConsoleOutput("cd('" + CwdDisplay.quoteQuotes(string) + "');");
        }
        this.refresh();
    }

    public static String quoteQuotes(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(39, n2);
            string2 = n == -1 ? String.valueOf(string2) + string.substring(n2, string.length()) : String.valueOf(string2) + string.substring(n2, n + 1) + "'";
            n2 = n + 1;
        }
        return string2;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.fCombo.getPreferredSize();
        Dimension dimension2 = new Dimension(0, 0);
        if (this.fShowLabel) {
            dimension2 = this.fLabel.getPreferredSize();
        }
        if (this.fIsVertical) {
            dimension.height += dimension2.height;
        } else {
            dimension.width += dimension2.width + 5;
        }
        int n = 200;
        if (this.fShowLabel) {
            n = 300;
        }
        if (dimension.width < n) {
            dimension.width = n;
        }
        return dimension;
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fCombo.getTextView().addFocusListener(focusListener);
    }

    public boolean hasFocus() {
        return this.fCombo.hasFocus();
    }

    public boolean canPaste() {
        return this.fCanPaste;
    }

    public CwdDisplay(Matlab matlab, MWCommandCenter mWCommandCenter, boolean bl, boolean bl2) {
        sCwdDisplays.addElement(this);
        this.fIsVertical = bl;
        this.fShowLabel = bl2;
        String string = "West";
        if (bl) {
            string = "North";
        }
        this.setOpaque(false);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fCenter = mWCommandCenter == null ? new MWCommandCenter((MWCommandTarget)this) : mWCommandCenter;
        this.fCenter.addCommand(900, true, 88);
        this.fCenter.addCommand(910, true, 67);
        this.fCenter.addCommand(920, true, 86);
        if (PlatformInfo.isUnix()) {
            this.fCanPaste = true;
        } else {
            MWClipboardMonitor.addListener((MWClipboardListener)this);
            this.clipboardContentTypeChanged(((Component)((Object)this)).getToolkit().getSystemClipboard().getContents(this));
        }
        if (this.fShowLabel) {
            this.fLabel = new MWLabel(String.valueOf(sRes.getString("CurrentDirectoryLabel")) + " ");
            this.fLabel.setName("Current Directory Label");
            ((Container)((Object)this)).add((Component)this.fLabel, string);
        }
        this.fCombo = new CwdCombobox();
        this.fCombo.setRestrictWidth(false);
        this.fCombo.setGutterWidth(3);
        this.fCombo.addActionListener(this);
        ((Component)((Object)this.fCombo)).setName("Current Directory History");
        this.fCombo.getTextView().addTextViewListener((MWTextViewListener)new SelectionListener());
        ((Container)((Object)this)).add((Component)((Object)this.fCombo), "Center");
        if (matlab == null && Matlab.isMatlabAvailable()) {
            matlab = new Matlab(new MWLooper("CwdDisplay"));
        }
        this.fMatlab = matlab;
        this.loadCwdHistory();
        String string2 = System.getProperty("user.dir");
        if (string2 != null && !string2.equals("")) {
            this.getCwdReply(string2);
        }
        this.fInterestCallback = new CwdCallback(1);
        this.fCwdCallback = new CwdCallback(2);
        if (this.fMatlab != null) {
            this.fMatlab.registerInterest(2, 0x40000000, (CompletionObserver)this.fInterestCallback);
        }
        this.refresh();
    }

    public CwdDisplay(Matlab matlab, MWCommandCenter mWCommandCenter, boolean bl) {
        this(matlab, mWCommandCenter, bl, true);
    }

    public CwdDisplay() {
        this(null, null, false);
    }

    public CwdDisplay(boolean bl) {
        this(null, null, bl);
    }

    public static void clearCwdDisplays() {
        int n = 0;
        while (n < sCwdDisplays.size()) {
            CwdDisplay cwdDisplay = (CwdDisplay)sCwdDisplays.elementAt(n);
            cwdDisplay.clearCwdHistory();
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.fShowLabel) {
            this.fLabel.setEnabled(bl);
        }
        this.fCombo.setEnabled(bl);
        ((Component)((Object)this)).repaint();
    }

    public void setFont(Font font) {
        if (this.fShowLabel) {
            this.fLabel.setFont(font);
        }
        this.fCombo.setFont(font);
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    public void doCommand(int n) {
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 900: {
                    this.fCombo.getTextView().cut();
                    return;
                }
                case 910: {
                    this.fCombo.getTextView().copy();
                    return;
                }
                case 920: {
                    this.fCombo.getTextView().paste();
                    return;
                }
                case 1060: {
                    this.fCombo.getTextView().bufferSelect();
                    return;
                }
            }
        }
    }

    public void clipboardContentTypeChanged(Transferable transferable) {
        this.fCanPaste = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        this.fCenter.setCommandEnabled(920, this.fCanPaste);
    }

    public static void main(String[] stringArray) {
        MWFrame mWFrame = new MWFrame("Current Working Directory");
        mWFrame.setSize(200, 100);
        CwdDisplay cwdDisplay = new CwdDisplay();
        mWFrame.add((Component)((Object)cwdDisplay), "Center");
        mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)cwdDisplay)));
        mWFrame.addComponentListener((ComponentListener)new MWWindowResizer(50, 50));
        mWFrame.show();
    }

    static /* synthetic */ int access$2() {
        return 2;
    }

    static /* synthetic */ int access$4() {
        return 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CwdCallback
    implements CompletionObserver {
        private int fMessageType;

        public CwdCallback(int n) {
            CwdDisplay.this = CwdDisplay.this;
            this.fMessageType = n;
        }

        public void completed(int n, Object object) {
            MWMessage mWMessage;
            Integer n2;
            if (this.fMessageType == CwdDisplay.access$2()) {
                CwdDisplay.this.getCwdReply((String)object);
                return;
            }
            if (this.fMessageType == CwdDisplay.access$4() && (n2 = (Integer)(mWMessage = (MWMessage)object).findData("familyid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = CwdDisplay.class$("java.lang.Integer")))) == 2) {
                CwdDisplay.this.refresh();
            }
        }
    }

    private class CwdCombobox
    extends MWCombobox {
        public void setSel(int n, int n2) {
            this.getTextField().setSel(n, n2);
        }

        public MWTextView getTextView() {
            return this.getTextField().getView();
        }

        public boolean hasFocus() {
            return this.getTextView().hasFocus();
        }

        CwdCombobox() {
            CwdDisplay.this = CwdDisplay.this;
        }
    }

    private class SelectionListener
    extends MWTextViewAdapter {
        public void selectionChanged(MWTextViewEvent mWTextViewEvent) {
            boolean bl = !CwdDisplay.this.fCombo.getTextView().isSelEmpty();
            CwdDisplay.this.fCenter.setCommandEnabled(900, bl);
            CwdDisplay.this.fCenter.setCommandEnabled(910, bl);
        }

        SelectionListener() {
            CwdDisplay.this = CwdDisplay.this;
        }
    }
}

