/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.widgets.ColorCombobox;
import com.mathworks.ide.widgets.ColorComboboxItem;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.util.Offscreen;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ColorComboboxList
extends Panel
implements MouseListener,
MouseMotionListener,
AdjustmentListener,
Floater {
    private Offscreen fOffscreen;
    private Vector fItems;
    private ColorCombobox fOwner;
    private MWScrollbar fScrollbar;
    private int fLinesVis;
    private int fSelectedIndex;
    private int fSelectionType = 1;
    private boolean fRestrictWidth = true;

    ColorComboboxList(ColorCombobox colorCombobox) {
        this.setLayout(null);
        this.fItems = new Vector();
        this.fOwner = colorCombobox;
        this.fScrollbar = new MWScrollbar();
        this.fOffscreen = new Offscreen((Component)this);
        this.add((Component)this.fScrollbar);
        this.fScrollbar.addAdjustmentListener((AdjustmentListener)this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    ColorComboboxItem[] getItems() {
        ColorComboboxItem[] colorComboboxItemArray = new ColorComboboxItem[this.fItems.size()];
        int n = 0;
        while (n < this.fItems.size()) {
            colorComboboxItemArray[n] = (ColorComboboxItem)this.fItems.elementAt(n);
            ++n;
        }
        return colorComboboxItemArray;
    }

    void setItems(String[] stringArray) {
        this.removeAllItems();
        int n = 0;
        while (n < stringArray.length) {
            this.addItem(new ColorComboboxItem(stringArray[n], ColorCombobox.fListBackgroundColor));
            ++n;
        }
    }

    void setItems(Color[] colorArray) {
        this.removeAllItems();
        int n = 0;
        while (n < colorArray.length) {
            this.addItem(new ColorComboboxItem("", colorArray[n]));
            ++n;
        }
    }

    void setItems(ColorComboboxItem[] colorComboboxItemArray) {
        this.removeAllItems();
        int n = 0;
        while (n < colorComboboxItemArray.length) {
            this.addItem(colorComboboxItemArray[n]);
            ++n;
        }
    }

    public void setSelectionType(int n) {
        this.fSelectionType = n;
    }

    private Font getAdjustedFont() {
        if (this.fSelectionType == 1) {
            return super.getFont();
        }
        Font font = this.getFont();
        if (font == null) {
            return new Font("Dialog", 0, 12);
        }
        return new Font(font.getFamily(), font.getStyle(), font.getSize() + 2);
    }

    /*
     * Unable to fully structure code
     */
    void fitOnScreen() {
        block8: {
            block9: {
                block7: {
                    var1_1 = new Rectangle();
                    var2_2 = this.fOwner.getBoundsInWindow();
                    var3_3 = this.fOwner.getEnclosingWindow().getBounds();
                    var4_4 = this.fOwner.getEnclosingWindow().getInsets();
                    var8_5 = this.getFontMetrics(this.getAdjustedFont()).getHeight();
                    if (!this.fRestrictWidth) {
                        var2_2.width = Math.max(var2_2.width, this.fOwner.getPreferredSize().width);
                    }
                    var3_3.x = 0;
                    var3_3.y = 0;
                    var3_3.width -= var4_4.left + var4_4.right;
                    var3_3.height -= var4_4.top + var4_4.bottom;
                    var5_6 = var2_2.y - var4_4.top;
                    var6_7 = var3_3.height - var5_6 - var2_2.height;
                    var7_8 = 2 + var8_5 * this.fItems.size();
                    this.fLinesVis = this.fItems.size();
                    var1_1.x = var2_2.x;
                    var1_1.width = var2_2.width;
                    if (var7_8 >= var6_7) break block7;
                    var1_1.y = var2_2.y + var2_2.height;
                    var1_1.height = var7_8;
                    break block8;
                }
                if (var7_8 >= var5_6) break block9;
                var1_1.y = var2_2.y - var7_8;
                var1_1.height = var7_8;
                break block8;
            }
            if (var6_7 <= var5_6) ** GOTO lbl38
            while (var7_8 > var6_7) {
                var7_8 -= var8_5;
                --this.fLinesVis;
            }
            var1_1.y = var2_2.y + var2_2.height;
            var1_1.height = var7_8;
            break block8;
lbl-1000:
            // 1 sources

            {
                var7_8 -= var8_5;
                --this.fLinesVis;
lbl38:
                // 2 sources

                ** while (var7_8 > var5_6)
            }
lbl39:
            // 1 sources

            var1_1.y = var2_2.y - var7_8;
            var1_1.height = var7_8;
        }
        this.fScrollbar.setVisibleAmount(this.fLinesVis);
        this.fScrollbar.setBlockIncrement(this.fLinesVis);
        this.fScrollbar.setMinimum(0);
        this.fScrollbar.setMaximum(Math.max(0, this.fItems.size() - this.fLinesVis));
        if (this.fSelectedIndex == -1) {
            this.fScrollbar.setValue(0);
        } else {
            this.fScrollbar.setValue(Math.min(this.fSelectedIndex, this.fScrollbar.getMaximum()));
        }
        if (this.fScrollbar.getMinimum() == this.fScrollbar.getMaximum()) {
            this.fScrollbar.setVisible(false);
        } else {
            this.fScrollbar.setVisible(true);
        }
        this.setBounds(var1_1.x, var1_1.y, var1_1.width, var1_1.height);
        this.positionScrollbar();
    }

    public void show(Component component, int n, int n2) {
    }

    public boolean getAutoCollapse() {
        return true;
    }

    public void collapse() {
        this.fOwner.hidePopup();
    }

    public void setFloaterOwner(FloaterOwner floaterOwner) {
        if (floaterOwner instanceof ColorCombobox) {
            this.fOwner = (ColorCombobox)floaterOwner;
        }
    }

    public FloaterOwner getFloaterOwner() {
        return this.fOwner;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.updateListArea();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.selectAtPoint(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.selectAtPoint(mouseEvent.getPoint());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.selectAtPoint(mouseEvent.getPoint());
        if (this.fSelectedIndex != -1) {
            ColorComboboxItem colorComboboxItem = (ColorComboboxItem)this.fItems.elementAt(this.fSelectedIndex);
            this.fOwner.setColor(colorComboboxItem.getColor());
            this.fOwner.setText(colorComboboxItem.getText());
            this.fOwner.fireAction();
        }
        this.collapse();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.selectAtPoint(mouseEvent.getPoint());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.selectAtPoint(mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.selectAtPoint(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.selectAtPoint(mouseEvent.getPoint());
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = this.fOffscreen.startRender(graphics);
        if (graphics2 == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getAdjustedFont());
        int n = fontMetrics.getAscent();
        int n2 = n + 1;
        int n3 = fontMetrics.getHeight();
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        graphics2.setFont(this.getFont());
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, n4 - 1, n5 - 1);
        n4 = this.fScrollbar.isVisible() ? this.fScrollbar.getLocation().x - 1 : (n4 -= 2);
        int n6 = 0;
        while (n6 < this.fLinesVis) {
            int n7 = n6 + this.fScrollbar.getValue();
            if (this.fSelectionType == 1) {
                if (n7 == this.fSelectedIndex) {
                    graphics2.setColor(Decorations.getColor((int)4));
                } else {
                    graphics2.setColor(Decorations.getColor((int)2));
                }
                graphics2.fillRect(1, n2 - n, n4, n3);
            } else {
                graphics2.setColor(Decorations.getColor((int)2));
                graphics2.fillRect(1, n2 - n, n4, n3);
                if (n7 == this.fSelectedIndex) {
                    graphics2.setColor(Decorations.getColor((int)4));
                    graphics2.drawRect(2, n2 - n, n4 - 3, n3 - 1);
                }
            }
            ColorComboboxItem colorComboboxItem = (ColorComboboxItem)this.fItems.elementAt(n7);
            String string = colorComboboxItem.getText();
            if (this.fSelectionType == 1) {
                if (n7 == this.fSelectedIndex) {
                    graphics2.setColor(Decorations.getColor((int)5));
                } else {
                    graphics2.setColor(SystemColor.textText);
                }
                graphics2.drawString(string, 3, n2);
            } else {
                graphics2.setColor(Color.black);
                graphics2.drawRect(5, n2 - n + 2, n4 - 9, n3 - 5);
                graphics2.setColor(colorComboboxItem.getColor());
                graphics2.fillRect(6, n2 - n + 3, n4 - 10, n3 - 6);
                graphics2.setColor(Color.black);
                graphics2.drawString(string, 12, n2);
            }
            n2 += n3;
            ++n6;
        }
        super.paint(graphics2);
        this.fOffscreen.finishRender(graphics);
    }

    private void positionScrollbar() {
        if (this.fScrollbar.isVisible()) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            int n3 = this.fScrollbar.getPreferredSize().width;
            if (PlatformInfo.getAppearance() != 0) {
                this.fScrollbar.setBounds(n - n3 - 1, 1, n3, n2 - 2);
                return;
            }
            this.fScrollbar.setBounds(n - n3, 0, n3, n2);
        }
    }

    private void selectAtPoint(Point point) {
        int n;
        int n2 = this.getFontMetrics(this.getAdjustedFont()).getHeight();
        int n3 = this.fScrollbar.isVisible() ? this.fScrollbar.getLocation().x : this.getSize().width;
        int n4 = this.getSize().height;
        if (point.y > 0 && point.y < n4 - 1 && point.x > 0 && point.x < n3 - 1 && (n = this.fScrollbar.getValue() + (point.y - 1) / n2) != this.fSelectedIndex) {
            this.fSelectedIndex = n;
            this.updateListArea();
        }
    }

    private void updateListArea() {
        int n = this.fScrollbar.isVisible() ? this.fScrollbar.getLocation().x : this.getSize().width;
        int n2 = this.getSize().height;
        this.repaint(5L, 1, 1, n - 1, n2 - 2);
    }

    void select(ColorComboboxItem colorComboboxItem) {
        this.fSelectedIndex = -1;
        int n = 0;
        while (n < this.fItems.size()) {
            ColorComboboxItem colorComboboxItem2 = (ColorComboboxItem)this.fItems.elementAt(n);
            if (colorComboboxItem2.getText().equals(colorComboboxItem.getText()) && colorComboboxItem2.getColor().equals(colorComboboxItem.getColor())) {
                this.fSelectedIndex = n;
            }
            ++n;
        }
    }

    void addItem(ColorComboboxItem colorComboboxItem) {
        this.fItems.addElement(colorComboboxItem);
    }

    void removeItem(ColorComboboxItem colorComboboxItem) {
        int n = 0;
        while (n < this.fItems.size()) {
            ColorComboboxItem colorComboboxItem2 = (ColorComboboxItem)this.fItems.elementAt(n);
            if (colorComboboxItem2.getText().equals(colorComboboxItem.getText()) && colorComboboxItem2.getColor().equals(colorComboboxItem.getColor())) {
                this.fItems.removeElement(colorComboboxItem2);
            }
            ++n;
        }
    }

    void removeItemIgnoreCase(ColorComboboxItem colorComboboxItem) {
        int n = 0;
        while (n < this.fItems.size()) {
            ColorComboboxItem colorComboboxItem2 = (ColorComboboxItem)this.fItems.elementAt(n);
            if (colorComboboxItem2.getText().equalsIgnoreCase(colorComboboxItem.getText()) && colorComboboxItem2.getColor().equals(colorComboboxItem.getColor())) {
                this.fItems.removeElement(colorComboboxItem2);
            }
            ++n;
        }
    }

    void removeAllItems() {
        this.fItems.removeAllElements();
    }

    void setRestrictWidth(boolean bl) {
        this.fRestrictWidth = bl;
    }
}

