/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.widgets.ColorComboboxItem;
import com.mathworks.ide.widgets.ColorComboboxList;
import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.util.Assert;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Array;

public class ColorCombobox
extends MWPanel
implements MouseListener,
FloaterOwner {
    private static final int BEVEL_SIZE = 2;
    private static final int GAP = 2;
    public static final int STANDARD_SELECTION = 1;
    public static final int RING_SELECTION = 2;
    private MWLabel fLabelField;
    private ColorComboboxList fList;
    private int fMinimumWidth = -1;
    private EscapeHandler fEscapeHandler;
    private DeactivateHandler fDeactivateHandler;
    private ActionListener fActionListener;
    private String fActionCommand;
    private transient Rectangle fButtonRect;
    private Color fColorWhileDisabled;
    protected static Color fListBackgroundColor = Decorations.getColor((int)0);

    public ColorCombobox(String string, String[] stringArray) {
        this(string, null, stringArray, null);
    }

    public ColorCombobox(Color color, Color[] colorArray) {
        this(null, color, null, colorArray);
    }

    public ColorCombobox(String string, Color color, String[] stringArray, Color[] colorArray) {
        int n;
        if (stringArray == null) {
            if (Assert.isEnabled() && (colorArray == null || colorArray.length < 0)) {
                throw new IllegalArgumentException();
            }
            stringArray = new String[colorArray.length];
            n = 0;
            while (n < colorArray.length) {
                stringArray[n] = "";
                ++n;
            }
        }
        if (colorArray == null) {
            if (Assert.isEnabled() && (stringArray == null || stringArray.length < 0)) {
                throw new IllegalArgumentException();
            }
            colorArray = new Color[stringArray.length];
            n = 0;
            while (n < stringArray.length) {
                colorArray[n] = fListBackgroundColor;
                ++n;
            }
        }
        if (Assert.isEnabled() && stringArray.length != colorArray.length) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            string = "";
        }
        ((Container)((Object)this)).setLayout(null);
        this.setOpaque(false);
        this.fLabelField = new MWLabel(string);
        if (color != null) {
            this.fLabelField.setBackground(color);
        }
        this.fLabelField.addMouseListener(this);
        this.fList = new ColorComboboxList(this);
        this.fList.setVisible(false);
        this.fEscapeHandler = new EscapeHandler();
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addKeyListener(this.fEscapeHandler);
        this.fLabelField.addKeyListener(this.fEscapeHandler);
        this.fDeactivateHandler = null;
        this.setFont(this.fLabelField.getFont());
        ((Container)((Object)this)).add((Component)this.fLabelField);
        n = 0;
        while (n < stringArray.length) {
            this.fList.addItem(new ColorComboboxItem(stringArray[n], colorArray[n]));
            ++n;
        }
        this.selectItem(string, color);
    }

    public ColorCombobox() {
        this("", new String[0]);
    }

    public Object getPopupForQE() {
        return this.fList;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fLabelField.setFont(font);
        ((Component)this.fList).setFont(font);
    }

    public void setSelectionType(int n) {
        this.fList.setSelectionType(n);
    }

    public void setMinimumWidth(int n) {
        this.fMinimumWidth = n;
    }

    public String getText() {
        return this.fLabelField.getText();
    }

    public void setText(String string) {
        this.fLabelField.setText(string);
    }

    public void addItem(String string) {
        this.fList.addItem(new ColorComboboxItem(string, fListBackgroundColor));
    }

    public void removeItem(String string) {
        this.fList.removeItem(new ColorComboboxItem(string, fListBackgroundColor));
    }

    public void removeItemIgnoreCase(String string) {
        this.fList.removeItemIgnoreCase(new ColorComboboxItem(string, fListBackgroundColor));
    }

    public void setRestrictWidth(boolean bl) {
        this.fList.setRestrictWidth(bl);
    }

    public void setEnabled(boolean bl) {
        if (bl != ((Component)((Object)this)).isEnabled()) {
            if (!bl) {
                this.fColorWhileDisabled = this.getColor();
                this.fLabelField.setBackground(Decorations.getColor((int)1));
                this.fLabelField.repaint();
                super.setEnabled(bl);
                ((Component)((Object)this)).removeMouseListener(this);
                this.fLabelField.removeMouseListener(this);
                ((Component)((Object)this)).removeKeyListener(this.fEscapeHandler);
                this.fLabelField.removeKeyListener(this.fEscapeHandler);
                return;
            }
            if (this.fColorWhileDisabled != null) {
                this.fLabelField.setBackground(this.fColorWhileDisabled);
            }
            this.fLabelField.repaint();
            super.setEnabled(bl);
            ((Component)((Object)this)).addMouseListener(this);
            this.fLabelField.addMouseListener(this);
            ((Component)((Object)this)).addKeyListener(this.fEscapeHandler);
            this.fLabelField.addKeyListener(this.fEscapeHandler);
        }
    }

    public void removeAllItems() {
        this.fList.removeAllItems();
    }

    public void setColor(Color color) {
        this.fLabelField.setBackground(color);
    }

    public Color getColor() {
        if (!((Component)((Object)this)).isEnabled() && this.fColorWhileDisabled != null) {
            return this.fColorWhileDisabled;
        }
        return this.fLabelField.getBackground();
    }

    public int getSelectedIndex() {
        ColorComboboxItem[] colorComboboxItemArray = this.fList.getItems();
        ColorComboboxItem colorComboboxItem = new ColorComboboxItem(this.getText(), this.getColor());
        int n = 0;
        while (n < colorComboboxItemArray.length) {
            ColorComboboxItem colorComboboxItem2 = colorComboboxItemArray[n];
            if (colorComboboxItem2.getText().equals(colorComboboxItem.getText()) && colorComboboxItem2.getColor().equals(colorComboboxItem.getColor())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void selectItem(int n) {
        ColorComboboxItem[] colorComboboxItemArray = this.fList.getItems();
        this.selectItem(colorComboboxItemArray[n].getText(), colorComboboxItemArray[n].getColor());
    }

    public void selectItem(String string, Color color) {
        this.setText(string);
        if (color != null) {
            this.setColor(color);
        }
    }

    public void selectItem(String string) {
        this.setText(string);
    }

    public String[] getItems() {
        return this.getTextItems();
    }

    public String[] getTextItems() {
        ColorComboboxItem[] colorComboboxItemArray = this.fList.getItems();
        String[] stringArray = new String[colorComboboxItemArray.length];
        int n = 0;
        while (n < colorComboboxItemArray.length) {
            stringArray[n] = colorComboboxItemArray[n].getText();
            ++n;
        }
        return stringArray;
    }

    public Color[] getColorItems() {
        ColorComboboxItem[] colorComboboxItemArray = this.fList.getItems();
        int n = Array.getLength(colorComboboxItemArray);
        Color[] colorArray = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            colorArray[n2] = colorComboboxItemArray[n2].getColor();
            ++n2;
        }
        return colorArray;
    }

    public void setItems(String[] stringArray) {
        ColorComboboxItem[] colorComboboxItemArray = new ColorComboboxItem[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            colorComboboxItemArray[n] = new ColorComboboxItem(stringArray[n], fListBackgroundColor);
            ++n;
        }
        this.fList.setItems(colorComboboxItemArray);
    }

    public void setItems(Color[] colorArray) {
        ColorComboboxItem[] colorComboboxItemArray = new ColorComboboxItem[colorArray.length];
        int n = 0;
        while (n < colorArray.length) {
            colorComboboxItemArray[n] = new ColorComboboxItem("", colorArray[n]);
            ++n;
        }
        this.fList.setItems(colorComboboxItemArray);
    }

    public void setItems(ColorComboboxItem[] colorComboboxItemArray) {
        this.fList.setItems(colorComboboxItemArray);
    }

    public boolean contains(String string) {
        String[] stringArray = this.getTextItems();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsIgnoreCase(String string) {
        String[] stringArray = this.getTextItems();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        String[] stringArray = this.getTextItems();
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(this.getFont());
            dimension.height = fontMetrics.getHeight();
            dimension.width = 0;
            int n = 0;
            while (n < stringArray.length) {
                dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(stringArray[n]));
                ++n;
            }
        }
        dimension.width += 5;
        if (dimension.width < this.fMinimumWidth) {
            dimension.width = this.fMinimumWidth;
        }
        switch (PlatformInfo.getAppearance()) {
            case 1: {
                dimension.width += 4 + dimension.height;
                dimension.height += 4;
                break;
            }
            default: {
                dimension.width += dimension.height + 2;
                dimension.height += 4;
            }
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    public void print(Graphics graphics) {
        this.bufferedPaint(graphics);
    }

    public void bufferedPaint(Graphics graphics) {
        Rectangle rectangle = new Rectangle(0, 0, ((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
        graphics.setColor(((Component)((Object)this)).getBackground());
        Decorations.drawComboControl((Graphics)graphics, (Rectangle)rectangle, (boolean)this.fList.isVisible(), (boolean)true);
        if (PlatformInfo.getAppearance() != 1) {
            rectangle = this.fLabelField.getBounds();
            rectangle.grow(2, 2);
            Decorations.drawBevelFrame((Graphics)graphics, (int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height);
        }
        super.bufferedPaint(graphics);
    }

    public void doLayout() {
        Rectangle rectangle = new Rectangle(0, 0, ((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
        if (PlatformInfo.getAppearance() == 1) {
            rectangle.grow(-2, -2);
            rectangle.width -= rectangle.height;
        } else {
            rectangle.grow(-2, -2);
            rectangle.width -= rectangle.height + 2;
        }
        this.fLabelField.setBounds(rectangle);
    }

    public void floaterAutoCollapsed(Floater floater) {
    }

    public void hidePopup() {
        Window window = this.getEnclosingWindow();
        Rectangle rectangle = this.fList.getBounds();
        this.fList.setVisible(false);
        if (window != null) {
            window.remove(this.fList);
            Graphics graphics = window.getGraphics();
            if (graphics != null && ((Component)window).getBackground() != null) {
                graphics.setColor(((Component)window).getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (graphics != null) {
                graphics.dispose();
            }
            window.repaint(5L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        ((Component)((Object)this)).repaint(5L);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Window window = this.getEnclosingWindow();
        LayoutManager layoutManager = window.getLayout();
        if (this.fList.isVisible()) {
            this.fList.collapse();
            ((Component)((Object)this)).transferFocus();
            return;
        }
        if (layoutManager instanceof MWBorderLayout) {
            window.add(this.fList, "Floating", 0);
            ColorComboboxItem colorComboboxItem = new ColorComboboxItem(this.fLabelField.getText(), this.fLabelField.getBackground());
            this.fList.select(colorComboboxItem);
            this.fList.fitOnScreen();
            this.fList.setVisible(true);
            ((Component)((Object)this)).requestFocus();
            ((Component)((Object)this)).repaint(5L);
            return;
        }
        System.out.println("The window containing this component must have");
        System.out.println("an MWBorderLayout for this component to function.");
        System.out.println("It is recommended that you use MWFrame or MWDialog.");
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void addNotify() {
        this.fDeactivateHandler = new DeactivateHandler();
        this.getEnclosingWindow().addWindowListener(this.fDeactivateHandler);
        super.addNotify();
    }

    public void removeNotify() {
        this.getEnclosingWindow().removeWindowListener(this.fDeactivateHandler);
        this.fDeactivateHandler = null;
        super.removeNotify();
    }

    Window getEnclosingWindow() {
        Container container = ((Component)((Object)this)).getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        return (Window)container;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    public void processActionEvent(ActionEvent actionEvent) {
        if (this.fActionListener != null) {
            this.fActionListener.actionPerformed(actionEvent);
        }
    }

    void fireAction() {
        this.processActionEvent(new ActionEvent(this, 0, this.getActionCommand()));
    }

    public String getActionCommand() {
        return this.fActionCommand;
    }

    public void setActionCommand(String string) {
        this.fActionCommand = string;
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    private class EscapeHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (ColorCombobox.this.fList.isVisible() && keyEvent.getKeyCode() == 27) {
                ColorCombobox.this.fList.collapse();
                ((Component)((Object)ColorCombobox.this)).transferFocus();
            }
        }

        EscapeHandler() {
            ColorCombobox.this = ColorCombobox.this;
        }
    }

    private class DeactivateHandler
    extends WindowAdapter {
        public void windowDeactivated(WindowEvent windowEvent) {
            ColorCombobox.this.fList.collapse();
        }

        DeactivateHandler() {
            ColorCombobox.this = ColorCombobox.this;
        }
    }

    private static class Test
    extends MWFrame {
        public Test() {
            super("Combobox Example");
            ((Window)((Object)this)).addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this)));
            MWPanel mWPanel = new MWPanel();
            this.setLayout((LayoutManager)new MWBorderLayout());
            ((Container)((Object)this)).add((Component)mWPanel, "North");
            mWPanel.setLayout((LayoutManager)new MWBorderLayout());
            String[] stringArray = new String[]{"One", "Two", "Three"};
            ColorCombobox colorCombobox = new ColorCombobox("One", stringArray);
            mWPanel.add((Component)((Object)colorCombobox), "North");
            ColorCombobox colorCombobox2 = new ColorCombobox("Two", stringArray);
            mWPanel.add((Component)((Object)colorCombobox2), "South");
            colorCombobox2.setEnabled(false);
            ((Component)((Object)this)).setSize(300, 300);
            ((Component)((Object)this)).setVisible(true);
        }
    }
}

