/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.prefs;

import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.prefs.PanelRegistrant;
import com.mathworks.ide.prefs.PrefsListener;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTreeView;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.TreeData;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.Vector;

public class PrefsDialog
implements MWCommandTarget,
MWCommandCenterOwner {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");
    private static final String OK_STRING = sRes.getString("button.ok");
    private static final String CANCEL_STRING = sRes.getString("button.cancel");
    private static final String HELP_STRING = sRes.getString("button.help");
    private static final int OK_COMMAND = 10;
    private static final int CANCEL_COMMAND = 11;
    private static final int HELP_COMMAND = 12;
    public static final int INIT_ALL = 0;
    public static final int INIT_STANDALONE = 1;
    private MWFrame fFrame;
    private MWTreeView fTree;
    private MWPanel fContentPanel;
    private MWLabel fPrefAreaLabel;
    private CardLayout fCardLayout;
    private Vector fRegistrants;
    private Vector fOpenRegistrants;
    private MWCommandCenter fCenter;
    private Vector fListeners;
    private static Vector sPanelRegistrants;
    private static Vector sExpandList;
    private static Vector sDeferredRegistrants;
    private static PrefsDialog sPrefsDialog;
    private static boolean sIsInited;
    private static int sInitOption;

    private static void initialize() {
        if (sIsInited) {
            return;
        }
        sPanelRegistrants = new Vector();
        sExpandList = new Vector();
        sIsInited = true;
        if (sInitOption == 0) {
            PrefsDialog.registerPanel(sRes.getString("area.general"), "com.mathworks.ide.prefs.GeneralPrefsPanel");
            PrefsDialog.registerPanel(sRes.getString("area.general.fontandcolors"), "com.mathworks.ide.prefs.GeneralPrefsColorPanel");
            PrefsDialog.registerPanel(sRes.getString("area.general.sourcecontrol"), "com.mathworks.ide.editor.EditorPrefsSavePanel");
            PrefsDialog.registerPanel(sRes.getString("area.commandwindow"), "com.mathworks.ide.prefs.CommandWindowPrefsPanel");
            PrefsDialog.registerPanel(sRes.getString("area.commandwindow.fontandcolors"), "com.mathworks.ide.prefs.CmdWinPrefsColorPanel");
        }
        if (sInitOption == 0 || sInitOption == 1) {
            PrefsDialog.registerPanel(sRes.getString("area.editordebugger"), "com.mathworks.ide.editor.EditorPrefsGeneralPanel");
            PrefsDialog.registerPanel(sRes.getString("area.editordebugger.fontandcolors"), "com.mathworks.ide.editor.EditorPrefsFontPanel");
            PrefsDialog.registerPanel(sRes.getString("area.editordebugger.display"), "com.mathworks.ide.editor.EditorPrefsDisplayPanel");
            PrefsDialog.registerPanel(sRes.getString("area.editordebugger.keyboardandindenting"), "com.mathworks.ide.editor.EditorPrefsKeyboardPanel");
            PrefsDialog.registerPanel(sRes.getString("area.editordebugger.printing"), "com.mathworks.ide.editor.EditorPrefsPrintPanel");
        }
        if (sInitOption == 0) {
            PrefsDialog.registerPanel(sRes.getString("area.help"), "com.mathworks.ide.help.HelpPrefs");
            PrefsDialog.registerPanel(sRes.getString("area.help.fonts"), "com.mathworks.ide.help.HelpFontPrefs");
            PrefsDialog.registerPanel(sRes.getString("area.currentdirectory"), "com.mathworks.ide.browsers.CurrentDirectoryPrefs");
            PrefsDialog.registerPanel(sRes.getString("area.workspace"), "com.mathworks.ide.workspace.WorkspacePrefsPanel");
            PrefsDialog.registerPanel(sRes.getString("area.arrayeditor"), "com.mathworks.ide.arrayeditor.ArrayEditorPrefsPanel");
            PrefsDialog.registerPanel(sRes.getString("area.guide"), "com.mathworks.ide.layout.LayoutPrefs");
            PrefsDialog.registerPanel(sRes.getString("area.figurecopytemplate"), "com.mathworks.page.prefs.FigureStyleOptions");
            if (PlatformInfo.isWindows()) {
                PrefsDialog.registerPanel(sRes.getString("area.figurecopytemplate.copyoptions"), "com.mathworks.page.prefs.CopyOptions");
                PrefsDialog.registerPanel(sRes.getString("area.figurecopytemplate.printingoptions"), "com.mathworks.page.prefs.PrintingOptions");
            }
        }
        if (sDeferredRegistrants != null) {
            int n = 0;
            while (n < sDeferredRegistrants.size()) {
                PrefsDialog.registerPanel((String)sDeferredRegistrants.elementAt(n), (String)sDeferredRegistrants.elementAt(n + 1));
                n += 2;
            }
            sDeferredRegistrants.removeAllElements();
            sDeferredRegistrants = null;
        }
    }

    public static void showPrefsDialog(String string) {
        PrefsDialog.initialize();
        if (sPrefsDialog == null) {
            sPrefsDialog = new PrefsDialog(sPanelRegistrants, string);
            return;
        }
        sPrefsDialog.showRegistrant(string);
        PrefsDialog.sPrefsDialog.fFrame.toFront();
    }

    public static void showPrefsDialog(String string, int n) {
        sInitOption = n;
        PrefsDialog.initialize();
        if (sPrefsDialog == null) {
            sPrefsDialog = new PrefsDialog(sPanelRegistrants, string);
            return;
        }
        sPrefsDialog.showRegistrant(string);
        PrefsDialog.sPrefsDialog.fFrame.toFront();
    }

    public static void showPrefsDialog() {
        PrefsDialog.initialize();
        if (sPrefsDialog == null) {
            sPrefsDialog = new PrefsDialog(sPanelRegistrants, null);
            return;
        }
        sPrefsDialog.showRegistrant(null);
        PrefsDialog.sPrefsDialog.fFrame.toFront();
    }

    public static void registerPanel(String string, String string2) {
        if (!sIsInited) {
            if (sDeferredRegistrants == null) {
                sDeferredRegistrants = new Vector();
            }
            sDeferredRegistrants.addElement(string);
            sDeferredRegistrants.addElement(string2);
            PrefsDialog.callClassMethod(string2, "installPrefs", false);
            return;
        }
        PrefsDialog.initialize();
        if (PrefsDialog.prefsMethodsExist(string2)) {
            PanelRegistrant panelRegistrant = new PanelRegistrant(string, string2);
            sPanelRegistrants.addElement(panelRegistrant);
            PrefsDialog.callClassMethod(string2, "installPrefs", false);
        }
    }

    private static boolean prefsMethodsExist(String string) {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{};
            Method method = clazz.getMethod("createPrefsPanel", classArray);
            if (method != null && (method = clazz.getMethod("commitPrefsChanges", classArray)) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public static PrefsDialog getPrefsDialog() {
        PrefsDialog.initialize();
        return sPrefsDialog;
    }

    public void addWindowListenerToFrame(WindowAdapter windowAdapter) {
        this.fFrame.addWindowListener(windowAdapter);
    }

    PrefsDialog(Vector vector, String string) {
        PrefsDialog.initialize();
        this.fRegistrants = vector;
        this.fOpenRegistrants = new Vector();
        this.fListeners = new Vector();
        sPrefsDialog = this;
        this.fFrame = new PrefsFrame(sRes.getString("dialog.title"));
        this.fFrame.setResizable(false);
        if (PlatformInfo.isWindows()) {
            this.fFrame.setSize(550, 460);
        } else {
            this.fFrame.setSize(630, 500);
        }
        this.fTree = new MWTreeView();
        this.fTree.setName("Preference Panel Tree");
        this.fTree.setFont(new Font("Dialog", 0, 12));
        this.fTree.addItemListener((ItemListener)new SelectionListener());
        this.fTree.addMouseListener(new TreeMouseAdapter());
        this.fTree.setPreferredTableSize(15, 2);
        this.buildTree();
        TreeData treeData = this.fTree.getTreeData();
        int[] nArray = treeData.getChildren(-1);
        while (sExpandList.size() > 0) {
            String string2 = (String)sExpandList.elementAt(0);
            sExpandList.removeElementAt(0);
            int n = 0;
            while (n < nArray.length) {
                if (treeData.getItem(nArray[n]).equals(string2)) {
                    treeData.expandItem(nArray[n]);
                }
                ++n;
            }
        }
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.setInsets(new Insets(5, 5, 5, 5));
        mWPanel.add((Component)this.fTree, "Center");
        this.fFrame.add((Component)mWPanel, "West");
        this.fCardLayout = new CardLayout();
        this.fContentPanel = new MWPanel((LayoutManager)this.fCardLayout);
        this.fContentPanel.setName("Preference Content Panel");
        this.fPrefAreaLabel = new MWLabel("");
        this.fPrefAreaLabel.setFont(new Font("Dialog", 1, 12));
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(0));
        mWPanel2.setInsets(new Insets(0, 0, 0, 0));
        mWPanel2.setOpaque(true);
        Color color = Decorations.getColor((int)6);
        int n = 7 * color.getRed() / 8;
        int n2 = 7 * color.getGreen() / 8;
        int n3 = 7 * color.getBlue() / 8;
        color = new Color(n, n2, n3);
        mWPanel2.setBackground(color);
        mWPanel2.add((Component)this.fPrefAreaLabel);
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new BorderLayout(5, 10));
        mWPanel3.setInsets(new Insets(5, 5, 5, 5));
        mWPanel3.add((Component)this.fContentPanel, "Center");
        mWPanel3.add((Component)mWPanel2, "North");
        this.fFrame.add((Component)mWPanel3, "Center");
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new FlowLayout(2));
        MWButton mWButton = new MWButton(OK_STRING);
        mWButton.setName("OK");
        this.fCenter.addCommandSource((MWCommandSource)mWButton, 10);
        mWPanel4.add((Component)mWButton);
        mWButton = new MWButton(CANCEL_STRING);
        mWButton.setName("Cancel");
        this.fCenter.addCommandSource((MWCommandSource)mWButton, 11);
        mWPanel4.add((Component)mWButton);
        mWButton = new MWButton(HELP_STRING);
        mWButton.setName("Help");
        this.fCenter.addCommandSource((MWCommandSource)mWButton, 12);
        mWPanel4.add((Component)mWButton);
        this.fFrame.add((Component)mWPanel4, "South");
        this.showRegistrant(string);
        this.fFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)this.fFrame));
        this.fFrame.show();
    }

    private void showRegistrant(String string) {
        int n = 0;
        if (string != null) {
            String string2;
            int n2;
            String string3;
            TreeData treeData = this.fTree.getTreeData();
            int n3 = string.indexOf(46);
            if (n3 > -1) {
                string3 = string.substring(0, n3);
                int[] nArray = treeData.getChildren(-1);
                n2 = 0;
                while (n2 < nArray.length) {
                    if (treeData.getItem(nArray[n2]).equals(string3)) {
                        treeData.expandItem(nArray[n2]);
                        break;
                    }
                    ++n2;
                }
                string2 = string.substring(n3 + 1, string.length());
            } else {
                string2 = string;
            }
            Dimension dimension = this.fTree.getTableSize();
            n2 = 0;
            while (n2 < dimension.height) {
                string3 = (String)this.fTree.getCellData(n2, 0);
                if (string3.equals(string2)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        this.fTree.select(n, 0);
        this.showItem(n);
    }

    private void showItem(int n) {
        MWPanel mWPanel = null;
        n = this.fTree.getItemId(n);
        PanelRegistrant panelRegistrant = (PanelRegistrant)this.fRegistrants.elementAt(n);
        String string = panelRegistrant.getPrefsArea();
        if (!this.fOpenRegistrants.contains(panelRegistrant)) {
            String string2 = panelRegistrant.getRegistrant();
            mWPanel = (MWPanel)PrefsDialog.callClassMethod(string2, "createPrefsPanel", true);
            if (mWPanel != null) {
                this.setPrefsAreaLabel(string);
                panelRegistrant.setThePanel(mWPanel);
                this.fContentPanel.add((Component)mWPanel, string);
                this.fOpenRegistrants.addElement(panelRegistrant);
                PrefsDialog.callClassMethod(string2, "initPrefsPanel", false);
                this.fCardLayout.show((Container)this.fContentPanel, string);
                return;
            }
        } else {
            this.setPrefsAreaLabel(string);
            if (sInitOption == 1) {
                this.fTree.getTreeData().expandItem(n);
            }
            this.fCardLayout.show((Container)this.fContentPanel, string);
        }
    }

    private static Object callClassMethod(String string, String string2, boolean bl) {
        Object object;
        block2: {
            object = null;
            try {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod(string2, classArray);
                Object[] objectArray = new Object[]{};
                object = method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                if (!bl) break block2;
                exception.printStackTrace();
            }
        }
        return object;
    }

    private void acceptChanges() {
        AcceptChangesThread acceptChangesThread = new AcceptChangesThread();
        acceptChangesThread.start();
    }

    private void setPrefsAreaLabel(String string) {
        this.fPrefAreaLabel.setText(String.valueOf(string.replace('.', ' ')) + " " + sRes.getString("dialog.title"));
        this.fPrefAreaLabel.invalidate();
        this.fFrame.validate();
    }

    private int findInTree(int n, String string) {
        int[] nArray = this.fTree.getChildren(n);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (string.equals((String)this.fTree.getItem(nArray[n2]))) {
                return nArray[n2];
            }
            ++n2;
        }
        return -1;
    }

    private void saveExpandedState() {
        TreeData treeData = this.fTree.getTreeData();
        int[] nArray = treeData.getChildren(-1);
        int n = 0;
        while (n < nArray.length) {
            if (treeData.isExpanded(nArray[n])) {
                sExpandList.addElement(treeData.getItem(nArray[n]));
            }
            ++n;
        }
    }

    public void doCommand(int n) {
        if (n == 10) {
            this.saveExpandedState();
            sPrefsDialog = null;
            this.fFrame.dispose();
            this.acceptChanges();
            return;
        }
        if (n == 11) {
            this.saveExpandedState();
            sPrefsDialog = null;
            this.fFrame.dispose();
            return;
        }
        if (n == 12) {
            HelpBrowser.getHelpBrowser().displayTopic(null, "matlab_env", "matlabenvironment_preferences", (Frame)this.fFrame);
        }
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    private int findSpotInTree(int n, String string, boolean bl) {
        int[] nArray = this.fTree.getChildren(n);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (string.equals((String)this.fTree.getItem(nArray[n2]))) {
                return nArray[n2];
            }
            ++n2;
        }
        return this.fTree.addItem(n, (Object)string, true);
    }

    private void buildTree() {
        int n = 0;
        while (n < this.fRegistrants.size()) {
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            boolean bl = false;
            String string = ((PanelRegistrant)this.fRegistrants.elementAt(n)).getPrefsArea();
            while (!bl) {
                n2 = string.indexOf(46, n3);
                if (n2 == -1) {
                    bl = true;
                    n2 = string.length();
                }
                n4 = this.findSpotInTree(n4, string.substring(n3, n2), bl);
                n3 = n2 + 1;
            }
            ++n;
        }
    }

    private MWPanel getThePanel(int n) {
        MWPanel mWPanel = null;
        n = this.fTree.getItemId(n);
        PanelRegistrant panelRegistrant = (PanelRegistrant)this.fRegistrants.elementAt(n);
        mWPanel = panelRegistrant.getThePanel();
        return mWPanel;
    }

    public static void main(String[] stringArray) {
        PrefsDialog.showPrefsDialog();
    }

    public synchronized void addPrefsDialogItemListener(Object object) {
        this.fListeners.addElement(object);
    }

    public synchronized void removePrefsDialogItemListener(Object object) {
        this.fListeners.removeElement(object);
    }

    static /* synthetic */ int access$4() {
        return 11;
    }

    private class AcceptChangesThread
    extends Thread {
        AcceptChangesThread() {
            PrefsDialog.this = PrefsDialog.this;
        }

        public void run() {
            int n = 0;
            while (n < PrefsDialog.this.fOpenRegistrants.size()) {
                PanelRegistrant panelRegistrant = (PanelRegistrant)PrefsDialog.this.fOpenRegistrants.elementAt(n);
                String string = panelRegistrant.getRegistrant();
                try {
                    Class<?> clazz = Class.forName(string);
                    Class[] classArray = new Class[]{};
                    Method method = clazz.getMethod("commitPrefsChanges", classArray);
                    Object[] objectArray = new Object[]{};
                    method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
    }

    class SelectionListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            PrefsDialog.this.showItem(PrefsDialog.this.fTree.getFirstSelectedRow());
            String string = (String)PrefsDialog.this.fTree.getCellData(PrefsDialog.this.fTree.getFirstSelectedRow(), 0);
            int n = 0;
            while (n < PrefsDialog.this.fListeners.size()) {
                MWPanel mWPanel = PrefsDialog.this.getThePanel(PrefsDialog.this.fTree.getFirstSelectedRow());
                ((PrefsListener)PrefsDialog.this.fListeners.elementAt(n)).PrefSelected(mWPanel, string);
                ++n;
            }
        }

        SelectionListener() {
            PrefsDialog.this = PrefsDialog.this;
        }
    }

    class PrefsFrame
    extends MWFrame
    implements MWWindowOwner {
        String fName;

        PrefsFrame(String string) {
            super(string);
            PrefsDialog.this = PrefsDialog.this;
            this.fName = string;
        }

        public int closeWindow() {
            PrefsDialog.this.doCommand(PrefsDialog.access$4());
            return 0;
        }

        public void setActive(boolean bl) {
        }

        public String getShortName() {
            return this.fName;
        }

        public String getLongName() {
            return this.fName;
        }
    }

    private class TreeMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n;
                TreeData treeData;
                Point point = PrefsDialog.this.fTree.findCell(mouseEvent.getX(), mouseEvent.getY());
                int n2 = point.y;
                int n3 = point.x;
                if (n2 != -2 && n3 != -2 && n3 != -3 && (treeData = PrefsDialog.this.fTree.getTreeData()).isBranch(n = PrefsDialog.this.fTree.getItemId(n2)) && treeData.hasChildren(n)) {
                    if (treeData.isExpanded(n)) {
                        treeData.collapseItem(n);
                        return;
                    }
                    treeData.expandItem(n);
                }
            }
        }

        TreeMouseAdapter() {
            PrefsDialog.this = PrefsDialog.this;
        }
    }
}

