/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.prefs;

import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ResourceBundle;

public class GeneralPrefsPanel
extends MWPanel
implements ActionListener {
    private MWCheckbox fShowTooltips;
    private MWCheckbox fUseCache;
    private MWCheckbox fUseCacheDiag;
    private MWButton fUpdateCache;
    private MWCheckbox fUseDefaultCheckbox;
    private MWCheckbox fUseBlackAndWhiteCheckbox;
    private MWCheckbox fUseColorCheckbox;
    private static Matlab sMatlab;
    private static File sCacheFile;
    private static boolean sUseDefault;
    private static boolean sUseBlackAndWhite;
    private static ResourceBundle sRes;
    private static GeneralPrefsPanel sPrefsPanel;

    private static void setPrintColorChoice() {
        if (PlatformInfo.isWindows() && sMatlab != null) {
            int n = -1;
            if (!sUseDefault) {
                n = sUseBlackAndWhite ? 0 : 1;
            }
            sMatlab.evalNoOutput("system_dependent('setprintcolorchoice', " + n + ")");
        }
    }

    private static boolean isCacheWritable() {
        if (sCacheFile == null) {
            sCacheFile = new File(new File(new File(Matlab.matlabRoot(), "toolbox"), "local"), "cachepath.mat");
        }
        return sCacheFile.canWrite();
    }

    public static int getToolboxCacheLevel() {
        if (!Prefs.getBooleanPref((String)"GeneralUseToolboxCache", (boolean)false)) {
            return 0;
        }
        if (Prefs.getBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)false)) {
            return 2;
        }
        return 1;
    }

    public GeneralPrefsPanel() {
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        this.fShowTooltips = new MWCheckbox(sRes.getString("gtlp.tooltips"));
        this.fShowTooltips.setName("gtlp.tooltips");
        this.fShowTooltips.setState(Prefs.getBooleanPref((String)"GeneralShowTooltips", (boolean)true));
        MWGroupbox mWGroupbox = new MWGroupbox(sRes.getString("gtlp.display"));
        mWGroupbox.setMargins(new Insets(10, 5, 10, 5));
        mWGroupbox.setLayout(new BorderLayout());
        mWGroupbox.add((Component)this.fShowTooltips, "North");
        CacheCheckboxListener cacheCheckboxListener = new CacheCheckboxListener();
        this.fUseCache = new MWCheckbox(sRes.getString("gtlp.usetoolboxcache"));
        this.fUseCache.setName("gtlp.usetoolboxcache");
        this.fUseCacheDiag = new MWCheckbox(sRes.getString("gtlp.usetoolboxcachediag"));
        this.fUseCache.setName("gtlp.usetoolboxcachediag");
        this.fUpdateCache = new MWButton(sRes.getString("gtlp.updatetoolboxcache"));
        this.fUpdateCache.setName("gtlp.updatetoolboxcache");
        this.fUpdateCache.setActionCommand("UpdateCache");
        this.fUpdateCache.addActionListener((ActionListener)this);
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fUseCache.setState(Prefs.getBooleanPref((String)"GeneralUseToolboxCache", (boolean)false));
        this.fUseCacheDiag.setState(Prefs.getBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)false));
        this.fUseCacheDiag.setEnabled(this.fUseCache.getState());
        this.fUpdateCache.setEnabled(this.fUseCache.getState() && GeneralPrefsPanel.isCacheWritable());
        this.fUseCache.addItemListener((ItemListener)cacheCheckboxListener);
        MWGroupbox mWGroupbox2 = new MWGroupbox(sRes.getString("gtlp.toolboxcachepanel"));
        mWGroupbox2.setMargins(new Insets(10, 5, 10, 5));
        mWGroupbox2.setLayout(vertFlowLayout);
        mWGroupbox2.add((Component)this.fUseCache);
        mWGroupbox2.add((Component)this.fUseCacheDiag);
        mWPanel.add((Component)this.fUpdateCache, "West");
        mWGroupbox2.add((Component)mWPanel);
        MWGroupbox mWGroupbox3 = new MWGroupbox(sRes.getString("gtlp.figwinprinting"));
        if (PlatformInfo.isWindows()) {
            MWExclusiveGroup mWExclusiveGroup = new MWExclusiveGroup();
            this.fUseDefaultCheckbox = new MWCheckbox(sRes.getString("gtlp.usedefaults"), sUseDefault, mWExclusiveGroup);
            this.fUseDefaultCheckbox.setName("gtlp.usedefaults");
            this.fUseBlackAndWhiteCheckbox = new MWCheckbox(sRes.getString("gtlp.alwaysbw"), !sUseDefault && sUseBlackAndWhite, mWExclusiveGroup);
            this.fUseBlackAndWhiteCheckbox.setName("gtlp.alwaysbw");
            this.fUseColorCheckbox = new MWCheckbox(sRes.getString("gtlp.alwayscolor"), !sUseDefault && !sUseBlackAndWhite, mWExclusiveGroup);
            this.fUseColorCheckbox.setName("gtlp.alwayscolor");
            mWExclusiveGroup.setSelectedItem((MWExclusiveGroupItem)(sUseDefault ? this.fUseDefaultCheckbox : (sUseBlackAndWhite ? this.fUseBlackAndWhiteCheckbox : this.fUseColorCheckbox)));
            mWGroupbox3.setLayout(vertFlowLayout);
            mWGroupbox3.add((Component)new MWLabel(sRes.getString("gtlp.bworcolor")));
            mWGroupbox3.add((Component)this.fUseDefaultCheckbox);
            mWGroupbox3.add((Component)this.fUseBlackAndWhiteCheckbox);
            mWGroupbox3.add((Component)this.fUseColorCheckbox);
        }
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
        if (PlatformInfo.isWindows()) {
            ((Container)((Object)this)).add((Component)mWGroupbox3);
        }
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new GeneralPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.savePrefs();
        }
    }

    private void savePrefs() {
        Prefs.setBooleanPref((String)"GeneralShowTooltips", (boolean)this.fShowTooltips.getState());
        Prefs.setBooleanPref((String)"GeneralUseToolboxCache", (boolean)this.fUseCache.getState());
        Prefs.setBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)this.fUseCacheDiag.getState());
        if (PlatformInfo.isWindows()) {
            boolean bl = this.fUseDefaultCheckbox.getState();
            boolean bl2 = this.fUseBlackAndWhiteCheckbox.getState();
            Prefs.setBooleanPref((String)"GeneralUseDefaultColors", (boolean)bl);
            Prefs.setBooleanPref((String)"GeneralUseBlackAndWhite", (boolean)bl2);
            if (bl != sUseDefault || bl2 != sUseBlackAndWhite) {
                sUseDefault = bl;
                sUseBlackAndWhite = bl2;
                GeneralPrefsPanel.setPrintColorChoice();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("UpdateCache") && sMatlab != null) {
            sMatlab.evalNoOutput("rehash toolboxcache;");
        }
    }

    static {
        sCacheFile = null;
        sRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");
        sPrefsPanel = null;
        if (PlatformInfo.isWindows()) {
            sUseDefault = Prefs.getBooleanPref((String)"GeneralUseDefaultColors", (boolean)true);
            sUseBlackAndWhite = Prefs.getBooleanPref((String)"GeneralUseBlackAndWhite", (boolean)true);
            sMatlab = new Matlab(new MWLooper("General Prefs Panel"));
            GeneralPrefsPanel.setPrintColorChoice();
        }
    }

    private class CacheCheckboxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            GeneralPrefsPanel.this.fUseCacheDiag.setEnabled(GeneralPrefsPanel.this.fUseCache.getState());
            GeneralPrefsPanel.this.fUpdateCache.setEnabled(GeneralPrefsPanel.this.fUseCache.getState() && GeneralPrefsPanel.isCacheWritable());
        }

        CacheCheckboxListener() {
            GeneralPrefsPanel.this = GeneralPrefsPanel.this;
        }
    }
}

