/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.prefs;

import com.mathworks.beans.editors.FontPicker;
import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.ide.widgets.ColorCombobox;
import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.ide.widgets.SyntaxTextArea;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.services.Prefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.ResourceBundle;

public class GeneralPrefsColorPanel
extends MWPanel {
    private static GeneralPrefsColorPanel sPrefsPanel = null;
    private static String[] sSyntaxCategories;
    private static MWStyle[] sSyntaxStyles;
    private static Font sDesktopFont;
    private ColorCombobox[] fColorComboBox;
    private MWButton fDefaultColorButton;
    private FontPicker fFontPicker = new FontPicker(sDesktopFont, true);
    private static ResourceBundle sRes;

    public GeneralPrefsColorPanel() {
        MWGroupbox mWGroupbox = new MWGroupbox(sRes.getString("gpcp.desktopfont"));
        mWGroupbox.setLayout(new FlowLayout(1, 0, 0));
        mWGroupbox.add((Component)this.fFontPicker);
        Color[] colorArray = new Color[Highlighter.PALETTE.length];
        String[] stringArray = new String[Highlighter.PALETTE.length];
        int n = 0;
        while (n < Highlighter.PALETTE.length) {
            stringArray[n] = GeneralPrefsColorPanel.getTextForCombo(Highlighter.PALETTE[n]);
            colorArray[n] = GeneralPrefsColorPanel.getColorForCombo(Highlighter.PALETTE[n]);
            ++n;
        }
        MWGroupbox mWGroupbox2 = new MWGroupbox(sRes.getString("gpcp.syntaxhighlightingcolors"), 0);
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 8, 8);
        vertFlowLayout.setMaximizeHorizontally(true);
        mWGroupbox2.setLayout(vertFlowLayout);
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new GridLayout(sSyntaxCategories.length - 1, 2));
        this.fColorComboBox = new ColorCombobox[sSyntaxCategories.length];
        int n2 = 0;
        while (n2 < sSyntaxCategories.length) {
            this.fColorComboBox[n2] = new ColorCombobox(GeneralPrefsColorPanel.getTextForCombo(sSyntaxStyles[n2]), GeneralPrefsColorPanel.getColorForCombo(sSyntaxStyles[n2]), stringArray, colorArray);
            this.fColorComboBox[n2].setOpaque(false);
            this.fColorComboBox[n2].setSelectionType(2);
            this.fColorComboBox[n2].setRestrictWidth(true);
            if (n2 > 0) {
                mWPanel.add((Component)new MWLabel(String.valueOf(sSyntaxCategories[n2]) + ":"));
                mWPanel.add((Component)((Object)this.fColorComboBox[n2]));
            }
            ++n2;
        }
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setLayout(new FlowLayout(1, 0, 0));
        this.fDefaultColorButton = new MWButton(" " + sRes.getString("gpcp.restoredefaultcolors") + " ");
        this.fDefaultColorButton.addActionListener((ActionListener)new ButtonListener());
        this.fDefaultColorButton.setActionCommand(sRes.getString("gpcp.defaultcolors"));
        mWPanel2.add((Component)this.fDefaultColorButton, "South");
        mWGroupbox2.add((Component)mWPanel, "North");
        mWGroupbox2.add((Component)mWPanel2, "South");
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new GeneralPrefsColorPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    public static String getTextForCombo(MWStyle mWStyle) {
        if (mWStyle.isAutoColor()) {
            return sRes.getString("gpcp.automatic");
        }
        return "";
    }

    public static Color getColorForCombo(MWStyle mWStyle) {
        if (mWStyle.isAutoColor()) {
            return Decorations.getColor((int)2);
        }
        return mWStyle.getColor();
    }

    public static MWStyle getStyleFromCombobox(ColorCombobox colorCombobox) {
        MWStyle mWStyle = new MWStyle(colorCombobox.getColor());
        if (colorCombobox.getText().equals(sRes.getString("gpcp.automatic"))) {
            mWStyle.setAutoColor(true);
        } else {
            mWStyle.setAutoColor(false);
        }
        return mWStyle;
    }

    private void saveOptions() {
        int n = Array.getLength(this.fColorComboBox);
        MWStyle[] mWStyleArray = new MWStyle[n];
        int n2 = 0;
        while (n2 < n) {
            mWStyleArray[n2] = GeneralPrefsColorPanel.getStyleFromCombobox(this.fColorComboBox[n2]);
            ++n2;
        }
        this.setSyntaxHighlightingStyles(mWStyleArray);
        Font font = this.fFontPicker.getSelectedFont();
        if (!sDesktopFont.equals(font)) {
            sDesktopFont = font;
            Prefs.setFontPref((String)"GeneralFont", (Font)sDesktopFont);
        }
    }

    public static Font getDesktopFont() {
        return sDesktopFont;
    }

    public static MWStyle[] getSyntaxHighlightingStyles() {
        return sSyntaxStyles;
    }

    public static MWStyle getErrorHighlightingStyle() {
        if (sSyntaxCategories.length > 6) {
            return sSyntaxStyles[6];
        }
        return null;
    }

    public static String[] getSyntaxHighlightingCategories() {
        return sSyntaxCategories;
    }

    private void setSyntaxHighlightingStyles(MWStyle[] mWStyleArray) {
        boolean bl = false;
        int n = 0;
        while (n < mWStyleArray.length) {
            if (!sSyntaxStyles[n].equals((Object)mWStyleArray[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            sSyntaxStyles = mWStyleArray;
            int n2 = 0;
            while (n2 < sSyntaxCategories.length) {
                String string = sSyntaxCategories[n2];
                string = string.replace(' ', '_');
                Prefs.setStringPref((String)("Syncolor" + string), (String)GeneralPrefsColorPanel.getColorString(sSyntaxStyles[n2]));
                ++n2;
            }
        }
    }

    public static String getColorString(MWStyle mWStyle) {
        String string = sRes.getString("gpcp.automatic");
        if (!mWStyle.isAutoColor()) {
            Color color = mWStyle.getColor();
            string = new Integer(color.getRGB()).toString();
        }
        return string;
    }

    public static MWStyle getStyleFromString(String string) {
        MWStyle mWStyle = new MWStyle();
        if (string != null) {
            boolean bl = true;
            if (!string.equals(sRes.getString("gpcp.automatic"))) {
                try {
                    Color color = Color.decode(string);
                    mWStyle.setColor(color);
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {}
                mWStyle.setAutoColor(bl);
            }
        }
        return mWStyle;
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");
        sSyntaxCategories = SyntaxTextArea.getHighlightCategories("M-code");
        sSyntaxStyles = SyntaxTextArea.getHighlightStyles("M-code");
        sDesktopFont = Prefs.getFontPref((String)"GeneralFont", (Font)new Font("Monospaced", 0, 12));
        int n = 0;
        while (n < sSyntaxCategories.length) {
            String string = sSyntaxCategories[n];
            string = string.replace(' ', '_');
            GeneralPrefsColorPanel.sSyntaxStyles[n] = GeneralPrefsColorPanel.getStyleFromString(Prefs.getStringPref((String)("Syncolor" + string), (String)GeneralPrefsColorPanel.getColorString(sSyntaxStyles[n])));
            ++n;
        }
    }

    private class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = SyntaxTextArea.getHighlightCategories("M-code");
            MWStyle[] mWStyleArray = SyntaxTextArea.getDefaultHighlightStyles("M-code");
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                GeneralPrefsColorPanel.this.fColorComboBox[n].selectItem(GeneralPrefsColorPanel.getTextForCombo(mWStyleArray[n2]), GeneralPrefsColorPanel.getColorForCombo(mWStyleArray[n2]));
                ((Component)((Object)GeneralPrefsColorPanel.this.fColorComboBox[n++])).repaint();
                ++n2;
            }
        }

        ButtonListener() {
            GeneralPrefsColorPanel.this = GeneralPrefsColorPanel.this;
        }
    }
}

