/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.prefs;

import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSlider;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.services.Prefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class CommandWindowPrefsPanel
extends MWPanel {
    private static final int EIGHTY_COLS = 0;
    private static final int TAB_COMPLETION = 1;
    private static CommandWindowPrefsPanel sPrefsPanel = null;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");
    private MWCheckbox fEchoOnCheckbox;
    private MWCheckbox fEightyColsCheckbox;
    private MWCheckbox fTabCompletionCheckbox;
    private MWChoice fFormatChoice;
    private MWChoice fDisplayChoice;
    private MWTextField fSpacesPerTabField;
    private MWTextField fTabCompletionField;
    private MWSlider fSessionSizeSlider;
    private FormatCallback fFormatAnswer;
    private Matlab fMatlab;

    public CommandWindowPrefsPanel() {
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        MWGroupbox mWGroupbox = new MWGroupbox(sRes.getString("cwpp.textdisplay.groupbox"));
        mWGroupbox.setName("DisplayGroupbox");
        mWGroupbox.setMargins(new Insets(10, 5, 10, 5));
        mWGroupbox.setLayout(new BorderLayout());
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(0));
        MWLabel mWLabel = new MWLabel(sRes.getString("cwpp.numericformat.label"));
        mWLabel.setName("FormatLabel");
        this.fFormatChoice = new MWChoice();
        this.fFormatChoice.setName("FormatChoice");
        this.fFormatChoice.add("short");
        this.fFormatChoice.add("long");
        this.fFormatChoice.add("short e");
        this.fFormatChoice.add("long e");
        this.fFormatChoice.add("short g");
        this.fFormatChoice.add("long g");
        this.fFormatChoice.add("hex");
        this.fFormatChoice.add("bank");
        this.fFormatChoice.add("+");
        this.fFormatChoice.add("rational");
        this.fFormatChoice.select(0);
        mWPanel.add((Component)mWLabel);
        mWPanel.add((Component)this.fFormatChoice);
        mWGroupbox.add((Component)mWPanel, "North");
        mWPanel = new MWPanel((LayoutManager)new FlowLayout(0));
        MWLabel mWLabel2 = new MWLabel(sRes.getString("cwpp.numericdisplay.label"));
        mWLabel2.setName("DisplayLabel");
        this.fDisplayChoice = new MWChoice();
        this.fDisplayChoice.setName("DisplayChoice");
        this.fDisplayChoice.add("compact");
        this.fDisplayChoice.add("loose");
        this.fDisplayChoice.select(0);
        mWPanel.add((Component)mWLabel2);
        mWPanel.add((Component)this.fDisplayChoice);
        mWGroupbox.add((Component)mWPanel, "Center");
        mWPanel = new MWPanel((LayoutManager)new FlowLayout(0));
        mWPanel.add((Component)new MWLabel(sRes.getString("cwpp.spacespertab.label")));
        mWPanel.setName("SpacesLabel");
        this.fSpacesPerTabField = new MWTextField(String.valueOf(Prefs.getIntegerPref((String)"CommandWindowSpacesPerTab", (int)4)), 3);
        this.fSpacesPerTabField.setName("SpacesTextField");
        mWPanel.add((Component)this.fSpacesPerTabField);
        mWGroupbox.add((Component)mWPanel, "South");
        this.fEchoOnCheckbox = new MWCheckbox(sRes.getString("cwpp.echoon.check"));
        this.fEchoOnCheckbox.setName("EchoOnCheck");
        MWGroupbox mWGroupbox2 = new MWGroupbox(sRes.getString("cwpp.display.groupbox"), 0);
        mWGroupbox2.setName("EchoGroupbox");
        mWGroupbox2.setLayout(vertFlowLayout);
        mWGroupbox2.add((Component)this.fEchoOnCheckbox);
        this.fEightyColsCheckbox = new MWCheckbox(sRes.getString("cwpp.eightycols.check"));
        this.fEightyColsCheckbox.setName("EightyColsCheck");
        this.fEightyColsCheckbox.setState(Prefs.getBooleanPref((String)"GeneralEightyColumns", (boolean)true));
        mWGroupbox2.add((Component)this.fEightyColsCheckbox);
        mWPanel = new MWPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.fTabCompletionCheckbox = new MWCheckbox(sRes.getString("cwpp.tabcompletion.check"));
        this.fTabCompletionCheckbox.setName("TabCompletionCheck");
        this.fTabCompletionCheckbox.setState(Prefs.getBooleanPref((String)"CommandWindowTabCompletion", (boolean)true));
        this.fTabCompletionCheckbox.addItemListener((ItemListener)new TabCompletionStateListener());
        this.fTabCompletionField = new MWTextField(String.valueOf(Prefs.getIntegerPref((String)"CommandWindowMaxCompletions", (int)100)), 4);
        this.fTabCompletionField.setName("TabCompletionsTextField");
        this.fTabCompletionField.setEnabled(this.fTabCompletionCheckbox.getState());
        mWPanel.add((Component)this.fTabCompletionCheckbox);
        mWPanel.add((Component)new MWCanvas(4, 0));
        mWPanel.add((Component)this.fTabCompletionField);
        mWPanel.add((Component)new MWCanvas(4, 0));
        mWPanel.add((Component)new MWLabel(sRes.getString("cwpp.tabcompletion.label")));
        mWGroupbox2.add((Component)mWPanel);
        mWPanel = new MWPanel((LayoutManager)new BorderLayout(0, 8));
        mWPanel.add((Component)new MWLabel(sRes.getString("cwpp.scrollbuffer.label")), "North");
        int n = Prefs.getIntegerPref((String)"CommandWindowSessionSize", (int)0);
        this.fSessionSizeSlider = new SessionSizeSlider(0, n, 0, 4);
        this.fSessionSizeSlider.setName("SessionSizeSlider");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(0, 4, 0));
        mWPanel2.add((Component)new MWLabel(sRes.getString("cwpp.min.label")));
        mWPanel2.add((Component)this.fSessionSizeSlider);
        mWPanel2.add((Component)new MWLabel(sRes.getString("cwpp.max.label")));
        mWPanel.add((Component)mWPanel2, "Center");
        mWGroupbox2.add((Component)mWPanel);
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab = new Matlab(new MWLooper("General Prefs Panel"));
            this.fFormatAnswer = new FormatCallback();
            sPrefsPanel = this;
            this.fMatlab.eval("disp(get(0, 'Format'))", (CompletionObserver)this.fFormatAnswer);
            this.fMatlab.eval("disp(get(0, 'FormatSpacing'))", (CompletionObserver)this.fFormatAnswer);
            this.fMatlab.evalStreamOutput("disp(get(0, 'Echo'))", (CompletionObserver)this.fFormatAnswer);
            Object[] objectArray = new Object[]{"EightyColumns"};
            this.fMatlab.feval("feature", objectArray, (CompletionObserver)new DoubleCallback(0));
            Object[] objectArray2 = new Object[]{"TabCompletion"};
            this.fMatlab.feval("system_dependent", objectArray2, (CompletionObserver)new DoubleCallback(1));
        }
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new CommandWindowPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        int n;
        Integer n2;
        String string;
        Prefs.setIntegerPref((String)"CommandWindowSessionSize", (int)this.fSessionSizeSlider.getValue());
        Prefs.setBooleanPref((String)"GeneralEchoOn", (boolean)this.fEchoOnCheckbox.getState());
        if (this.fMatlab != null) {
            string = this.fEchoOnCheckbox.getState() ? "on" : "off";
            this.fMatlab.evalStreamOutput("set(0, 'Echo', '" + string + "')", (CompletionObserver)this.fFormatAnswer);
        }
        string = this.fFormatChoice.getSelectedItem();
        Prefs.setStringPref((String)"GeneralNumFormat", (String)string);
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("set(0, 'Format', '" + string + "')");
        }
        string = this.fDisplayChoice.getSelectedItem();
        Prefs.setStringPref((String)"GeneralNumDisplay", (String)string);
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("set(0, 'FormatSpacing', '" + string + "')");
        }
        string = this.fSpacesPerTabField.getText();
        try {
            n2 = new Integer(string);
            n = n2;
            if (n > 24) {
                n = 24;
            }
            if (n > 0) {
                Prefs.setIntegerPref((String)"CommandWindowSpacesPerTab", (int)n);
            }
        }
        catch (Exception exception) {}
        Prefs.setBooleanPref((String)"GeneralEightyColumns", (boolean)this.fEightyColsCheckbox.getState());
        if (this.fMatlab != null) {
            string = this.fEightyColsCheckbox.getState() ? "1" : "0";
            this.fMatlab.evalNoOutput("feature('EightyColumns', " + string + ");");
        }
        Prefs.setBooleanPref((String)"CommandWindowTabCompletion", (boolean)this.fTabCompletionCheckbox.getState());
        string = this.fTabCompletionField.getText();
        try {
            n2 = new Integer(string);
            n = n2;
            if (n > 9999) {
                n = 9999;
            }
            if (n >= 0) {
                Prefs.setIntegerPref((String)"CommandWindowMaxCompletions", (int)n);
            }
            if (this.fMatlab != null) {
                if (!this.fTabCompletionCheckbox.getState()) {
                    n = 0;
                }
                string = String.valueOf(n);
                this.fMatlab.evalNoOutput("system_dependent('TabCompletion', " + string + ");");
                return;
            }
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ int access$1() {
        return 0;
    }

    static /* synthetic */ int access$3() {
        return 1;
    }

    class FormatCallback
    implements CompletionObserver {
        public void completed(int n, Object object) {
            String string = (String)object;
            if (string == null || string.length() == 0 || sPrefsPanel == null) {
                return;
            }
            if (string.startsWith("on")) {
                sPrefsPanel.fEchoOnCheckbox.setState(true);
                return;
            }
            if (string.startsWith("off")) {
                sPrefsPanel.fEchoOnCheckbox.setState(false);
                return;
            }
            if (string.indexOf("compact") != -1) {
                sPrefsPanel.fDisplayChoice.select(0);
                return;
            }
            if (string.indexOf("loose") != -1) {
                sPrefsPanel.fDisplayChoice.select(1);
                return;
            }
            if (string.indexOf("shortE") != -1) {
                sPrefsPanel.fFormatChoice.select(2);
                return;
            }
            if (string.indexOf("shortG") != -1) {
                sPrefsPanel.fFormatChoice.select(4);
                return;
            }
            if (string.indexOf("short") != -1) {
                sPrefsPanel.fFormatChoice.select(0);
                return;
            }
            if (string.indexOf("longE") != -1) {
                sPrefsPanel.fFormatChoice.select(3);
                return;
            }
            if (string.indexOf("longG") != -1) {
                sPrefsPanel.fFormatChoice.select(5);
                return;
            }
            if (string.indexOf("long") != -1) {
                sPrefsPanel.fFormatChoice.select(1);
                return;
            }
            if (string.indexOf("hex") != -1) {
                sPrefsPanel.fFormatChoice.select(6);
                return;
            }
            if (string.indexOf("bank") != -1) {
                sPrefsPanel.fFormatChoice.select(7);
                return;
            }
            if (string.indexOf("+") != -1) {
                sPrefsPanel.fFormatChoice.select(8);
                return;
            }
            if (string.indexOf("rational") != -1) {
                sPrefsPanel.fFormatChoice.select(9);
            }
        }

        FormatCallback() {
            CommandWindowPrefsPanel.this = CommandWindowPrefsPanel.this;
        }
    }

    class DoubleCallback
    implements CompletionObserver {
        int fCmd;

        public DoubleCallback(int n) {
            CommandWindowPrefsPanel.this = CommandWindowPrefsPanel.this;
            this.fCmd = n;
        }

        public void completed(int n, Object object) {
            double[] dArray = (double[])object;
            if (dArray == null || sPrefsPanel == null) {
                return;
            }
            if (dArray[0] == 0.0) {
                if (this.fCmd == CommandWindowPrefsPanel.access$1()) {
                    sPrefsPanel.fEightyColsCheckbox.setState(false);
                    return;
                }
                if (this.fCmd == CommandWindowPrefsPanel.access$3()) {
                    sPrefsPanel.fTabCompletionCheckbox.setState(false);
                    CommandWindowPrefsPanel.this.fTabCompletionField.setEnabled(false);
                    return;
                }
            } else {
                if (this.fCmd == CommandWindowPrefsPanel.access$1()) {
                    sPrefsPanel.fEightyColsCheckbox.setState(true);
                    return;
                }
                if (this.fCmd == CommandWindowPrefsPanel.access$3()) {
                    sPrefsPanel.fTabCompletionCheckbox.setState(true);
                    CommandWindowPrefsPanel.this.fTabCompletionField.setText(String.valueOf((int)dArray[0]));
                    CommandWindowPrefsPanel.this.fTabCompletionField.setEnabled(true);
                }
            }
        }
    }

    class TabCompletionStateListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            CommandWindowPrefsPanel.this.fTabCompletionField.setEnabled(CommandWindowPrefsPanel.this.fTabCompletionCheckbox.getState());
        }

        TabCompletionStateListener() {
            CommandWindowPrefsPanel.this = CommandWindowPrefsPanel.this;
        }
    }

    private class SessionSizeSlider
    extends MWSlider {
        private final int TICK_HEIGHT = 4;
        private final int TICK_AREA_HEIGHT = 6;
        private boolean fIsPainting;
        private Rectangle fTickArea;

        public SessionSizeSlider(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            CommandWindowPrefsPanel.this = CommandWindowPrefsPanel.this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.setSize(dimension.width, dimension.height + 6);
            return dimension;
        }

        public Dimension getSize() {
            Dimension dimension = super.getSize();
            if (this.fIsPainting) {
                dimension.height -= 6;
            }
            return dimension;
        }

        public void paint(Graphics graphics) {
            this.fIsPainting = true;
            super.paint(graphics);
            this.fIsPainting = false;
            if (this.fTickArea == null) {
                this.fTickArea = new Rectangle();
            }
            Rectangle rectangle = graphics.getClipBounds();
            Dimension dimension = super.getSize();
            this.fTickArea.x = 0;
            this.fTickArea.y = dimension.height - 6;
            this.fTickArea.width = dimension.width;
            this.fTickArea.height = dimension.height;
            if (this.fTickArea.intersects(rectangle)) {
                int n;
                graphics.clearRect(this.fTickArea.x, this.fTickArea.y, this.fTickArea.width, this.fTickArea.height);
                int n2 = this.getMaximum() - this.getMinimum();
                int n3 = this.sliderThumbLength();
                int n4 = n3 / 2;
                graphics.setColor(((Component)((Object)this)).getForeground());
                int n5 = 1;
                while (n5 < n2) {
                    n = n4 + (dimension.width - n3) * n5 / n2 - 1;
                    graphics.drawLine(n, dimension.height - 4, n, dimension.height);
                    ++n5;
                }
                graphics.drawLine(n4, dimension.height - 4, n4, dimension.height);
                n = dimension.width - n4 - 1;
                graphics.drawLine(n, dimension.height - 4, n, dimension.height);
            }
        }

        protected void moveIt(Point point) {
            this.fIsPainting = true;
            super.moveIt(point);
            this.fIsPainting = false;
        }
    }
}

