/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.prefs;

import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.ide.widgets.ColorCombobox;
import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.DesktopFontPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class CmdWinPrefsColorPanel
extends MWPanel
implements ActionListener {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");
    private static CmdWinPrefsColorPanel sPrefsPanel = null;
    private static boolean sUseDesktopFont = Prefs.getBooleanPref((String)"CommandWindowUseDesktopFont", (boolean)true);
    private static Font sFont = Prefs.getFontPref((String)"CommandWindowFont", (Font)GeneralPrefsColorPanel.getDesktopFont());
    private static MWStyle sBackgroundColor = GeneralPrefsColorPanel.getStyleFromString(Prefs.getStringPref((String)"CommandWindowBackgroundColor", (String)GeneralPrefsColorPanel.getColorString(new MWStyle(Color.white))));
    private static MWStyle sTextColor = GeneralPrefsColorPanel.getStyleFromString(Prefs.getStringPref((String)"CommandWindowTextColor", (String)GeneralPrefsColorPanel.getColorString(new MWStyle(true))));
    private static boolean sSyntaxHighlightingEnabled = Prefs.getBooleanPref((String)"CommandWindowSyntaxHighlighting", (boolean)true);
    private DesktopFontPicker fFontEditor;
    private ColorCombobox fBackgroundColorCombobox;
    private ColorCombobox fTextColorCombobox;
    private MWCheckbox fSyntaxHighlightingCheckbox;

    public CmdWinPrefsColorPanel() {
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        this.fFontEditor = new DesktopFontPicker(CmdWinPrefsColorPanel.getUseDesktopFont(), CmdWinPrefsColorPanel.getCmdWinFont());
        MWGroupbox mWGroupbox = new MWGroupbox(sRes.getString("cwpcp.font"));
        mWGroupbox.setLayout(new FlowLayout(0, 0, 0));
        mWGroupbox.add((Component)this.fFontEditor);
        Color[] colorArray = new Color[Highlighter.PALETTE.length];
        String[] stringArray = new String[Highlighter.PALETTE.length];
        int n = 0;
        while (n < Highlighter.PALETTE.length) {
            stringArray[n] = GeneralPrefsColorPanel.getTextForCombo(Highlighter.PALETTE[n]);
            colorArray[n] = GeneralPrefsColorPanel.getColorForCombo(Highlighter.PALETTE[n]);
            ++n;
        }
        MWStyle mWStyle = CmdWinPrefsColorPanel.getTextColor();
        this.fTextColorCombobox = new ColorCombobox(GeneralPrefsColorPanel.getTextForCombo(mWStyle), GeneralPrefsColorPanel.getColorForCombo(mWStyle), stringArray, colorArray);
        this.fTextColorCombobox.setOpaque(false);
        this.fTextColorCombobox.setSelectionType(2);
        this.fTextColorCombobox.setRestrictWidth(true);
        this.fTextColorCombobox.addActionListener(this);
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new GridLayout(1, 2, 5, 5));
        mWPanel.add((Component)new MWLabel(String.valueOf(sRes.getString("cwpcp.textcolor")) + ":"));
        mWPanel.add((Component)((Object)this.fTextColorCombobox));
        MWStyle mWStyle2 = CmdWinPrefsColorPanel.getBackgroundColor();
        this.fBackgroundColorCombobox = new ColorCombobox(GeneralPrefsColorPanel.getTextForCombo(mWStyle2), GeneralPrefsColorPanel.getColorForCombo(mWStyle2), stringArray, colorArray);
        this.fBackgroundColorCombobox.setOpaque(false);
        this.fBackgroundColorCombobox.setSelectionType(2);
        this.fBackgroundColorCombobox.setRestrictWidth(true);
        this.setBackgroundEnabled();
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        mWPanel2.add((Component)new MWLabel(String.valueOf(sRes.getString("cwpcp.backgroundcolor")) + ":"));
        mWPanel2.add((Component)((Object)this.fBackgroundColorCombobox));
        this.fSyntaxHighlightingCheckbox = new MWCheckbox(sRes.getString("cwpcp.syntaxhighlighting"));
        this.fSyntaxHighlightingCheckbox.setState(CmdWinPrefsColorPanel.isSyntaxHighlightingEnabled());
        MWButton mWButton = new MWButton(String.valueOf(sRes.getString("cwpcp.setcolors")) + "...");
        mWButton.addActionListener((ActionListener)new ButtonListener());
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new FlowLayout(1, 15, 0));
        mWPanel3.add((Component)this.fSyntaxHighlightingCheckbox);
        mWPanel3.add((Component)mWButton);
        mWPanel3.setInsets(new Insets(0, 0, 0, 0));
        MWGroupbox mWGroupbox2 = new MWGroupbox(sRes.getString("cwpcp.colors"), 0);
        mWGroupbox2.setLayout(vertFlowLayout);
        mWGroupbox2.setInsets(new Insets(0, 0, 0, 0));
        mWGroupbox2.add((Component)mWPanel);
        mWGroupbox2.add((Component)mWPanel2);
        mWGroupbox2.add((Component)mWPanel3);
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new CmdWinPrefsColorPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        CmdWinPrefsColorPanel.setUseDesktopFont(this.fFontEditor.getUseDesktopFont());
        CmdWinPrefsColorPanel.setCmdWinFont(this.fFontEditor.getSelectedFont());
        CmdWinPrefsColorPanel.setTextColor(GeneralPrefsColorPanel.getStyleFromCombobox(this.fTextColorCombobox));
        CmdWinPrefsColorPanel.setBackgroundColor(GeneralPrefsColorPanel.getStyleFromCombobox(this.fBackgroundColorCombobox));
        CmdWinPrefsColorPanel.setSyntaxHighlightingEnabled(this.fSyntaxHighlightingCheckbox.getState());
    }

    public static Font getCmdWinFont() {
        return sFont;
    }

    public static Font getCommandWindowFont() {
        if (sUseDesktopFont) {
            return GeneralPrefsColorPanel.getDesktopFont();
        }
        return sFont;
    }

    public static void setCmdWinFont(Font font) {
        if (!sFont.equals(font)) {
            sFont = font;
            Prefs.setFontPref((String)"CommandWindowFont", (Font)sFont);
        }
    }

    public static MWStyle getTextColor() {
        return sTextColor;
    }

    public static void setTextColor(MWStyle mWStyle) {
        if (!sTextColor.equals((Object)mWStyle)) {
            sTextColor = mWStyle;
            Prefs.setStringPref((String)"CommandWindowTextColor", (String)GeneralPrefsColorPanel.getColorString(mWStyle));
        }
    }

    public static MWStyle getBackgroundColor() {
        return sBackgroundColor;
    }

    public static void setBackgroundColor(MWStyle mWStyle) {
        if (!sBackgroundColor.equals((Object)mWStyle)) {
            sBackgroundColor = mWStyle;
            Prefs.setStringPref((String)"CommandWindowBackgroundColor", (String)GeneralPrefsColorPanel.getColorString(mWStyle));
        }
    }

    public static boolean getUseDesktopFont() {
        return sUseDesktopFont;
    }

    public static void setUseDesktopFont(boolean bl) {
        if (sUseDesktopFont != bl) {
            sUseDesktopFont = bl;
            Prefs.setBooleanPref((String)"CommandWindowUseDesktopFont", (boolean)sUseDesktopFont);
        }
    }

    public static boolean isSyntaxHighlightingEnabled() {
        return sSyntaxHighlightingEnabled;
    }

    public static void setSyntaxHighlightingEnabled(boolean bl) {
        if (sSyntaxHighlightingEnabled != bl) {
            sSyntaxHighlightingEnabled = bl;
            Prefs.setBooleanPref((String)"CommandWindowSyntaxHighlighting", (boolean)sSyntaxHighlightingEnabled);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setBackgroundEnabled();
    }

    private void setBackgroundEnabled() {
        if (this.fTextColorCombobox.getSelectedIndex() == 0) {
            this.fBackgroundColorCombobox.setEnabled(false);
            return;
        }
        this.fBackgroundColorCombobox.setEnabled(true);
    }

    private class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PrefsDialog.showPrefsDialog(sRes.getString("area.general.fontandcolors"));
        }

        ButtonListener() {
            CmdWinPrefsColorPanel.this = CmdWinPrefsColorPanel.this;
        }
    }
}

