/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.objectbrowser;

import com.mathworks.ide.inspector.Inspector;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.MWTListEvent;
import com.mathworks.mwt.MWTListListener;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import com.mathworks.widgets.BrowserInfo;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectView
extends MWPanel
implements ItemSelectable {
    private static final int UIC_PUSHB = 0;
    private static final int UIC_SLIDER = 1;
    private static final int UIC_RADIOB = 2;
    private static final int UIC_CHECKB = 3;
    private static final int UIC_EDIT = 4;
    private static final int UIC_STATIC = 5;
    private static final int UIC_FRAME = 6;
    private static final int UIC_POPUP = 7;
    private static final int UIC_LISTB = 8;
    private static final int UIC_TOGGLEB = 9;
    private static final int NUM_ICONS = 10;
    private static final String LAYOUT_RES = "/com/mathworks/ide/layout/lowidgets/resources/";
    private static Image[] sUIControlIcons;
    private static Image sUnknownIcon;
    private ObjectRegistry fRegistry;
    private RegistryHandler fRegistryHandler = new RegistryHandler();
    private MWTList fList = new MWTList(true, true);
    private int fUniqueID;
    private Hashtable fObjects;
    private Vector fExpandedNodes;
    private boolean fAutoExpand;
    private transient ItemListener fItemListener;
    private transient int fTransactionCount;

    public ObjectView() {
        this(ObjectRegistry.getRegistry());
    }

    public ObjectView(ObjectRegistry objectRegistry) {
        this.fList.setFont(new Font("SansSerif", 0, 10));
        this.fList.setMultiSelection(true);
        ListHandler listHandler = new ListHandler();
        this.fList.addMWTListListener((MWTListListener)listHandler);
        this.fList.addItemListener((ItemListener)listHandler);
        this.setOpaque(false);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.fList, "Center");
        this.fTransactionCount = 0;
        this.fUniqueID = 0;
        this.fObjects = new Hashtable();
        this.fExpandedNodes = new Vector();
        this.fAutoExpand = false;
        this.setRegistry(objectRegistry);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fList.setFont(font);
        ((Component)((Object)this)).repaint();
    }

    public void setRegistry(ObjectRegistry objectRegistry) {
        if (this.fRegistry != null) {
            this.fRegistry.removeItemListener((ItemListener)this.fRegistryHandler);
            this.fRegistry.removeObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
        }
        if (objectRegistry != null) {
            objectRegistry.addItemListener((ItemListener)this.fRegistryHandler);
            objectRegistry.addObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
        }
        this.fRegistry = objectRegistry;
        this.populate();
    }

    public boolean getAutoExpand() {
        return this.fAutoExpand;
    }

    public void setAutoExpand(boolean bl) {
        this.fAutoExpand = bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(((Container)((Object)Inspector.getInspector())).getPreferredSize().width, 12 * this.fList.getCellHeight());
    }

    public void select(Object object) {
        this.fList.unselectAll();
        this.fList.selectItem(this.findCell(object));
        if (this.fItemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, null, 1);
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    public Object[] getSelectedObjects() {
        int n = this.fList.getSelectedObjects().length;
        int n2 = 0;
        Object[] objectArray = new Object[n];
        int n3 = this.fList.getFirstSelectedItem();
        while (n3 != -1) {
            objectArray[n2++] = this.fObjects.get(new Integer(n3));
            n3 = this.fList.getNextSelectedItem(n3);
        }
        return objectArray;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.fList.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fList.removeActionListener(actionListener);
    }

    public void requestFocus() {
        this.fList.requestFocus();
    }

    private boolean expandToHere(Object object) {
        boolean bl = false;
        if (object != null && this.fRegistry != null) {
            Object object2 = this.fRegistry.getParent(object);
            bl = this.expandToHere(object2);
            int n = this.findCell(object);
            if (n != -1 && !this.fList.isItemTwisted(n)) {
                if (!this.fExpandedNodes.contains(object)) {
                    this.fExpandedNodes.addElement(object);
                }
                this.fList.setItemTwisted(n, true);
                this.expand(n);
                bl = true;
            }
        }
        return bl;
    }

    private void expand(int n) {
        if (this.fRegistry != null) {
            Object v = this.fObjects.get(new Integer(n));
            Vector vector = this.fRegistry.getChildren(v);
            int n2 = 0;
            while (n2 < vector.size()) {
                this.addCell(vector.elementAt(n2), n);
                ++n2;
            }
        }
    }

    private void collapse(int n) {
        int[] nArray = this.fList.getDescendants(n);
        if (nArray != null && nArray.length > 0) {
            int n2 = 0;
            while (n2 < nArray.length) {
                this.fObjects.remove(new Integer(nArray[n2]));
                ++n2;
            }
        }
        this.fList.removeDescendants(n);
    }

    private int findCell(Object object) {
        Enumeration enumeration = this.fObjects.keys();
        int n = -1;
        while (enumeration.hasMoreElements() && n == -1) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (this.fObjects.get(n2) != object) continue;
            n = n2;
        }
        return n;
    }

    private void removeCell(Object object) {
        this.removeCell(this.findCell(object));
    }

    private void removeCell(int n) {
        if (this.fRegistry != null) {
            boolean bl;
            Object v = this.fObjects.get(new Integer(n));
            Object object = this.fRegistry.getParent(v);
            int n2 = object != null ? this.findCell(object) : -1;
            int[] nArray = this.fList.getDescendants(n);
            boolean bl2 = bl = PlatformInfo.getAppearance() == 0;
            if (nArray != null && nArray.length > 0) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    this.fObjects.remove(new Integer(nArray[n3]));
                    ++n3;
                }
                this.fList.removeDescendants(n);
            }
            this.fObjects.remove(new Integer(n));
            this.fList.remove(n);
            if (object != null && n2 != -1 && !bl && this.fList.isItemKiddable(n2) && this.fRegistry.getChildren(object).size() == 0) {
                this.fList.setItemKiddable(n2, false);
            }
        }
    }

    private void insertCell(Object object, int n, int n2) {
        if (this.fRegistry != null) {
            boolean bl = this.fRegistry.isParental(object);
            boolean bl2 = this.fRegistry.isSelected(object);
            boolean bl3 = this.fRegistry.getChildren(object).size() > 0;
            boolean bl4 = object != null && this.fExpandedNodes.contains(object);
            Object object2 = this.fRegistry.getParent(object);
            int n3 = object2 != null ? this.findCell(object2) : -1;
            boolean bl5 = PlatformInfo.getAppearance() == 0;
            boolean bl6 = bl5 ? bl : bl & bl3;
            this.fList.insert(n, n2, this.fUniqueID, this.getLabel(object), this.getIcon(object), bl6);
            this.fObjects.put(new Integer(this.fUniqueID), object);
            ++this.fUniqueID;
            if (bl2) {
                this.fList.selectItem(this.fUniqueID - 1);
            } else {
                this.fList.unselectItem(this.fUniqueID - 1);
            }
            if (bl4) {
                this.fList.setItemTwisted(this.fUniqueID - 1, true);
                this.expand(this.fUniqueID - 1);
            }
            if (!bl5 && n3 != -1 && !this.fList.isItemKiddable(n3)) {
                this.fList.setItemKiddable(n3, true);
            }
        }
    }

    private void addCell(Object object, int n) {
        if (this.fRegistry != null) {
            boolean bl;
            boolean bl2 = this.fRegistry.isParental(object);
            boolean bl3 = this.fRegistry.isSelected(object);
            boolean bl4 = this.fRegistry.getChildren(object).size() > 0;
            boolean bl5 = object != null && this.fExpandedNodes.contains(object);
            Object object2 = this.fRegistry.getParent(object);
            int n2 = object2 != null ? this.findCell(object2) : -1;
            boolean bl6 = bl = PlatformInfo.getAppearance() == 0;
            boolean bl7 = bl ? bl2 : bl2 && bl4;
            this.fList.add(n, this.fUniqueID, this.getLabel(object), this.getIcon(object), bl7);
            this.fObjects.put(new Integer(this.fUniqueID), object);
            ++this.fUniqueID;
            if (bl3) {
                this.fList.selectItem(this.fUniqueID - 1);
            } else {
                this.fList.unselectItem(this.fUniqueID - 1);
            }
            if (bl5) {
                this.fList.setItemTwisted(this.fUniqueID - 1, true);
                this.expand(this.fUniqueID - 1);
            }
            if (!bl && n2 != -1 && !this.fList.isItemKiddable(n2)) {
                this.fList.setItemKiddable(n2, true);
            }
        }
    }

    private void populate() {
        boolean bl = ((Component)((Object)this)).isVisible();
        if (bl) {
            ((Component)((Object)this)).setVisible(false);
        }
        this.fList.removeAll();
        this.fObjects.clear();
        this.fExpandedNodes.removeAllElements();
        this.fUniqueID = 0;
        if (this.fRegistry != null) {
            Vector vector = this.fRegistry.getTopLevelObjects();
            int n = 0;
            while (n < vector.size()) {
                this.addCell(vector.elementAt(n), -1);
                ++n;
            }
        }
        if (bl) {
            ((Component)((Object)this)).setVisible(true);
        }
    }

    private String getLabel(Object object) {
        String string = "";
        if (object instanceof BrowserInfo) {
            BrowserInfo browserInfo = (BrowserInfo)object;
            string = browserInfo.getBrowserLabel();
        } else if (object instanceof Component) {
            Component component = (Component)object;
            string = component.getName();
        }
        if (string == null || string.equals("")) {
            string = this.getBeanName(object);
        }
        return string;
    }

    private String getBeanName(Object object) {
        BeanInfo beanInfo = null;
        String string = "";
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {}
        if (beanInfo != null) {
            string = beanInfo.getBeanDescriptor().getDisplayName();
        } else {
            string = object.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        String string2 = null;
        if (object instanceof Component) {
            string2 = ((Component)object).getName();
        } else if (object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            if (string.equals("uicontrol")) {
                String[] stringArray = (String[])uDDObject.getPropertyValue("String");
                if (stringArray != null && stringArray.length > 0) {
                    string2 = stringArray[0];
                }
                if (string2 == null || string2.length() == 0) {
                    string2 = (String)uDDObject.getPropertyValue("Tag");
                }
            } else if (string.equals("uimenu")) {
                string2 = (String)uDDObject.getPropertyValue("Label");
            } else if (string.equals("uicontextmenu")) {
                string2 = (String)uDDObject.getPropertyValue("Tag");
            } else if (string.equals("axes")) {
                string2 = (String)uDDObject.getPropertyValue("Tag");
            } else if (string.equals("figure")) {
                string2 = (String)uDDObject.getPropertyValue("Name");
            }
        }
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + " (" + string2 + ")";
        }
        return string;
    }

    private Image getIcon(Object object) {
        UDDObject uDDObject;
        if (sUnknownIcon == null) {
            this.initIcons();
        }
        BeanInfo beanInfo = null;
        Image image = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {}
        if (beanInfo != null) {
            if (object instanceof UDDObject) {
                uDDObject = (UDDObject)object;
                String string = beanInfo.getBeanDescriptor().getDisplayName();
                if (string.equals("uicontrol")) {
                    int n = (Integer)uDDObject.getPropertyValue("Style");
                    image = sUIControlIcons[n];
                }
            }
            if (image == null) {
                image = beanInfo.getIcon(1);
            }
        }
        if (image == null) {
            image = sUnknownIcon;
        }
        uDDObject = new ResLoader((Component)((Object)this));
        uDDObject.addImage(image);
        uDDObject.waitForPendingImages();
        return image;
    }

    private void initIcons() {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        sUnknownIcon = resLoader.loadImage("/com/mathworks/ide/resources/unknownicon.gif");
        sUIControlIcons = new Image[10];
        ObjectView.sUIControlIcons[0] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/buttonicon.gif");
        ObjectView.sUIControlIcons[1] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/scrollbaricon.gif");
        ObjectView.sUIControlIcons[2] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/radiobuttonicon.gif");
        ObjectView.sUIControlIcons[3] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/checkboxicon.gif");
        ObjectView.sUIControlIcons[4] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/edittexticon.gif");
        ObjectView.sUIControlIcons[5] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/texticon.gif");
        ObjectView.sUIControlIcons[6] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/panelicon.gif");
        ObjectView.sUIControlIcons[7] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/popupmenuicon.gif");
        ObjectView.sUIControlIcons[8] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/listboxicon.gif");
        ObjectView.sUIControlIcons[9] = resLoader.loadImage("/com/mathworks/ide/layout/lowidgets/resources/togglebuttonicon.gif");
        resLoader.waitForPendingImages();
    }

    private class ListHandler
    implements MWTListListener,
    ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            itemEvent.getItemSelectable();
            int[] nArray = ObjectView.this.fList.getSelectedIds();
            Object[] objectArray = new Object[nArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = ObjectView.this.fObjects.get(new Integer(nArray[n]));
                ++n;
            }
            if (ObjectView.this.fRegistry != null) {
                ObjectView.this.fRegistry.setSelected(objectArray, true, true);
            }
        }

        public void expandItem(MWTListEvent mWTListEvent) {
            int n = mWTListEvent.getItemId();
            Object v = ObjectView.this.fObjects.get(new Integer(n));
            boolean bl = ((Component)((Object)ObjectView.this)).isVisible();
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(false);
            }
            if (v != null && !ObjectView.this.fExpandedNodes.contains(v)) {
                ObjectView.this.fExpandedNodes.addElement(v);
            }
            ObjectView.this.expand(n);
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(true);
            }
        }

        public void collapseItem(MWTListEvent mWTListEvent) {
            int n = mWTListEvent.getItemId();
            Object v = ObjectView.this.fObjects.get(new Integer(n));
            boolean bl = ((Component)((Object)ObjectView.this)).isVisible();
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(false);
            }
            if (v != null && ObjectView.this.fExpandedNodes.contains(v)) {
                ObjectView.this.fExpandedNodes.removeElement(v);
            }
            ObjectView.this.collapse(n);
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(true);
            }
        }

        public void scrollList(MWTListEvent mWTListEvent) {
        }

        ListHandler() {
            ObjectView.this = ObjectView.this;
        }
    }

    private class RegistryHandler
    implements ItemListener,
    ObjectRegistryListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object[] objectArray = (Object[])itemEvent.getItem();
            boolean bl = itemEvent.getStateChange() == 1;
            boolean bl2 = ((Component)((Object)ObjectView.this)).isVisible();
            if (bl2) {
                ((Component)((Object)ObjectView.this)).setVisible(false);
            }
            int n = 0;
            while (n < objectArray.length) {
                int n2 = ObjectView.this.findCell(objectArray[n]);
                if (n2 != -1 && ObjectView.this.fList.isSelected(n2) != bl) {
                    if (bl) {
                        ObjectView.this.fList.selectItem(n2);
                    } else {
                        ObjectView.this.fList.unselectItem(n2);
                    }
                }
                ++n;
            }
            if (bl2) {
                ((Component)((Object)ObjectView.this)).setVisible(true);
            }
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
            Object[] objectArray = objectRegistryEvent.getObjects();
            Object object = objectRegistryEvent.getParent();
            int n = ObjectView.this.findCell(object);
            int n2 = objectRegistryEvent.getPosition();
            boolean bl = ((Component)((Object)ObjectView.this)).isVisible();
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(false);
            }
            if (n != -1) {
                if (!ObjectView.this.fList.isItemKiddable(n)) {
                    ObjectView.this.fList.setItemKiddable(n, true);
                }
                if (ObjectView.this.fAutoExpand && !ObjectView.this.fList.isItemTwisted(n)) {
                    if (!ObjectView.this.fExpandedNodes.contains(object)) {
                        ObjectView.this.fExpandedNodes.addElement(object);
                    }
                    ObjectView.this.fList.setItemTwisted(n, true);
                    ObjectView.this.expand(n);
                } else if (!ObjectView.this.fAutoExpand && ObjectView.this.fExpandedNodes.contains(object)) {
                    ObjectView.this.fList.setItemTwisted(n, true);
                    ObjectView.this.expand(n);
                } else if (ObjectView.this.fList.isItemTwisted(n)) {
                    if (n2 != -1) {
                        int n3 = 0;
                        while (n3 < objectArray.length) {
                            ObjectView.this.insertCell(objectArray[n3], n, n2 + n3);
                            ++n3;
                        }
                    } else {
                        int n4 = 0;
                        while (n4 < objectArray.length) {
                            ObjectView.this.addCell(objectArray[n4], n);
                            ++n4;
                        }
                    }
                }
            } else if (object == null) {
                int n5 = 0;
                while (n5 < objectArray.length) {
                    ObjectView.this.addCell(objectArray[n5], -1);
                    ++n5;
                }
            } else if (ObjectView.this.fAutoExpand) {
                ObjectView.this.expandToHere(object);
            }
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(true);
            }
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
            boolean bl;
            Object[] objectArray = objectRegistryEvent.getObjects();
            Object[] objectArray2 = objectRegistryEvent.getOldParents();
            boolean bl2 = ((Component)((Object)ObjectView.this)).isVisible();
            boolean bl3 = bl = PlatformInfo.getAppearance() == 0;
            if (bl2) {
                ((Component)((Object)ObjectView.this)).setVisible(false);
            }
            int n = 0;
            while (n < objectArray.length) {
                ObjectView.this.removeCell(objectArray[n]);
                ++n;
            }
            if (!bl) {
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    int n3;
                    if (objectRegistryEvent.getObjectRegistry().getChildren(objectArray2[n2]).size() == 0 && (n3 = ObjectView.this.findCell(objectArray2[n2])) != -1 && ObjectView.this.fList.isItemKiddable(n3)) {
                        ObjectView.this.fList.setItemKiddable(n3, false);
                    }
                    ++n2;
                }
            }
            if (bl2) {
                ((Component)((Object)ObjectView.this)).setVisible(true);
            }
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            Object[] objectArray = objectRegistryEvent.getObjects();
            boolean bl = false;
            int n = 0;
            while (n < objectArray.length) {
                int n2 = ObjectView.this.findCell(objectArray[n]);
                if (n2 != -1) {
                    ObjectView.this.fList.setItemString(n2, ObjectView.this.getLabel(objectArray[n]));
                    ObjectView.this.fList.setItemIcon(n2, ObjectView.this.getIcon(objectArray[n]));
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                ObjectView.this.fList.repaint(5L);
            }
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
            int n;
            Object[] objectArray = objectRegistryEvent.getObjects();
            Object[] objectArray2 = objectRegistryEvent.getOldParents();
            int n2 = ObjectView.this.findCell(objectRegistryEvent.getParent());
            ObjectView.this.fList.getChildren(n2);
            int n3 = objectRegistryEvent.getPosition();
            boolean[] blArray = new boolean[objectArray.length];
            boolean bl = ((Component)((Object)ObjectView.this)).isVisible();
            boolean bl2 = PlatformInfo.getAppearance() == 0;
            boolean bl3 = true;
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(false);
            }
            int n4 = 0;
            while (n4 < objectArray.length) {
                blArray[n4] = objectRegistryEvent.getObjectRegistry().isSelected(objectArray[n4]);
                ObjectView.this.removeCell(objectArray[n4]);
                ++n4;
            }
            if (ObjectView.this.fAutoExpand) {
                boolean bl4 = bl3 = !ObjectView.this.expandToHere(objectRegistryEvent.getParent());
            }
            if (bl3 && (n2 == -1 || ObjectView.this.fList.isItemTwisted(n2))) {
                n = 0;
                while (n < objectArray.length) {
                    if (n3 != -1) {
                        ObjectView.this.insertCell(objectArray[n], n2, n3 + n);
                    } else {
                        ObjectView.this.addCell(objectArray[n], n2);
                    }
                    ++n;
                }
            }
            n = 0;
            while (n < objectArray.length) {
                Object[] objectArray3 = new Object[]{objectArray[n]};
                objectRegistryEvent.getObjectRegistry().setSelected(objectArray3, blArray[n], false);
                ++n;
            }
            if (!bl2) {
                int n5 = 0;
                while (n5 < objectArray2.length) {
                    int n6;
                    if (objectRegistryEvent.getObjectRegistry().getChildren(objectArray2[n5]).size() == 0 && (n6 = ObjectView.this.findCell(objectArray2[n5])) != -1 && ObjectView.this.fList.isItemKiddable(n6)) {
                        ObjectView.this.fList.setItemKiddable(n6, false);
                    }
                    ++n5;
                }
            }
            if (bl) {
                ((Component)((Object)ObjectView.this)).setVisible(true);
            }
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
            ObjectView objectView = ObjectView.this;
            objectView.fTransactionCount = objectView.fTransactionCount + 1;
            if (((Component)((Object)ObjectView.this)).isVisible()) {
                ((Component)((Object)ObjectView.this)).setVisible(false);
            }
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
            ObjectView objectView = ObjectView.this;
            objectView.fTransactionCount = objectView.fTransactionCount - 1;
            if (ObjectView.this.fTransactionCount < 0) {
                ObjectView.this.fTransactionCount = 0;
            }
            if (ObjectView.this.fTransactionCount == 0) {
                ((Component)((Object)ObjectView.this)).setVisible(true);
            }
        }

        RegistryHandler() {
            ObjectView.this = ObjectView.this;
        }
    }
}

