/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.objectbrowser;

import com.mathworks.ide.arrayeditor.ArrayEditor;
import com.mathworks.ide.browsers.FileBrowser;
import com.mathworks.ide.browsers.PathBrowser;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.editorobject.EditorEntry;
import com.mathworks.ide.inspector.Inspector;
import com.mathworks.ide.objectbrowser.ObjectView;
import com.mathworks.ide.objectbrowser.pathobject.PathDirectory;
import com.mathworks.ide.objectbrowser.pathobject.PathObject;
import com.mathworks.ide.objectbrowser.workspaceobject.CellMatrix;
import com.mathworks.ide.objectbrowser.workspaceobject.CharMatrix;
import com.mathworks.ide.objectbrowser.workspaceobject.FullMatrix;
import com.mathworks.ide.objectbrowser.workspaceobject.ObjectMatrix;
import com.mathworks.ide.objectbrowser.workspaceobject.SparseMatrix;
import com.mathworks.ide.objectbrowser.workspaceobject.StructMatrix;
import com.mathworks.ide.objectbrowser.workspaceobject.WorkspaceObject;
import com.mathworks.ide.workspace.WorkspaceBrowser;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.ResLoader;
import com.mathworks.widgets.BrowserInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

public class ObjectBrowser
extends MWPanel
implements MWWindowOwner {
    private static ResourceBundle fObjBrowsBundle = ResourceBundle.getBundle("com.mathworks.ide.objectbrowser.resources.RES_ObjBrows");
    private static Image sBrowserIcon = null;
    private static MWFrame sBrowserWin = null;
    private static ObjectBrowser sBrowser = null;
    private static Rectangle sWindowBounds = null;
    private ObjectView fObjView;
    private MWFrame fFrame;

    public ObjectBrowser(MWFrame mWFrame, ObjectRegistry objectRegistry) {
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(2));
        mWPanel.setOpaque(true);
        this.fFrame = mWFrame;
        this.setOpaque(false);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fObjView = new ObjectView(objectRegistry);
        this.fObjView.addActionListener(new ObjectViewHandler());
        this.fObjView.setFont(Prefs.getFontPref((String)"GeneralFont", (Font)new Font("Dialog", 0, 10)));
        ((Container)((Object)this)).add("Center", (Component)((Object)this.fObjView));
        Prefs.addListener((PrefListener)new FontChangeListener(), (String)"GeneralFont");
        if (this.fFrame != null) {
            WindowRegistry.getRegistry().register((MWWindowOwner)this);
        }
    }

    public ObjectBrowser() {
        this(null, ObjectRegistry.getRegistry());
    }

    public boolean getAutoExpand() {
        return this.fObjView.getAutoExpand();
    }

    public void setAutoExpand(boolean bl) {
        this.fObjView.setAutoExpand(bl);
    }

    public void select(Object object) {
        this.fObjView.select(object);
    }

    public String getWindowTitle() {
        return fObjBrowsBundle.getString("title.object_browser");
    }

    public int closeWindow() {
        if (this.fFrame != null) {
            WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
            if (this.fFrame == sBrowserWin) {
                sWindowBounds = sBrowserWin.getBounds();
                sBrowserWin = null;
            }
            if (this == sBrowser) {
                sBrowser = null;
            }
            this.fFrame.dispose();
        }
        this.fObjView.setRegistry(null);
        return 0;
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.fObjView.requestFocus();
        }
    }

    public String getShortName() {
        return this.getWindowTitle();
    }

    public String getLongName() {
        return this.getWindowTitle();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fObjView.setFont(font);
        ((Component)((Object)this)).repaint();
    }

    private static void createObjectBrowser() {
        if (sBrowser == null || sBrowserWin == null) {
            Object object;
            sBrowserWin = new MWFrame();
            sBrowser = new ObjectBrowser(sBrowserWin, ObjectRegistry.getLayoutRegistry());
            sBrowser.setAutoExpand(true);
            sBrowserWin.setTitle(sBrowser.getWindowTitle());
            if (sBrowserIcon == null) {
                object = new ResLoader((Component)((Object)sBrowser));
                sBrowserIcon = object.loadImage("resources/objectbrowsericon.gif");
                object.waitForPendingImages();
            }
            sBrowserWin.setIconImage(sBrowserIcon);
            object = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension = ((Container)((Object)sBrowser)).getPreferredSize();
            Dimension dimension2 = ((Container)((Object)Inspector.getInspector())).getPreferredSize();
            sBrowserWin.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)sBrowser)));
            sBrowserWin.add("Center", (Component)((Object)sBrowser));
            if (sWindowBounds == null) {
                sBrowserWin.setLocation(object.width - dimension.width - 10, 50 + dimension2.height);
                sBrowserWin.setContentSize(new Dimension(dimension.width, dimension.height));
                return;
            }
            sBrowserWin.setBounds(sWindowBounds);
        }
    }

    public static ObjectBrowser getObjectBrowser() {
        ObjectBrowser.createObjectBrowser();
        return sBrowser;
    }

    public static void activateObjectBrowser() {
        if (sBrowserWin == null || sBrowser == null) {
            ObjectBrowser.createObjectBrowser();
        }
        if (!sBrowserWin.isVisible()) {
            sBrowserWin.setVisible(true);
        }
        sBrowserWin.toFront();
    }

    public static void main(String[] stringArray) {
        try {
            ObjectBrowser.activateObjectBrowser();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private class ObjectViewHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ObjectBrowser.this.fObjView.getSelectedObjects();
            boolean bl = false;
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                if (objectArray[n] instanceof CellMatrix || objectArray[n] instanceof CharMatrix || objectArray[n] instanceof FullMatrix || objectArray[n] instanceof ObjectMatrix || objectArray[n] instanceof SparseMatrix || objectArray[n] instanceof StructMatrix) {
                    object = (BrowserInfo)objectArray[n];
                    ArrayEditor.invoke(object.getBrowserLabel());
                } else if (objectArray[n] instanceof WorkspaceObject) {
                    WorkspaceBrowser.getWorkspaceBrowser();
                } else if (objectArray[n] instanceof PathObject) {
                    PathBrowser.getPathBrowser();
                } else if (objectArray[n] instanceof EditorEntry) {
                    EditorApplication.openDocument(((EditorEntry)objectArray[n]).getFullName());
                } else if (objectArray[n] instanceof PathDirectory) {
                    object = MLDesktop.getMLDesktop();
                    if (object != null) {
                        ((Desktop)object).showClient("Current Directory");
                    }
                    FileBrowser.invoke(((BrowserInfo)objectArray[n]).getBrowserLabel());
                } else {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                Inspector.activateInspector();
            }
        }

        ObjectViewHandler() {
            ObjectBrowser.this = ObjectBrowser.this;
        }
    }

    private class FontChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                ObjectBrowser.this.setFont(Prefs.getFontPref((String)"GeneralFont"));
            }
        }

        FontChangeListener() {
            ObjectBrowser.this = ObjectBrowser.this;
        }
    }
}

