/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout.menueditor;

import com.mathworks.ide.layout.menueditor.MenuEditor;
import com.mathworks.ide.layout.menueditor.MenuEditorUtils;
import com.mathworks.ide.layout.menueditor.MenuNode;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class MenuPropertyPanel
extends MWGroupbox {
    private static final boolean SHOW_CALLBACK = true;
    private MWTextField fLabelField;
    private MWTextField fTagField;
    private MWTextField fCallbackField;
    private MWCheckbox fSeparatorCBox;
    private MWCheckbox fCheckedCBox;
    private MenuEditor fEditor;
    private MenuNode fNode;
    private EditHandler fHandler;

    MenuPropertyPanel(MenuEditor menuEditor, int n) {
        this.fEditor = menuEditor;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        switch (n) {
            case 1: {
                ((Component)((Object)this)).setName("menuPropertyPanel");
                this.setLabel(MenuEditorUtils.getResource("groupbox.UIMenu"));
                this.fHandler = new EditHandler();
                MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout(0, 8));
                mWPanel.add((Component)this.stringsPanel(n), "North");
                mWPanel.add((Component)this.checkboxPanel(), "Center");
                mWPanel.add((Component)this.callbackPanel(), "South");
                ((Container)((Object)this)).add((Component)mWPanel, "North");
                return;
            }
            case 2: {
                ((Component)((Object)this)).setName("contextMenuPropertyPanel");
                this.setLabel(MenuEditorUtils.getResource("groupbox.UIContextMenu"));
                this.fHandler = new EditHandler();
                MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout(0, 8));
                mWPanel.add((Component)this.stringsPanel(n));
                mWPanel.add((Component)this.callbackPanel(), "South");
                ((Container)((Object)this)).add((Component)mWPanel, "North");
                return;
            }
        }
        ((Component)((Object)this)).setName("nonePropertyPanel");
        this.setLabel(MenuEditorUtils.getResource("groupbox.NoSelection"));
        MWLabel mWLabel = new MWLabel(MenuEditorUtils.getResource("label.NoSelection"));
        ((Container)((Object)this)).add((Component)mWLabel, "North");
    }

    protected void synchToNode(MenuNode menuNode) {
        this.fNode = menuNode;
        if (this.fLabelField != null) {
            this.fLabelField.setText(menuNode.getLabel());
            this.fLabelField.getView().setHScrollAmount(0);
        }
        if (this.fTagField != null) {
            this.fTagField.setText(menuNode.getTag());
            this.fTagField.getView().setHScrollAmount(0);
        }
        if (this.fSeparatorCBox != null) {
            this.fSeparatorCBox.setState(menuNode.getSeparator());
        }
        if (this.fCheckedCBox != null) {
            this.fCheckedCBox.setState(menuNode.getChecked());
        }
        if (this.fCallbackField != null) {
            this.fCallbackField.setText(menuNode.getCallback());
            this.fCallbackField.getView().setHScrollAmount(0);
        }
    }

    private MWPanel stringsPanel(int n) {
        MWLabel mWLabel;
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout(4, 0));
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(0, 1, 0, 8));
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new GridLayout(0, 1, 0, 8));
        if (n == 1) {
            mWLabel = new MWLabel(MenuEditorUtils.getResource("label.menuLabel"));
            this.fLabelField = new MWTextField();
            this.fLabelField.setName("fieldLabel");
            this.fLabelField.addActionListener((ActionListener)this.fHandler);
            this.fLabelField.addFocusListener((FocusListener)this.fHandler);
            mWPanel2.add((Component)mWLabel);
            mWPanel3.add((Component)this.fLabelField);
        }
        mWLabel = new MWLabel(MenuEditorUtils.getResource("label.menuTag"));
        this.fTagField = new MWTextField();
        this.fTagField.setName("fieldTag");
        this.fTagField.addActionListener((ActionListener)this.fHandler);
        this.fTagField.addFocusListener((FocusListener)this.fHandler);
        mWPanel2.add((Component)mWLabel);
        mWPanel3.add((Component)this.fTagField);
        mWPanel.add((Component)mWPanel2, "West");
        mWPanel.add((Component)mWPanel3, "Center");
        return mWPanel;
    }

    private MWPanel checkboxPanel() {
        MWPanel mWPanel = new MWPanel((LayoutManager)new GridLayout(2, 1, 0, 8));
        this.fSeparatorCBox = new MWCheckbox(MenuEditorUtils.getResource("checkbox.Separator"));
        this.fSeparatorCBox.setName("checkboxSeparator");
        this.fSeparatorCBox.addItemListener((ItemListener)this.fHandler);
        this.fCheckedCBox = new MWCheckbox(MenuEditorUtils.getResource("checkbox.Checked"));
        this.fCheckedCBox.setName("checkboxChecked");
        this.fCheckedCBox.addItemListener((ItemListener)this.fHandler);
        mWPanel.add((Component)this.fSeparatorCBox);
        mWPanel.add((Component)this.fCheckedCBox);
        return mWPanel;
    }

    private MWPanel callbackPanel() {
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout(0, 4));
        MWLabel mWLabel = new MWLabel(MenuEditorUtils.getResource("label.menuCallback"));
        this.fCallbackField = new MWTextField();
        this.fCallbackField.setName("fieldCallback");
        this.fCallbackField.addActionListener((ActionListener)this.fHandler);
        this.fCallbackField.addFocusListener((FocusListener)this.fHandler);
        mWPanel.add((Component)mWLabel, "North");
        mWPanel.add((Component)this.fCallbackField, "Center");
        return mWPanel;
    }

    private class EditHandler
    extends FocusAdapter
    implements ActionListener,
    ItemListener {
        public void focusLost(FocusEvent focusEvent) {
            this.commitText(focusEvent.getSource());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.commitText(actionEvent.getSource());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (MenuPropertyPanel.this.fNode != null) {
                if (itemEvent.getSource() == MenuPropertyPanel.this.fSeparatorCBox) {
                    MenuPropertyPanel.this.fNode.setSeparator(MenuPropertyPanel.this.fSeparatorCBox.getState());
                    return;
                }
                if (itemEvent.getSource() == MenuPropertyPanel.this.fCheckedCBox) {
                    MenuPropertyPanel.this.fNode.setChecked(MenuPropertyPanel.this.fCheckedCBox.getState());
                }
            }
        }

        private void commitText(Object object) {
            if (MenuPropertyPanel.this.fNode != null) {
                if (object == MenuPropertyPanel.this.fLabelField) {
                    MenuPropertyPanel.this.fNode.setLabel(MenuPropertyPanel.this.fLabelField.getText());
                    if (MenuPropertyPanel.this.fNode.getType() == 1) {
                        MenuPropertyPanel.this.fEditor.updateControls(1);
                        return;
                    }
                } else if (object == MenuPropertyPanel.this.fTagField) {
                    MenuPropertyPanel.this.fNode.setTag(MenuPropertyPanel.this.fTagField.getText());
                    if (MenuPropertyPanel.this.fNode.getType() == 2) {
                        MenuPropertyPanel.this.fEditor.updateControls(1);
                        return;
                    }
                } else if (object == MenuPropertyPanel.this.fCallbackField) {
                    MenuPropertyPanel.this.fNode.setCallback(MenuPropertyPanel.this.fCallbackField.getText());
                }
            }
        }

        EditHandler() {
            MenuPropertyPanel.this = MenuPropertyPanel.this;
        }
    }
}

