/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout.menueditor;

import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwt.command.MWCommandTarget;
import java.util.Vector;

public class MenuNode {
    public static final int ROOT = 0;
    public static final int UIMENU = 1;
    public static final int UICONTEXTMENU = 2;
    public static final int NUM_TYPES = 3;
    private MWCommandTarget fTarget;
    private int fType;
    private double fHandle;
    private UDDObject fMenu;
    private boolean fValuesCached;
    private String fLabel;
    private String fTag;
    private String fCallback;
    private boolean fChecked;
    private boolean fSeparator;
    private MenuNode fParent;
    private Vector fChildren;

    public MenuNode(int n, double d, UDDObject uDDObject) {
        this.fType = n;
        this.fHandle = d;
        this.fMenu = uDDObject;
        this.fParent = null;
        this.fChildren = new Vector();
    }

    public MenuNode() {
        this(0, 0.0, null);
    }

    public void addChild(MenuNode menuNode) {
        if (menuNode != null) {
            this.fChildren.addElement(menuNode);
            menuNode.setParent(this);
        }
    }

    public double getHandle() {
        return this.fHandle;
    }

    public int getType() {
        return this.fType;
    }

    public String getLabel() {
        this.cacheValues();
        return this.fLabel;
    }

    public void setLabel(String string) {
        if (!string.equals(this.fLabel)) {
            this.fLabel = string;
            if (this.fMenu != null) {
                this.fMenu.setPropertyValue("Label", (Object)string);
                this.fTarget.doCommand(1002);
            }
            this.fTarget.doCommand(1002);
        }
    }

    public String getTag() {
        this.cacheValues();
        return this.fTag;
    }

    public void setTag(String string) {
        if (!string.equals(this.fTag)) {
            this.fTag = string;
            if (this.fMenu != null) {
                this.fMenu.setPropertyValue("Tag", (Object)string);
            }
            this.fTarget.doCommand(1002);
        }
    }

    public String getCallback() {
        this.cacheValues();
        return this.fCallback;
    }

    public void setCallback(String string) {
        if (!string.equals(this.fCallback)) {
            this.fCallback = string;
            if (this.fMenu != null) {
                this.fMenu.setPropertyValue("Callback", (Object)string);
                this.fTarget.doCommand(1002);
            }
            this.fTarget.doCommand(1002);
        }
    }

    public boolean getSeparator() {
        this.cacheValues();
        return this.fSeparator;
    }

    public void setSeparator(boolean bl) {
        if (this.fSeparator != bl) {
            this.fSeparator = bl;
            if (this.fMenu != null) {
                Integer n = bl ? new Integer(1) : new Integer(0);
                this.fMenu.setPropertyValue("Separator", (Object)n);
            }
            this.fTarget.doCommand(1002);
        }
    }

    public boolean getChecked() {
        this.cacheValues();
        return this.fChecked;
    }

    public void setChecked(boolean bl) {
        if (this.fChecked != bl) {
            this.fChecked = bl;
            if (this.fMenu != null) {
                Integer n = bl ? new Integer(1) : new Integer(0);
                this.fMenu.setPropertyValue("Checked", (Object)n);
            }
            this.fTarget.doCommand(1002);
        }
    }

    void setTarget(MWCommandTarget mWCommandTarget) {
        this.fTarget = mWCommandTarget;
    }

    protected Vector getChildren() {
        return this.fChildren;
    }

    private void cacheValues() {
        if (!this.fValuesCached) {
            this.fValuesCached = true;
            if (this.fMenu != null) {
                Object object = this.fMenu.getPropertyValue("Tag");
                if (object instanceof String) {
                    this.fTag = (String)object;
                }
                if ((object = this.fMenu.getPropertyValue("Callback")) instanceof String) {
                    this.fCallback = (String)object;
                }
                if (this.getType() == 1) {
                    int n;
                    object = this.fMenu.getPropertyValue("Label");
                    if (object instanceof String) {
                        this.fLabel = (String)object;
                    }
                    if ((object = this.fMenu.getPropertyValue("Separator")) instanceof Integer) {
                        n = (Integer)object;
                        boolean bl = this.fSeparator = n == 1;
                    }
                    if ((object = this.fMenu.getPropertyValue("Checked")) instanceof Integer) {
                        n = (Integer)object;
                        this.fChecked = n == 1;
                    }
                }
            }
        }
    }

    boolean isRoot() {
        boolean bl = false;
        bl = this.fParent != null && this.fParent.getType() == 0;
        return bl;
    }

    private void setParent(MenuNode menuNode) {
        this.fParent = menuNode;
    }
}

