/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout.menueditor;

import com.mathworks.ide.layout.menueditor.CellMenuNode;
import com.mathworks.ide.layout.menueditor.MenuEditorLooper;
import com.mathworks.ide.layout.menueditor.MenuEditorUtils;
import com.mathworks.ide.layout.menueditor.MenuNode;
import com.mathworks.ide.layout.menueditor.MenuPropertyPanel;
import com.mathworks.mwt.MWCardPanel;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.MWTreeView;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TreeData;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.util.Vector;

public class MenuEditor
extends MWCommandPanel
implements MWWindowOwner {
    private static final String RES_PATH = "/com/mathworks/ide/layout/menueditor/resources/";
    protected static final int TREES = 1;
    protected static final int PANELS = 2;
    protected static final int COMMANDS = 4;
    protected static final int ALL = 255;
    private static final int MENU = 0;
    private static final int CMNU = 1;
    private static final int NUM_TREES = 2;
    private static final int NEW_MENU = 100;
    private static final int NEW_MENUITEM = 101;
    private static final int NEW_CONTEXTMENU = 102;
    private static final int MOVE_UP = 103;
    private static final int MOVE_DOWN = 104;
    private static final int DELETE = 105;
    static final int CONTENT_CHANGED = 1002;
    private static Style sMessageStyle;
    private double fFigHandle;
    private MenuNode[] fRoot;
    private MWFrame fFrame;
    private MWTreeView[] fTree;
    private boolean[] fHasItems;
    private MWCardPanel fCardPanel;
    private MenuPropertyPanel[] fPanel;
    private MWToolbar fToolbar;
    private MWTabPanel fTabPanel;
    private MWCommandCenter fCommandCenter;
    private int fUntitledCount;
    static /* synthetic */ Class class$com$mathworks$ide$layout$menueditor$MenuNode;

    MenuEditor(double d) {
        this.fFigHandle = d;
        this.fUntitledCount = 0;
        this.fCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new BorderLayout(6, 6));
        mWPanel.setInsets(new Insets(6, 6, 6, 6));
        ControlUpdater controlUpdater = new ControlUpdater();
        this.fTabPanel = new MWTabPanel(3);
        this.fTabPanel.setName("tabPanel");
        this.fHasItems = new boolean[2];
        this.fTree = new MWTreeView[2];
        this.fTree[0] = this.buildTree(controlUpdater);
        this.fTree[0].setName("menuTree");
        this.fTree[1] = this.buildTree(controlUpdater);
        this.fTree[1].setName("contextMenuTree");
        this.fTabPanel.addPanel(MenuEditorUtils.getResource("tab.MenuBar"), (Component)this.fTree[0]);
        this.fTabPanel.addPanel(MenuEditorUtils.getResource("tab.ContextMenus"), (Component)this.fTree[1]);
        this.fTabPanel.selectPanel(0);
        this.fTabPanel.addItemListener((ItemListener)controlUpdater);
        mWPanel.add((Component)this.fTabPanel, "West");
        this.fCardPanel = new MWCardPanel(null, 5);
        this.fCardPanel.setMargins(new Insets(0, 0, 0, 0));
        this.fPanel = new MenuPropertyPanel[3];
        int n = 0;
        while (n < this.fPanel.length) {
            this.fPanel[n] = new MenuPropertyPanel(this, n);
            this.fCardPanel.addPanel("panel" + n, (Component)((Object)this.fPanel[n]));
            ++n;
        }
        mWPanel.add((Component)this.fCardPanel, "Center");
        ((Container)((Object)this)).add((Component)mWPanel, "Center");
        this.fToolbar = this.buildToolbar(this.fCommandCenter);
        ((Container)((Object)this)).add((Component)this.fToolbar, "North");
        this.fFrame = new MWFrame(this.getLongName());
        this.fFrame.add((Component)((Object)this), "Center");
        this.fFrame.pack();
    }

    private MWTreeView buildTree(ControlUpdater controlUpdater) {
        MWTreeView mWTreeView = new MWTreeView();
        mWTreeView.getTableStyle().setEditable(true);
        mWTreeView.setPreferredTableSize(15, 3);
        mWTreeView.addItemListener((ItemListener)controlUpdater);
        mWTreeView.addValueListener((ValueListener)controlUpdater);
        mWTreeView.registerCellType(class$com$mathworks$ide$layout$menueditor$MenuNode != null ? class$com$mathworks$ide$layout$menueditor$MenuNode : (class$com$mathworks$ide$layout$menueditor$MenuNode = MenuEditor.class$("com.mathworks.ide.layout.menueditor.MenuNode")), (Cell)new CellMenuNode((Table)mWTreeView));
        return mWTreeView;
    }

    private void doNewMenu() {
        if (this.fTabPanel.getSelectedIndex() == 0) {
            MenuEditorLooper.doNew(this, 1, this.fFigHandle, this.untitled(), -1, 0);
        }
    }

    private void doNewMenuItem() {
        MenuNode menuNode;
        int n;
        int n2 = this.fTabPanel.getSelectedIndex();
        int n3 = this.fTree[n2].getFirstSelectedRow();
        if (n3 != -2 && (n = this.fTree[n2].getItemId(n3)) != -1 && (menuNode = (MenuNode)this.fTree[n2].getItem(n)) != null) {
            MenuEditorLooper.doNew(this, 1, menuNode.getHandle(), this.untitled(), n, n2);
        }
    }

    private void doNewContextMenu() {
        if (this.fTabPanel.getSelectedIndex() == 1) {
            MenuEditorLooper.doNew(this, 2, this.fFigHandle, this.untitled(), -1, 1);
        }
    }

    private void doDelete() {
        MenuNode menuNode;
        int n;
        MWTreeView mWTreeView = this.getActiveTree();
        int n2 = mWTreeView.getFirstSelectedRow();
        if (n2 != -2 && (n = mWTreeView.getItemId(n2)) != -1 && (menuNode = (MenuNode)mWTreeView.getItem(n)) != null) {
            mWTreeView.removeItem(n);
            if (mWTreeView.getChildren(-1).length == 0) {
                int n3 = this.fTabPanel.getSelectedIndex();
                this.fHasItems[n3] = false;
                this.addNoItemMessage(n3);
            }
            MenuEditorLooper.doDelete(menuNode.getHandle());
            this.doCommand(1002);
            this.updateControls(6);
        }
    }

    private void doMoveUp() {
        System.out.println("doMoveUp()");
    }

    private void doMoveDown() {
        System.out.println("doMoveDown()");
    }

    public void doCommand(int n) {
        switch (n) {
            case -103: {
                this.closeWindow();
                return;
            }
            case 100: {
                this.doNewMenu();
                return;
            }
            case 101: {
                this.doNewMenuItem();
                return;
            }
            case 102: {
                this.doNewContextMenu();
                return;
            }
            case 103: {
                this.doMoveUp();
                return;
            }
            case 104: {
                this.doMoveDown();
                return;
            }
            case 105: {
                this.doDelete();
                return;
            }
        }
        super.doCommand(n);
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case -103: {
                return true;
            }
            case 100: {
                return this.fTabPanel.getSelectedIndex() == 0;
            }
            case 101: {
                return this.getActiveTree().getFirstSelectedRow() != -2;
            }
            case 102: {
                return this.fTabPanel.getSelectedIndex() == 1;
            }
            case 103: {
                return false;
            }
            case 104: {
                return false;
            }
            case 105: {
                return this.fTree[this.fTabPanel.getSelectedIndex()].getFirstSelectedRow() != -2;
            }
        }
        return super.isCommandEnabled(n);
    }

    public int closeWindow() {
        this.fFrame.setVisible(false);
        this.fFrame.dispose();
        return 0;
    }

    public void setActive(boolean bl) {
    }

    public String getShortName() {
        return MenuEditorUtils.getResource("frame.title");
    }

    public String getLongName() {
        return MenuEditorUtils.getResource("frame.title");
    }

    protected double getFigHandle() {
        return this.fFigHandle;
    }

    protected void completeNew(int n, MenuNode menuNode, int n2) {
        if (menuNode != null) {
            if (!this.fHasItems[n2]) {
                this.fTree[n2].setRowStyle(0, null);
                this.fTree[n2].setRowStyle(1, null);
                int n3 = this.fTree[n2].getItemId(0);
                if (n3 != -1) {
                    this.fTree[n2].removeItem(n3);
                }
                if ((n3 = this.fTree[n2].getItemId(0)) != -1) {
                    this.fTree[n2].removeItem(n3);
                }
                this.fTree[n2].getSelectionOptions().setMode(1);
                this.fTree[n2].setShowRootlines(true);
            }
            this.fHasItems[n2] = true;
            if (n == -1) {
                this.fRoot[n2].addChild(menuNode);
            } else {
                MenuNode menuNode2 = (MenuNode)this.fTree[n2].getItem(n);
                if (menuNode2 != null) {
                    menuNode2.addChild(menuNode);
                }
            }
            TreeData treeData = this.fTree[n2].getTreeData();
            this.fTree[n2].addItem(n, (Object)menuNode, true);
            menuNode.setTarget((MWCommandTarget)this);
            if (!treeData.isExpanded(n)) {
                treeData.expandItem(n);
            }
            this.doCommand(1002);
        }
    }

    protected void completeInvoke(MenuNode menuNode, MenuNode menuNode2) {
        this.fRoot = new MenuNode[2];
        this.fRoot[0] = menuNode;
        this.fRoot[1] = menuNode2;
        this.populate(menuNode, menuNode2);
        this.fFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this)));
        this.fFrame.setVisible(true);
    }

    private String untitled() {
        return MenuEditorUtils.getResource("string.Untitled", ++this.fUntitledCount);
    }

    private MWToolbar buildToolbar(MWCommandCenter mWCommandCenter) {
        MWToolbar mWToolbar = new MWToolbar();
        mWToolbar.addImageButton("/com/mathworks/ide/layout/menueditor/resources/menu.gif", 100, MenuEditorUtils.getResource("command.NewMenu"), mWCommandCenter);
        mWToolbar.addImageButton("/com/mathworks/ide/layout/menueditor/resources/menuitem.gif", 101, MenuEditorUtils.getResource("command.NewMenuItem"), mWCommandCenter);
        mWToolbar.addImageButton("/com/mathworks/ide/layout/menueditor/resources/contextmenu.gif", 102, MenuEditorUtils.getResource("command.NewContextMenu"), mWCommandCenter);
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/ide/layout/menueditor/resources/delete.gif", 105, MenuEditorUtils.getResource("command.Delete"), mWCommandCenter);
        return mWToolbar;
    }

    private MWTreeView getActiveTree() {
        return this.fTree[this.fTabPanel.getSelectedIndex()];
    }

    protected void updateControls(int n) {
        int n2;
        int n3 = this.fTabPanel.getSelectedIndex();
        if ((n & 1) != 0) {
            this.fTree[n3].repaint();
        }
        if ((n & 4) != 0) {
            n2 = 0;
            while (n2 < this.fTree.length) {
                if (!this.fHasItems[n2]) {
                    this.fTree[n2].deselectAll();
                }
                ++n2;
            }
            this.fCommandCenter.updateCommand(-103);
            this.fCommandCenter.updateCommand(100);
            this.fCommandCenter.updateCommand(102);
            this.fCommandCenter.updateCommand(101);
            this.fCommandCenter.updateCommand(105);
            this.fCommandCenter.updateCommand(103);
            this.fCommandCenter.updateCommand(104);
        }
        if ((n & 2) != 0) {
            Object object;
            int n4;
            n2 = this.fTree[n3].getFirstSelectedRow();
            boolean bl = true;
            if (n2 != -2 && (n4 = this.fTree[n3].getItemId(n2)) != -1 && (object = this.fTree[n3].getItem(n4)) instanceof MenuNode) {
                MenuNode menuNode = (MenuNode)object;
                int n5 = menuNode.getType();
                switch (n5) {
                    case 1: 
                    case 2: {
                        this.fPanel[n5].synchToNode(menuNode);
                        this.fCardPanel.selectPanel(n5);
                        bl = false;
                        break;
                    }
                }
            }
            if (bl) {
                this.fCardPanel.selectPanel(0);
            }
        }
    }

    private void populate(MenuNode menuNode, MenuNode menuNode2) {
        this.fHasItems[0] = this.populateHelper(-1, this.fTree[0], menuNode);
        if (!this.fHasItems[0]) {
            this.addNoItemMessage(0);
        }
        this.fHasItems[1] = this.populateHelper(-1, this.fTree[1], menuNode2);
        if (!this.fHasItems[1]) {
            this.addNoItemMessage(1);
        }
        this.updateControls(255);
    }

    private boolean populateHelper(int n, MWTreeView mWTreeView, MenuNode menuNode) {
        boolean bl = false;
        Vector vector = menuNode.getChildren();
        int n2 = 0;
        while (n2 < vector.size()) {
            MenuNode menuNode2 = (MenuNode)vector.elementAt(n2);
            bl = true;
            int n3 = mWTreeView.addItem(n, (Object)menuNode2, true);
            menuNode2.setTarget((MWCommandTarget)this);
            this.populateHelper(n3, mWTreeView, menuNode2);
            ++n2;
        }
        return bl;
    }

    private void addNoItemMessage(int n) {
        if (!this.fHasItems[n]) {
            String string = MenuEditorUtils.getResource("prompt.NoItems" + n);
            String string2 = MenuEditorUtils.getResource("prompt.NoItemsFinish");
            if (sMessageStyle == null) {
                sMessageStyle = new Style(1027);
                sMessageStyle.setForeground(Color.gray);
                sMessageStyle.setFont(new Font("Dialog", 2, 10));
                sMessageStyle.setEditable(false);
            }
            this.fTree[n].setShowRootlines(false);
            this.fTree[n].addItem(-1, (Object)string, false);
            this.fTree[n].addItem(-1, (Object)string2, false);
            this.fTree[n].setRowStyle(0, sMessageStyle);
            this.fTree[n].setRowStyle(1, sMessageStyle);
            this.fTree[n].getSelectionOptions().setMode(0);
        }
    }

    public static MenuEditor invoke(double d) {
        MenuEditor menuEditor = new MenuEditor(d);
        MenuEditorLooper.invoke(menuEditor);
        return menuEditor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ControlUpdater
    implements ItemListener,
    ValueListener {
        public void valueChanged(ValueEvent valueEvent) {
            MenuEditor.this.updateControls(6);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            MenuEditor.this.updateControls(6);
        }

        ControlUpdater() {
            MenuEditor.this = MenuEditor.this;
        }
    }
}

