/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout.lowidgets;

import com.mathworks.ide.layout.lowidgets.LOTreeView;
import java.util.Vector;

public class LOTreeViewNode {
    private String fText;
    private boolean fHasChildren;
    private boolean fExpanded;
    private LOTreeViewNode fParent;
    private Vector fChildren;
    private LOTreeView fOwner;
    private int fId;

    public LOTreeViewNode(String string, boolean bl) {
        this.fText = string;
        this.fHasChildren = bl;
        this.fExpanded = false;
        this.fOwner = null;
        this.fParent = null;
        this.fChildren = new Vector();
    }

    public LOTreeViewNode nextNode() {
        return this.nextNode(true);
    }

    private LOTreeViewNode nextNode(boolean bl) {
        LOTreeViewNode lOTreeViewNode = null;
        if (bl && this.fChildren.size() > 0) {
            lOTreeViewNode = (LOTreeViewNode)this.fChildren.elementAt(0);
        } else {
            lOTreeViewNode = this.nextSibling();
            if (this.fParent != null && lOTreeViewNode == null) {
                lOTreeViewNode = this.fParent.nextNode(false);
            }
        }
        return lOTreeViewNode;
    }

    private LOTreeViewNode nextSibling() {
        LOTreeViewNode lOTreeViewNode = null;
        LOTreeViewNode[] lOTreeViewNodeArray = null;
        lOTreeViewNodeArray = this.fParent == null && this.fOwner != null ? this.fOwner.getNodes() : this.fParent.getChildrenAsArray();
        if (lOTreeViewNodeArray != null) {
            int n = 0;
            while (n < lOTreeViewNodeArray.length && lOTreeViewNodeArray[n] != this) {
                ++n;
            }
            if (n < lOTreeViewNodeArray.length - 1) {
                lOTreeViewNode = lOTreeViewNodeArray[n + 1];
            }
        }
        return lOTreeViewNode;
    }

    public LOTreeView getOwner() {
        return this.fOwner;
    }

    public void setOwner(LOTreeView lOTreeView) {
        this.fOwner = lOTreeView;
    }

    public int getId() {
        return this.fId;
    }

    public void setId(int n) {
        this.fId = n;
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        this.fText = string;
    }

    public boolean getHasChildren() {
        return this.fHasChildren;
    }

    public void setHasChildren(boolean bl) {
        this.fHasChildren = bl;
    }

    public boolean isExpanded() {
        return this.fExpanded;
    }

    public void setExpanded(boolean bl) {
        if (bl != this.fExpanded) {
            this.fExpanded = bl;
            if (this.fOwner != null) {
                this.fOwner.setNodeExpanded(this, this.fExpanded);
            }
        }
    }

    public LOTreeViewNode getParent() {
        return this.fParent;
    }

    void setParent(LOTreeViewNode lOTreeViewNode) {
        this.fParent = lOTreeViewNode;
    }

    public LOTreeViewNode[] getChildrenAsArray() {
        LOTreeViewNode[] lOTreeViewNodeArray = new LOTreeViewNode[this.fChildren.size()];
        int n = 0;
        while (n < lOTreeViewNodeArray.length) {
            lOTreeViewNodeArray[n] = (LOTreeViewNode)this.fChildren.elementAt(n);
            ++n;
        }
        return lOTreeViewNodeArray;
    }

    public Vector getChildren() {
        return this.fChildren;
    }

    void add(LOTreeViewNode lOTreeViewNode) {
        if (lOTreeViewNode != null) {
            this.fChildren.addElement(lOTreeViewNode);
            lOTreeViewNode.setParent(this);
        }
    }

    void insert(LOTreeViewNode lOTreeViewNode, int n) {
        if (lOTreeViewNode != null) {
            this.fChildren.insertElementAt(lOTreeViewNode, n);
            lOTreeViewNode.setParent(this);
        }
    }

    void remove(LOTreeViewNode lOTreeViewNode) {
        if (this.fChildren.contains(lOTreeViewNode)) {
            this.fChildren.removeElement(lOTreeViewNode);
            lOTreeViewNode.setParent(null);
        }
    }
}

