/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout.lowidgets;

import com.mathworks.ide.layout.lowidgets.LOEvents;
import com.mathworks.ide.layout.lowidgets.LOTreeViewNode;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.MWTListEvent;
import com.mathworks.mwt.MWTListListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Hashtable;
import java.util.Vector;

public class LOTreeView
extends MWTList
implements MWTListListener {
    private static final String MWT_RES = "/com/mathworks/mwt/resources/";
    private static final int DEFAULT_ROWS = 10;
    private static final int MIN_ROWS = 3;
    private static final int PREF_WIDTH = 175;
    private static final int MIN_WIDTH = 50;
    private static final int LEAF = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private MWImageResource fLeafIcon;
    private MWImageResource fClosedIcon;
    private MWImageResource fOpenIcon;
    private MWImageResource fRootIcon;
    private LOEvents fEvents;
    private transient Vector fTopLevelNodes = new Vector();
    private transient Hashtable fNodeLookup = new Hashtable();
    private transient int fNextId = 0;
    private transient int fNextSelectedNodeId = -1;

    public LOTreeView() {
        super(true, true);
        this.fLeafIcon = new MWImageResource("/com/mathworks/mwt/resources/document.gif");
        this.fClosedIcon = new MWImageResource("/com/mathworks/mwt/resources/folderwin.gif");
        this.fOpenIcon = new MWImageResource("/com/mathworks/mwt/resources/folderwin.gif");
        this.fRootIcon = new MWImageResource("/com/mathworks/mwt/resources/diskwin.gif");
        this.fEvents = new LOEvents((Component)((Object)this));
        this.addMWTListListener(this);
    }

    public LOEvents getEvents() {
        return this.fEvents;
    }

    public void setEvents(LOEvents lOEvents) {
        if (this.fEvents != null) {
            this.fEvents.unwireEvents();
        }
        this.fEvents = lOEvents;
        if (this.fEvents != null) {
            this.fEvents.wireEvents();
        }
    }

    public LOTreeViewNode getFirstSelectedNode() {
        LOTreeViewNode lOTreeViewNode = null;
        this.fNextSelectedNodeId = this.getFirstSelectedItem();
        if (this.fNextSelectedNodeId != -1) {
            lOTreeViewNode = (LOTreeViewNode)this.fNodeLookup.get(new Integer(this.fNextSelectedNodeId));
        }
        return lOTreeViewNode;
    }

    public LOTreeViewNode getNextSelectedNode() {
        LOTreeViewNode lOTreeViewNode = null;
        if (this.fNextSelectedNodeId == -1) {
            lOTreeViewNode = this.getFirstSelectedNode();
        } else {
            this.fNextSelectedNodeId = this.getNextSelectedItem(this.fNextSelectedNodeId);
            if (this.fNextSelectedNodeId != -1) {
                lOTreeViewNode = (LOTreeViewNode)this.fNodeLookup.get(new Integer(this.fNextSelectedNodeId));
            }
        }
        return lOTreeViewNode;
    }

    public Dimension getPreferredSize() {
        return new Dimension(175, 10 * this.getCellHeight() + 2);
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 3 * this.getCellHeight() + 2);
    }

    private void initialPopulate() {
        int n = 1;
        while (n < 4) {
            LOTreeViewNode lOTreeViewNode = this.addNode("Root " + n, true, null);
            int n2 = 1;
            while (n2 < 4) {
                LOTreeViewNode lOTreeViewNode2 = this.addNode("Branch " + n2, true, lOTreeViewNode);
                int n3 = 1;
                while (n3 < 4) {
                    LOTreeViewNode lOTreeViewNode3 = this.addNode("Leaf " + n3, false, lOTreeViewNode2);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void updateIcons() {
        int n = this.getFirstItem();
        while (n != -1) {
            LOTreeViewNode lOTreeViewNode = (LOTreeViewNode)this.fNodeLookup.get(new Integer(n));
            if (lOTreeViewNode != null && lOTreeViewNode.getParent() != null) {
                if (!lOTreeViewNode.getHasChildren()) {
                    if (this.fLeafIcon != null) {
                        this.setItemIcon(n, this.fLeafIcon.getImage((Component)((Object)this)));
                    } else {
                        this.setItemIcon(n, null);
                    }
                } else if (lOTreeViewNode.isExpanded()) {
                    if (this.fOpenIcon != null) {
                        this.setItemIcon(n, this.fOpenIcon.getImage((Component)((Object)this)));
                    } else {
                        this.setItemIcon(n, null);
                    }
                } else if (!lOTreeViewNode.isExpanded()) {
                    if (this.fClosedIcon != null) {
                        this.setItemIcon(n, this.fClosedIcon.getImage((Component)((Object)this)));
                    } else {
                        this.setItemIcon(n, null);
                    }
                }
            }
            n = this.getNextItem();
        }
    }

    public LOTreeViewNode[] getNodes() {
        LOTreeViewNode[] lOTreeViewNodeArray = new LOTreeViewNode[this.fTopLevelNodes.size()];
        int n = 0;
        while (n < lOTreeViewNodeArray.length) {
            lOTreeViewNodeArray[n] = (LOTreeViewNode)this.fTopLevelNodes.elementAt(n);
            ++n;
        }
        return lOTreeViewNodeArray;
    }

    public void setNodes(LOTreeViewNode[] lOTreeViewNodeArray) {
        this.fTopLevelNodes = new Vector();
        this.fNodeLookup = new Hashtable();
        this.removeAll();
        this.fNextId = 0;
        if (lOTreeViewNodeArray != null) {
            int n = 0;
            while (n < lOTreeViewNodeArray.length) {
                LOTreeViewNode lOTreeViewNode = lOTreeViewNodeArray[n];
                lOTreeViewNode.setId(this.fNextId++);
                this.fTopLevelNodes.addElement(lOTreeViewNode);
                this.addNodeToHashtable(lOTreeViewNode);
                this.add(-1, lOTreeViewNode.getId(), lOTreeViewNode.getText(), this.getIcon(lOTreeViewNode), lOTreeViewNode.getHasChildren());
                if (lOTreeViewNode.isExpanded()) {
                    this.setItemTwisted(lOTreeViewNode.getId(), true);
                    this.expand(lOTreeViewNode.getId());
                }
                ++n;
            }
        }
    }

    private void addNodeToHashtable(LOTreeViewNode lOTreeViewNode) {
        if (lOTreeViewNode != null) {
            this.fNodeLookup.put(new Integer(lOTreeViewNode.getId()), lOTreeViewNode);
            Vector vector = lOTreeViewNode.getChildren();
            int n = 0;
            while (n < vector.size()) {
                LOTreeViewNode lOTreeViewNode2 = (LOTreeViewNode)vector.elementAt(n);
                lOTreeViewNode2.setId(this.fNextId++);
                this.addNodeToHashtable((LOTreeViewNode)vector.elementAt(n));
                ++n;
            }
        }
    }

    public MWImageResource getRootIcon() {
        return this.fRootIcon;
    }

    public void setRootIcon(MWImageResource mWImageResource) {
        this.fRootIcon = mWImageResource;
        this.updateIcons();
    }

    public MWImageResource getLeafIcon() {
        return this.fLeafIcon;
    }

    public void setLeafIcon(MWImageResource mWImageResource) {
        this.fLeafIcon = mWImageResource;
        this.updateIcons();
    }

    public MWImageResource getOpenIcon() {
        return this.fOpenIcon;
    }

    public void setOpenIcon(MWImageResource mWImageResource) {
        this.fOpenIcon = mWImageResource;
        this.updateIcons();
    }

    public MWImageResource getClosedIcon() {
        return this.fClosedIcon;
    }

    public void setClosedIcon(MWImageResource mWImageResource) {
        this.fClosedIcon = mWImageResource;
        this.updateIcons();
    }

    public void addNode(LOTreeViewNode lOTreeViewNode, LOTreeViewNode lOTreeViewNode2) {
        int n = -1;
        this.fNodeLookup.put(new Integer(this.fNextId), lOTreeViewNode);
        if (lOTreeViewNode2 != null) {
            lOTreeViewNode2.add(lOTreeViewNode);
            n = lOTreeViewNode2.getId();
        } else {
            this.fTopLevelNodes.addElement(lOTreeViewNode);
        }
        if (this.isNodeVisible(lOTreeViewNode)) {
            this.add(n, this.fNextId, lOTreeViewNode.getText(), this.getIcon(lOTreeViewNode), lOTreeViewNode.getHasChildren());
        }
        lOTreeViewNode.setOwner(this);
        lOTreeViewNode.setId(this.fNextId++);
    }

    public LOTreeViewNode addNode(String string, boolean bl, LOTreeViewNode lOTreeViewNode) {
        LOTreeViewNode lOTreeViewNode2 = new LOTreeViewNode(string, bl);
        this.addNode(lOTreeViewNode2, lOTreeViewNode);
        return lOTreeViewNode2;
    }

    public void removeNode(LOTreeViewNode lOTreeViewNode) {
        if (lOTreeViewNode != null) {
            boolean bl = this.isNodeVisible(lOTreeViewNode);
            int n = lOTreeViewNode.getId();
            LOTreeViewNode lOTreeViewNode2 = lOTreeViewNode.getParent();
            if (lOTreeViewNode2 != null) {
                lOTreeViewNode2.remove(lOTreeViewNode);
            }
            if (bl) {
                this.removeDescendants(n);
                this.remove(n);
            }
        }
    }

    private Image getIcon(LOTreeViewNode lOTreeViewNode) {
        Image image = null;
        if (lOTreeViewNode != null) {
            if (lOTreeViewNode.getParent() == null) {
                image = this.fRootIcon.getImage((Component)((Object)this));
            } else if (!lOTreeViewNode.getHasChildren() && this.fLeafIcon != null) {
                image = this.fLeafIcon.getImage((Component)((Object)this));
            } else if (lOTreeViewNode.isExpanded() && this.fOpenIcon != null) {
                image = this.fOpenIcon.getImage((Component)((Object)this));
            } else if (!lOTreeViewNode.isExpanded() && this.fClosedIcon != null) {
                image = this.fClosedIcon.getImage((Component)((Object)this));
            }
        }
        return image;
    }

    private boolean isNodeVisible(LOTreeViewNode lOTreeViewNode) {
        boolean bl = false;
        if (lOTreeViewNode != null) {
            LOTreeViewNode lOTreeViewNode2 = lOTreeViewNode.getParent();
            if (lOTreeViewNode2 == null) {
                bl = true;
            } else if (lOTreeViewNode2.isExpanded()) {
                bl = this.isNodeVisible(lOTreeViewNode2);
            }
        }
        return bl;
    }

    public void makeNodeVisible(LOTreeViewNode lOTreeViewNode) {
        if (lOTreeViewNode != null && !this.isNodeVisible(lOTreeViewNode)) {
            LOTreeViewNode lOTreeViewNode2 = lOTreeViewNode.getParent();
            this.makeNodeVisible(lOTreeViewNode2);
            if (this.isNodeVisible(lOTreeViewNode2)) {
                lOTreeViewNode2.setExpanded(true);
            }
        }
    }

    void setNodeExpanded(LOTreeViewNode lOTreeViewNode, boolean bl) {
        if (this.isNodeVisible(lOTreeViewNode)) {
            if (bl) {
                this.expand(lOTreeViewNode.getId());
                return;
            }
            this.collapse(lOTreeViewNode.getId());
        }
    }

    private void expand(int n) {
        LOTreeViewNode lOTreeViewNode = (LOTreeViewNode)this.fNodeLookup.get(new Integer(n));
        if (lOTreeViewNode != null) {
            Vector vector = lOTreeViewNode.getChildren();
            if (!this.isItemTwisted(n)) {
                this.setItemTwisted(n, true);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                LOTreeViewNode lOTreeViewNode2 = (LOTreeViewNode)vector.elementAt(n2);
                this.add(n, lOTreeViewNode2.getId(), lOTreeViewNode2.getText(), this.getIcon(lOTreeViewNode2), lOTreeViewNode2.getHasChildren());
                if (lOTreeViewNode2.isExpanded()) {
                    this.expand(lOTreeViewNode2.getId());
                }
                ++n2;
            }
        }
    }

    private void collapse(int n) {
        LOTreeViewNode lOTreeViewNode = (LOTreeViewNode)this.fNodeLookup.get(new Integer(n));
        if (lOTreeViewNode != null) {
            if (this.isItemTwisted(n)) {
                this.setItemTwisted(n, false);
            }
            this.removeDescendants(n);
        }
    }

    public void expandItem(MWTListEvent mWTListEvent) {
        int n = mWTListEvent.getItemId();
        LOTreeViewNode lOTreeViewNode = (LOTreeViewNode)this.fNodeLookup.get(new Integer(n));
        boolean bl = ((Component)((Object)this)).isVisible();
        if (bl) {
            this.setVisible(false);
        }
        if (lOTreeViewNode != null) {
            lOTreeViewNode.setExpanded(true);
        }
        this.updateIcons();
        if (bl) {
            this.setVisible(true);
        }
    }

    public void collapseItem(MWTListEvent mWTListEvent) {
        int n = mWTListEvent.getItemId();
        LOTreeViewNode lOTreeViewNode = (LOTreeViewNode)this.fNodeLookup.get(new Integer(n));
        boolean bl = ((Component)((Object)this)).isVisible();
        if (bl) {
            this.setVisible(false);
        }
        if (lOTreeViewNode != null) {
            lOTreeViewNode.setExpanded(false);
        }
        this.updateIcons();
        if (bl) {
            this.setVisible(true);
        }
    }

    public void scrollList(MWTListEvent mWTListEvent) {
    }
}

