/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout.lowidgets;

import com.mathworks.ide.layout.lowidgets.LOTabLayer;
import com.mathworks.ide.layout.lowidgets.SubpanelEvent;
import com.mathworks.ide.layout.lowidgets.SubpanelListener;
import com.mathworks.ide.layout.lowidgets.SubpanelOwner;
import com.mathworks.mwt.MWGroupbox;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class LOCardPanel
extends MWGroupbox
implements SubpanelOwner {
    private static final String kPanelString = "subpanel";
    private static final int kIncrement = 5;
    private static final int kMinWidth = 40;
    private static final int kMinHeight = 40;
    private CardLayout fLayout;
    private int[] fTable;
    private int fLastID;
    private int fPanelCount;
    private int fValue;
    private SubpanelListener fSubpanelListener;

    public LOCardPanel() {
        this.setStyle(4);
        this.fLayout = new CardLayout();
        ((Container)((Object)this)).setLayout(this.fLayout);
        this.fTable = new int[5];
        this.addPanel();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = ((Component)((Object)this)).getSize();
        return new Dimension(Math.max(dimension.width, 40), Math.max(dimension.height, 40));
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    public int getSubpanelCount() {
        return this.fPanelCount;
    }

    public void setSubpanelCount(int n) {
        if (n > this.fPanelCount) {
            int n2 = this.fPanelCount;
            while (n2 < n) {
                this.addPanel();
                ++n2;
            }
            return;
        }
        if (n < this.fPanelCount && n > 0) {
            int n3 = this.fPanelCount - 1;
            while (n3 >= n) {
                this.removePanel(n3);
                --n3;
            }
        }
    }

    public int getSubpanelIndex() {
        return this.fValue;
    }

    public void setSubpanelIndex(int n) {
        if (n != this.fValue && n >= 0 && n < this.fPanelCount) {
            this.fLayout.show((Container)((Object)this), kPanelString + this.fTable[n]);
            this.fValue = n;
            this.fireSubpanelIndexChangedEvent();
        }
    }

    public synchronized String[] getLabels() {
        boolean bl = false;
        int n = this.getSubpanelCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((Component)((Object)this.getSubpanel(n2))).getName();
            if (!stringArray[n2].equals(kPanelString + this.fTable[n2])) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            return stringArray;
        }
        return null;
    }

    public synchronized void setLabels(String[] stringArray) {
        int n = stringArray.length;
        this.setSubpanelCount(n);
        int n2 = 0;
        while (n2 < n) {
            ((Component)((Object)this.getSubpanel(n2))).setName(stringArray[n2]);
            ++n2;
        }
    }

    public void nextPanel() {
        if (this.fValue < this.fPanelCount) {
            ++this.fValue;
            this.fLayout.show((Container)((Object)this), kPanelString + this.fTable[this.fValue]);
            this.fireSubpanelIndexChangedEvent();
        }
    }

    public void previousPanel() {
        if (this.fValue > 0) {
            --this.fValue;
            this.fLayout.show((Container)((Object)this), kPanelString + this.fTable[this.fValue]);
            this.fireSubpanelIndexChangedEvent();
        }
    }

    public LOTabLayer getSubpanel(int n) {
        if (n >= 0 && n < this.fPanelCount) {
            return (LOTabLayer)((Object)((Container)((Object)this)).getComponent(n));
        }
        return null;
    }

    public void changePanelName(int n, String string) {
    }

    public synchronized void addSubpanelListener(SubpanelListener subpanelListener) {
        this.fSubpanelListener = subpanelListener;
    }

    public synchronized void removeSubpanelListener(SubpanelListener subpanelListener) {
        if (this.fSubpanelListener == subpanelListener) {
            this.fSubpanelListener = null;
        }
    }

    private void fireSubpanelIndexChangedEvent() {
        SubpanelListener subpanelListener = this.fSubpanelListener;
        if (subpanelListener != null) {
            subpanelListener.subpanelIndexChanged(new SubpanelEvent(this, this.fValue));
        }
    }

    private void addPanel() {
        this.ensureCapacity(this.fPanelCount + 1);
        if (this.fPanelCount == 0) {
            this.fTable[0] = 0;
        } else {
            this.fTable[this.fPanelCount] = this.fTable[this.fPanelCount - 1] + 1;
        }
        String string = kPanelString + this.fTable[this.fPanelCount];
        ((Container)((Object)this)).add((Component)((Object)new LOTabLayer(this, string)), string);
        ++this.fPanelCount;
    }

    private void removePanel(int n) {
        if (n >= 0 && n < this.fPanelCount && this.fPanelCount > 1) {
            ((Container)((Object)this)).remove(((Container)((Object)this)).getComponent(n));
            if (n < this.fPanelCount - 1) {
                System.arraycopy(this.fTable, n + 1, this.fTable, n, this.fPanelCount - n - 1);
            }
            --this.fPanelCount;
            if (n == this.fValue) {
                if (n == this.fPanelCount) {
                    --n;
                }
                this.fLayout.show((Container)((Object)this), kPanelString + this.fTable[n]);
            }
        }
    }

    private void ensureCapacity(int n) {
        if (n <= this.fTable.length) {
            return;
        }
        int n2 = n % 5;
        if (n2 != 0) {
            n += 5 - n2;
        }
        int[] nArray = this.fTable;
        this.fTable = new int[n];
        System.arraycopy(nArray, 0, this.fTable, 0, nArray.length);
    }
}

