/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout.lowidgets;

import com.mathworks.mwt.MWCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class LOAxis
extends MWCanvas {
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private static final int NUM = 11;
    private static final int VERTICAL = 0;
    private static final int HORIZONTAL = 1;
    private static final int MIN_PIXELS = 50;
    protected FontMetrics fFontMet;
    protected Rectangle fAxisRect = new Rectangle(0, 0, 0, 0);
    protected double fXmin;
    protected double fXmax;
    protected double fYmin;
    protected double fYmax;
    protected ScaleInfo fXscale;
    protected ScaleInfo fYscale;
    protected boolean fXdirReversed = false;
    protected boolean fYdirReversed = false;
    protected boolean fEqualMode = false;
    protected double fA11;
    protected double fA22;
    protected double fA13;
    protected double fA23;

    public LOAxis(double d, double d2, double d3, double d4) {
        this.setXLim(d, d2);
        this.setYLim(d3, d4);
        this.fXscale = null;
        this.fYscale = null;
        ((Component)((Object)this)).setBackground(Color.white);
        ((Component)((Object)this)).setForeground(Color.black);
    }

    public double getXmin() {
        return this.fXmin;
    }

    public double getXmax() {
        return this.fXmax;
    }

    public void setXLim(double d, double d2) {
        if (d < d2) {
            this.fXmin = d;
            this.fXmax = d2;
        } else {
            this.fXmin = d2 - 1.0;
            this.fYmax = d2 + 1.0;
        }
        this.fXscale = null;
    }

    public double getYmin() {
        return this.fYmin;
    }

    public double getYmax() {
        return this.fYmax;
    }

    public void setYLim(double d, double d2) {
        if (d < d2) {
            this.fYmin = d;
            this.fYmax = d2;
        } else {
            this.fYmin = d - 1.0;
            this.fYmax = d2 + 1.0;
        }
        this.fYscale = null;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(50, 50);
        return dimension;
    }

    public void paint(Graphics graphics) {
        this.drawAxis(graphics);
    }

    public void update(Graphics graphics) {
        this.drawAxis(graphics);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fFontMet = null;
    }

    protected static String DoubletoString(double d, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(n2);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(n2);
        ((NumberFormat)decimalFormat).setGroupingUsed(false);
        return decimalFormat.format(d);
    }

    protected static String fixedWidthDoubletoString(double d, int n, int n2) {
        String string = LOAxis.DoubletoString(d, n, n2);
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    protected static String fixedWidthIntegertoString(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    protected Rectangle equalRect(Rectangle rectangle, double d, double d2) {
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        if (d * (double)rectangle.height < d2 * (double)rectangle.width) {
            rectangle2.width = (int)this.round(d * (double)rectangle.height / d2);
            rectangle2.height = rectangle.height;
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y;
        } else {
            rectangle2.width = rectangle.width;
            rectangle2.height = (int)this.round(d2 * (double)rectangle.width / d);
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
        }
        return rectangle2;
    }

    protected void checkFontInfo() {
        if (this.fFontMet == null) {
            this.fFontMet = ((Component)((Object)this)).getFontMetrics(((Component)((Object)this)).getFont());
        }
    }

    protected void calcDimensions(Graphics graphics) {
        this.checkFontInfo();
        int n = this.fFontMet.getHeight();
        this.fAxisRect.x = 0;
        this.fAxisRect.y = 0;
        this.fAxisRect.width = ((Component)((Object)this)).getSize().width;
        this.fAxisRect.height = ((Component)((Object)this)).getSize().height;
        if (this.fEqualMode) {
            this.fAxisRect = this.equalRect(this.fAxisRect, this.fXmax - this.fXmin, this.fYmax - this.fYmin);
        }
        n = this.fFontMet.getHeight();
        int n2 = n + 3;
        this.fYscale = this.bestScale(this.fYmin, this.fYmax, 0, this.fAxisRect.height - n2 - n / 2, 0);
        int n3 = this.fFontMet.stringWidth(LOAxis.fixedWidthDoubletoString(this.fYscale.ticks[0], this.fYscale.w + 2, this.fYscale.d)) + 3;
        this.fXscale = this.bestScale(this.fXmin, this.fXmax, 1, this.fAxisRect.width - n3, 0);
        int n4 = this.fFontMet.stringWidth(LOAxis.DoubletoString(this.fXscale.ticks[this.fXscale.ticks.length - 1], this.fXscale.w + 2, this.fXscale.d));
        this.fAxisRect.x = n3;
        this.fAxisRect.y = n / 2;
        this.fAxisRect.width = ((Component)((Object)this)).getSize().width - n3 - n4 / 2 - 3;
        this.fAxisRect.height = ((Component)((Object)this)).getSize().height - n2 - n / 2;
        if (this.fEqualMode) {
            double[] dArray = this.fXscale.ticks;
            double[] dArray2 = this.fYscale.ticks;
            double d = dArray[dArray.length - 1] - dArray[0];
            double d2 = dArray2[dArray2.length - 1] - dArray2[0];
            Rectangle rectangle = this.equalRect(this.fAxisRect, d, d2);
            if (this.fAxisRect.width == rectangle.width) {
                this.fYscale = this.bestScale(this.fYmin, this.fYmax, 0, this.fAxisRect.height, (int)((double)rectangle.width / d));
                n3 = this.fFontMet.stringWidth(LOAxis.fixedWidthDoubletoString(this.fYscale.ticks[0], this.fYscale.w + 2, this.fYscale.d)) + 3;
            } else {
                this.fXscale = this.bestScale(this.fXmin, this.fXmax, 1, this.fAxisRect.width, (int)((double)rectangle.height / d2));
                n4 = this.fFontMet.stringWidth(LOAxis.DoubletoString(this.fXscale.ticks[this.fXscale.ticks.length - 1], this.fXscale.w + 2, this.fXscale.d));
            }
            this.fAxisRect.x = n3;
            this.fAxisRect.y = n / 2;
            this.fAxisRect.width = ((Component)((Object)this)).getSize().width - n3 - n4 / 2 - 3;
            this.fAxisRect.height = ((Component)((Object)this)).getSize().height - n2 - n / 2;
            dArray = this.fXscale.ticks;
            dArray2 = this.fYscale.ticks;
            d = dArray[dArray.length - 1] - dArray[0];
            d2 = dArray2[dArray2.length - 1] - dArray2[0];
            this.fAxisRect = this.equalRect(this.fAxisRect, d, d2);
        }
        this.calcTransform();
    }

    protected void calcTransform() {
        double[] dArray = this.fXscale.ticks;
        double[] dArray2 = this.fYscale.ticks;
        double d = dArray[dArray.length - 1] - dArray[0];
        if (this.fXdirReversed) {
            this.fA11 = (double)(-this.fAxisRect.width) / d;
            this.fA13 = (double)(this.fAxisRect.x + this.fAxisRect.width) + dArray[0] * (double)this.fAxisRect.width / d;
        } else {
            this.fA11 = (double)this.fAxisRect.width / d;
            this.fA13 = (double)this.fAxisRect.x - dArray[0] * (double)this.fAxisRect.width / d;
        }
        d = dArray2[dArray2.length - 1] - dArray2[0];
        if (this.fYdirReversed) {
            this.fA22 = (double)this.fAxisRect.height / d;
            this.fA23 = (double)this.fAxisRect.y - dArray2[0] * (double)this.fAxisRect.height / d;
            return;
        }
        this.fA22 = (double)(-this.fAxisRect.height) / d;
        this.fA23 = (double)(this.fAxisRect.y + this.fAxisRect.height) + dArray2[0] * (double)this.fAxisRect.height / d;
    }

    protected int screenX(double d) {
        return (int)this.round(d * this.fA11 + this.fA13);
    }

    protected int screenY(double d) {
        return (int)this.round(d * this.fA22 + this.fA23);
    }

    private double pow10(double d) {
        return Math.pow(10.0, d);
    }

    private double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    protected double round(double d) {
        return Math.floor(d + 0.5);
    }

    private double orderOfMagnitude(double d) {
        double d2 = (d = Math.abs(d)) == 0.0 ? 1.0 : (d < 1.0 ? Math.floor(this.log10(d)) : Math.floor(this.log10(d)) + 1.0);
        return d2;
    }

    private int getPixelsPerChar(int n) {
        this.checkFontInfo();
        int n2 = n == 1 ? this.fFontMet.stringWidth("W") : this.fFontMet.getHeight();
        return n2;
    }

    protected ScaleInfo bestScale(double d, double d2, int n, int n2, int n3) {
        int n4;
        ScaleInfo scaleInfo = new ScaleInfo();
        int n5 = (int)this.orderOfMagnitude(Math.max(Math.abs(d), Math.abs(d2)));
        int n6 = this.getPixelsPerChar(n);
        double d3 = 1.0;
        if (d == d2) {
            n4 = n2;
        } else {
            d3 = this.pow10(this.round(this.log10(d2 - d) - 1.0));
            n4 = (int)((double)n5 + Math.max(0.0, -this.orderOfMagnitude(d3 * 0.1))) * n6;
        }
        if (d == d2 || n4 > n2) {
            scaleInfo.ticks = new double[2];
            scaleInfo.ticks[0] = d;
            scaleInfo.ticks[1] = d2;
            scaleInfo.d = (int)Math.max(0.0, -this.orderOfMagnitude(d2 - d));
            scaleInfo.w = n5 + scaleInfo.d;
        } else {
            double[] dArray = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0};
            int n7 = dArray.length;
            double[] dArray2 = new double[n7];
            int[] nArray = new int[n7];
            double[] dArray3 = new double[n7];
            double[] dArray4 = new double[n7];
            int[] nArray2 = new int[n7];
            int n8 = 0;
            if (n3 > 0 && (double)n4 > (d2 - d) * (double)n3) {
                double d4 = (double)(n4 / n3) - (d2 - d);
                d -= d4;
                d2 += d4;
            }
            int n9 = 0;
            while (n9 < n7) {
                double d5 = d3 * dArray[n9];
                double d6 = d5 * Math.ceil(d2 / d5);
                dArray2[n9] = d5 * Math.floor(d / d5);
                dArray3[n9] = d6 - dArray2[n9];
                nArray[n9] = (int)this.round(dArray3[n9] / d5);
                nArray2[n9] = (int)Math.max(0.0, -this.orderOfMagnitude(dArray3[n9] / (double)nArray[n9]));
                int n10 = n3 > 0 ? (int)(dArray3[n9] * (double)n3) : n2;
                int n11 = n == 1 ? (n5 + nArray2[n9] + 2) * n6 : 3 * n6;
                double d7 = (double)n11 / (double)n10;
                dArray4[n9] = (Math.abs(d - dArray2[n9]) + Math.abs(d6 - d2)) / dArray3[n9] + Math.max(0.0, d7 * (double)nArray[n9] - 1.0) + (double)Math.max(0, n10 - n2);
                ++n9;
            }
            n9 = 0;
            while (n9 < n7) {
                if (dArray4[n9] < dArray4[n8] || dArray4[n9] == dArray4[n8] && (double)nArray[n9] < dArray4[n8]) {
                    n8 = n9;
                }
                ++n9;
            }
            scaleInfo.ticks = new double[nArray[n8] + 1];
            n9 = 0;
            while (n9 <= nArray[n8]) {
                scaleInfo.ticks[n9] = dArray2[n8] + (double)n9 * dArray3[n8] / (double)nArray[n8];
                ++n9;
            }
            scaleInfo.d = nArray2[n8];
            scaleInfo.w = n5 + nArray2[n8];
        }
        return scaleInfo;
    }

    protected void drawAxis(Graphics graphics) {
        String string;
        int n;
        Dimension dimension = ((Component)((Object)this)).getSize();
        graphics.setFont(((Component)((Object)this)).getFont());
        this.calcDimensions(graphics);
        double[] dArray = this.fXscale.ticks;
        double[] dArray2 = this.fYscale.ticks;
        this.checkFontInfo();
        int n2 = this.fFontMet.getHeight();
        graphics.setColor(((Component)((Object)this)).getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(((Component)((Object)this)).getParent().getBackground());
        graphics.fillRect(0, 0, this.fAxisRect.x, this.fAxisRect.y + this.fAxisRect.height);
        graphics.fillRect(0, this.fAxisRect.y + this.fAxisRect.height, dimension.width, dimension.height - (this.fAxisRect.y + this.fAxisRect.height));
        graphics.setColor(((Component)((Object)this)).getForeground());
        int n3 = this.fAxisRect.y + this.fAxisRect.height;
        graphics.drawLine(this.fAxisRect.x, n3, this.fAxisRect.x + this.fAxisRect.width, n3);
        double d = dArray[dArray.length - 1] - dArray[0];
        int n4 = 0;
        while (n4 < dArray.length) {
            n = this.screenX(dArray[n4]);
            graphics.drawLine(n, n3, n, n3 - 4);
            string = LOAxis.DoubletoString(dArray[n4], this.fXscale.w + 2, this.fXscale.d);
            graphics.drawString(string, n -= this.fFontMet.stringWidth(string) / 2, n3 + n2);
            ++n4;
        }
        n = this.fAxisRect.y + this.fAxisRect.height;
        graphics.drawLine(this.fAxisRect.x, this.fAxisRect.y, this.fAxisRect.x, n);
        d = dArray2[dArray2.length - 1] - dArray2[0];
        n4 = 0;
        while (n4 < dArray2.length) {
            n3 = this.screenY(dArray2[n4]);
            graphics.drawLine(this.fAxisRect.x, n3, this.fAxisRect.x + 4, n3);
            string = LOAxis.DoubletoString(dArray2[n4], this.fYscale.w + 2, this.fYscale.d);
            graphics.drawString(string, this.fAxisRect.x - this.fFontMet.stringWidth(string) - 2, n3 += this.fFontMet.getAscent() / 2);
            ++n4;
        }
        graphics.drawLine(this.fAxisRect.x, this.fAxisRect.y, this.fAxisRect.x + this.fAxisRect.width, this.fAxisRect.y);
        graphics.drawLine(this.fAxisRect.x + this.fAxisRect.width, this.fAxisRect.y, this.fAxisRect.x + this.fAxisRect.width, this.fAxisRect.y + this.fAxisRect.height);
        graphics.setColor(Color.black);
    }

    public static void main(String[] stringArray) {
        try {
            new TestApp();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    protected static class ScaleInfo {
        public double[] ticks;
        public int d;
        public int w;
        public int textW;

        protected ScaleInfo() {
        }
    }

    private static class TestApp {
        public TestApp() {
            LOAxis lOAxis = new LOAxis(1.0, 15.0, 1.0, 100.0);
            Frame frame = new Frame("Test");
            frame.addWindowListener(new WindowClosing());
            frame.setLayout(new BorderLayout());
            ((Component)frame).setBounds(40, 60, 340, 280);
            frame.add((Component)((Object)lOAxis), "Center");
            ((Component)frame).setVisible(true);
        }

        private class WindowClosing
        extends WindowAdapter {
            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.dispose();
            }

            WindowClosing() {
                TestApp.this = TestApp.this;
            }
        }
    }
}

