/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.mwt.undo.UndoableEdit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;

class UndoResize
implements UndoableEdit {
    private LayoutArea fLayout;
    private LOControlWrapper fWrapper;
    private Point fStartLocation;
    private Point fFinalLocation;
    private Dimension fStartSize;
    private Dimension fFinalSize;

    UndoResize(LayoutArea layoutArea, LOControlWrapper lOControlWrapper) {
        this.fLayout = layoutArea;
        this.fWrapper = lOControlWrapper;
        this.fStartLocation = this.fWrapper.getControl().getLocation();
        this.fStartSize = this.fWrapper.getControl().getSize();
    }

    boolean resizeComplete() {
        boolean bl;
        this.fFinalLocation = this.fWrapper.getControl().getLocation();
        this.fFinalSize = this.fWrapper.getControl().getSize();
        boolean bl2 = bl = this.fStartSize.width != this.fFinalSize.width || this.fStartSize.height != this.fFinalSize.height || this.fStartLocation.x != this.fFinalLocation.x || this.fStartLocation.y != this.fFinalLocation.y;
        if (bl) {
            if (this.fStartSize.width == this.fFinalSize.width && this.fStartSize.height == this.fFinalSize.height) {
                this.fStartSize = null;
                this.fFinalSize = null;
            }
            if (this.fStartLocation.x == this.fFinalLocation.x && this.fStartLocation.y == this.fFinalLocation.y) {
                this.fStartLocation = null;
                this.fFinalLocation = null;
            }
        }
        return bl;
    }

    public void undo() {
        this.fLayout.selectAll(false);
        if (this.fStartLocation != null) {
            this.fWrapper.getControl().setLocation(this.fStartLocation);
        }
        if (this.fStartSize != null) {
            this.fWrapper.getControl().setSize(this.fStartSize);
        }
        if (this.fWrapper.getNeedsLayout()) {
            LayoutArea.forceLayout((Container)this.fWrapper.getControl());
        }
        this.fLayout.fireObjectChangedEvent(this.fWrapper);
        this.fWrapper.setSelected(true);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public void redo() {
        this.fLayout.selectAll(false);
        if (this.fFinalLocation != null) {
            this.fWrapper.getControl().setLocation(this.fFinalLocation);
        }
        if (this.fFinalSize != null) {
            this.fWrapper.getControl().setSize(this.fFinalSize);
        }
        if (this.fWrapper.getNeedsLayout()) {
            LayoutArea.forceLayout((Container)this.fWrapper.getControl());
        }
        this.fLayout.fireObjectChangedEvent(this.fWrapper);
        this.fWrapper.setSelected(true);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public String getName() {
        return "Resize";
    }
}

