/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LOWrapperOwner;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.mwt.undo.UndoableEdit;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;

class UndoReorder
implements UndoableEdit {
    private LayoutArea fLayout;
    private int fDirection;
    private Vector fLayers;

    UndoReorder(LayoutArea layoutArea, int n) {
        this.fLayout = layoutArea;
        this.fDirection = n;
        this.fLayers = new Vector();
    }

    LayoutArea getLayout() {
        return this.fLayout;
    }

    void addLayer(Vector vector) {
        LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.firstElement();
        LOWrapperOwner lOWrapperOwner = lOControlWrapper.getParent();
        if (lOWrapperOwner == null) {
            lOWrapperOwner = this.fLayout;
        }
        this.fLayers.addElement(new UndoLayerReorder(lOWrapperOwner, vector, this.fDirection));
    }

    boolean reorderComplete() {
        if (this.fLayers.isEmpty()) {
            return false;
        }
        Enumeration enumeration = this.fLayers.elements();
        while (enumeration.hasMoreElements()) {
            UndoLayerReorder undoLayerReorder = (UndoLayerReorder)enumeration.nextElement();
            undoLayerReorder.reorderComplete(this.fDirection);
        }
        this.fDirection = this.fDirection == 0 ? 1 : 0;
        return true;
    }

    public void undo() {
        this.fLayout.selectAll(false);
        Enumeration enumeration = this.fLayers.elements();
        while (enumeration.hasMoreElements()) {
            UndoLayerReorder undoLayerReorder = (UndoLayerReorder)enumeration.nextElement();
            undoLayerReorder.reorder(this.fDirection);
        }
        this.fDirection = this.fDirection == 0 ? 1 : 0;
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public void redo() {
        this.fLayout.selectAll(false);
        Enumeration enumeration = this.fLayers.elements();
        while (enumeration.hasMoreElements()) {
            UndoLayerReorder undoLayerReorder = (UndoLayerReorder)enumeration.nextElement();
            undoLayerReorder.reorder(this.fDirection);
        }
        this.fDirection = this.fDirection == 0 ? 1 : 0;
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public String getName() {
        return "Reorder";
    }

    private class UndoLayerReorder {
        private LOWrapperOwner fOwner;
        private int fWrapperCount;
        private int fDirection;
        private LOControlWrapper[] fWrappers;
        private int[] fForwardIndexs;
        private int[] fBackwardIndexs;

        UndoLayerReorder(LOWrapperOwner lOWrapperOwner, Vector vector, int n) {
            UndoReorder.this = UndoReorder.this;
            this.fOwner = lOWrapperOwner;
            this.fWrapperCount = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                if (!lOControlWrapper.isSelected()) continue;
                ++this.fWrapperCount;
            }
            this.fWrappers = new LOControlWrapper[this.fWrapperCount];
            this.fForwardIndexs = new int[this.fWrapperCount];
            this.fBackwardIndexs = new int[this.fWrapperCount];
            int n2 = 0;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                if (!lOControlWrapper.isSelected()) continue;
                this.fWrappers[n2] = lOControlWrapper;
                if (n == 0) {
                    this.fBackwardIndexs[n2] = this.fOwner.getIndexOfWrapper(this.fWrappers[n2]);
                } else if (n == 1) {
                    this.fForwardIndexs[n2] = this.fOwner.getIndexOfWrapper(this.fWrappers[n2]);
                }
                ++n2;
            }
        }

        void reorderComplete(int n) {
            if (n == 0) {
                int n2 = 0;
                while (n2 < this.fWrapperCount) {
                    this.fForwardIndexs[n2] = this.fOwner.getIndexOfWrapper(this.fWrappers[n2]);
                    ++n2;
                }
                return;
            }
            if (n == 1) {
                int n3 = 0;
                while (n3 < this.fWrapperCount) {
                    this.fBackwardIndexs[n3] = this.fOwner.getIndexOfWrapper(this.fWrappers[n3]);
                    ++n3;
                }
            }
        }

        void reorder(int n) {
            if (n == 0) {
                int n2 = this.fWrapperCount - 1;
                while (n2 >= 0) {
                    this.fOwner.removeWrapper(this.fWrappers[n2]);
                    this.fOwner.addWrapper(this.fWrappers[n2], this.fForwardIndexs[n2]);
                    this.fWrappers[n2].setSelected(true);
                    UndoReorder.this.getLayout().move(this.fWrappers[n2], this.fForwardIndexs[n2]);
                    --n2;
                }
                return;
            }
            if (n == 1) {
                int n3 = 0;
                while (n3 < this.fWrapperCount) {
                    this.fOwner.removeWrapper(this.fWrappers[n3]);
                    this.fOwner.addWrapper(this.fWrappers[n3], this.fBackwardIndexs[n3]);
                    this.fWrappers[n3].setSelected(true);
                    UndoReorder.this.getLayout().move(this.fWrappers[n3], this.fBackwardIndexs[n3]);
                    ++n3;
                }
            }
        }
    }
}

