/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LOWrapperOwner;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.mwt.undo.UndoableEdit;
import com.mathworks.services.ObjectRegistry;
import java.awt.Component;
import java.awt.Point;
import java.util.Vector;

class UndoMove
implements UndoableEdit {
    private LayoutArea fLayout;
    private int fNumWrappers;
    private LOControlWrapper[] fWrappers;
    private Point[] fStartLocations;
    private Point[] fFinalLocations;
    private Object[] fObjects;
    private LOWrapperOwner[] fStartOwners;
    private int[] fStartIndexs;
    private LOWrapperOwner[] fFinalOwners;

    UndoMove(LayoutArea layoutArea, Vector vector) {
        this.fLayout = layoutArea;
        this.fNumWrappers = vector.size();
        this.fWrappers = new LOControlWrapper[this.fNumWrappers];
        this.fStartLocations = new Point[this.fNumWrappers];
        this.fFinalLocations = new Point[this.fNumWrappers];
        this.fObjects = new Object[this.fNumWrappers];
        this.fStartOwners = new LOWrapperOwner[this.fNumWrappers];
        this.fStartIndexs = new int[this.fNumWrappers];
        this.fFinalOwners = new LOWrapperOwner[this.fNumWrappers];
        int n = 0;
        while (n < this.fNumWrappers) {
            this.fWrappers[n] = (LOControlWrapper)vector.elementAt(n);
            this.fStartLocations[n] = this.fWrappers[n].getControl().getLocation();
            this.fObjects[n] = this.fWrappers[n].getBean();
            this.fStartOwners[n] = this.fWrappers[n].getParent();
            if (this.fStartOwners[n] == null) {
                this.fStartOwners[n] = this.fLayout;
            }
            this.fStartIndexs[n] = this.fStartOwners[n].getIndexOfWrapper(this.fWrappers[n]);
            ++n;
        }
    }

    boolean moveComplete() {
        boolean bl = false;
        int n = 0;
        while (n < this.fNumWrappers) {
            this.fFinalLocations[n] = this.fWrappers[n].getControl().getLocation();
            this.fFinalOwners[n] = this.fWrappers[n].getParent();
            if (this.fFinalOwners[n] == null) {
                this.fFinalOwners[n] = this.fLayout;
            }
            if (this.fStartLocations[n].x != this.fFinalLocations[n].x || this.fStartLocations[n].y != this.fFinalLocations[n].y || this.fStartOwners[n] != this.fFinalOwners[n]) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void undo() {
        this.fLayout.selectAll(false);
        int n = 0;
        while (n < this.fNumWrappers) {
            if (this.fFinalOwners[n] != this.fStartOwners[n]) {
                this.fFinalOwners[n].removeWrapper(this.fWrappers[n]);
                this.fStartOwners[n].addWrapper(this.fWrappers[n], this.fStartIndexs[n]);
            }
            this.fWrappers[n].getControl().setLocation(this.fStartLocations[n]);
            this.fWrappers[n].setSelected(true);
            ++n;
        }
        ObjectRegistry.getLayoutRegistry().change(this.fObjects);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public void redo() {
        this.fLayout.selectAll(false);
        int n = 0;
        while (n < this.fNumWrappers) {
            if (this.fFinalOwners[n] != this.fStartOwners[n]) {
                this.fStartOwners[n].removeWrapper(this.fWrappers[n]);
                this.fFinalOwners[n].addWrapper(this.fWrappers[n], -1);
            }
            this.fWrappers[n].getControl().setLocation(this.fFinalLocations[n]);
            this.fWrappers[n].setSelected(true);
            ++n;
        }
        ObjectRegistry.getLayoutRegistry().change(this.fObjects);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public String getName() {
        return "Move";
    }
}

