/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LOGlueWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.mwt.undo.UndoableEdit;
import java.awt.Component;
import java.util.Vector;

class UndoConnect
implements UndoableEdit {
    private LayoutArea fLayout;
    private int fNumWrappers;
    private LOGlueWrapper[] fWrappers;
    private int[] fIndexs;
    private boolean fIsConnected;

    UndoConnect(LayoutArea layoutArea, boolean bl, Vector vector) {
        this.fLayout = layoutArea;
        this.fIsConnected = bl;
        this.fNumWrappers = vector.size();
        this.fWrappers = new LOGlueWrapper[this.fNumWrappers];
        this.fIndexs = new int[this.fNumWrappers];
        int n = 0;
        while (n < this.fNumWrappers) {
            this.fWrappers[n] = (LOGlueWrapper)vector.elementAt(n);
            this.fIndexs[n] = this.fLayout.getIndexOfWrapper(this.fWrappers[n]);
            ++n;
        }
    }

    public void undo() {
        this.toggleConnection();
    }

    public void redo() {
        this.toggleConnection();
    }

    public String getName() {
        return "Connect";
    }

    private void toggleConnection() {
        this.fLayout.selectAll(false);
        if (this.fIsConnected) {
            this.disconnect();
        } else {
            this.reconnect();
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    private void reconnect() {
        int n = 0;
        while (n < this.fNumWrappers) {
            this.fLayout.addWrapper(this.fWrappers[n], this.fIndexs[n]);
            this.fWrappers[n].reconnect();
            ++n;
        }
        this.fIsConnected = true;
    }

    private void disconnect() {
        int n = 0;
        while (n < this.fNumWrappers) {
            this.fLayout.removeWrapper(this.fWrappers[n]);
            this.fWrappers[n].disconnect();
            ++n;
        }
        this.fIsConnected = false;
    }
}

