/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LOGlueWrapper;
import com.mathworks.ide.layout.LOWrapperOwner;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.mwt.undo.UndoableEdit;
import java.awt.Component;
import java.util.Vector;

class UndoAdd
implements UndoableEdit {
    private LayoutArea fLayout;
    private int fWrapperCount;
    private LOControlWrapper[] fWrappers;
    private LOWrapperOwner[] fOwners;

    UndoAdd(LayoutArea layoutArea, Vector vector) {
        this.fLayout = layoutArea;
        this.fWrapperCount = vector.size();
        this.fWrappers = new LOControlWrapper[this.fWrapperCount];
        this.fOwners = new LOWrapperOwner[this.fWrapperCount];
        int n = 0;
        while (n < this.fWrapperCount) {
            this.fWrappers[n] = (LOControlWrapper)vector.elementAt(n);
            this.fOwners[n] = this.fWrappers[n].getParent();
            if (this.fOwners[n] == null) {
                this.fOwners[n] = this.fLayout;
            }
            ++n;
        }
    }

    public void undo() {
        this.fLayout.selectAll(false);
        int n = 0;
        while (n < this.fWrapperCount) {
            if (this.fWrappers[n].getControlType() == 28) {
                ((LOGlueWrapper)this.fWrappers[n]).disconnect();
                this.fLayout.removeWrapper(this.fWrappers[n]);
            } else {
                this.fLayout.removeServices(this.fWrappers[n]);
                this.fLayout.unregister(this.fWrappers[n]);
                this.fOwners[n].removeWrapper(this.fWrappers[n]);
            }
            ++n;
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public void redo() {
        this.fLayout.selectAll(false);
        int n = 0;
        while (n < this.fWrapperCount) {
            if (this.fWrappers[n].getControlType() == 28) {
                this.fLayout.addWrapper(this.fWrappers[n], -1);
                ((LOGlueWrapper)this.fWrappers[n]).reconnect();
            } else {
                this.fOwners[n].addWrapper(this.fWrappers[n], -1);
                this.fLayout.register(this.fWrappers[n]);
                this.fLayout.addServices(this.fWrappers[n]);
                this.fWrappers[n].setSelected(true);
            }
            ++n;
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        ((Component)((Object)this.fLayout)).repaint(5L);
    }

    public String getName() {
        return "Add";
    }
}

