/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.ClassBeanFactory;
import com.mathworks.ide.layout.ControlFactory;
import com.mathworks.ide.layout.GObjectFactory;
import com.mathworks.ide.layout.JarBeanFactory;
import com.mathworks.ide.layout.LayoutEditor;
import com.mathworks.ide.layout.ObjectFactory;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.util.IntHashtable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.jarloader.JarInfo;
import com.mathworks.util.jarloader.JarLoader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ToolRegistry {
    static final String STANDARD_NAME = "Standard";
    private static final String STANDARD_ICON_PATH = "/com/mathworks/ide/layout/lowidgets/resources/";
    private static final String ICON_SUFFIX = "icon.gif";
    private static final int[] STANDARD_ID_VALUES = new int[]{9, 10, 11, 12, 15, 22, 16, 13, 14, 18, 17, 19, 64, 21, 20, 66};
    private static final String[] STANDARD_NAMES = new String[]{"Push Button", "Toggle Button", "Checkbox", "Radio Button", "Text Area", "Text Field", "Label", "Listbox", "Scrollbar", "Popup Menu", "Groupbox", "Tab Panel", "Card Panel", "Combobox", "Tree View", "Table"};
    private static final String[] STANDARD_ICON_NAMES = new String[]{"/com/mathworks/ide/layout/lowidgets/resources/buttonicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/togglebuttonicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/checkboxicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/radiobuttonicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/edittexticon.gif", "/com/mathworks/ide/layout/lowidgets/resources/textfieldicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/texticon.gif", "/com/mathworks/ide/layout/lowidgets/resources/listboxicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/scrollbaricon.gif", "/com/mathworks/ide/layout/lowidgets/resources/popupmenuicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/panelicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/tabpanelicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/cardpanelicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/comboboxicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/treeviewicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/tableicon.gif"};
    private static final String EXTRAS_NAME = "Special";
    private static final String EXTRAS_ICON_PATH = "lowidgets/resources/";
    private static final int[] EXTRAS_ID_VALUES = new int[]{67, 68};
    private static final String[] EXTRAS_NAMES = new String[]{"Array View", "TeX View"};
    private static final String[] EXTRAS_ICON_NAMES = new String[]{"/com/mathworks/ide/layout/lowidgets/resources/arrayviewicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/texviewicon.gif"};
    private static final String SPECIAL_ICON_PATH = "/com/mathworks/ide/resources/";
    private static final int[] SPECIAL_ID_VALUES;
    private static final int[] SELECT_ONLY_VALUES;
    private static final String[] SPECIAL_NAMES;
    private static final String[] SPECIAL_ICON_NAMES;
    private static final String UICONTROL_NAME = "UIControl";
    private static final int[] UICONTROL_STYLES;
    private static final String[] UICONTROL_NAMES;
    private static final String[] UICONTROL_STRINGS;
    private static final String[] UICONTROL_ICON_NAMES;
    private static boolean sDebug;
    private static IntHashtable sFactoryTable;
    private static int sNextID;
    private static Hashtable sJarTable;
    private static Hashtable sUIControlTable;
    private Hashtable fToolTable;
    private String fName;

    private static synchronized void initToolRegistry() {
        ToolRegistry.buildStandardFactories(STANDARD_ID_VALUES, STANDARD_NAMES, STANDARD_ICON_NAMES);
        ToolRegistry.buildStandardFactories(EXTRAS_ID_VALUES, EXTRAS_NAMES, EXTRAS_ICON_NAMES);
        ToolRegistry.buildStandardFactories(SPECIAL_ID_VALUES, SPECIAL_NAMES, SPECIAL_ICON_NAMES);
        sJarTable = null;
        sJarTable = ToolRegistry.buildJarTable();
        if (sJarTable == null) {
            sJarTable = new Hashtable(1);
        }
        sJarTable.put(STANDARD_NAME.toLowerCase(), STANDARD_ID_VALUES);
        sJarTable.put(EXTRAS_NAME.toLowerCase(), EXTRAS_ID_VALUES);
        int[] nArray = ToolRegistry.buildUIControlPage(UICONTROL_NAMES, UICONTROL_ICON_NAMES, UICONTROL_STYLES, UICONTROL_STRINGS);
        sUIControlTable = new Hashtable(1);
        sUIControlTable.put(UICONTROL_NAME.toLowerCase(), nArray);
    }

    private static Hashtable buildJarTable() {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        String[] stringArray;
        ToolRegistry.debug("Starting to search for tool pages...");
        File file = null;
        String string = System.getProperty("java.class.path");
        int n = string.indexOf("ide.jar");
        if (n != -1) {
            ToolRegistry.debug("Found ide.jar in class path.");
            stringArray = System.getProperty("path.separator");
            int n2 = string.lastIndexOf((String)stringArray, n);
            if (n2 + 1 < n - 1) {
                ToolRegistry.debug("Extracting full path of ide.jar.");
                object3 = string.substring(n2 + 1, n - 1);
                if (PlatformInfo.getPlatform() == 1) {
                    object3 = ((String)object3).replace('/', '\\');
                }
                serializable = new File((String)object3);
                ToolRegistry.debug("   jar dir: " + serializable);
                String string2 = ((File)serializable).getParent();
                if (string2 != null) {
                    object2 = new File(string2);
                    ToolRegistry.debug("  java dir: " + object2);
                    file = new File((File)object2, "beans");
                    ToolRegistry.debug("  bean dir: " + file);
                } else {
                    ToolRegistry.debug("jar directory has no parent.");
                }
            } else {
                ToolRegistry.debug("This isn't the ide.jar I'm looking for...");
            }
        } else {
            ToolRegistry.debug("Did not find ide.jar in class path.");
        }
        if (file == null || !file.isDirectory()) {
            ToolRegistry.debug("Looking in the user directory.");
            stringArray = System.getProperty("user.dir");
            File file2 = new File((String)stringArray);
            ToolRegistry.debug("  user dir: " + file2);
            object3 = new File(file2, "java");
            ToolRegistry.debug("  java dir: " + object3);
            if (((File)object3).isDirectory()) {
                file = new File((File)object3, "beans");
                ToolRegistry.debug("  bean dir: " + file);
            }
        }
        if (file == null || !file.isDirectory()) {
            ToolRegistry.debug("Looking for the Tools directory.");
            stringArray = System.getProperty("user.dir");
            File file3 = new File((String)stringArray);
            file = new File(file3, "Tools");
            ToolRegistry.debug("  bean dir: " + file);
        }
        if (file == null || !file.isDirectory()) {
            ToolRegistry.debug(String.valueOf(file) + " is not a directory.");
            ToolRegistry.debug("Giving up.");
            return null;
        }
        ToolRegistry.debug("Looking for jar files in " + file);
        stringArray = file.list(new FileExtension(".jar"));
        if (stringArray.length == 0) {
            ToolRegistry.debug("No lower-case .jar extensions found.");
            stringArray = file.list(new FileExtension(".JAR"));
            if (stringArray.length == 0) {
                ToolRegistry.debug("No upper-case .JAR extensions found.");
            } else {
                ToolRegistry.debug("Found " + stringArray.length + " jar file(s).");
            }
        } else {
            ToolRegistry.debug("Found " + stringArray.length + " jar file(s).");
        }
        ToolRegistry.debug("Looking for list files in " + file + ".");
        String[] stringArray2 = file.list(new FileExtension(".list"));
        if (stringArray2.length == 0) {
            ToolRegistry.debug("No .list extensions found.");
        } else {
            ToolRegistry.debug("Found " + stringArray2.length + " list file(s).");
        }
        int n3 = stringArray.length + stringArray2.length;
        if (n3 == 0) {
            ToolRegistry.debug("Giving up.");
            return null;
        }
        serializable = new Hashtable(stringArray.length + stringArray2.length + 1);
        if (stringArray.length > 0) {
            int n4 = 0;
            while (n4 < stringArray.length) {
                object2 = String.valueOf(file.getPath()) + File.separatorChar + stringArray[n4];
                ToolRegistry.debug(object2);
                object = ToolRegistry.buildJarInfo((String)object2);
                if (object != null) {
                    String string3 = stringArray[n4].substring(0, stringArray[n4].length() - 4);
                    ((Hashtable)serializable).put(string3.toLowerCase(), object);
                }
                ++n4;
            }
        }
        if (stringArray2.length > 0) {
            int n5 = 0;
            while (n5 < stringArray2.length) {
                object2 = String.valueOf(file.getPath()) + File.separatorChar + stringArray2[n5];
                ToolRegistry.debug(object2);
                object = stringArray2[n5].substring(0, stringArray2[n5].length() - 5);
                ((Hashtable)serializable).put(((String)object).toLowerCase(), object2);
                ++n5;
            }
        }
        ToolRegistry.debug("Tool pages completed.");
        return serializable;
    }

    private static JarInfo buildJarInfo(String string) {
        ToolRegistry.debug("  loading " + string);
        JarInfo jarInfo = null;
        try {
            JarLoader jarLoader = new JarLoader(string);
            jarInfo = jarLoader.loadJar();
            if (jarInfo == null) {
                Object[] objectArray = new Object[]{string};
                String string2 = MessageFormat.format(LayoutEditor.sLayoutBundle.getString("error.file_did_not_load"), objectArray);
                System.out.println(string2);
            } else if (jarInfo.getCount() == 0) {
                Object[] objectArray = new Object[]{string};
                String string3 = MessageFormat.format(LayoutEditor.sLayoutBundle.getString("error.file_contains_no_beans"), objectArray);
                System.out.println(string3);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            String string4 = MessageFormat.format(LayoutEditor.sLayoutBundle.getString("error.file_caused_exceptions"), objectArray);
            System.out.println(string4);
            System.out.println("    " + exception);
        }
        return jarInfo;
    }

    private static Class[] buildClassList(String string) {
        ToolRegistry.debug("  reading " + string);
        Class[] classArray = null;
        try {
            FileReader fileReader = new FileReader(string);
            char[] cArray = new char[1024];
            String string2 = new String("");
            int n = 0;
            while (n != -1) {
                n = fileReader.read(cArray);
                if (n == -1) continue;
                string2 = String.valueOf(string2) + new String(cArray, 0, n);
            }
            if (string2.length() > 0) {
                Object object;
                int n2;
                String string3 = System.getProperty("line.separator");
                if (string2.indexOf(string3) == -1) {
                    ToolRegistry.debug("No line separators found, assume UNIX newlines.");
                    string3 = "\n";
                }
                int n3 = 0;
                Vector<Object> vector = new Vector<Object>(10);
                int n4 = 1;
                while ((n2 = string2.indexOf(string3, n3)) != -1) {
                    object = string2.substring(n3, n2).trim();
                    ToolRegistry.debug("Line " + n4 + ": " + (String)object);
                    if (!((String)object).startsWith("#") && ((String)object).length() > 0) {
                        vector.addElement(object);
                    }
                    n3 = n2 + 1;
                    ++n4;
                }
                if (n3 < string2.length()) {
                    object = string2.substring(n3).trim();
                    ToolRegistry.debug("Line " + n4 + " (w/o CR): " + (String)object);
                    if (!((String)object).startsWith("#") && ((String)object).length() > 0) {
                        vector.addElement(object);
                    }
                }
                if (vector.size() > 0) {
                    Class[] classArray2;
                    classArray = new Class[vector.size()];
                    object = vector.elements();
                    int n5 = 0;
                    while (object.hasMoreElements()) {
                        classArray2 = (Class[])object.nextElement();
                        ToolRegistry.debug("looking for: " + (String)classArray2);
                        try {
                            classArray[n5] = Class.forName((String)classArray2);
                            ++n5;
                        }
                        catch (Exception exception) {
                            Object[] objectArray = new Object[]{string};
                            String string4 = MessageFormat.format(LayoutEditor.sLayoutBundle.getString("error.file_caused_exceptions"), objectArray);
                            System.out.println(string4);
                            System.out.println("    " + exception);
                        }
                    }
                    if (n5 < classArray.length) {
                        classArray2 = classArray;
                        classArray = new Class[n5];
                        System.arraycopy(classArray2, 0, classArray, 0, n5);
                        classArray2 = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            classArray = null;
            Object[] objectArray = new Object[]{string};
            String string5 = MessageFormat.format(LayoutEditor.sLayoutBundle.getString("error.file_caused_exceptions"), objectArray);
            System.out.println(string5);
            System.out.println("    " + exception);
        }
        return classArray;
    }

    static void buildStandardFactories(int[] nArray, String[] stringArray, String[] stringArray2) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            sFactoryTable.put(nArray[n2], (Object)new ControlFactory(nArray[n2], stringArray[n2], stringArray2[n2]));
            ++n2;
        }
    }

    static int[] buildUIControlPage(String[] stringArray, String[] stringArray2, int[] nArray, String[] stringArray3) {
        int n = stringArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            ++sNextID;
            sFactoryTable.put(nArray2[n2], (Object)new GObjectFactory(stringArray[n2], stringArray2[n2], nArray[n2], stringArray3[n2]));
            ++n2;
        }
        return nArray2;
    }

    static int[] buildPage(JarInfo jarInfo) {
        int n = jarInfo.getCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            ++sNextID;
            sFactoryTable.put(nArray[n2], (Object)new JarBeanFactory(jarInfo, n2));
            ++n2;
        }
        return nArray;
    }

    static int[] buildPage(Class[] classArray) {
        int n = classArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            ++sNextID;
            sFactoryTable.put(nArray[n2], (Object)new ClassBeanFactory(classArray[n2]));
            ++n2;
        }
        return nArray;
    }

    static Object buildObject(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.buildObject();
        }
        return null;
    }

    static String getName(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.getName();
        }
        return "";
    }

    static MWImageResource getImageResource(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.getImageResource();
        }
        return null;
    }

    static int getType(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.getType();
        }
        return 0;
    }

    static int[] getSpecialPage(boolean bl) {
        if (bl) {
            return SPECIAL_ID_VALUES;
        }
        return SELECT_ONLY_VALUES;
    }

    private ToolRegistry(Hashtable hashtable, String string) {
        this.fToolTable = hashtable;
        this.fName = string;
    }

    int[] getDefaultPage() {
        return this.getPage(this.fName);
    }

    synchronized int[] getPage(String string) {
        Object v = this.fToolTable.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof int[]) {
            return (int[])v;
        }
        if (v instanceof JarInfo) {
            JarInfo jarInfo = (JarInfo)v;
            int[] nArray = ToolRegistry.buildPage(jarInfo);
            if (nArray == null) {
                this.fToolTable.remove(string);
                return null;
            }
            this.fToolTable.put(string, nArray);
            return nArray;
        }
        if (v instanceof String) {
            String string2 = (String)v;
            if (string2.endsWith(".jar")) {
                JarInfo jarInfo = ToolRegistry.buildJarInfo(string2);
                if (jarInfo == null) {
                    this.fToolTable.remove(string);
                    return null;
                }
                int[] nArray = ToolRegistry.buildPage(jarInfo);
                if (nArray == null) {
                    this.fToolTable.remove(string);
                    return null;
                }
                this.fToolTable.put(string, nArray);
                return nArray;
            }
            if (string2.endsWith(".list")) {
                Class[] classArray = ToolRegistry.buildClassList(string2);
                if (classArray == null) {
                    this.fToolTable.remove(string);
                    return null;
                }
                int[] nArray = ToolRegistry.buildPage(classArray);
                if (nArray == null) {
                    this.fToolTable.remove(string);
                    return null;
                }
                this.fToolTable.put(string, nArray);
                return nArray;
            }
        }
        return null;
    }

    int getPageCount() {
        return this.fToolTable.size();
    }

    Enumeration pages() {
        return this.fToolTable.keys();
    }

    static ToolRegistry getStandardToolRegistry() {
        return new ToolRegistry(sJarTable, STANDARD_NAME.toLowerCase());
    }

    static ToolRegistry getUIControlToolRegistry() {
        return new ToolRegistry(sUIControlTable, UICONTROL_NAME.toLowerCase());
    }

    private static void debug(Object object) {
        if (sDebug) {
            System.out.println(object);
        }
    }

    public static void main(String[] stringArray) {
        sDebug = true;
        ToolRegistry.initToolRegistry();
        sDebug = false;
    }

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        SPECIAL_ID_VALUES = nArray;
        SELECT_ONLY_VALUES = new int[1];
        SPECIAL_NAMES = new String[]{LayoutEditor.sLayoutBundle.getString("label.select"), LayoutEditor.sLayoutBundle.getString("label.connect")};
        SPECIAL_ICON_NAMES = new String[]{"/com/mathworks/ide/resources/selecticon.gif", "/com/mathworks/ide/resources/handicon.gif"};
        int[] nArray2 = new int[11];
        nArray2[1] = 9;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 1;
        nArray2[7] = 6;
        nArray2[8] = 8;
        nArray2[9] = 7;
        nArray2[10] = 10;
        UICONTROL_STYLES = nArray2;
        UICONTROL_NAMES = new String[]{LayoutEditor.sLayoutBundle.getString("uicontrol.push_button"), LayoutEditor.sLayoutBundle.getString("uicontrol.toggle_button"), LayoutEditor.sLayoutBundle.getString("uicontrol.radio_button"), LayoutEditor.sLayoutBundle.getString("uicontrol.checkbox"), LayoutEditor.sLayoutBundle.getString("uicontrol.edit_text"), LayoutEditor.sLayoutBundle.getString("uicontrol.static_text"), LayoutEditor.sLayoutBundle.getString("uicontrol.slider"), LayoutEditor.sLayoutBundle.getString("uicontrol.frame"), LayoutEditor.sLayoutBundle.getString("uicontrol.listbox"), LayoutEditor.sLayoutBundle.getString("uicontrol.popupmenu"), LayoutEditor.sLayoutBundle.getString("uicontrol.axes")};
        UICONTROL_STRINGS = new String[]{LayoutEditor.sLayoutBundle.getString("uicontrol.push_button"), LayoutEditor.sLayoutBundle.getString("uicontrol.toggle_button"), LayoutEditor.sLayoutBundle.getString("uicontrol.radio_button"), LayoutEditor.sLayoutBundle.getString("uicontrol.checkbox"), LayoutEditor.sLayoutBundle.getString("uicontrol.edit_text"), LayoutEditor.sLayoutBundle.getString("uicontrol.static_text"), null, null, LayoutEditor.sLayoutBundle.getString("uicontrol.listbox"), LayoutEditor.sLayoutBundle.getString("uicontrol.popupmenu"), null};
        UICONTROL_ICON_NAMES = new String[]{"/com/mathworks/ide/layout/lowidgets/resources/buttonicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/togglebuttonicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/radiobuttonicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/checkboxicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/edittexticon.gif", "/com/mathworks/ide/layout/lowidgets/resources/texticon.gif", "/com/mathworks/ide/layout/lowidgets/resources/scrollbaricon.gif", "/com/mathworks/ide/layout/lowidgets/resources/panelicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/listboxicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/popupmenuicon.gif", "/com/mathworks/ide/layout/lowidgets/resources/axesicon.gif"};
        sFactoryTable = new IntHashtable(32);
        sNextID = 4096;
        ToolRegistry.initToolRegistry();
    }

    private static class FileExtension
    implements FilenameFilter {
        private String extension;

        FileExtension(String string) {
            this.extension = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith(this.extension);
        }
    }
}

