/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.LayoutEditor;
import com.mathworks.ide.layout.ToolRegistry;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWDragListener;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTab;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QSortAlgorithm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.util.Enumeration;
import java.util.Hashtable;

class ToolPalette
extends MWPanel {
    static final int SELECT_TOOL = 0;
    static final int CONNECT_TOOL = 1;
    private static final String STANDARD_KEY = "standard";
    private static final String TOP_ICON_PATH = "/com/mathworks/ide/resources/";
    private ToolRegistry fToolRegistry;
    private ToolPage fCurrentPage;
    private MWPanel fPageHolder;
    private Hashtable fPanelTable;
    private boolean fFixedWidth = true;
    private int fStandardWidth;
    private boolean fShowConnect;
    private boolean fShowNames;
    private MWTab fTabs;
    private LayoutArea fLayoutArea;
    static /* synthetic */ Class class$com$mathworks$mwt$MWCanvas;
    static /* synthetic */ Class class$com$mathworks$mwt$MWPanel;
    static /* synthetic */ Class class$java$awt$Component;

    ToolPalette(ToolRegistry toolRegistry, boolean bl, boolean bl2, LayoutArea layoutArea) {
        this.fToolRegistry = toolRegistry;
        this.fShowConnect = bl;
        this.fShowNames = bl2;
        this.fLayoutArea = layoutArea;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setOpaque(false);
        if (PlatformInfo.getAppearance() != 2) {
            MWCanvas mWCanvas = new MWCanvas();
            mWCanvas.setBackground(Color.black);
            mWCanvas.setPreferredSize(new Dimension(1, 0));
            ((Container)((Object)this)).add((Component)mWCanvas, "East");
        }
        this.fPageHolder = new PagePanel();
        this.fPageHolder.add((Component)new MWCanvas(), "Center");
        ((Container)((Object)this)).add((Component)this.fPageHolder, "Center");
        this.buildDefaultPanel();
        if (this.fToolRegistry.getPageCount() > 1) {
            this.buildTabs();
            this.fPanelTable = new Hashtable(this.fToolRegistry.getPageCount());
            this.fPanelTable.put(STANDARD_KEY, this.fCurrentPage);
        }
    }

    private void buildTabs() {
        String string;
        int n = this.fToolRegistry.getPageCount();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.fToolRegistry.pages();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, string.length());
            stringArray[n2++] = string;
        }
        if (stringArray.length > 1) {
            string = new QSortAlgorithm();
            string.sort(stringArray);
            int n3 = 0;
            while (!stringArray[n3].equals("Standard")) {
                ++n3;
            }
            if (n3 != 0) {
                System.arraycopy(stringArray, 0, stringArray, 1, n3);
                stringArray[0] = "Standard";
            }
        }
        this.fTabs = new MWTab(2, 2);
        this.fTabs.setSelectedTabColor(9);
        int n4 = 0;
        while (n4 < stringArray.length) {
            this.fTabs.add(stringArray[n4]);
            ++n4;
        }
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new BorderLayout());
        mWPanel.setInsets(new Insets(0, 1, 0, 0));
        mWPanel.setOpaque(false);
        mWPanel.add((Component)this.fTabs, "Center");
        ((Container)((Object)this)).add((Component)mWPanel, "West");
        this.fTabs.addItemListener((ItemListener)new ToolPageChanged());
    }

    private void buildDefaultPanel() {
        int[] nArray = this.fToolRegistry.getDefaultPage();
        this.fCurrentPage = new ToolPage(nArray, this.fShowConnect, this.fShowNames, this.fLayoutArea);
        this.fPageHolder.add((Component)((Object)this.fCurrentPage), "North");
    }

    public Dimension getPreferredSize() {
        if (this.fFixedWidth) {
            if (this.fStandardWidth == 0) {
                Dimension dimension = super.getPreferredSize();
                this.fStandardWidth = dimension.width;
                return dimension;
            }
            return new Dimension(this.fStandardWidth, super.getPreferredSize().height);
        }
        return super.getPreferredSize();
    }

    private void setFixedWidth(boolean bl) {
        this.fFixedWidth = bl;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    final int getSelectedButtonIndex() {
        return this.fCurrentPage.getToolID();
    }

    void resetToSelectTool() {
        this.fCurrentPage.initialState();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ToolPalette.enableComponents((Container)((Object)this), bl);
    }

    private static void enableComponents(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                ToolPalette.enableComponents((Container)componentArray[n], bl);
            } else {
                componentArray[n].setEnabled(bl);
            }
            ++n;
        }
    }

    synchronized void changePanel(String string) {
        Object object;
        String string2 = string.toLowerCase();
        ToolPage toolPage = null;
        toolPage = (ToolPage)this.fPanelTable.get(string2);
        if (toolPage == null) {
            object = this.fToolRegistry.getPage(string2);
            if (object == null) {
                return;
            }
            toolPage = new ToolPage((int[])object, this.fShowConnect, this.fShowNames, this.fLayoutArea);
            this.fPanelTable.put(string2, toolPage);
        }
        this.fPageHolder.remove((Component)((Object)this.fCurrentPage));
        this.fCurrentPage.initialState();
        this.fCurrentPage = toolPage;
        this.fPageHolder.add((Component)((Object)this.fCurrentPage), "North");
        if (this.fTabs != null) {
            this.fTabs.select(string);
        }
        if ((object = (Object)((Component)((Object)this)).getParent()) != null) {
            this.fPageHolder.invalidate();
            object.validate();
            object.repaint();
        }
    }

    public static void main(String[] stringArray) {
        try {
            ResizeFrame resizeFrame = new ResizeFrame(LayoutEditor.sLayoutBundle.getString("frame.tools"));
            ToolPalette toolPalette = new ToolPalette(ToolRegistry.getStandardToolRegistry(), true, true, null);
            toolPalette.setFixedWidth(false);
            resizeFrame.setLayout(new BorderLayout());
            ((Component)((Object)resizeFrame)).setLocation(20, 40);
            ((Window)((Object)resizeFrame)).addWindowListener(new WindowClosing());
            ((Container)((Object)resizeFrame)).add((Component)((Object)toolPalette), "Center");
            resizeFrame.setContentSize(toolPalette.getPreferredSize());
            ((Frame)((Object)resizeFrame)).setResizable(false);
            ((Component)((Object)resizeFrame)).setVisible(true);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PagePanel
    extends MWPanel {
        PagePanel() {
            super((LayoutManager)new BorderLayout());
            this.setInsets(new Insets(3, 3, 3, 3));
            this.setOpaque(false);
            this.setOpaqueInsets(false);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Dimension dimension = ((Component)((Object)this)).getSize();
            Insets insets = this.getInsets();
            graphics.setColor(Decorations.getColor((int)7));
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 1, 0, dimension.height - 1);
            graphics.setColor(Decorations.getColor((int)9));
            graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 2);
            graphics.setColor(((Component)((Object)this)).getBackground());
            graphics.fillRect(1, 1, dimension.width - 2, insets.top - 1);
            graphics.fillRect(1, 1, insets.left - 1, dimension.height - 2);
            graphics.fillRect(dimension.width - insets.right, 1, insets.right - 1, dimension.height - 2);
            graphics.fillRect(1, dimension.height - insets.bottom, dimension.width - 2, insets.bottom - 1);
        }
    }

    private static class ToolPage
    extends MWPanel
    implements ItemListener {
        private int fCurrentID;
        private MWExclusiveGroup fToolButtonGroup;
        private int[] fToolInfo;

        ToolPage(int[] nArray, boolean bl, boolean bl2, LayoutArea layoutArea) {
            ((Container)((Object)this)).setLayout(new ToolLayout());
            this.setOpaque(false);
            this.fToolInfo = nArray;
            this.fToolButtonGroup = new MWExclusiveGroup();
            boolean bl3 = true;
            boolean bl4 = nArray.length != 0;
            ToolDragger toolDragger = new ToolDragger(layoutArea);
            if (bl3) {
                if (bl2) {
                    ((Container)((Object)this)).add((Component)((Object)new OldToolPanel(ToolRegistry.getSpecialPage(bl), this.fToolButtonGroup, this, null)));
                } else {
                    ((Container)((Object)this)).add((Component)((Object)new ToolPanel(ToolRegistry.getSpecialPage(bl), this.fToolButtonGroup, this, null)));
                }
            }
            if (bl3 && bl4) {
                ((Container)((Object)this)).add((Component)((Object)new Spacer()));
            }
            if (bl4) {
                if (bl2) {
                    ((Container)((Object)this)).add((Component)((Object)new OldToolPanel(nArray, this.fToolButtonGroup, this, toolDragger)));
                } else {
                    ((Container)((Object)this)).add((Component)((Object)new ToolPanel(nArray, this.fToolButtonGroup, this, toolDragger)));
                }
            }
            this.initialState();
        }

        int getToolID() {
            return this.fCurrentID;
        }

        private static ToolButton findButton(Container container, int n) {
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                ToolButton toolButton;
                if (componentArray[n2] instanceof Container ? (toolButton = ToolPage.findButton((Container)componentArray[n2], n)) != null : componentArray[n2] instanceof ToolButton && (toolButton = (ToolButton)((Object)componentArray[n2])).getID() == n) {
                    return toolButton;
                }
                ++n2;
            }
            return null;
        }

        void initialState() {
            ToolButton toolButton = ToolPage.findButton((Container)((Object)this), 0);
            if (toolButton != null) {
                toolButton.setState(true);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                ToolButton toolButton = (ToolButton)((Object)itemEvent.getSource());
                this.fCurrentID = toolButton.getID();
            }
        }

        private static class ToolPanel
        extends MWPanel {
            private static int kColumnCount = 2;
            private static int kMargin;

            ToolPanel(int[] nArray, MWExclusiveGroup mWExclusiveGroup, ItemListener itemListener, MWDragListener mWDragListener) {
                ((Container)((Object)this)).setLayout(new ColumnLayout(kColumnCount, kMargin));
                this.setOpaque(false);
                int n = 0;
                while (n < nArray.length) {
                    MWImageResource mWImageResource = ToolRegistry.getImageResource(nArray[n]);
                    ToolButton toolButton = new ToolButton(mWImageResource, mWExclusiveGroup, nArray[n]);
                    toolButton.addItemListener(itemListener);
                    if (mWDragListener != null) {
                        try {
                            toolButton.addDragListener(mWDragListener);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    ((Container)((Object)this)).add((Component)((Object)toolButton));
                    String string = ToolRegistry.getName(nArray[n]);
                    new MWToolTip((Component)((Object)toolButton), string);
                    ((Component)((Object)toolButton)).setName(string);
                    ++n;
                }
                if ((((Container)((Object)this)).getComponentCount() & 1) != 0) {
                    ((Container)((Object)this)).add((Component)((Object)new Spacer()));
                }
            }

            private static class ColumnLayout
            implements LayoutManager {
                private int fColumns;
                private int fMargin;

                ColumnLayout(int n, int n2) {
                    this.fColumns = n;
                    this.fMargin = n2;
                }

                public void addLayoutComponent(String string, Component component) {
                }

                public void removeLayoutComponent(Component component) {
                }

                public Dimension preferredLayoutSize(Container container) {
                    Dimension dimension = new Dimension(0, 0);
                    int n = container.getComponentCount();
                    if (n > 0) {
                        Component component = container.getComponent(0);
                        Dimension dimension2 = component.getPreferredSize();
                        dimension.width = this.fMargin + this.fColumns * (dimension2.width + this.fMargin);
                        int n2 = n % this.fColumns == 0 ? 0 : 1;
                        int n3 = n / this.fColumns + n2;
                        dimension.height = this.fMargin + n3 * (dimension2.height + this.fMargin);
                    }
                    return dimension;
                }

                public Dimension minimumLayoutSize(Container container) {
                    Dimension dimension = new Dimension(0, 0);
                    int n = container.getComponentCount();
                    if (n > 0) {
                        Component component = container.getComponent(0);
                        Dimension dimension2 = component.getMinimumSize();
                        dimension.width = this.fMargin + this.fColumns * (dimension2.width + this.fMargin);
                        int n2 = n % this.fColumns == 0 ? 0 : 1;
                        int n3 = n / this.fColumns + n2;
                        dimension.height = this.fMargin + n3 * (dimension2.height + this.fMargin);
                    }
                    return dimension;
                }

                public void layoutContainer(Container container) {
                    container.getSize();
                    int n = container.getComponentCount();
                    Point point = new Point(0, 0);
                    if (n > 0) {
                        Component component = container.getComponent(0);
                        Dimension dimension = component.getPreferredSize();
                        int n2 = 0;
                        while (n2 < n) {
                            component = container.getComponent(n2);
                            point.x = this.fMargin + n2 % this.fColumns * (dimension.width + this.fMargin);
                            point.y = this.fMargin + n2 / this.fColumns * (dimension.height + this.fMargin);
                            component.setLocation(point);
                            component.setSize(dimension);
                            ++n2;
                        }
                    }
                }
            }
        }

        private static class OldToolPanel
        extends MWPanel {
            OldToolPanel(int[] nArray, MWExclusiveGroup mWExclusiveGroup, ItemListener itemListener, MWDragListener mWDragListener) {
                ((Container)((Object)this)).setLayout(new ToolLayout());
                this.setOpaque(false);
                int n = 0;
                while (n < nArray.length) {
                    MWImageResource mWImageResource = ToolRegistry.getImageResource(nArray[n]);
                    String string = ToolRegistry.getName(nArray[n]);
                    ToolButton toolButton = new ToolButton(mWImageResource, string, mWExclusiveGroup, nArray[n]);
                    toolButton.addItemListener(itemListener);
                    ((Component)((Object)toolButton)).setName(string);
                    if (mWDragListener != null) {
                        try {
                            toolButton.addDragListener(mWDragListener);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    ((Container)((Object)this)).add((Component)((Object)toolButton));
                    ++n;
                }
            }
        }

        private static class ToolButton
        extends MWButton {
            private int fID;
            private boolean fBusy;

            ToolButton(MWImageResource mWImageResource, String string, MWExclusiveGroup mWExclusiveGroup, int n) {
                super(mWImageResource);
                this.setLabel(string);
                this.setGroup(mWExclusiveGroup);
                this.setTextPlacement(4);
                this.setGraphicAlignment(1);
                this.fID = n;
            }

            ToolButton(MWImageResource mWImageResource, MWExclusiveGroup mWExclusiveGroup, int n) {
                super(mWImageResource);
                this.setGroup(mWExclusiveGroup);
                this.setTextPlacement(0);
                this.setGraphicAlignment(0);
                this.fID = n;
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (this.fBusy) {
                    this.fBusy = false;
                }
            }

            int getID() {
                return this.fID;
            }

            void setBusy(boolean bl) {
                this.fBusy = bl;
            }

            boolean isBusy() {
                return this.fBusy;
            }
        }

        private static class ToolDragger
        implements MWDragListener {
            Object fBean;
            ToolButton fButton;
            boolean fDragging;
            boolean fTracking;
            boolean fContainerDrawn;
            boolean fCanBeEnclosed;
            MWFrame fWindow;
            Point fOffset;
            Point fPinPt;
            Point fStartPt;
            Point fCurrentPt;
            Dimension fSize;
            LayoutArea fLayoutArea;
            Rectangle fLayoutBounds;
            Point fLayoutLocation;
            LOControlWrapper fCurrentParent;
            private static final int kDragThreshold = 3;

            ToolDragger(LayoutArea layoutArea) {
                this.fLayoutArea = layoutArea;
            }

            public void startDrag(MouseEvent mouseEvent) {
                this.fDragging = false;
                this.fTracking = false;
                this.fContainerDrawn = false;
                this.fButton = (ToolButton)((Object)mouseEvent.getComponent());
                this.fWindow = (MWFrame)MWUtils.getTopLevelWindow((Component)((Object)this.fButton));
                Rectangle rectangle = MWUtils.boundsInOtherComponent((Component)((Object)this.fButton), (Component)this.fWindow);
                this.fOffset = new Point(rectangle.x, rectangle.y);
                this.fPinPt = new Point(rectangle.x, rectangle.y);
                this.fStartPt = mouseEvent.getPoint();
                this.fStartPt.translate(this.fOffset.x, this.fOffset.y);
                this.fCurrentPt = this.fStartPt;
                this.fCurrentParent = null;
                this.fLayoutLocation = MWUtils.mapFromComponentToComponent((Point)new Point(0, 0), (Component)((Object)this.fLayoutArea), (Component)this.fWindow);
                this.fLayoutBounds = MWUtils.boundsInOtherComponent((Component)((Component)((Object)this.fLayoutArea)).getParent(), (Component)this.fWindow);
            }

            public void continueDrag(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                point.translate(this.fOffset.x, this.fOffset.y);
                if (!this.fCurrentPt.equals(point)) {
                    Object object;
                    Graphics graphics = this.getXORGraphics();
                    if (this.fTracking) {
                        this.drawOutline(graphics);
                    }
                    this.fCurrentPt = point;
                    if (!(this.fDragging || Math.abs(this.fCurrentPt.x - this.fStartPt.x) <= 3 && Math.abs(this.fCurrentPt.y - this.fStartPt.y) <= 3)) {
                        this.fDragging = true;
                        this.calcSize();
                        object = (ToolButton)this.fButton.getGroup().getSelectedItem();
                        if (object != this.fButton) {
                            this.fButton.setBusy(true);
                            this.fButton.setState(true);
                            ((Component)((Object)this.fButton)).getParent().getParent().repaint();
                            Toolkit.getDefaultToolkit().sync();
                        }
                    }
                    if (this.fDragging && !this.fTracking) {
                        boolean bl = this.fTracking = !this.fButton.isBusy();
                    }
                    if (this.fTracking) {
                        Object object2;
                        if (this.fLayoutBounds.contains(this.fCurrentPt.x, this.fCurrentPt.y)) {
                            object = new Rectangle(this.fPinPt.x + (this.fCurrentPt.x - this.fStartPt.x), this.fPinPt.y + (this.fCurrentPt.y - this.fStartPt.y), this.fSize.width, this.fSize.height);
                            object = MWUtils.mapFromComponentToComponent((Rectangle)object, (Component)this.fWindow, (Component)((Object)this.fLayoutArea));
                            object2 = this.snapRect((Rectangle)object);
                            if (((Point)object2).x != 0 || ((Point)object2).y != 0) {
                                this.fCurrentPt.translate(((Point)object2).x, ((Point)object2).y);
                            }
                        }
                        this.drawOutline(graphics);
                        if (this.fLayoutBounds.contains(this.fCurrentPt.x, this.fCurrentPt.y)) {
                            object = new Point(this.fCurrentPt.x - this.fLayoutLocation.x, this.fCurrentPt.y - this.fLayoutLocation.y);
                            object2 = null;
                            if (this.fCanBeEnclosed) {
                                object2 = this.fLayoutArea.findContainer((Point)object);
                            }
                            if (this.fContainerDrawn) {
                                if (object2 != this.fCurrentParent) {
                                    graphics.setClip(this.fLayoutBounds);
                                    graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                                    this.drawContainer(graphics);
                                    this.fCurrentParent = object2;
                                    this.drawContainer(graphics);
                                }
                            } else {
                                this.fCurrentParent = object2;
                                graphics.setClip(this.fLayoutBounds);
                                graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                                this.drawContainer(graphics);
                                this.fContainerDrawn = true;
                            }
                        } else if (this.fContainerDrawn) {
                            this.fContainerDrawn = false;
                            graphics.setClip(this.fLayoutBounds);
                            graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                            this.drawContainer(graphics);
                            this.fCurrentParent = null;
                        }
                    }
                    graphics.dispose();
                    graphics = null;
                }
            }

            public void finishDrag(MouseEvent mouseEvent) {
                if (this.fTracking) {
                    Graphics graphics = this.getXORGraphics();
                    this.drawOutline(graphics);
                    if (this.fContainerDrawn) {
                        graphics.setClip(this.fLayoutBounds);
                        graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                        this.drawContainer(graphics);
                    }
                    graphics.dispose();
                    graphics = null;
                }
                this.fCurrentPt = mouseEvent.getPoint();
                this.fCurrentPt.translate(this.fOffset.x, this.fOffset.y);
                this.checkDrop();
                this.fBean = null;
            }

            private void drawOutline(Graphics graphics) {
                graphics.drawRect(this.fPinPt.x + (this.fCurrentPt.x - this.fStartPt.x), this.fPinPt.y + (this.fCurrentPt.y - this.fStartPt.y), this.fSize.width - 1, this.fSize.height - 1);
            }

            private void drawContainer(Graphics graphics) {
                if (this.fCurrentParent != null) {
                    Point point = this.fCurrentParent.getBaseLocation();
                    Dimension dimension = this.fCurrentParent.getControl().getSize();
                    graphics.drawRect(point.x - 1, point.y - 1, dimension.width + 1, dimension.height + 1);
                    graphics.drawRect(point.x - 2, point.y - 2, dimension.width + 3, dimension.height + 3);
                    return;
                }
                this.fLayoutArea.drawDropOutline(graphics);
            }

            private void calcSize() {
                int n = this.fButton.getID();
                Dimension dimension = ((Component)((Object)this.fButton)).getSize();
                this.fBean = ToolRegistry.buildObject(n);
                if (this.fBean != null && this.fBean instanceof Component) {
                    this.fSize = ((Component)this.fBean).getPreferredSize();
                    if (this.fSize.width < dimension.width) {
                        this.fPinPt.x += (dimension.width - this.fSize.width) / 2;
                    }
                    if (this.fPinPt.x > this.fStartPt.x) {
                        this.fPinPt.x = this.fStartPt.x;
                    } else if (this.fPinPt.x + this.fSize.width - 1 < this.fStartPt.x) {
                        this.fPinPt.x = this.fStartPt.x - this.fSize.width + 1;
                    }
                    if (this.fSize.height < dimension.height) {
                        this.fPinPt.y += (dimension.height - this.fSize.height) / 2;
                    }
                    if (this.fPinPt.y > this.fStartPt.y) {
                        this.fPinPt.y = this.fStartPt.y;
                    } else if (this.fPinPt.y + this.fSize.height - 1 < this.fStartPt.y) {
                        this.fPinPt.y = this.fStartPt.y - this.fSize.height + 1;
                    }
                } else {
                    this.fSize = dimension;
                }
                this.fCanBeEnclosed = n < 23 || n > 63 && n < 4096 || this.isLightweight(this.fBean);
            }

            private boolean isLightweight(Object object) {
                boolean bl;
                block4: {
                    block3: {
                        bl = false;
                        if (!Beans.isInstanceOf(object, class$com$mathworks$mwt$MWCanvas != null ? class$com$mathworks$mwt$MWCanvas : (class$com$mathworks$mwt$MWCanvas = ToolPalette.class$("com.mathworks.mwt.MWCanvas"))) && !Beans.isInstanceOf(object, class$com$mathworks$mwt$MWPanel != null ? class$com$mathworks$mwt$MWPanel : (class$com$mathworks$mwt$MWPanel = ToolPalette.class$("com.mathworks.mwt.MWPanel")))) break block3;
                        bl = true;
                        break block4;
                    }
                    if (!Beans.isInstanceOf(object, class$java$awt$Component != null ? class$java$awt$Component : (class$java$awt$Component = ToolPalette.class$("java.awt.Component")))) break block4;
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                        Boolean bl2 = (Boolean)beanInfo.getBeanDescriptor().getValue("lightweight");
                        if (bl2 != null) {
                            bl = bl2;
                        }
                    }
                    catch (Exception exception) {}
                }
                return bl;
            }

            private void checkDrop() {
                if (this.fDragging && this.fLayoutBounds.contains(this.fCurrentPt.x, this.fCurrentPt.y)) {
                    Rectangle rectangle = new Rectangle(this.fPinPt.x + (this.fCurrentPt.x - this.fStartPt.x), this.fPinPt.y + (this.fCurrentPt.y - this.fStartPt.y), this.fSize.width, this.fSize.height);
                    rectangle = MWUtils.mapFromComponentToComponent((Rectangle)rectangle, (Component)this.fWindow, (Component)((Object)this.fLayoutArea));
                    this.snapRect(rectangle);
                    this.fLayoutArea.selectAllObjects(false);
                    this.fLayoutArea.addObject(ToolRegistry.getType(this.fButton.getID()), this.fBean, rectangle, this.fCurrentParent);
                    this.fLayoutArea.getPalette().resetToSelectTool();
                }
            }

            private Point snapRect(Rectangle rectangle) {
                int n = 0;
                int n2 = 0;
                if (rectangle.x < 0) {
                    n = -rectangle.x;
                }
                if (rectangle.y < 0) {
                    n2 = -rectangle.y;
                }
                Dimension dimension = ((Component)((Object)this.fLayoutArea)).getSize();
                if (rectangle.x + rectangle.width > dimension.width) {
                    n = dimension.width - (rectangle.x + rectangle.width);
                }
                if (rectangle.y + rectangle.height > dimension.height) {
                    n2 = dimension.height - (rectangle.y + rectangle.height);
                }
                if (n != 0 || n2 != 0) {
                    rectangle.translate(n, n2);
                }
                Point point = this.fLayoutArea.getSnapRect(rectangle);
                if (point.x != 0 || point.y != 0) {
                    n += point.x;
                    n2 += point.y;
                }
                return new Point(n, n2);
            }

            private Graphics getXORGraphics() {
                Graphics graphics = this.fWindow.getGraphics();
                graphics.setColor(Color.white);
                graphics.setXORMode(Color.gray);
                return graphics;
            }
        }

        private static class Spacer
        extends MWCanvas {
            Spacer() {
                ((Component)((Object)this)).setSize(4, 4);
                this.setOpaque(true);
            }

            public Dimension getPreferredSize() {
                return ((Component)((Object)this)).getSize();
            }
        }

        private static class ToolLayout
        implements LayoutManager {
            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension preferredLayoutSize(Container container) {
                Dimension dimension = new Dimension(0, 0);
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component = container.getComponent(n2);
                    Dimension dimension2 = component.getPreferredSize();
                    dimension.height += dimension2.height;
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    ++n2;
                }
                return dimension;
            }

            public Dimension minimumLayoutSize(Container container) {
                Dimension dimension = new Dimension(0, 0);
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component = container.getComponent(n2);
                    Dimension dimension2 = component.getMinimumSize();
                    dimension.height += dimension2.height;
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    ++n2;
                }
                return dimension;
            }

            public void layoutContainer(Container container) {
                Dimension dimension = container.getSize();
                int n = container.getComponentCount();
                Point point = new Point(0, 0);
                int n2 = 0;
                while (n2 < n) {
                    Component component = container.getComponent(n2);
                    Dimension dimension2 = component.getPreferredSize();
                    dimension2.width = dimension.width;
                    component.setLocation(point);
                    component.setSize(dimension2);
                    point.y += dimension2.height;
                    ++n2;
                }
            }

            ToolLayout() {
            }
        }
    }

    private class ToolPageChanged
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            ToolPalette.this.changePanel((String)itemEvent.getItem());
        }

        ToolPageChanged() {
            ToolPalette.this = ToolPalette.this;
        }
    }

    private static class WindowClosing
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            windowEvent.getWindow().dispose();
        }

        WindowClosing() {
        }
    }

    private static class ResizeFrame
    extends MWFrame {
        ResizeFrame(String string) {
            super(string);
        }

        public void validate() {
            this.setContentSize(((Container)((Object)this)).getComponent(0).getPreferredSize());
            super.validate();
        }
    }
}

