/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.DragTracker;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.RulerGuide;
import com.mathworks.mwt.MWUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

final class RulerGuideDrag
implements DragTracker {
    private RulerGuide fGuide;
    private LayoutArea fLayoutArea;
    private Point fStartPt;
    private Point fCurrentPt;
    private int fOrientation;

    RulerGuideDrag(LayoutArea layoutArea, int n) {
        this.fLayoutArea = layoutArea;
        this.fOrientation = n;
    }

    RulerGuideDrag(LayoutArea layoutArea, RulerGuide rulerGuide) {
        this.fGuide = rulerGuide;
        this.fLayoutArea = layoutArea;
        this.fOrientation = rulerGuide.getOrientation();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fStartPt = mouseEvent.getPoint();
        if (mouseEvent.getComponent() != this.fLayoutArea) {
            this.fStartPt = MWUtils.mapFromComponentToComponent((Point)this.fStartPt, (Component)mouseEvent.getComponent(), (Component)((Object)this.fLayoutArea));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawDragGuide(graphics);
        this.fCurrentPt = mouseEvent.getPoint();
        if (mouseEvent.getComponent() != this.fLayoutArea) {
            this.fCurrentPt = MWUtils.mapFromComponentToComponent((Point)this.fCurrentPt, (Component)mouseEvent.getComponent(), (Component)((Object)this.fLayoutArea));
        }
        this.drawDragGuide(graphics);
        graphics.dispose();
        graphics = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawDragGuide(graphics);
        graphics.dispose();
        graphics = null;
        this.fCurrentPt = mouseEvent.getPoint();
        if (mouseEvent.getComponent() != this.fLayoutArea) {
            this.fCurrentPt = MWUtils.mapFromComponentToComponent((Point)this.fCurrentPt, (Component)mouseEvent.getComponent(), (Component)((Object)this.fLayoutArea));
        }
        if (this.fOrientation == 0) {
            if (this.fCurrentPt.x > 0) {
                if (this.fGuide == null) {
                    this.fGuide = new RulerGuide(this.fCurrentPt.x, this.fOrientation);
                    this.fLayoutArea.getGrid().addGuide(this.fGuide);
                } else {
                    this.fGuide.setLocation(this.fCurrentPt.x);
                }
                ((Component)((Object)this.fLayoutArea)).repaint();
                return;
            }
            if (this.fGuide != null) {
                this.fLayoutArea.getGrid().removeGuide(this.fGuide);
                ((Component)((Object)this.fLayoutArea)).repaint();
                return;
            }
        } else {
            if (this.fCurrentPt.y > 0) {
                if (this.fGuide == null) {
                    this.fGuide = new RulerGuide(this.fCurrentPt.y, this.fOrientation);
                    this.fLayoutArea.getGrid().addGuide(this.fGuide);
                } else {
                    this.fGuide.setLocation(this.fCurrentPt.y);
                }
                ((Component)((Object)this.fLayoutArea)).repaint();
                return;
            }
            if (this.fGuide != null) {
                this.fLayoutArea.getGrid().removeGuide(this.fGuide);
                ((Component)((Object)this.fLayoutArea)).repaint();
            }
        }
    }

    private void drawDragGuide(Graphics graphics) {
        if (this.fCurrentPt != null) {
            if (this.fOrientation == 0) {
                graphics.drawLine(this.fCurrentPt.x, 0, this.fCurrentPt.x, ((Component)((Object)this.fLayoutArea)).getSize().height);
                return;
            }
            graphics.drawLine(0, this.fCurrentPt.y, ((Component)((Object)this.fLayoutArea)).getSize().width, this.fCurrentPt.y);
        }
    }

    private Graphics getXORGraphics() {
        Graphics graphics = ((Component)((Object)this.fLayoutArea)).getGraphics();
        graphics.setColor(((Component)((Object)this.fLayoutArea)).getBackground());
        graphics.setXORMode(Color.gray);
        return graphics;
    }
}

