/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.DragTracker;
import com.mathworks.ide.layout.GObjectWrapper;
import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.UndoResize;
import com.mathworks.mwt.MWScrollbar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

class ResizeDrag
implements DragTracker {
    private static final int NO_CONSTRAINT = 0;
    private static final int CONSTRAIN_HEIGHT = 1;
    private static final int CONSTRAIN_HEIGHT_AND_WIDTH = 2;
    private static final int CONSTRAIN_HEIGHT_OR_WIDTH = 3;
    private static final int MIN_LENGTH = 50;
    private LayoutArea fLayout;
    private LOControlWrapper fWrapper;
    private Point fStartLocation;
    private Point fAnchorPt;
    private Point fSnapPt;
    private Point fStartPt;
    private Point fCurrentPt;
    private Dimension fMinSize;
    private int fConstraint;
    private int fDirection;
    private int fxfudge;
    private int fyfudge;

    ResizeDrag(LayoutArea layoutArea, LOControlWrapper lOControlWrapper) {
        this.fLayout = layoutArea;
        this.fWrapper = lOControlWrapper;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void mousePressed(MouseEvent var1_1) {
        this.fStartPt = var1_1.getPoint();
        this.fDirection = this.fWrapper.findResizeHandle(this.fStartPt);
        this.fMinSize = this.fWrapper.getControl().getMinimumSize();
        this.fStartLocation = this.fWrapper.getBaseLocation();
        if (this.fMinSize.width < 8) {
            this.fMinSize.width = 8;
        }
        if (this.fMinSize.height < 8) {
            this.fMinSize.height = 8;
        }
        var2_2 = this.fWrapper.getControl().getSize();
        switch (this.fDirection) {
            case 1: {
                this.fxfudge = 1;
                this.fyfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x, this.fStartLocation.y);
                this.fSnapPt = new Point(this.fStartLocation.x + var2_2.width, this.fStartLocation.y + var2_2.height);
                break;
            }
            case 2: {
                this.fxfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x, this.fStartLocation.y + var2_2.height);
                this.fSnapPt = new Point(this.fStartLocation.x + var2_2.width, this.fStartLocation.y);
                break;
            }
            case 3: {
                this.fAnchorPt = new Point(this.fStartLocation.x + var2_2.width, this.fStartLocation.y + var2_2.height);
                this.fSnapPt = new Point(this.fStartLocation.x, this.fStartLocation.y);
                break;
            }
            case 4: {
                this.fyfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x + var2_2.width, this.fStartLocation.y);
                this.fSnapPt = new Point(this.fStartLocation.x, this.fStartLocation.y + var2_2.height);
                break;
            }
        }
        this.fConstraint = 0;
        var3_3 = this.fWrapper.getControlType();
        if (var3_3 != 11 && var3_3 != 12 && var3_3 != 18 && var3_3 != 21 && var3_3 != 22) ** GOTO lbl43
        this.fConstraint = 1;
        var4_4 = this.fWrapper.getControl().getPreferredSize().height;
        switch (this.fDirection) {
            case 1: 
            case 4: {
                this.fSnapPt.y = this.fStartLocation.y + var4_4;
                break;
            }
            case 2: 
            case 3: {
                this.fSnapPt.y = this.fStartLocation.y + var2_2.height - var4_4;
                break;
            }
lbl43:
            // 1 sources

            if (var3_3 != 14) break;
            this.fConstraint = 3;
            var4_5 = ((MWScrollbar)this.fWrapper.getControl()).getPreferredWidth();
            switch (this.fDirection) {
                case 1: 
                case 4: {
                    this.fSnapPt.y = this.fStartLocation.y + var4_5;
                    break;
                }
                case 2: 
                case 3: {
                    this.fSnapPt.y = this.fStartLocation.y + var2_2.height - var4_5;
                    break;
                }
            }
            switch (this.fDirection) {
                case 1: 
                case 2: {
                    this.fSnapPt.x = this.fStartLocation.x + var4_5;
                    break;
                }
                case 3: 
                case 4: {
                    this.fSnapPt.x = this.fStartLocation.x + var2_2.width - var4_5;
                }
            }
            break;
        }
        this.fLayout.selectAll(false);
        this.fWrapper.setSelected(true);
        this.fLayout.drawNow();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        this.fCurrentPt = mouseEvent.getPoint();
        this.fLayout.constrainPoint(this.fCurrentPt);
        this.fLayout.snapToGrid(this.fCurrentPt, this.fxfudge, this.fyfudge);
        this.constrainSize(mouseEvent.isShiftDown());
        this.drawMarquee(graphics);
        graphics.dispose();
        graphics = null;
        Point point = new Point(this.fCurrentPt.x, this.fCurrentPt.y);
        switch (this.fDirection) {
            case 1: {
                point.translate(-1, -1);
                break;
            }
            case 2: {
                point.translate(-1, 0);
                break;
            }
            case 4: {
                point.translate(0, -1);
                break;
            }
        }
        this.fLayout.getHRuler().doMouseTrackMouseMoved(point);
        this.fLayout.getVRuler().doMouseTrackMouseMoved(point);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        graphics.dispose();
        graphics = null;
        this.fCurrentPt = mouseEvent.getPoint();
        this.fLayout.constrainPoint(this.fCurrentPt);
        this.fLayout.snapToGrid(this.fCurrentPt, this.fxfudge, this.fyfudge);
        this.constrainSize(mouseEvent.isShiftDown());
        UndoResize undoResize = new UndoResize(this.fLayout, this.fWrapper);
        switch (this.fDirection) {
            case 2: {
                this.fWrapper.offsetRect(0, this.fCurrentPt.y - this.fStartLocation.y);
                break;
            }
            case 3: {
                this.fWrapper.offsetRect(this.fCurrentPt.x - this.fStartLocation.x, this.fCurrentPt.y - this.fStartLocation.y);
                break;
            }
            case 4: {
                this.fWrapper.offsetRect(this.fCurrentPt.x - this.fStartLocation.x, 0);
                break;
            }
        }
        int n = Math.abs(this.fCurrentPt.x - this.fAnchorPt.x);
        int n2 = Math.abs(this.fCurrentPt.y - this.fAnchorPt.y);
        this.fWrapper.getControl().setSize(n, n2);
        if (this.fWrapper.getNeedsLayout()) {
            LayoutArea.forceLayout((Container)this.fWrapper.getControl());
        }
        if (undoResize.resizeComplete()) {
            this.fLayout.updateSelection();
            this.fLayout.fireContentChangedEvent();
            this.fLayout.fireUndoEvent(undoResize);
            if (this.fWrapper.isGObject()) {
                ((GObjectWrapper)this.fWrapper).updatePosition();
                return;
            }
            this.fLayout.fireObjectChangedEvent(this.fWrapper);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void constrainSize(boolean bl) {
        switch (this.fConstraint) {
            case 2: {
                this.fCurrentPt.x = this.fSnapPt.x;
            }
            case 1: {
                this.fCurrentPt.y = this.fSnapPt.y;
                break;
            }
            case 3: {
                int n = Math.abs(this.fCurrentPt.x - this.fAnchorPt.x);
                int n2 = Math.abs(this.fCurrentPt.y - this.fAnchorPt.y);
                if (n > n2) {
                    this.fCurrentPt.y = this.fSnapPt.y;
                    switch (this.fDirection) {
                        case 1: 
                        case 2: {
                            if (this.fCurrentPt.x >= this.fAnchorPt.x + 50) return;
                            this.fCurrentPt.x = this.fAnchorPt.x + 50;
                            return;
                        }
                        case 3: 
                        case 4: {
                            if (this.fCurrentPt.x <= this.fAnchorPt.x - 50) return;
                            this.fCurrentPt.x = this.fAnchorPt.x - 50;
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                this.fCurrentPt.x = this.fSnapPt.x;
                switch (this.fDirection) {
                    case 1: 
                    case 4: {
                        if (this.fCurrentPt.y < this.fAnchorPt.y + 50) {
                            this.fCurrentPt.y = this.fAnchorPt.y + 50;
                            return;
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (this.fCurrentPt.y <= this.fAnchorPt.y - 50) break;
                        this.fCurrentPt.y = this.fAnchorPt.y - 50;
                        return;
                    }
                }
                return;
            }
            default: {
                int n;
                if (!bl) break;
                int n3 = Math.abs(this.fCurrentPt.x - this.fSnapPt.x);
                if (n3 > (n = Math.abs(this.fCurrentPt.y - this.fSnapPt.y))) {
                    this.fCurrentPt.y = this.fSnapPt.y;
                    break;
                }
                this.fCurrentPt.x = this.fSnapPt.x;
            }
        }
        switch (this.fDirection) {
            case 1: {
                if (this.fCurrentPt.x < this.fAnchorPt.x + this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x + this.fMinSize.width;
                }
                if (this.fCurrentPt.y >= this.fAnchorPt.y + this.fMinSize.height) return;
                this.fCurrentPt.y = this.fAnchorPt.y + this.fMinSize.height;
                return;
            }
            case 2: {
                if (this.fCurrentPt.x < this.fAnchorPt.x + this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x + this.fMinSize.width;
                }
                if (this.fCurrentPt.y <= this.fAnchorPt.y - this.fMinSize.height) return;
                this.fCurrentPt.y = this.fAnchorPt.y - this.fMinSize.height;
                return;
            }
            case 3: {
                if (this.fCurrentPt.x > this.fAnchorPt.x - this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x - this.fMinSize.width;
                }
                if (this.fCurrentPt.y <= this.fAnchorPt.y - this.fMinSize.height) return;
                this.fCurrentPt.y = this.fAnchorPt.y - this.fMinSize.height;
                return;
            }
            case 4: {
                if (this.fCurrentPt.x > this.fAnchorPt.x - this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x - this.fMinSize.width;
                }
                if (this.fCurrentPt.y >= this.fAnchorPt.y + this.fMinSize.height) return;
                this.fCurrentPt.y = this.fAnchorPt.y + this.fMinSize.height;
                return;
            }
        }
    }

    private void drawMarquee(Graphics graphics) {
        if (this.fCurrentPt != null) {
            int n = Math.min(this.fCurrentPt.x, this.fAnchorPt.x);
            int n2 = Math.min(this.fCurrentPt.y, this.fAnchorPt.y);
            int n3 = Math.abs(this.fCurrentPt.x - this.fAnchorPt.x);
            int n4 = Math.abs(this.fCurrentPt.y - this.fAnchorPt.y);
            if (n3 > 1 && n4 > 1) {
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }
    }

    private Graphics getXORGraphics() {
        Graphics graphics = ((Component)((Object)this.fLayout)).getGraphics();
        graphics.setColor(((Component)((Object)this.fLayout)).getBackground());
        graphics.setXORMode(Color.gray);
        return graphics;
    }
}

