/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.DragTracker;
import com.mathworks.ide.layout.GObjectWrapper;
import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.UndoMove;
import com.mathworks.services.ObjectRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

final class MoveDrag
implements DragTracker {
    private static final int MOVE_THRESHOLD = 3;
    private LayoutArea fLayout;
    private LOControlWrapper fWrapper;
    private Point fStartPt;
    private Point fCurrentPt;
    private Rectangle fBounds;
    private Vector fSelection;
    private LOControlWrapper fOriginalParent;
    private LOControlWrapper fCurrentParent;
    private boolean fThreshold;
    private boolean fHasLeftParent;
    private boolean fControlOnly;
    private boolean fDuplicate;

    MoveDrag(LayoutArea layoutArea, LOControlWrapper lOControlWrapper, boolean bl) {
        this.fLayout = layoutArea;
        this.fWrapper = lOControlWrapper;
        this.fThreshold = false;
        this.fHasLeftParent = false;
        this.fControlOnly = true;
        this.fDuplicate = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        LOControlWrapper lOControlWrapper;
        this.fStartPt = mouseEvent.getPoint();
        if (!this.fWrapper.isSelected()) {
            if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                this.fLayout.selectAll(false);
            }
            this.fWrapper.setSelected(true);
            this.fLayout.drawNow();
        }
        this.fSelection = this.fLayout.getSelectedControls();
        Point point = this.fWrapper.getBaseLocation();
        Dimension dimension = this.fWrapper.getControl().getSize();
        this.fBounds = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        Enumeration enumeration = this.fSelection.elements();
        while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            point = lOControlWrapper.getBaseLocation();
            dimension = lOControlWrapper.getControl().getSize();
            this.fBounds.add(point);
            this.fBounds.add(point.x + dimension.width, point.y + dimension.height);
            if (lOControlWrapper.isEnclosable()) continue;
            this.fControlOnly = false;
            break;
        }
        if (this.fControlOnly) {
            lOControlWrapper = this.fWrapper.getParent();
            while (lOControlWrapper != null && lOControlWrapper.isSelected()) {
                lOControlWrapper = lOControlWrapper.getParent();
            }
            this.fOriginalParent = this.fCurrentParent = lOControlWrapper;
        }
        this.fLayout.getHRuler().doMouseTrackXOROff();
        this.fLayout.getVRuler().doMouseTrackXOROff();
        this.fLayout.getHRuler().doMouseDragMouseMoved(this.fBounds);
        this.fLayout.getVRuler().doMouseDragMouseMoved(this.fBounds);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        Cloneable cloneable;
        Graphics graphics = this.getXORGraphics();
        this.drawObjects(graphics);
        if (!this.fThreshold) {
            cloneable = mouseEvent.getPoint();
            n = Math.abs(cloneable.x - this.fStartPt.x);
            int n2 = Math.abs(cloneable.y - this.fStartPt.y);
            boolean bl = this.fThreshold = n > 3 || n2 > 3;
        }
        if (this.fThreshold) {
            this.fCurrentPt = mouseEvent.getPoint();
            if (mouseEvent.isShiftDown()) {
                int n3 = Math.abs(this.fCurrentPt.x - this.fStartPt.x);
                if (n3 > (n = Math.abs(this.fCurrentPt.y - this.fStartPt.y))) {
                    this.fCurrentPt.y = this.fStartPt.y;
                } else {
                    this.fCurrentPt.x = this.fStartPt.x;
                }
            }
            cloneable = this.pinPointWithSnap();
            this.drawObjects(graphics);
            if (this.fControlOnly) {
                LOControlWrapper lOControlWrapper = this.fLayout.findContainer(this.fCurrentPt);
                if ((lOControlWrapper = this.validateParent(lOControlWrapper)) != this.fCurrentParent) {
                    this.drawContainer(graphics);
                    this.fCurrentParent = lOControlWrapper;
                    this.fHasLeftParent = true;
                    this.drawContainer(graphics);
                }
            }
            this.fLayout.getHRuler().doMouseDragMouseMoved((Rectangle)cloneable);
            this.fLayout.getVRuler().doMouseDragMouseMoved((Rectangle)cloneable);
        }
        graphics.dispose();
        graphics = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fThreshold && this.fCurrentPt != null) {
            Graphics graphics = this.getXORGraphics();
            this.drawObjects(graphics);
            this.fCurrentPt = mouseEvent.getPoint();
            if (mouseEvent.isShiftDown()) {
                int n;
                int n2 = Math.abs(this.fCurrentPt.x - this.fStartPt.x);
                if (n2 > (n = Math.abs(this.fCurrentPt.y - this.fStartPt.y))) {
                    this.fCurrentPt.y = this.fStartPt.y;
                } else {
                    this.fCurrentPt.x = this.fStartPt.x;
                }
            }
            this.pinPointWithSnap();
            if (this.fControlOnly) {
                this.drawContainer(graphics);
                LOControlWrapper lOControlWrapper = this.fLayout.findContainer(this.fCurrentPt);
                this.fCurrentParent = this.validateParent(lOControlWrapper);
            }
            if (this.fDuplicate) {
                Point point = new Point(this.fCurrentPt.x - this.fStartPt.x, this.fCurrentPt.y - this.fStartPt.y);
                this.fLayout.doDuplicate(point);
            } else {
                UndoMove undoMove = new UndoMove(this.fLayout, this.fSelection);
                if (this.fCurrentParent != this.fOriginalParent) {
                    this.reparentObjects();
                } else {
                    this.moveObjects();
                }
                if (undoMove.moveComplete()) {
                    this.fLayout.fireUndoEvent(undoMove);
                    this.fLayout.fireContentChangedEvent();
                    if (this.fWrapper.isGObject()) {
                        GObjectWrapper.updateVector(this.fSelection);
                    } else {
                        this.fLayout.fireObjectChangedEvent(this.fSelection);
                    }
                }
            }
            graphics.dispose();
            graphics = null;
        }
        this.fLayout.getHRuler().doMouseDragXOROff();
        this.fLayout.getVRuler().doMouseDragXOROff();
        this.fLayout.getHRuler().doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.fLayout.getVRuler().doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.fLayout.updateSelection();
    }

    private Rectangle pinPointWithSnap() {
        if (this.fCurrentPt.x < 0) {
            this.fCurrentPt.x = 0;
        }
        if (this.fCurrentPt.y < 0) {
            this.fCurrentPt.y = 0;
        }
        Dimension dimension = ((Component)((Object)this.fLayout)).getSize();
        if (this.fCurrentPt.x > dimension.width) {
            this.fCurrentPt.x = dimension.width;
        }
        if (this.fCurrentPt.y > dimension.height) {
            this.fCurrentPt.y = dimension.height;
        }
        Rectangle rectangle = new Rectangle(this.fBounds);
        int n = this.fCurrentPt.x - this.fStartPt.x;
        int n2 = this.fCurrentPt.y - this.fStartPt.y;
        rectangle.translate(n, n2);
        n2 = 0;
        n = 0;
        if (rectangle.x < 0) {
            n = -rectangle.x;
        }
        if (rectangle.y < 0) {
            n2 = -rectangle.y;
        }
        if (rectangle.x + rectangle.width > dimension.width) {
            n = dimension.width - (rectangle.x + rectangle.width);
        }
        if (rectangle.y + rectangle.height > dimension.height) {
            n2 = dimension.height - (rectangle.y + rectangle.height);
        }
        if (n != 0 || n2 != 0) {
            this.fCurrentPt.translate(n, n2);
            rectangle.translate(n, n2);
        }
        Point point = this.fLayout.getSnapRect(rectangle);
        this.fCurrentPt.translate(point.x, point.y);
        return rectangle;
    }

    private void drawObjects(Graphics graphics) {
        if (this.fCurrentPt != null) {
            int n = this.fCurrentPt.x - this.fStartPt.x;
            int n2 = this.fCurrentPt.y - this.fStartPt.y;
            Enumeration enumeration = this.fSelection.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                Point point = lOControlWrapper.getBaseLocation();
                point.translate(n, n2);
                Dimension dimension = lOControlWrapper.getControl().getSize();
                graphics.drawRect(point.x, point.y, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    private void drawContainer(Graphics graphics) {
        if (this.fHasLeftParent) {
            if (this.fCurrentParent != null) {
                Point point = this.fCurrentParent.getBaseLocation();
                Dimension dimension = this.fCurrentParent.getControl().getSize();
                graphics.drawRect(point.x - 1, point.y - 1, dimension.width + 1, dimension.height + 1);
                graphics.drawRect(point.x - 2, point.y - 2, dimension.width + 3, dimension.height + 3);
                return;
            }
            this.fLayout.drawDropOutline(graphics);
        }
    }

    private LOControlWrapper validateParent(LOControlWrapper lOControlWrapper) {
        LOControlWrapper lOControlWrapper2 = lOControlWrapper;
        while (lOControlWrapper != null) {
            if (this.fSelection.contains(lOControlWrapper)) {
                lOControlWrapper2 = lOControlWrapper.getParent();
                break;
            }
            lOControlWrapper = lOControlWrapper.getParent();
        }
        return lOControlWrapper2;
    }

    private void moveObjects() {
        int n = this.fCurrentPt.x - this.fStartPt.x;
        int n2 = this.fCurrentPt.y - this.fStartPt.y;
        Enumeration enumeration = this.fSelection.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            Point point = lOControlWrapper.getControl().getLocation();
            point.translate(n, n2);
            lOControlWrapper.getControl().setLocation(point);
        }
    }

    private void reparentObjects() {
        Object object;
        int n = this.fCurrentPt.x - this.fStartPt.x;
        int n2 = this.fCurrentPt.y - this.fStartPt.y;
        Enumeration enumeration = this.fSelection.elements();
        Object[] objectArray = new Object[this.fSelection.size()];
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            object = (LOControlWrapper)enumeration.nextElement();
            Point point = ((LOControlWrapper)object).getBaseLocation();
            point.translate(n, n2);
            LOControlWrapper lOControlWrapper = ((LOControlWrapper)object).getParent();
            if (lOControlWrapper == null) {
                this.fLayout.removeWrapper((LOControlWrapper)object);
            } else {
                lOControlWrapper.removeWrapper((LOControlWrapper)object);
            }
            if (this.fCurrentParent == null) {
                ((LOControlWrapper)object).getControl().setLocation(point);
                this.fLayout.addWrapper((LOControlWrapper)object, -1);
            } else {
                this.fCurrentParent.translateFromBaseCoordinates(point);
                ((LOControlWrapper)object).getControl().setLocation(point);
                this.fCurrentParent.addWrapper((LOControlWrapper)object, -1);
            }
            objectArray[n3++] = ((LOControlWrapper)object).getBean();
        }
        ((Component)((Object)this.fLayout)).repaint();
        object = this.fCurrentParent != null ? ((Component)objectArray[0]).getParent() : this.fLayout.getRootObject();
        ObjectRegistry.getLayoutRegistry().move(objectArray, object, -1);
    }

    private Graphics getXORGraphics() {
        Graphics graphics = ((Component)((Object)this.fLayout)).getGraphics();
        graphics.setColor(((Component)((Object)this.fLayout)).getBackground());
        graphics.setXORMode(Color.gray);
        return graphics;
    }
}

