/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.DragTracker;
import com.mathworks.ide.layout.LayoutArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

abstract class MarqueeDrag
implements DragTracker {
    protected LayoutArea fLayoutArea;
    protected Point fStartPt;
    protected Point fCurrentPt;

    MarqueeDrag(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fStartPt = mouseEvent.getPoint();
        this.fLayoutArea.constrainBounds(this.fStartPt);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        this.fCurrentPt = mouseEvent.getPoint();
        this.constrainMarquee(mouseEvent.isMetaDown());
        this.fLayoutArea.constrainBounds(this.fCurrentPt);
        this.drawMarquee(graphics);
        this.fLayoutArea.getHRuler().doMouseTrackMouseMoved(this.fCurrentPt);
        this.fLayoutArea.getVRuler().doMouseTrackMouseMoved(this.fCurrentPt);
        graphics.dispose();
        graphics = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        graphics.dispose();
        graphics = null;
        this.fCurrentPt = mouseEvent.getPoint();
        this.constrainMarquee(mouseEvent.isMetaDown());
        this.fLayoutArea.constrainBounds(this.fCurrentPt);
    }

    Rectangle getBounds() {
        int n = Math.min(this.fStartPt.x, this.fCurrentPt.x);
        int n2 = Math.min(this.fStartPt.y, this.fCurrentPt.y);
        int n3 = Math.abs(this.fCurrentPt.x - this.fStartPt.x);
        int n4 = Math.abs(this.fCurrentPt.y - this.fStartPt.y);
        return new Rectangle(n, n2, n3 + 1, n4 + 1);
    }

    private void drawMarquee(Graphics graphics) {
        if (this.fCurrentPt != null) {
            int n = Math.min(this.fStartPt.x, this.fCurrentPt.x);
            int n2 = Math.min(this.fStartPt.y, this.fCurrentPt.y);
            int n3 = Math.abs(this.fCurrentPt.x - this.fStartPt.x);
            int n4 = Math.abs(this.fCurrentPt.y - this.fStartPt.y);
            if (n3 > 1 && n4 > 1) {
                graphics.drawRect(n, n2, n3, n4);
            }
        }
    }

    private Graphics getXORGraphics() {
        Graphics graphics = ((Component)((Object)this.fLayoutArea)).getGraphics();
        graphics.setColor(((Component)((Object)this.fLayoutArea)).getBackground());
        graphics.setXORMode(Color.gray);
        return graphics;
    }

    protected abstract void constrainMarquee(boolean var1);
}

