/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.RulerGuideDrag;
import com.mathworks.mwt.MWRuler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class LayoutRuler
extends MWRuler
implements MouseListener,
MouseMotionListener {
    private LayoutArea fLayoutArea;
    private RulerGuideDrag fGuideTracker;

    LayoutRuler(LayoutArea layoutArea, int n, int n2) {
        super(n, 10, 50);
        this.setLabelStart(n2);
        this.fLayoutArea = layoutArea;
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
    }

    public void setLabelStart(int n) {
        int n2 = this.getLabelStart();
        if (n != n2) {
            super.setLabelStart(n);
            if (n == 0) {
                this.setLabelInterval(this.getMajorInterval());
                return;
            }
            if (n2 == 0) {
                this.setLabelInterval(-this.getMajorInterval());
            }
        }
    }

    int getGridWidth() {
        return this.getMajorInterval();
    }

    void setGridWidth(int n) {
        this.setMajorInterval(n);
        if (this.getLabelStart() == 0) {
            this.setLabelInterval(n);
        } else {
            this.setLabelInterval(-n);
        }
        this.setLabelUnit(n);
    }

    boolean getRulerState() {
        return ((Component)((Object)this)).isVisible();
    }

    synchronized void setRulerState(boolean bl) {
        ((Component)((Object)this)).setVisible(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fGuideTracker = new RulerGuideDrag(this.fLayoutArea, this.getOrientation());
        this.fGuideTracker.mousePressed(mouseEvent);
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (this.fGuideTracker != null) {
            this.fGuideTracker.mouseReleased(mouseEvent);
            this.fGuideTracker = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fGuideTracker != null) {
            this.fGuideTracker.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getOrientation() == 1) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(9));
            return;
        }
        if (this.getOrientation() == 0) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    static Component buildMitre() {
        return new RulerMitre();
    }

    private static class RulerMitre
    extends Component {
        public void paint(Graphics graphics) {
            MWRuler.drawMitre((Graphics)graphics, (Dimension)this.getSize());
        }

        RulerMitre() {
        }
    }
}

