/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.RaggedLayout;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.Component;
import java.awt.Container;
import java.util.ResourceBundle;

public class LayoutPrefs
extends MWPanel {
    static final String TYPE = "Layout";
    static final String TOOLBAR = "LayoutToolBar";
    static final String TOOLNAMES = "LayoutToolNames";
    static final String CONNECT = "LayoutConnect";
    static final String EXTENSION = "LayoutExtension";
    static final String FULLPATH = "LayoutFullPath";
    static final String ALLFILES = "LayoutAllFiles";
    private static LayoutPrefs sLayoutPrefs;
    static boolean sShowToolBar;
    static boolean sShowToolNames;
    static boolean sShowConnect;
    static boolean sShowExtension;
    static boolean sShowFullPath;
    private static final String[] kKeys;
    private MWCheckbox[] fBoxes;

    private LayoutPrefs() {
        ((Container)((Object)this)).setLayout(new RaggedLayout(12));
    }

    private void readPrefs() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.ide.layout.resources.RES_Layout");
        int n = kKeys.length;
        this.fBoxes = new MWCheckbox[n];
        int n2 = 0;
        while (n2 < n) {
            String string = resourceBundle.getString(kKeys[n2]);
            this.fBoxes[n2] = new MWCheckbox(string);
            this.fBoxes[n2].setState(Prefs.getBooleanPref((String)kKeys[n2]));
            ((Container)((Object)this)).add((Component)this.fBoxes[n2]);
            ++n2;
        }
    }

    private void storePrefs() {
        int n = this.fBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.fBoxes[n2].getState() != Prefs.getBooleanPref((String)kKeys[n2])) {
                Prefs.setBooleanPref((String)kKeys[n2], (boolean)this.fBoxes[n2].getState());
            }
            ++n2;
        }
    }

    public static MWPanel createPrefsPanel() {
        sLayoutPrefs = new LayoutPrefs();
        sLayoutPrefs.readPrefs();
        return sLayoutPrefs;
    }

    public static void commitPrefsChanges() {
        sLayoutPrefs.storePrefs();
        sLayoutPrefs = null;
    }

    static {
        sShowToolBar = Prefs.getBooleanPref((String)TOOLBAR, (boolean)true);
        sShowToolNames = Prefs.getBooleanPref((String)TOOLNAMES, (boolean)false);
        sShowConnect = Prefs.getBooleanPref((String)CONNECT, (boolean)true);
        sShowExtension = Prefs.getBooleanPref((String)EXTENSION, (boolean)true);
        sShowFullPath = Prefs.getBooleanPref((String)FULLPATH, (boolean)false);
        kKeys = new String[]{TOOLBAR, TOOLNAMES, EXTENSION, FULLPATH, ALLFILES};
        Prefs.addListener((PrefListener)new PrefChanged(), (String)TYPE);
    }

    private static class PrefChanged
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            sShowToolBar = Prefs.getBooleanPref((String)LayoutPrefs.TOOLBAR);
            sShowToolNames = Prefs.getBooleanPref((String)LayoutPrefs.TOOLNAMES);
            sShowConnect = Prefs.getBooleanPref((String)LayoutPrefs.CONNECT);
            sShowExtension = Prefs.getBooleanPref((String)LayoutPrefs.EXTENSION);
            sShowFullPath = Prefs.getBooleanPref((String)LayoutPrefs.FULLPATH);
        }

        PrefChanged() {
        }
    }
}

