/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.hg.types.HGRectangle;
import com.mathworks.ide.layout.GObjectProxy;
import com.mathworks.ide.layout.GObjectWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.LayoutEditor;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwt.message.MWLooper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

final class LayoutLooper {
    private static boolean sAvailable;
    private static MWLooper sLooper;
    private static Matlab sMatlab;
    private static Object sCopyBuffer;
    private static double[] sCopyContents;
    private static final String HELPER_FUNCTION = "guidefunc";
    private static final String NEW_FIGURE = "newFigure";
    private static final String NEW_UICONTROL = "newUicontrol";
    private static final String NEW_AXES = "newAxes";
    private static final String READ_FIGURE = "readFigure";
    private static final String DUPLICATE = "duplicate";
    private static final String COPY = "copy";
    private static final String ACTIVATE_FIGURE = "activateFigure";
    private static final String SNAPSHOT_FIGURE = "snapshotFigure";
    private static final String DELETE = "delete";
    private static final String MOVE = "move";
    private static final String MOVE_TO_FRONT = "moveToFront";
    private static final String MOVE_TO_BACK = "moveToBack";
    private static final String MOVE_FORWARD = "moveForward";
    private static final String MOVE_BACKWARD = "moveBackward";
    private static final String RESIZE_FIGURE = "resizeFigure";
    public static final String OPEN_FIGURE = "openFigure";
    public static final String HELP_USING_LAYOUT = "helpUsingLayout";
    public static final String HELP_CREATING_GUIS = "helpCreatingGUIs";
    public static final String SAVE = "save";
    public static final String SAVE_AS = "saveAs";
    private static final String APPLICATION_OPTIONS = "applicationOptions";
    private static final String EDIT_CALLBACK = "editCallback";

    static boolean isAvailable() {
        return sAvailable;
    }

    static boolean canPaste() {
        return sCopyBuffer != null;
    }

    static int checkStatus(int n) {
        return Matlab.getExecutionStatus((int)n);
    }

    static void requestEval(String string) {
        if (sAvailable) {
            sMatlab.evalNoOutput(string);
        }
    }

    static void requestFigure(CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = NEW_FIGURE;
            objectArray[n++] = (LayoutEditor)completionObserver;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 3, completionObserver);
            return;
        }
        completionObserver.completed(-1, null);
    }

    static void deleteObject(Object object) {
        if (sAvailable && object != null) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = DELETE;
            objectArray[n++] = object;
            sMatlab.feval(HELPER_FUNCTION, objectArray, null);
        }
    }

    static void activateFigure(Object object, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = ACTIVATE_FIGURE;
            objectArray[n++] = object;
            sMatlab.feval(HELPER_FUNCTION, objectArray, completionObserver);
        }
    }

    static void applicationOptions(Object object) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = APPLICATION_OPTIONS;
            objectArray[n++] = object;
            sMatlab.feval(HELPER_FUNCTION, objectArray, null);
        }
    }

    static void requestUIControl(Object object, GObjectWrapper gObjectWrapper, int n) {
        if (sAvailable) {
            GObjectProxy gObjectProxy = (GObjectProxy)gObjectWrapper.getControl();
            String[] stringArray = gObjectProxy.getStringArray();
            double[] dArray = LayoutLooper.calcPosition(gObjectProxy);
            Object[] objectArray = new Object[6];
            int n2 = 0;
            objectArray[n2++] = NEW_UICONTROL;
            objectArray[n2++] = object;
            objectArray[n2++] = dArray;
            objectArray[n2++] = gObjectProxy.getStyleString();
            objectArray[n2++] = stringArray;
            objectArray[n2++] = gObjectProxy;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 2, (CompletionObserver)gObjectWrapper);
            return;
        }
        gObjectWrapper.completed(-1, null);
    }

    static void requestAxes(Object object, GObjectWrapper gObjectWrapper, int n) {
        if (sAvailable) {
            GObjectProxy gObjectProxy = (GObjectProxy)gObjectWrapper.getControl();
            double[] dArray = LayoutLooper.calcPosition(gObjectWrapper.getControl());
            Object[] objectArray = new Object[4];
            int n2 = 0;
            objectArray[n2++] = NEW_AXES;
            objectArray[n2++] = object;
            objectArray[n2++] = dArray;
            objectArray[n2++] = gObjectProxy;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 2, (CompletionObserver)gObjectWrapper);
            return;
        }
        gObjectWrapper.completed(-1, null);
    }

    static void requestMove(Object object, Component component, CompletionObserver completionObserver) {
        if (sAvailable) {
            double[] dArray = LayoutLooper.calcPosition(component);
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = MOVE;
            objectArray[n++] = object;
            objectArray[n++] = dArray;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 1, completionObserver);
            return;
        }
        completionObserver.completed(-1, null);
    }

    static void moveToFront(GObjectWrapper gObjectWrapper) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_TO_FRONT;
            objectArray[n++] = gObjectWrapper.getHandle();
            sMatlab.feval(HELPER_FUNCTION, objectArray, null);
        }
    }

    static void moveToBack(GObjectWrapper gObjectWrapper) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_TO_BACK;
            objectArray[n++] = gObjectWrapper.getHandle();
            sMatlab.feval(HELPER_FUNCTION, objectArray, null);
        }
    }

    static void moveForward(GObjectWrapper gObjectWrapper) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_FORWARD;
            objectArray[n++] = gObjectWrapper.getHandle();
            sMatlab.feval(HELPER_FUNCTION, objectArray, null);
        }
    }

    static void moveBackward(GObjectWrapper gObjectWrapper) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_BACKWARD;
            objectArray[n++] = gObjectWrapper.getHandle();
            sMatlab.feval(HELPER_FUNCTION, objectArray, null);
        }
    }

    private static double[] calcPosition(Component component) {
        Rectangle rectangle = component.getBounds();
        Dimension dimension = component.getParent().getSize();
        double[] dArray = new double[]{rectangle.x, dimension.height - rectangle.y - rectangle.height, rectangle.width, rectangle.height};
        return dArray;
    }

    static void readFigure(String string, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = READ_FIGURE;
            objectArray[n++] = (LayoutEditor)completionObserver;
            objectArray[n++] = string;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 6, completionObserver);
            return;
        }
        completionObserver.completed(-1, null);
    }

    static void snapshotFigure(double d, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = SNAPSHOT_FIGURE;
            objectArray[n++] = (LayoutEditor)completionObserver;
            objectArray[n++] = new Double(d);
            sMatlab.feval(HELPER_FUNCTION, objectArray, 6, completionObserver);
            return;
        }
        completionObserver.completed(-1, null);
    }

    static void duplicate(Object object, Vector vector, Point point, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray;
            int n = vector.size();
            double[] dArray = new double[n];
            double[] dArray2 = new double[2];
            int n2 = 0;
            while (n2 < n) {
                objectArray = (Object[])vector.elementAt(n2);
                double[] dArray3 = (double[])objectArray.getHandle();
                dArray[n2] = dArray3[0];
                ++n2;
            }
            dArray2[0] = point.x;
            dArray2[1] = point.y;
            objectArray = new Object[4];
            int n3 = 0;
            objectArray[n3++] = DUPLICATE;
            objectArray[n3++] = dArray;
            objectArray[n3++] = object;
            objectArray[n3++] = dArray2;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 3, completionObserver);
            return;
        }
        completionObserver.completed(-1, null);
    }

    static void copy(Vector vector, LayoutArea layoutArea) {
        if (sAvailable) {
            Object object;
            int n = vector.size();
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                object = (GObjectWrapper)vector.elementAt(n2);
                double[] dArray2 = (double[])((GObjectWrapper)object).getHandle();
                dArray[n2] = dArray2[0];
                ++n2;
            }
            object = new Object[3];
            int n3 = 0;
            object[n3++] = COPY;
            object[n3++] = dArray;
            object[n3++] = sCopyBuffer;
            sMatlab.feval(HELPER_FUNCTION, (Object[])object, 2, (CompletionObserver)new CopyCompleted(layoutArea));
        }
    }

    static void editCallback(Object object, String string) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = EDIT_CALLBACK;
            objectArray[n++] = object;
            objectArray[n++] = string;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    static void paste(Object object, Point point, CompletionObserver completionObserver) {
        if (sAvailable && sCopyContents != null) {
            double[] dArray = new double[]{point.x, point.y};
            Object[] objectArray = new Object[4];
            int n = 0;
            objectArray[n++] = DUPLICATE;
            objectArray[n++] = sCopyContents;
            objectArray[n++] = object;
            objectArray[n++] = dArray;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 3, completionObserver);
            return;
        }
        completionObserver.completed(-1, null);
    }

    static void updateObject(Object object, GObjectProxy gObjectProxy, Component component) {
        if (sAvailable) {
            UpdateObject updateObject = new UpdateObject(object, gObjectProxy, component);
            Matlab.whenMatlabReady((Runnable)updateObject);
        }
    }

    static void updateFigure(Object object, Container container, Enumeration enumeration, Component component) {
        if (sAvailable) {
            UpdateFigure updateFigure = new UpdateFigure(object, container, enumeration, component);
            Matlab.whenMatlabReady((Runnable)updateFigure);
        }
    }

    static void resizeFigure(Object object, Point point, CompletionObserver completionObserver) {
        if (sAvailable) {
            double[] dArray = new double[]{point.x, point.y};
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = RESIZE_FIGURE;
            objectArray[n++] = object;
            objectArray[n++] = dArray;
            sMatlab.feval(HELPER_FUNCTION, objectArray, 1, completionObserver);
            return;
        }
        completionObserver.completed(-1, null);
    }

    static void executeInM(String string) {
        if (sAvailable) {
            Object[] objectArray = new Object[]{string};
            sMatlab.feval(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    static void executeInM(String string, Object object) {
        if (sAvailable) {
            Object[] objectArray = new Object[]{string, object};
            sMatlab.feval(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    LayoutLooper() {
    }

    static /* synthetic */ double[] access$1() {
        return sCopyContents;
    }

    static {
        if (Matlab.isMatlabAvailable()) {
            sAvailable = true;
            sLooper = new MWLooper("Layout Looper");
            sMatlab = new Matlab(sLooper);
        }
    }

    private static class CopyCompleted
    implements CompletionObserver {
        private LayoutArea fLayoutArea;

        CopyCompleted(LayoutArea layoutArea) {
            this.fLayoutArea = layoutArea;
        }

        public void completed(int n, Object object) {
            if (sAvailable && object != null) {
                Object[] objectArray = (Object[])object;
                sCopyContents = (double[])objectArray[0];
                if (sCopyBuffer == null) {
                    sCopyBuffer = objectArray[1];
                }
                if (this.fLayoutArea != null) {
                    this.fLayoutArea.updatePasteCmd();
                }
            }
        }
    }

    private static class UpdateObject
    implements Runnable {
        private Object fAdapter;
        private GObjectProxy fProxy;
        private Component fComponent;

        UpdateObject(Object object, GObjectProxy gObjectProxy, Component component) {
            this.fAdapter = object;
            this.fProxy = gObjectProxy;
            this.fComponent = component;
        }

        public void run() {
            this.fProxy.updateProxy(this.fAdapter);
            this.fComponent.repaint(5L);
        }
    }

    private static class UpdateFigure
    implements Runnable {
        private UDDObject fAdapter;
        private Container fContainer;
        private Enumeration fEnumeration;
        private Component fComponent;

        UpdateFigure(Object object, Container container, Enumeration enumeration, Component component) {
            this.fAdapter = (UDDObject)object;
            this.fContainer = container;
            this.fEnumeration = enumeration;
            this.fComponent = component;
        }

        public void run() {
            int n = 4;
            Object object = this.fAdapter.getPropertyValue("Units");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if (n != 4) {
                this.fAdapter.setPropertyValue("Units", (Object)new Integer(4));
            }
            if ((object = this.fAdapter.getPropertyValue("Position")) != null && object instanceof HGRectangle) {
                HGRectangle hGRectangle = (HGRectangle)object;
                int n2 = (int)hGRectangle.getWidth();
                int n3 = (int)hGRectangle.getHeight();
                Dimension dimension = this.fContainer.getSize();
                if (n2 != dimension.width || n3 != dimension.height) {
                    this.fContainer.setSize(n2, n3);
                    LayoutArea.forceLayout(this.fContainer);
                    while (this.fEnumeration.hasMoreElements()) {
                        GObjectWrapper gObjectWrapper = (GObjectWrapper)this.fEnumeration.nextElement();
                        GObjectProxy gObjectProxy = (GObjectProxy)gObjectWrapper.getControl();
                        UDDObject uDDObject = (UDDObject)gObjectWrapper.getBean();
                        gObjectProxy.updatePosition(uDDObject);
                    }
                    this.fComponent.repaint(5L);
                }
            }
            if (n != 4) {
                this.fAdapter.setPropertyValue("Units", (Object)new Integer(n));
            }
        }
    }
}

