/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LayoutGridTarget;
import com.mathworks.ide.layout.RulerGuide;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

final class LayoutGrid {
    static final int DEFAULT_GRID_WIDTH = 50;
    private static final int SNAP_TOL = 9;
    private static final int HIT_TOL = 2;
    private boolean fSnapToGrid = false;
    private boolean fShowGrid = true;
    private boolean fShowGuides = true;
    private int fGridWidth = 50;
    private Vector fHGuideList = new Vector();
    private Vector fVGuideList = new Vector();
    private Vector fTargets = new Vector(3);

    void setSnapToGrid(boolean bl) {
        if (bl != this.fSnapToGrid) {
            this.fSnapToGrid = bl;
            this.notifyTargets();
        }
    }

    boolean getSnapToGrid() {
        return this.fSnapToGrid;
    }

    void setShowGrid(boolean bl) {
        this.fShowGrid = bl;
    }

    boolean getShowGrid() {
        return this.fShowGrid;
    }

    void setShowGuides(boolean bl) {
        this.fShowGuides = bl;
    }

    boolean getShowGuides() {
        return this.fShowGuides;
    }

    void setGridWidth(int n) {
        this.fGridWidth = n;
    }

    int getGridWidth() {
        return this.fGridWidth;
    }

    void snapToGrid(Point point, int n, int n2) {
        int n3;
        int n4;
        if (this.fSnapToGrid) {
            int n5 = point.x / this.fGridWidth;
            int n6 = point.y / this.fGridWidth;
            n4 = point.x - n5 * this.fGridWidth;
            n3 = point.y - n6 * this.fGridWidth;
            if (n4 < 9) {
                point.x = n5 * this.fGridWidth + n;
            } else if (this.fGridWidth - n4 < 9) {
                point.x = (n5 + 1) * this.fGridWidth + n;
            }
            if (n3 < 9) {
                point.y = n6 * this.fGridWidth + n2;
            } else if (this.fGridWidth - n3 < 9) {
                point.y = (n6 + 1) * this.fGridWidth + n2;
            }
        }
        Enumeration enumeration = this.fHGuideList.elements();
        while (enumeration.hasMoreElements()) {
            RulerGuide rulerGuide = (RulerGuide)enumeration.nextElement();
            n4 = Math.abs(rulerGuide.getLocation() - point.y);
            if (n4 >= 9) continue;
            point.y = rulerGuide.getLocation() + n2;
        }
        Enumeration enumeration2 = this.fVGuideList.elements();
        while (enumeration2.hasMoreElements()) {
            RulerGuide rulerGuide = (RulerGuide)enumeration2.nextElement();
            n3 = Math.abs(rulerGuide.getLocation() - point.x);
            if (n3 >= 9) continue;
            point.x = rulerGuide.getLocation() + n;
        }
    }

    Point getGridSnapRect(Rectangle rectangle, int n, int n2) {
        int n3;
        int n4;
        Point point = new Point(0, 0);
        int n5 = n / this.fGridWidth;
        int n6 = n2 / this.fGridWidth;
        int n7 = 0;
        while (n7 <= n5) {
            n4 = n7 * this.fGridWidth;
            n3 = rectangle.x - n4;
            if (n3 > 0) {
                if (n3 <= 9) {
                    point.x = n3 * -1;
                }
            } else {
                n3 = n4 - rectangle.x;
                if (n3 <= 9 && n3 + rectangle.x + rectangle.width <= n) {
                    point.x = n3;
                }
            }
            if (point.x == 0) {
                n3 = rectangle.x + rectangle.width - n4;
                if (n3 > 0) {
                    if (n3 <= 9) {
                        point.x = n3 * -1 + 1;
                    }
                } else {
                    n3 = n4 - (rectangle.x + rectangle.width);
                    if (n3 <= 9) {
                        point.x = n3 + 1;
                    }
                }
            }
            ++n7;
        }
        n7 = 0;
        while (n7 <= n6) {
            n4 = n7 * this.fGridWidth;
            n3 = rectangle.y - n4;
            if (n3 > 0) {
                if (n3 <= 9) {
                    point.y = n3 * -1;
                }
            } else {
                n3 = n4 - rectangle.y;
                if (n3 <= 9 && n3 - 1 + rectangle.y + rectangle.height <= n2) {
                    point.y = n3;
                }
            }
            if (point.y == 0) {
                n3 = rectangle.y + rectangle.height - n4;
                if (n3 > 0) {
                    if (n3 <= 9) {
                        point.y = n3 * -1 + 1;
                    }
                } else {
                    n3 = n4 - (rectangle.y + rectangle.height);
                    if (n3 <= 9) {
                        point.y = n3 + 1;
                    }
                }
            }
            ++n7;
        }
        return point;
    }

    Point getGuideSnapRect(Rectangle rectangle, int n, int n2) {
        int n3;
        int n4;
        RulerGuide rulerGuide;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = new Point(0, 0);
        rectangle2.x = rectangle.x;
        rectangle2.y = rectangle.y;
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
        Enumeration enumeration = this.fHGuideList.elements();
        while (enumeration.hasMoreElements()) {
            rulerGuide = (RulerGuide)enumeration.nextElement();
            n4 = rulerGuide.getLocation();
            n3 = rectangle.y - n4;
            if (n3 > 0) {
                if (n3 <= 9) {
                    point.y = n3 * -1;
                }
            } else {
                n3 = n4 - rectangle.y;
                if (n3 <= 9 && n3 + rectangle.y + rectangle.height <= n2) {
                    point.y = n3;
                }
            }
            if (point.y != 0) continue;
            n3 = rectangle.y + rectangle.height - n4;
            if (n3 > 0) {
                if (n3 > 9 || rectangle.y - n3 <= 0) continue;
                point.y = n3 * -1 + 1;
                continue;
            }
            n3 = n4 - (rectangle.y + rectangle.height);
            if (n3 > 9) continue;
            point.y = n3 + 1;
        }
        Enumeration enumeration2 = this.fVGuideList.elements();
        while (enumeration2.hasMoreElements()) {
            rulerGuide = (RulerGuide)enumeration2.nextElement();
            n4 = rulerGuide.getLocation();
            n3 = rectangle.x - n4;
            if (n3 > 0) {
                if (n3 <= 9) {
                    point.x = n3 * -1;
                }
            } else {
                n3 = n4 - rectangle.x;
                if (n3 <= 9 && n3 + rectangle.x + rectangle.width <= n) {
                    point.x = n3;
                }
            }
            if (point.x != 0) continue;
            n3 = rectangle.x + rectangle.width - n4;
            if (n3 > 0) {
                if (n3 > 9 || rectangle.x - n3 <= 0) continue;
                point.x = n3 * -1 + 1;
                continue;
            }
            n3 = n4 - (rectangle.x + rectangle.width);
            if (n3 > 9) continue;
            point.x = n3 + 1;
        }
        rectangle2.translate(point.x, point.y);
        return point;
    }

    void paintGrid(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Color color = Decorations.getColor((int)9);
        Color color2 = Color.blue;
        if (this.fShowGrid) {
            graphics.setColor(color);
            int n = rectangle.y / this.fGridWidth * this.fGridWidth;
            while (n < rectangle.y + rectangle.height) {
                graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
                n += this.fGridWidth;
            }
            int n2 = rectangle.x / this.fGridWidth * this.fGridWidth;
            while (n2 < rectangle.x + rectangle.width) {
                graphics.drawLine(n2, rectangle.y, n2, rectangle.y + rectangle.height);
                n2 += this.fGridWidth;
            }
        }
        if (this.fShowGuides) {
            graphics.setColor(color2);
            Enumeration enumeration = this.fHGuideList.elements();
            while (enumeration.hasMoreElements()) {
                RulerGuide rulerGuide = (RulerGuide)enumeration.nextElement();
                int n = rulerGuide.getLocation();
                graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
            }
            Enumeration enumeration2 = this.fVGuideList.elements();
            while (enumeration2.hasMoreElements()) {
                RulerGuide rulerGuide = (RulerGuide)enumeration2.nextElement();
                int n = rulerGuide.getLocation();
                graphics.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            }
        }
    }

    void addGuide(RulerGuide rulerGuide) {
        if (rulerGuide.getOrientation() == 1) {
            this.fHGuideList.addElement(rulerGuide);
            return;
        }
        this.fVGuideList.addElement(rulerGuide);
    }

    void removeGuide(RulerGuide rulerGuide) {
        if (rulerGuide.getOrientation() == 1) {
            this.fHGuideList.removeElement(rulerGuide);
            return;
        }
        this.fVGuideList.removeElement(rulerGuide);
    }

    RulerGuide findGuide(Point point) {
        if (this.fShowGuides) {
            Object object;
            Enumeration enumeration = this.fHGuideList.elements();
            while (enumeration.hasMoreElements()) {
                object = (RulerGuide)enumeration.nextElement();
                if (((RulerGuide)object).getLocation() < point.y - 2 || ((RulerGuide)object).getLocation() > point.y + 2) continue;
                return object;
            }
            object = this.fVGuideList.elements();
            while (object.hasMoreElements()) {
                RulerGuide rulerGuide = (RulerGuide)object.nextElement();
                if (rulerGuide.getLocation() < point.x - 2 || rulerGuide.getLocation() > point.x + 2) continue;
                return rulerGuide;
            }
        }
        return null;
    }

    void addLayoutGridTarget(LayoutGridTarget layoutGridTarget) {
        this.fTargets.addElement(layoutGridTarget);
    }

    void removeLayoutGridTarget(LayoutGridTarget layoutGridTarget) {
        this.fTargets.removeElement(layoutGridTarget);
    }

    void notifyTargets() {
        if (!this.fTargets.isEmpty()) {
            Enumeration enumeration = this.fTargets.elements();
            while (enumeration.hasMoreElements()) {
                LayoutGridTarget layoutGridTarget = (LayoutGridTarget)enumeration.nextElement();
                layoutGridTarget.snapToGridChanged(this.fSnapToGrid);
            }
        }
    }

    LayoutGrid() {
    }
}

