/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.inspector.Inspector;
import com.mathworks.ide.layout.AlignToolbar;
import com.mathworks.ide.layout.ConnectDialog;
import com.mathworks.ide.layout.FileEvent;
import com.mathworks.ide.layout.FileListener;
import com.mathworks.ide.layout.GridDialog;
import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.LayoutFormat;
import com.mathworks.ide.layout.LayoutFormatException;
import com.mathworks.ide.layout.LayoutGrid;
import com.mathworks.ide.layout.LayoutGridTarget;
import com.mathworks.ide.layout.LayoutLooper;
import com.mathworks.ide.layout.LayoutPrefs;
import com.mathworks.ide.layout.LayoutRuler;
import com.mathworks.ide.layout.RuntimeArea;
import com.mathworks.ide.layout.ToolPalette;
import com.mathworks.ide.layout.ToolRegistry;
import com.mathworks.ide.layout.menueditor.MenuEditor;
import com.mathworks.ide.objectbrowser.ObjectBrowser;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWScrollPanel;
import com.mathworks.mwt.MWScrollTarget;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandChain;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWFileDialog;
import com.mathworks.mwt.dialog.MWFileFilter;
import com.mathworks.mwt.undo.UndoEvent;
import com.mathworks.mwt.undo.UndoManager;
import com.mathworks.mwt.undo.UndoManagerListener;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowHider;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import com.mathworks.util.StringUtils;
import com.mathworks.util.jarloader.JarAccess;
import com.mathworks.util.jarloader.JarLoader;
import com.mathworks.util.jarloader.ObjectInputStreamLoader;
import com.mathworks.widgets.BrowserInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class LayoutEditor
extends MWCommandPanel
implements MWWindowOwner,
UndoManagerListener,
CompletionObserver,
BrowserInfo {
    public static ResourceBundle sLayoutBundle = ResourceBundle.getBundle("com.mathworks.ide.layout.resources.RES_Layout");
    public static final String LAYOUT_EDITOR_SERVICE = "com/mathworks/ide/layout/LayoutEditor";
    public static final int STANDARD_TYPE = 0;
    public static final int DASHBOARD_TYPE = 1;
    public static final int GOBJECT_TYPE = 2;
    public static final boolean LAYOUT_MODE = false;
    public static final boolean RUN_MODE = true;
    static final int ALL_EDIT_CMDS = 200;
    static final int DUPLICATE = 201;
    static final int DISCONNECT = 202;
    static final int INSPECT_THIS = 203;
    static final int PREFERENCES = 204;
    static final int EDIT_CALLBACK = 210;
    static final int EDIT_BUTTONDOWNFCN = 211;
    static final int EDIT_WINDOWBUTTONDOWNFCN = 212;
    static final int EDIT_WINDOWBUTTONMOTIONFCN = 213;
    static final int EDIT_WINDOWBUTTONUPFCN = 214;
    static final int EDIT_CREATEFCN = 215;
    static final int EDIT_DELETEFCN = 216;
    static final int EDIT_CLOSEREQUESTFCN = 217;
    static final int EDIT_RESIZEFCN = 218;
    static final int ALL_LAYOUT_CMDS = 300;
    static final int SHOW_RESIZE_WINDOW = 301;
    static final int SHOW_ALIGN_WINDOW = 302;
    static final int SHOW_GRID_WINDOW = 303;
    static final int TOGGLE_SNAP = 304;
    static final int SHOW_MENU_EDITOR = 305;
    static final int MOVE_TO_FRONT = 306;
    static final int MOVE_TO_BACK = 307;
    static final int MOVE_FORWARD = 308;
    static final int MOVE_BACKWARD = 309;
    static final int SHOW_INSPECTOR = 401;
    static final int SHOW_BROWSER = 402;
    static final int APPLICATION_OPTIONS = 403;
    static final int RUN = 404;
    static final int HELP = 501;
    static final int HELP_CREATING_GUIS = 502;
    static final int SELECTION_CHANGED = 1001;
    static final int CONTENT_CHANGED = 1002;
    static final int MAKE_CONNECTION = 1003;
    private static final String LAYOUT_PAGE = sLayoutBundle.getString("string.layout");
    private static final String RUNTIME_PAGE = sLayoutBundle.getString("string.runtime");
    private static final int DEFAULT_WIDTH = 560;
    private static final int DEFAULT_HEIGHT = 420;
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private static final String kDialsHelpString = "web(dnghelp('dials.html'));";
    private static final String kUntitledString = sLayoutBundle.getString("string.untitled");
    private static final String kStandardExtension = ".gui";
    private static final String kDashboardExtension = ".dash";
    private static final String kFigureExtension = ".fig";
    private static final String kDashboardPanelString = sLayoutBundle.getString("string.dials");
    private static final String kDashboardTypeString = sLayoutBundle.getString("string.dashboard");
    private static final String kWindowTypeString = sLayoutBundle.getString("string.window");
    private static final String kFigureTypeString = sLayoutBundle.getString("string.figure");
    private static final int INITIAL_HORIZONTAL_LOCATION = 20;
    private static final int INITIAL_VERTICAL_LOCATION = 60;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 20;
    private static int sCount;
    private static int sOpenCount;
    private static int sHorizontalLocation;
    private static int sVerticalLocation;
    private MWToolbar fToolbar;
    private ToolPalette fToolPalette;
    private MWMenuBar fMenuBar;
    private LayoutArea fLayoutArea;
    private RuntimeArea fRuntimeArea;
    private LayoutGrid fLayoutGrid;
    private MWPanel fTogglePanel;
    private MWFrame fEditorFrame;
    private MWCommandCenter fCenter;
    private UndoManager fUndoManager;
    private PrefListener fPrefListener;
    private File fFile;
    private Object fHandle;
    private Object fBean;
    private AlignToolbar fAlignToolbar;
    private MWFrame fAlignmentFrame;
    private GridDialog fGridDialog;
    private MWFrame fGridFrame;
    private ConnectDialog fConnectDialog;
    private MenuEditor fMenuEditor;
    private Rectangle fRuntimeBounds;
    private Rectangle fLayoutBounds;
    private boolean fDirty;
    private boolean fMarkDirtyLater;
    private boolean fState;
    private int fType;
    private String fWindowName;
    private Vector fFileListeners;
    private boolean fNoExtension;
    private boolean fActive;
    private boolean fCurrentlyRunning = false;
    private boolean fShowToolBar = LayoutPrefs.sShowToolBar;
    private boolean fShowToolNames = LayoutPrefs.sShowToolNames;
    private boolean fShowConnect = LayoutPrefs.sShowConnect;
    private boolean fShowExtension = LayoutPrefs.sShowExtension;
    private boolean fShowFullPath = LayoutPrefs.sShowFullPath;
    private static ResourceBundle sRes;

    private LayoutEditor(int n) {
        this.fType = n;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setOpaqueInsets(false);
        ((Component)((Object)this)).setName("Layout Editor");
        this.fEditorFrame = new MWFrame();
        this.fEditorFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this)));
        if (this.fType != 2) {
            this.fUndoManager = new UndoManager();
            this.fUndoManager.addUndoManagerListener((UndoManagerListener)this);
        }
        this.fRuntimeArea = new RuntimeArea(this);
        ((Component)((Object)this.fRuntimeArea)).setSize(560, 420);
        ((Component)((Object)this.fRuntimeArea)).addComponentListener(new RuntimeResized());
        if (this.fType != 2) {
            this.fEditorFrame.addComponentListener(new FrameMoved());
        }
        this.fRuntimeBounds = new Rectangle(sHorizontalLocation, sVerticalLocation, 560, 420);
        this.fLayoutArea = new LayoutArea(560, 420, (Container)((Object)this.fRuntimeArea));
        this.fLayoutArea.setNextTarget((MWCommandChain)this);
        this.fLayoutArea.setUndoManager(this.fUndoManager);
        this.fLayoutGrid = new LayoutGrid();
        this.fLayoutArea.setGrid(this.fLayoutGrid);
        this.fToolPalette = this.buildToolPalette();
        this.fLayoutArea.setPalette(this.fToolPalette);
        switch (this.fType) {
            default: {
                this.fWindowName = kWindowTypeString;
                break;
            }
            case 1: {
                this.fWindowName = kDashboardTypeString;
                break;
            }
            case 2: {
                this.fWindowName = kFigureTypeString;
            }
        }
        this.fCenter = this.buildCommandCenter((MWCommandChain)this.fLayoutArea);
        this.setCommandCenter(this.fCenter);
        this.fLayoutArea.setCommandCenter(this.fCenter);
        MWScrollPanel mWScrollPanel = new MWScrollPanel((Component)((Object)this.fLayoutArea));
        mWScrollPanel.setInsets(false, false, false, false);
        ((Container)((Object)this)).add((Component)mWScrollPanel, "Center");
        ((Container)((Object)this)).add((Component)((Object)this.fToolPalette), "West");
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.setOpaque(false);
        mWPanel.add((Component)((Object)this), "Center");
        if (this.fShowToolBar) {
            this.fToolbar = this.buildToolbar();
            mWPanel.add((Component)this.fToolbar, "North");
        }
        this.fTogglePanel = new MWPanel((LayoutManager)new CardLayout());
        this.fTogglePanel.setOpaque(false);
        this.fEditorFrame.add((Component)this.fTogglePanel, "Center");
        this.fTogglePanel.add((Component)mWPanel, LAYOUT_PAGE);
        this.fTogglePanel.add((Component)((Object)this.fRuntimeArea), RUNTIME_PAGE);
        int n2 = this.fType == 2 ? 420 : 0;
        LayoutRuler layoutRuler = new LayoutRuler(this.fLayoutArea, 1, 0);
        LayoutRuler layoutRuler2 = new LayoutRuler(this.fLayoutArea, 0, n2);
        this.fLayoutArea.setHRuler(layoutRuler);
        this.fLayoutArea.setVRuler(layoutRuler2);
        mWScrollPanel.add((Component)((Object)layoutRuler), "North");
        mWScrollPanel.add((Component)((Object)layoutRuler2), "West");
        mWScrollPanel.add(LayoutRuler.buildMitre(), "Northwest");
        mWScrollPanel.addScrollTarget((MWScrollTarget)layoutRuler);
        mWScrollPanel.addScrollTarget((MWScrollTarget)layoutRuler2);
        this.fMenuBar = this.buildMenuBar();
        this.fMenuBar.attachTo(this.fEditorFrame);
        this.fLayoutArea.setObjectPopup(this.buildObjectPopup());
        this.fLayoutArea.setWindowPopup(this.buildWindowPopup());
        this.fLayoutArea.addService(LAYOUT_EDITOR_SERVICE, (Object)this);
        Dimension dimension = ((Component)((Object)this)).getParent().getPreferredSize();
        this.fLayoutBounds = new Rectangle(sHorizontalLocation, sVerticalLocation, dimension.width, dimension.height);
        this.setContentBounds(this.fLayoutBounds);
        this.fPrefListener = new PrefChanged();
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"Layout");
    }

    public String toString() {
        return String.valueOf(sLayoutBundle.getString("string.layout_document")) + " [" + ((Component)((Object)this.fRuntimeArea)).getName() + "]";
    }

    private MWCommandCenter buildCommandCenter(MWCommandChain mWCommandChain) {
        this.fCenter = new MWCommandCenter((MWCommandTarget)mWCommandChain, 40);
        this.fCenter.setCommandEnabled(-101, true);
        this.fCenter.setCommandEnabled(-102, true);
        this.fCenter.setCommandEnabled(-103, true);
        this.fCenter.setCommandEnabled(-104, false);
        this.fCenter.setCommandEnabled(-105, true);
        this.fCenter.setCommandEnabled(-107, false);
        this.fCenter.setCommandEnabled(-108, false);
        this.fCenter.setCommandEnabled(-109, true);
        this.fCenter.setCommandEnabled(-201, false);
        this.fCenter.setCommandEnabled(-202, false);
        this.fCenter.setCommandEnabled(-203, false);
        this.fCenter.setCommandEnabled(-204, false);
        this.fCenter.setCommandEnabled(-205, false);
        this.fCenter.setCommandEnabled(-206, false);
        this.fCenter.setCommandEnabled(-207, true);
        this.fCenter.setCommandEnabled(201, false);
        this.fCenter.setCommandEnabled(202, false);
        this.fCenter.setCommandEnabled(204, true);
        this.fCenter.setCommandEnabled(203, true);
        this.fCenter.setCommandEnabled(302, true);
        this.fCenter.setCommandEnabled(303, true);
        this.fCenter.setCommandEnabled(304, true);
        this.fCenter.setCommandEnabled(305, false);
        this.fCenter.setCommandEnabled(306, false);
        this.fCenter.setCommandEnabled(307, false);
        this.fCenter.setCommandEnabled(308, false);
        this.fCenter.setCommandEnabled(309, false);
        this.fCenter.setCommandEnabled(401, true);
        this.fCenter.setCommandEnabled(402, true);
        this.fCenter.setCommandEnabled(404, true);
        this.fCenter.setCommandEnabled(501, true);
        return this.fCenter;
    }

    private ToolPalette buildToolPalette() {
        ToolPalette toolPalette = null;
        switch (this.fType) {
            default: {
                toolPalette = new ToolPalette(ToolRegistry.getStandardToolRegistry(), this.fShowConnect, this.fShowToolNames, this.fLayoutArea);
                break;
            }
            case 1: {
                toolPalette = new ToolPalette(ToolRegistry.getStandardToolRegistry(), true, this.fShowToolNames, this.fLayoutArea);
                toolPalette.changePanel(kDashboardPanelString);
                break;
            }
            case 2: {
                toolPalette = new ToolPalette(ToolRegistry.getUIControlToolRegistry(), false, this.fShowToolNames, this.fLayoutArea);
            }
        }
        return toolPalette;
    }

    private MWToolbar buildToolbar() {
        MWToolbar mWToolbar = new MWToolbar(this.getCommandCenter());
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/new.gif", -101, sLayoutBundle.getString("tip.new"));
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/open.gif", -102, sLayoutBundle.getString("tip.open"));
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/save.gif", -104, sLayoutBundle.getString("tip.save"));
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/cut.gif", -203, sLayoutBundle.getString("tip.cut"));
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/copy.gif", -204, sLayoutBundle.getString("tip.copy"));
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/paste.gif", -205, sLayoutBundle.getString("tip.paste"));
        if (this.fType != 2) {
            mWToolbar.addImageButton("/com/mathworks/mwt/resources/undo.gif", -201, sLayoutBundle.getString("tip.undo"));
            mWToolbar.addImageButton("/com/mathworks/mwt/resources/redo.gif", -202, sLayoutBundle.getString("tip.redo"));
        }
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/ide/layout/resources/alignicon.gif", 302, sLayoutBundle.getString("tip.align_objects"));
        mWToolbar.addImageButton("/com/mathworks/ide/layout/menueditor/resources/menueditor.gif", 305, sLayoutBundle.getString("tip.edit_menubar"));
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/ide/inspector/resources/inspectoricon.gif", 401, sLayoutBundle.getString("tip.property_inspector"));
        mWToolbar.addImageButton("/com/mathworks/ide/objectbrowser/resources/objectbrowsericon.gif", 402, sLayoutBundle.getString("tip.object_browser"));
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/ide/resources/figureicon.gif", 404, String.valueOf(sLayoutBundle.getString("tip.activate")) + " " + this.fWindowName);
        mWToolbar.setOpaqueInsets(false);
        switch (PlatformInfo.getAppearance()) {
            case 1: {
                mWToolbar.setTopInset(2);
                mWToolbar.setBottomInset(0);
                break;
            }
            case 0: {
                mWToolbar.setBottomInset(2);
                break;
            }
        }
        return mWToolbar;
    }

    private MWMenuBar buildMenuBar() {
        MWMenuBar mWMenuBar = new MWMenuBar(this.getCommandCenter());
        MWMenu mWMenu = mWMenuBar.addMenu(sLayoutBundle.getString("menu.file"));
        mWMenu.addMenuItem(sLayoutBundle.getString("menu.new"), -101, 78);
        mWMenu.addMenuItem(sLayoutBundle.getString("menu.open"), -102, 79);
        mWMenu.addSeparator();
        mWMenu.addMenuItem(sLayoutBundle.getString("menu.close"), -103, 87);
        mWMenu.addMenuItem(sLayoutBundle.getString("menu.save"), -104, 83);
        mWMenu.addMenuItem(sLayoutBundle.getString("menu.save_as"), -105);
        if (PlatformInfo.getAppearance() != 0) {
            mWMenu.addSeparator();
            mWMenu.addMenuItem(sLayoutBundle.getString("menu.prefs"), 204);
        }
        mWMenu.addSeparator();
        mWMenu.addMenuItem(sLayoutBundle.getString("menu.print"), -109, 80);
        MWMenu mWMenu2 = mWMenuBar.addMenu(sLayoutBundle.getString("menu.edit"), 200);
        if (this.fType != 2) {
            mWMenu2.addMenuItem(sLayoutBundle.getString("menu.undo"), -201, 90);
            mWMenu2.addMenuItem(sLayoutBundle.getString("menu.redo"), -202, 89);
            mWMenu2.addSeparator();
        }
        mWMenu2.addMenuItem(sLayoutBundle.getString("menu.cut"), -203, 88);
        mWMenu2.addMenuItem(sLayoutBundle.getString("menu.copy"), -204, 67);
        mWMenu2.addMenuItem(sLayoutBundle.getString("menu.paste"), -205, 86);
        mWMenu2.addMenuItem(sLayoutBundle.getString("menu.clear"), -206);
        mWMenu2.addMenuItem(sLayoutBundle.getString("menu.select_all"), -207, 65);
        mWMenu2.addSeparator();
        mWMenu2.addMenuItem(sLayoutBundle.getString("menu.duplicate"), 201, 68);
        if (this.fType != 2) {
            mWMenu2.addMenuItem(sLayoutBundle.getString("menu.disconnect"), 202);
        }
        mWMenu2.addSeparator();
        mWMenu2.addMenuItem(sLayoutBundle.getString("menu.inspect_properties"), 203);
        if (PlatformInfo.getAppearance() == 0) {
            mWMenu2.addSeparator();
            mWMenu2.addMenuItem(sLayoutBundle.getString("menu.prefs"), 204);
        }
        MWMenu mWMenu3 = mWMenuBar.addMenu(sLayoutBundle.getString("menu.layout"), 300);
        mWMenu3.addMenuItem(sLayoutBundle.getString("menu.align_objects"), 302);
        mWMenu3.addSeparator();
        mWMenu3.addMenuItem(sLayoutBundle.getString("menu.grid_and_rulers"), 303);
        MWMenuItem mWMenuItem = mWMenu3.addMenuItem(sLayoutBundle.getString("menu.snap_to_grid"), 304);
        mWMenu3.addSeparator();
        mWMenu3.addMenuItem(sLayoutBundle.getString("menu.menubar"), 305);
        mWMenu3.addSeparator();
        mWMenu3.addMenuItem(sLayoutBundle.getString("menu.bring_to_front"), 306, 70);
        mWMenu3.addMenuItem(sLayoutBundle.getString("menu.send_to_back"), 307, 66);
        mWMenu3.addMenuItem(sLayoutBundle.getString("menu.bring_forward"), 308);
        mWMenu3.addMenuItem(sLayoutBundle.getString("menu.send_backward"), 309);
        this.fLayoutGrid.addLayoutGridTarget(new SnapChanged(mWMenuItem));
        MWMenu mWMenu4 = mWMenuBar.addMenu(sLayoutBundle.getString("menu.tools"));
        mWMenu4.addMenuItem(sLayoutBundle.getString("menu.property_inspector"), 401);
        mWMenu4.addMenuItem(sLayoutBundle.getString("menu.object_browser"), 402);
        mWMenu4.addMenuItem(sLayoutBundle.getString("menu.application_options"), 403);
        mWMenu4.addSeparator();
        Object[] objectArray = new Object[]{this.fWindowName};
        String string = MessageFormat.format(sLayoutBundle.getString("menu.activate"), objectArray);
        mWMenu4.addMenuItem(string, 404, 84);
        if (this.fType == 1 || this.fType == 2) {
            MWMenu mWMenu5 = new MWMenu(sLayoutBundle.getString("menu.help"), this.getCommandCenter());
            if (this.fType == 1) {
                MWMenuItem mWMenuItem2 = new MWMenuItem(sLayoutBundle.getString("menu.dials_and_guages"));
                this.fCenter.addCommandSource((MWCommandSource)mWMenuItem2, 501);
                mWMenu5.add((MWMenuComponent)mWMenuItem2);
            } else {
                mWMenu5.addMenuItem(sLayoutBundle.getString("menu.using_the_LE"), 501);
                mWMenu5.addMenuItem(sLayoutBundle.getString("menu_creating_GUIs"), 502);
            }
            mWMenuBar.add((MWMenuComponent)mWMenu5);
        }
        return mWMenuBar;
    }

    private MWMenu buildObjectPopup() {
        MWMenu mWMenu = new MWMenu(sLayoutBundle.getString("popmenu.layout"), this.getCommandCenter());
        mWMenu.addMenuItem(sLayoutBundle.getString("tip.cut"), -203);
        mWMenu.addMenuItem(sLayoutBundle.getString("tip.copy"), -204);
        mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.delete"), -206);
        mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.duplicate"), 201);
        mWMenu.addSeparator();
        mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.bring_to_front"), 306);
        mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.send_to_back"), 307);
        mWMenu.addSeparator();
        mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.inspect_properties"), 203);
        if (this.fType == 2) {
            mWMenu.addSeparator();
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_callback"), 210);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_buttondownfcn"), 211);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_createfcn"), 215);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_deletefcn"), 216);
        }
        return mWMenu;
    }

    private MWMenu buildWindowPopup() {
        MWMenu mWMenu = new MWMenu(sLayoutBundle.getString("popmenu.layout"), this.getCommandCenter());
        mWMenu.addMenuItem(sLayoutBundle.getString("tip.paste"), -205);
        MWMenuItem mWMenuItem = mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.snap_to_grid"), 304);
        mWMenu.addSeparator();
        if (PlatformInfo.getAppearance() != 0) {
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.options"), 403);
            mWMenu.addSeparator();
        }
        mWMenu.addMenuItem(sLayoutBundle.getString("tip.property_inspector"), 401);
        mWMenu.addMenuItem(sLayoutBundle.getString("tip.object_browser"), 402);
        mWMenu.addSeparator();
        mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.activate_window"), 404);
        if (this.fType == 2) {
            mWMenu.addSeparator();
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_buttondownfcn"), 211);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_windowbuttondonwfcn"), 212);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_windowbuttonmotionfcn"), 213);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_windowbuttonupfcn"), 214);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_createfcn"), 215);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_deletefcn"), 216);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_closerequestfcn"), 217);
            mWMenu.addMenuItem(sLayoutBundle.getString("popmenu.edit_resizefcn"), 218);
        }
        this.fLayoutGrid.addLayoutGridTarget(new SnapChanged(mWMenuItem));
        return mWMenu;
    }

    public Insets getInsets() {
        if (PlatformInfo.getAppearance() == 1) {
            return new Insets(2, 2, 2, 2);
        }
        return super.getInsets();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (PlatformInfo.getAppearance() == 1) {
            Dimension dimension = ((Component)((Object)this)).getSize();
            Decorations.drawBevelFrame((Graphics)graphics, (int)0, (int)0, (int)dimension.width, (int)dimension.height);
        }
    }

    public void doCommand(int n) {
        switch (n) {
            case -101: {
                LayoutEditor.newLayoutEditor(this.fType);
                return;
            }
            case -102: {
                this.doOpen();
                return;
            }
            case -103: {
                this.closeWindow();
                return;
            }
            case -104: {
                this.doSave();
                return;
            }
            case -105: {
                this.doSaveAs();
                return;
            }
            case -109: {
                this.doPrint();
                return;
            }
            case -201: {
                if (this.fUndoManager == null) break;
                this.fUndoManager.undo();
                return;
            }
            case -202: {
                if (this.fUndoManager == null) break;
                this.fUndoManager.redo();
                return;
            }
            case 204: {
                this.doPreferences();
                return;
            }
            case 203: {
                if (!this.fLayoutArea.hasSelection()) {
                    Object[] objectArray = new Object[]{this.getBean()};
                    ObjectRegistry.getLayoutRegistry().setSelected(objectArray, true);
                }
                Inspector.activateInspector();
                return;
            }
            case 302: {
                this.showAlignmentWindow();
                return;
            }
            case 303: {
                this.showGridDlgWindow();
                return;
            }
            case 304: {
                this.toggleSnap();
                return;
            }
            case 305: {
                this.showMenuEditor();
                return;
            }
            case 401: {
                Inspector.activateInspector();
                return;
            }
            case 402: {
                ObjectBrowser.activateObjectBrowser();
                return;
            }
            case 403: {
                if (this.fHandle == null) break;
                LayoutLooper.applicationOptions(this.fHandle);
                return;
            }
            case 404: {
                if (this.fHandle != null) {
                    LayoutLooper.activateFigure(this.fHandle, new ActivateCompleted());
                    this.setCurrentlyRunning(true);
                    return;
                }
                this.setState(!this.fState);
                return;
            }
            case 501: {
                if (this.fType == 1) {
                    LayoutLooper.requestEval(kDialsHelpString);
                    return;
                }
                if (this.fType != 2) break;
                LayoutLooper.executeInM("helpUsingLayout");
                return;
            }
            case 502: {
                LayoutLooper.executeInM("helpCreatingGUIs");
                return;
            }
            case 1001: {
                this.selectionChanged();
                return;
            }
            case 1002: {
                this.contentChanged(null);
                return;
            }
            case 1003: {
                this.makeConnection();
                return;
            }
            default: {
                super.doCommand(n);
            }
        }
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case -109: 
            case -105: 
            case -103: 
            case -102: 
            case -101: 
            case 203: 
            case 204: 
            case 302: 
            case 303: 
            case 401: 
            case 402: {
                return true;
            }
            case 404: {
                return !this.fCurrentlyRunning;
            }
            case 305: {
                return this.fHandle != null;
            }
            case 200: 
            case 300: {
                return !this.fState;
            }
            case -104: {
                return this.fDirty;
            }
            case -201: {
                return this.fUndoManager != null && this.fUndoManager.canUndo();
            }
            case -202: {
                return this.fUndoManager != null && this.fUndoManager.canRedo();
            }
            case 501: {
                return this.fType == 1 && LayoutLooper.isAvailable();
            }
        }
        return super.isCommandEnabled(n);
    }

    public Frame getFrame() {
        return this.fEditorFrame;
    }

    public boolean getDirty() {
        return this.fDirty;
    }

    private void markDirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean bl) {
        if (bl != this.fDirty) {
            this.fDirty = bl;
            this.fCenter.updateCommand(-104);
        }
    }

    public boolean isCurrentlyRunning() {
        return this.fCurrentlyRunning;
    }

    public void setCurrentlyRunning(boolean bl) {
        if (this.fCurrentlyRunning != bl) {
            this.fCurrentlyRunning = bl;
            this.fCenter.updateCommand(404);
        }
    }

    protected final LayoutArea getLayoutArea() {
        return this.fLayoutArea;
    }

    protected final RuntimeArea getRuntimeArea() {
        return this.fRuntimeArea;
    }

    private void buildAlignmentWindow() {
        this.fAlignToolbar = new AlignToolbar(this.fLayoutArea);
        this.fAlignmentFrame = new MWFrame(this.fAlignToolbar.getWindowTitle());
        this.fAlignmentFrame.setResizable(false);
        this.fAlignmentFrame.add("Center", (Component)((Object)this.fAlignToolbar));
        this.fAlignmentFrame.addWindowListener((WindowListener)new MWWindowHider((Component)((Object)this.fAlignToolbar)));
        this.fAlignmentFrame.setContentSize(((Container)((Object)this.fAlignToolbar)).getPreferredSize());
        Rectangle rectangle = this.fEditorFrame.getBounds();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fAlignmentFrame.getSize();
        int n = rectangle.x + rectangle.width + 8;
        int n2 = rectangle.y;
        int n3 = n + dimension2.width;
        if (n3 > dimension.width - 4) {
            n -= n3 - dimension.width + 4;
            n2 += 4;
        }
        this.fAlignmentFrame.setLocation(n, n2);
    }

    private void buildGridDlgWindow() {
        this.fGridDialog = new GridDialog(this.fLayoutArea);
        this.fGridFrame = new MWFrame(this.fGridDialog.getWindowTitle());
        this.fGridFrame.setResizable(false);
        this.fGridFrame.add("Center", (Component)((Object)this.fGridDialog));
        this.fGridFrame.addWindowListener((WindowListener)new MWWindowHider((Component)((Object)this.fGridDialog)));
        Dimension dimension = ((Container)((Object)this.fGridDialog)).getPreferredSize();
        dimension.width += 4;
        this.fGridFrame.setContentSize(dimension);
        Rectangle rectangle = this.fEditorFrame.getBounds();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.fGridFrame.getSize();
        int n = rectangle.x + rectangle.width + 8;
        int n2 = rectangle.y;
        int n3 = n + dimension3.width;
        if (n3 > dimension2.width - 4) {
            n -= n3 - dimension2.width + 4;
            n2 += 4;
        }
        this.fGridFrame.setLocation(n, n2);
    }

    private void showAlignmentWindow() {
        if (this.fAlignmentFrame == null) {
            this.buildAlignmentWindow();
        }
        if (this.fAlignmentFrame != null && this.fLayoutArea != null) {
            if (PlatformInfo.isMicrosoftVM()) {
                this.fAlignmentFrame.setVisible(false);
            }
            this.fAlignmentFrame.setVisible(true);
        }
    }

    private void showGridDlgWindow() {
        if (this.fGridFrame == null) {
            this.buildGridDlgWindow();
        }
        if (this.fGridFrame != null && this.fLayoutArea != null) {
            if (!this.fGridFrame.isVisible()) {
                this.fGridDialog.updateState();
            }
            if (PlatformInfo.isMicrosoftVM()) {
                this.fGridFrame.setVisible(false);
            }
            this.fGridFrame.setVisible(true);
        }
    }

    private void toggleSnap() {
        this.setSnap(!this.getSnap());
    }

    boolean getSnap() {
        return this.fLayoutGrid.getSnapToGrid();
    }

    void setSnap(boolean bl) {
        this.fLayoutGrid.setSnapToGrid(bl);
    }

    public void toFront() {
        if (PlatformInfo.isMicrosoftVM()) {
            this.fEditorFrame.setVisible(false);
            this.fEditorFrame.setVisible(true);
            return;
        }
        this.fEditorFrame.toFront();
    }

    public final void addBean(Object object, int n, int n2, int n3, int n4) {
        this.fLayoutArea.addBeanExternal(object, n, n2, n3, n4);
    }

    public final String[] getComponentNames() {
        return this.fLayoutArea.getComponentNames();
    }

    public final Object getComponentByName(String string) {
        return this.fLayoutArea.getComponentByName(string);
    }

    public File getFile() {
        File file = null;
        if (this.fFile != null) {
            file = new File(this.fFile.getPath());
        }
        return file;
    }

    public synchronized void addFileListener(FileListener fileListener) {
        if (this.fFileListeners == null) {
            this.fFileListeners = new Vector();
        }
        this.fFileListeners.addElement(fileListener);
    }

    private void fireFileEvent(File file) {
        if (this.fFileListeners != null) {
            Enumeration enumeration = this.fFileListeners.elements();
            String string = file != null ? file.getPath() : null;
            String string2 = this.fFile != null ? this.fFile.getPath() : null;
            while (enumeration.hasMoreElements()) {
                FileListener fileListener = (FileListener)enumeration.nextElement();
                File file2 = string != null ? new File(string) : null;
                File file3 = string2 != null ? new File(string2) : null;
                FileEvent fileEvent = new FileEvent((Object)this, file2, file3);
                fileListener.fileChanged(fileEvent);
            }
        }
    }

    void fireObjectChangedEvent() {
        Object[] objectArray = new Object[]{this.getBean()};
        ObjectRegistry.getLayoutRegistry().change(objectArray);
    }

    public String getBrowserLabel() {
        return this.getDocumentName();
    }

    public String getDocumentName() {
        if (this.fNoExtension) {
            return ((Component)((Object)this.fRuntimeArea)).getName();
        }
        return String.valueOf(((Component)((Object)this.fRuntimeArea)).getName()) + this.getExtension();
    }

    public String getRuntimeName() {
        return ((Component)((Object)this.fRuntimeArea)).getName();
    }

    private String getExtension() {
        switch (this.fType) {
            case 1: {
                return kDashboardExtension;
            }
            case 2: {
                return kFigureExtension;
            }
        }
        return kStandardExtension;
    }

    private void updateTitle() {
        String string;
        if (this.fState) {
            String string2 = this.fRuntimeArea.getTitle();
            string = string2 == null || string2.equals("") ? ((Component)((Object)this.fRuntimeArea)).getName() : string2;
        } else {
            String string3;
            if (this.fFile != null) {
                int n;
                string = this.fShowFullPath ? StringUtils.fromJavaPath((String)this.fFile.getAbsolutePath()) : StringUtils.xlate((String)this.fFile.getName());
                if (!this.fShowExtension && (n = string.lastIndexOf(".")) != -1) {
                    string = string.substring(0, n);
                }
            } else {
                string = !this.fNoExtension && this.fShowExtension ? String.valueOf(((Component)((Object)this.fRuntimeArea)).getName()) + this.getExtension() : ((Component)((Object)this.fRuntimeArea)).getName();
            }
            if ((string3 = this.fRuntimeArea.getTitle()) != null && !string3.equals("")) {
                string = String.valueOf(string) + " [" + string3 + "]";
            }
        }
        if (!string.equals(this.fEditorFrame.getTitle())) {
            this.fEditorFrame.setTitle(string);
        }
    }

    void nameChanged() {
        String string;
        if (this.fFile != null && !(string = StringUtils.xlate((String)this.fFile.getName())).equals(this.getDocumentName())) {
            this.fFile = null;
            this.fNoExtension = false;
        }
        this.updateTitle();
    }

    void titleChanged() {
        this.updateTitle();
    }

    String getTitle() {
        return this.fRuntimeArea.getTitle();
    }

    void setTitle(String string) {
        this.fRuntimeArea.setTitle(string);
    }

    public synchronized void removeFileListener(FileListener fileListener) {
        if (this.fFileListeners != null) {
            this.fFileListeners.removeElement(fileListener);
            if (this.fFileListeners.size() == 0) {
                this.fFileListeners = null;
            }
        }
    }

    public void dirtyStateChanged(UndoEvent undoEvent) {
    }

    public void undoabilityChanged(UndoEvent undoEvent) {
        this.fCenter.updateCommand(-201);
    }

    public void redoabilityChanged(UndoEvent undoEvent) {
        this.fCenter.updateCommand(-202);
    }

    public int closeWindow() {
        return this.closeWindow(0);
    }

    public int closeWindow(int n) {
        if (n == 0 && this.checkIfDirty() == 1) {
            return 1;
        }
        this.hideWindow();
        this.fLayoutArea.removeServices();
        if (this.fGridFrame != null) {
            this.fGridFrame.dispose();
        }
        if (this.fAlignmentFrame != null) {
            this.fAlignmentFrame.dispose();
        }
        if (this.fConnectDialog != null) {
            this.fConnectDialog.dispose();
        }
        if (this.fMenuEditor != null) {
            this.fMenuEditor.closeWindow();
        }
        if (this.fEditorFrame != null) {
            this.fEditorFrame.dispose();
        }
        if (this.fPrefListener != null) {
            Prefs.removeListener((PrefListener)this.fPrefListener);
        }
        if (this.fHandle != null) {
            LayoutLooper.deleteObject(this.fHandle);
            this.fHandle = null;
        }
        return 0;
    }

    private int checkIfDirty() {
        int n = 0;
        if (this.fDirty) {
            Object[] objectArray = new Object[]{this.getDocumentName()};
            String string = MessageFormat.format(sLayoutBundle.getString("question.savechangestofile"), objectArray);
            int n2 = PlatformInfo.getAppearance() == 0 ? 5 : 4;
            MWAlert mWAlert = new MWAlert((Frame)this.fEditorFrame, sLayoutBundle.getString("alert.matlab_layout_editor"), string, n2);
            int n3 = mWAlert.getReply();
            mWAlert.dispose();
            mWAlert = null;
            if (n3 == 4) {
                n = 1;
            } else if (n3 == 1) {
                n = this.doSave();
            }
        }
        return n;
    }

    public void setActive(boolean bl) {
        this.fActive = bl;
        if (PlatformInfo.getAppearance() == 0 && PlatformInfo.getVendor() != 1) {
            this.fCenter.setActive(bl);
            this.fToolPalette.setEnabled(bl);
        }
        this.fLayoutArea.getHRuler().setShowTracker(bl);
        this.fLayoutArea.getVRuler().setShowTracker(bl);
        if (bl) {
            if (this.fState) {
                ((Component)((Object)this.fRuntimeArea)).requestFocus();
            } else {
                ((Component)((Object)this.fLayoutArea)).requestFocus();
            }
            this.fCenter.setCommandEnabled(-205, LayoutArea.canPaste());
        }
    }

    public String getShortName() {
        return ((Component)((Object)this.fRuntimeArea)).getName();
    }

    public String getLongName() {
        return this.getShortName();
    }

    public void showWindow() {
        if (this.fEditorFrame != null && !this.fEditorFrame.isVisible()) {
            this.register();
            this.fEditorFrame.setVisible(true);
            ++sOpenCount;
        }
    }

    private void register() {
        if (this.fType != 2) {
            this.registerObject((Object)this.fRuntimeArea);
        }
        WindowRegistry.getRegistry().register((MWWindowOwner)this);
    }

    private void unregister() {
        this.fLayoutArea.unregisterAll();
        this.unregisterObject(this.getBean());
        WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
    }

    private void registerObject(Object object) {
        Object[] objectArray = new Object[]{object};
        ObjectRegistry.getLayoutRegistry().register(objectArray, null, -1, null, true);
        ObjectRegistry.getLayoutRegistry().setSelected(objectArray, true);
        this.fLayoutArea.registerAll();
    }

    private void unregisterObject(Object object) {
        Object[] objectArray = new Object[]{object};
        ObjectRegistry.getLayoutRegistry().unregister(objectArray);
        if (ObjectRegistry.getLayoutRegistry().isSelected(object)) {
            ObjectRegistry.getLayoutRegistry().setSelected(objectArray, false);
        }
    }

    private Object getBean() {
        if (this.fType != 2) {
            return this.fRuntimeArea;
        }
        if (this.fBean != null) {
            return this.fBean;
        }
        return null;
    }

    public void hideWindow() {
        if (this.fEditorFrame != null && this.fEditorFrame.isVisible()) {
            if (--sOpenCount <= 0) {
                sOpenCount = 0;
                sHorizontalLocation = 20;
                sVerticalLocation = 60;
            }
            this.fEditorFrame.setVisible(false);
            this.unregister();
        }
    }

    protected void doOpen() {
        if (this.fType == 2) {
            LayoutLooper.executeInM("openFigure");
            return;
        }
        MWFileFilter mWFileFilter = Prefs.getBooleanPref((String)"LayoutAllFiles", (boolean)false) ? new MWFileFilter() : new MWFileFilter(this.getExtension());
        MWFileDialog mWFileDialog = new MWFileDialog((Frame)this.fEditorFrame, sLayoutBundle.getString("frame.open_file"), 0, mWFileFilter);
        mWFileDialog.show();
        String string = mWFileDialog.getDirectory();
        String string2 = mWFileDialog.getFile();
        if (string2 != null) {
            File file = new File(string, string2);
            LayoutEditor.openLayoutEditor(file, this.fType);
        }
    }

    protected int doSave() {
        if (this.fType == 2) {
            LayoutLooper.executeInM("save", this.fHandle);
            return 0;
        }
        if (this.fFile == null) {
            return this.doSaveAs();
        }
        return this.writeDocumentToFile(this.fFile);
    }

    private static boolean isValidMatName(String string) {
        int n = string.length();
        if (n == 0 || !Character.isLetter(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected int doSaveAs() {
        String string;
        if (this.fType == 2) {
            LayoutLooper.executeInM("saveAs", this.fHandle);
            return 0;
        }
        String string2 = this.getExtension();
        MWFileDialog mWFileDialog = new MWFileDialog((Frame)this.fEditorFrame, sLayoutBundle.getString("frame.save_as"), 1, new MWFileFilter(string2));
        mWFileDialog.setFile(String.valueOf(((Component)((Object)this.fRuntimeArea)).getName()) + string2);
        mWFileDialog.show();
        String string3 = mWFileDialog.getDirectory();
        String string4 = mWFileDialog.getFile();
        if (string4 == null) {
            return 1;
        }
        boolean bl = false;
        if (string4.endsWith(string2)) {
            string = string4.substring(0, string4.lastIndexOf(string2));
        } else {
            bl = true;
            string = string4;
            string4 = String.valueOf(string4) + string2;
        }
        if (!LayoutEditor.isValidMatName(string)) {
            Object[] objectArray = new Object[]{string};
            String string5 = MessageFormat.format(sLayoutBundle.getString("question.error.notavalididentifier"), objectArray);
            MWAlert mWAlert = new MWAlert((Frame)this.fEditorFrame, sLayoutBundle.getString("alert.matlab_layout_editor"), string5, 1);
            mWAlert.dispose();
            mWAlert = null;
            return 1;
        }
        File file = new File(string3, string4);
        if (bl && file.exists()) {
            Object[] objectArray = new Object[]{string4};
            String string6 = MessageFormat.format(sLayoutBundle.getString("alert.filealreadyexists"), objectArray);
            MWAlert mWAlert = new MWAlert((Frame)this.fEditorFrame, sLayoutBundle.getString("alert.matlab_layout_editor"), string6, 1);
            mWAlert.dispose();
            mWAlert = null;
            return 1;
        }
        return this.writeDocumentToFile(file);
    }

    private void doPrint() {
        Object object = this.fState ? this.fRuntimeArea : this.fLayoutArea;
        PrintJob printJob = ((Component)((Object)this)).getToolkit().getPrintJob((Frame)this.fEditorFrame, this.getDocumentName(), null);
        if (printJob == null) {
            return;
        }
        Graphics graphics = printJob.getGraphics();
        graphics.setFont(((Component)object).getFont());
        Dimension dimension = printJob.getPageDimension();
        Dimension dimension2 = ((Component)object).getSize();
        int n = 0;
        int n2 = 0;
        if (dimension2.width < dimension.width) {
            n = (dimension.width - dimension2.width) / 2;
        }
        if (dimension2.height < dimension.height) {
            n2 = (dimension.height - dimension2.height) / 2;
        }
        if (n != 0 || n2 != 0) {
            graphics.translate(n, n2);
        }
        graphics.drawRect(-1, -1, dimension2.width + 1, dimension2.height + 1);
        if (PlatformInfo.getPlatform() == 1) {
            graphics.setClip(-16000, -16000, 32000, 32000);
        } else {
            graphics.setClip(0, 0, dimension2.width, dimension2.height);
        }
        ((Component)object).print(graphics);
        graphics.dispose();
        graphics = null;
        printJob.end();
    }

    protected void doPreferences() {
        PrefsDialog.showPrefsDialog(sRes.getString("area.guide"));
    }

    Rectangle getDocumentBounds() {
        return this.getRuntimeBounds();
    }

    void setDocumentBounds(Rectangle rectangle) {
        this.fRuntimeBounds = new Rectangle(rectangle);
        if (this.fState) {
            this.setContentBounds(rectangle);
            this.fLayoutBounds.x = rectangle.x;
            this.fLayoutBounds.y = rectangle.y;
            return;
        }
        if (!this.fState) {
            ((Component)((Object)this.fRuntimeArea)).setSize(rectangle.width, rectangle.height);
            this.fLayoutBounds.x = rectangle.x;
            this.fLayoutBounds.y = rectangle.y;
            this.fEditorFrame.setContentLocation(rectangle.x, rectangle.y);
        }
    }

    void setDocumentLocation(int n, int n2) {
        this.fEditorFrame.setContentLocation(n, n2);
        this.fRuntimeBounds.x = n;
        this.fRuntimeBounds.y = n2;
        this.fLayoutBounds.x = n;
        this.fLayoutBounds.y = n2;
    }

    void setDocumentSize(int n, int n2) {
        ((Component)((Object)this.fRuntimeArea)).setSize(n, n2);
        ((Component)((Object)this.fLayoutArea)).setSize(n, n2);
        Dimension dimension = ((Component)((Object)this)).getParent().getPreferredSize();
        this.fEditorFrame.setContentSize(dimension.width, dimension.height);
        this.fRuntimeBounds.width = n;
        this.fRuntimeBounds.height = n2;
        this.fLayoutBounds.width = dimension.width;
        this.fLayoutBounds.height = dimension.height;
    }

    void setRuntimeBounds(Rectangle rectangle) {
        this.fRuntimeBounds = rectangle;
        ((Component)((Object)this.fRuntimeArea)).setSize(rectangle.width, rectangle.height);
        ((Component)((Object)this.fLayoutArea)).setSize(rectangle.width, rectangle.height);
    }

    void setLayoutBounds(Rectangle rectangle) {
        this.fLayoutBounds = rectangle;
        this.fLayoutBounds.x = this.fRuntimeBounds.x;
        this.fLayoutBounds.y = this.fRuntimeBounds.y;
        this.setContentBounds(rectangle);
    }

    Rectangle getRuntimeBounds() {
        return this.fRuntimeBounds;
    }

    Rectangle getLayoutBounds() {
        return this.fLayoutBounds;
    }

    private void setContentBounds(Rectangle rectangle) {
        this.fEditorFrame.setContentLocation(rectangle.x, rectangle.y);
        this.fEditorFrame.setContentSize(rectangle.width, rectangle.height);
    }

    public void setState(boolean bl) {
        if (bl != this.fState) {
            CardLayout cardLayout = (CardLayout)this.fTogglePanel.getLayout();
            if (!bl) {
                this.fState = bl;
                this.fLayoutArea.hideBeans();
                this.setContentBounds(this.fLayoutBounds);
                MWCommandSource mWCommandSource = this.fMenuBar.findCommandSource(404);
                if (mWCommandSource != null && mWCommandSource instanceof MWMenuItem) {
                    Object[] objectArray = new Object[]{this.fWindowName};
                    String string = MessageFormat.format(sLayoutBundle.getString("menu.activate"), objectArray);
                    ((MWMenuItem)mWCommandSource).setLabel(string);
                }
                cardLayout.show((Container)this.fTogglePanel, LAYOUT_PAGE);
                this.updateTitle();
                if (this.fActive) {
                    this.fLayoutArea.getHRuler().setShowTracker(true);
                    this.fLayoutArea.getVRuler().setShowTracker(true);
                    ((Component)((Object)this.fLayoutArea)).requestFocus();
                }
                if (this.fMarkDirtyLater) {
                    this.fMarkDirtyLater = false;
                    this.markDirty();
                }
            } else {
                this.fState = bl;
                this.setContentBounds(this.fRuntimeBounds);
                MWCommandSource mWCommandSource = this.fMenuBar.findCommandSource(404);
                if (mWCommandSource != null && mWCommandSource instanceof MWMenuItem) {
                    Object[] objectArray = new Object[]{this.fWindowName};
                    String string = MessageFormat.format(sLayoutBundle.getString("menu.editwindowname"), objectArray);
                    ((MWMenuItem)mWCommandSource).setLabel(string);
                }
                cardLayout.show((Container)this.fTogglePanel, RUNTIME_PAGE);
                this.fLayoutArea.showBeans();
                this.fLayoutArea.getHRuler().setShowTracker(false);
                this.fLayoutArea.getVRuler().setShowTracker(false);
                this.updateTitle();
                if (this.fActive) {
                    ((Component)((Object)this.fRuntimeArea)).requestFocus();
                }
            }
            this.fCenter.updateCommand(200);
            this.fCenter.updateCommand(300);
        }
    }

    public final boolean getState() {
        return this.fState;
    }

    private void selectionChanged() {
        this.fCenter.updateCommand(-203);
        this.fCenter.updateCommand(-204);
        this.fCenter.updateCommand(-206);
        this.fCenter.updateCommand(201);
        this.fCenter.updateCommand(202);
        this.fCenter.updateCommand(306);
        this.fCenter.updateCommand(307);
        this.fCenter.updateCommand(308);
        this.fCenter.updateCommand(309);
    }

    public void contentChanged(Object object) {
        if (!this.fState) {
            this.markDirty();
        } else if (this.fState) {
            this.fMarkDirtyLater = true;
        }
        this.fCenter.updateCommand(202);
    }

    private void makeConnection() {
        LOControlWrapper lOControlWrapper = this.fLayoutArea.getMarkedWrapper(0);
        LOControlWrapper lOControlWrapper2 = this.fLayoutArea.getMarkedWrapper(1);
        this.fLayoutArea.clearMarkers();
        if (lOControlWrapper != null && lOControlWrapper2 != null) {
            if (this.fConnectDialog != null) {
                this.fConnectDialog.dispose();
            }
            this.fConnectDialog = new ConnectDialog(this.fLayoutArea, (Frame)this.fEditorFrame, lOControlWrapper, lOControlWrapper2);
            ((Window)((Object)this.fConnectDialog)).addWindowListener(new ConnectDialogClosed());
        }
    }

    private void clearConnectDialog() {
        this.fConnectDialog = null;
    }

    private void showMenuEditor() {
        if (this.fMenuEditor != null) {
            Window window = MWUtils.getTopLevelWindow((Component)((Object)this.fMenuEditor));
            if (window != null) {
                window.toFront();
                return;
            }
        } else if (this.fHandle != null) {
            double[] dArray = (double[])this.fHandle;
            this.fMenuEditor = MenuEditor.invoke(dArray[0]);
            this.fMenuEditor.setNextTarget((MWCommandChain)this);
            Window window = MWUtils.getTopLevelWindow((Component)((Object)this.fMenuEditor));
            if (window != null) {
                window.addWindowListener(new MenuEditorClosed());
            }
        }
    }

    private void setMenuEditor(MenuEditor menuEditor) {
        this.fMenuEditor = menuEditor;
    }

    public void writeDocument(String string) {
        String string2 = StringUtils.toJavaPath((String)string);
        this.writeDocumentToFile(new File(string2));
    }

    private static boolean checkWrite(File file) {
        boolean bl = false;
        if (file.exists()) {
            bl = file.canWrite();
        } else {
            File file2;
            String string = file.getParent();
            if (string != null && !string.equals("") && (file2 = new File(string)).exists()) {
                bl = file2.canWrite();
            }
        }
        return bl;
    }

    private int writeDocumentToFile(File file) {
        int n = 0;
        if (!LayoutEditor.checkWrite(file)) {
            Object[] objectArray = new Object[]{StringUtils.xlate((String)file.getName())};
            String string = MessageFormat.format(sLayoutBundle.getString("error.fileisnotwritable"), objectArray);
            MWAlert mWAlert = new MWAlert((Frame)this.fEditorFrame, sLayoutBundle.getString("alert.matlab_layout_editor"), string, 1);
            mWAlert.dispose();
            mWAlert = null;
            n = 1;
        } else {
            n = this.writeDocumentToJarFile(file);
        }
        return n;
    }

    private void writeCompleted(File file) {
        this.fFile = file;
        String string = StringUtils.xlate((String)this.fFile.getName());
        int n = string.lastIndexOf(".");
        if (n != -1 && n != 0) {
            string = string.substring(0, n);
        }
        if (!string.equals(((Component)((Object)this.fRuntimeArea)).getName())) {
            this.fRuntimeArea.setName(string);
        }
        this.fDirty = false;
        this.fMarkDirtyLater = false;
        this.fCenter.updateCommand(-104);
    }

    public void writeCompleted(String string) {
        this.writeCompleted(new File(string));
    }

    private int writeDocumentToJarFile(File file) {
        String string;
        int n;
        block9: {
            File file2 = null;
            n = 0;
            try {
                try {
                    File file3 = new File(file.getParent());
                    file2 = new File(file3, "contents.ser");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    LayoutFormat layoutFormat = new LayoutFormat();
                    layoutFormat.writeLayout(objectOutputStream, this);
                    objectOutputStream.close();
                    String[] stringArray = new String[]{"contents.ser"};
                    JarAccess.create((OutputStream)new FileOutputStream(file), (File)file3, null, (String[])stringArray);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{file};
                    String string2 = MessageFormat.format(sLayoutBundle.getString("alert.couldnotsavefile"), objectArray);
                    System.out.println(string2);
                    System.out.println(exception);
                    n = 1;
                }
                string = null;
                if (file2 == null || !file2.exists()) break block9;
                file2.delete();
            }
            catch (Throwable throwable) {
                Object var5_14 = null;
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
                throw throwable;
            }
        }
        if (n == 0) {
            File file4 = this.fFile;
            this.fFile = file;
            string = StringUtils.xlate((String)this.fFile.getName());
            int n2 = string.lastIndexOf(".");
            boolean bl = this.fNoExtension = n2 == -1;
            if (n2 != -1 && n2 != 0) {
                string = string.substring(0, n2);
            }
            if (!string.equals(((Component)((Object)this.fRuntimeArea)).getName())) {
                this.fRuntimeArea.setName(string);
                this.fireObjectChangedEvent();
            }
            if (file4 != null && !file4.equals(file)) {
                this.fireFileEvent(file4);
            }
            this.fDirty = false;
            this.fMarkDirtyLater = false;
            this.fCenter.setCommandEnabled(-104, false);
        }
        return n;
    }

    private void readDocumentFromFile(File file) throws ClassNotFoundException, FileNotFoundException, IOException, StreamCorruptedException, LayoutFormatException {
        if (this.fType == 2) {
            this.readDocumentFromFigFile(file);
            return;
        }
        this.readDocumentFromJarFile(file);
    }

    private void readDocumentFromFigFile(File file) {
        LayoutLooper.readFigure(StringUtils.fromJavaPath((String)file.getAbsolutePath()), this);
        this.fFile = file;
        String string = StringUtils.xlate((String)this.fFile.getName());
        int n = string.lastIndexOf(".");
        boolean bl = this.fNoExtension = n == -1;
        if (n != -1 && n != 0) {
            string = string.substring(0, n);
        }
        this.fRuntimeArea.setName(string);
    }

    private void readDocumentFromJarFile(File file) throws ClassNotFoundException, FileNotFoundException, IOException, StreamCorruptedException, LayoutFormatException {
        JarLoader jarLoader = new JarLoader(file.getPath());
        jarLoader.loadJar();
        ClassLoader classLoader = jarLoader.getLoader();
        InputStream inputStream = classLoader.getResourceAsStream("contents.ser");
        ObjectInputStreamLoader objectInputStreamLoader = new ObjectInputStreamLoader(inputStream, classLoader);
        LayoutFormat layoutFormat = new LayoutFormat();
        layoutFormat.readLayout((ObjectInputStream)objectInputStreamLoader, this);
        objectInputStreamLoader.close();
        this.fLayoutArea.addServices();
        this.fFile = file;
        String string = StringUtils.xlate((String)this.fFile.getName());
        int n = string.lastIndexOf(".");
        boolean bl = this.fNoExtension = n == -1;
        if (n != -1 && n != 0) {
            string = string.substring(0, n);
        }
        this.fRuntimeArea.setName(string);
    }

    public static LayoutEditor newLayoutEditor() {
        return LayoutEditor.newLayoutEditor(2);
    }

    public static LayoutEditor newLayoutEditor(int n) {
        LayoutEditor layoutEditor = LayoutEditor.untitledLayoutEditor(n);
        if (n == 2 && LayoutLooper.isAvailable()) {
            LayoutLooper.requestFigure(layoutEditor);
        } else {
            layoutEditor.showWindow();
        }
        return layoutEditor;
    }

    private static LayoutEditor untitledLayoutEditor(int n) {
        LayoutEditor layoutEditor = new LayoutEditor(n);
        String string = sCount == 0 ? kUntitledString : String.valueOf(kUntitledString) + sCount;
        ++sCount;
        layoutEditor.getRuntimeArea().setName(string);
        Frame frame = layoutEditor.getFrame();
        Dimension dimension = frame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if ((sHorizontalLocation += 10) + dimension.width > dimension2.width) {
            sHorizontalLocation = 20;
        }
        if ((sVerticalLocation += 20) + dimension.height > dimension2.height) {
            sVerticalLocation = 60;
        }
        return layoutEditor;
    }

    public static LayoutEditor openLayoutEditor(String string) {
        return LayoutEditor.openLayoutEditor(string, 2);
    }

    public static LayoutEditor openLayoutEditor(String string, int n) {
        String string2 = StringUtils.toJavaPath((String)string);
        return LayoutEditor.openLayoutEditor(new File(string2), n);
    }

    public static LayoutEditor openLayoutEditor(File file) {
        return LayoutEditor.openLayoutEditor(file, 1);
    }

    private static boolean compareFileNames(String string, String string2) {
        if (PlatformInfo.getPlatform() != 2) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    private static LayoutEditor findLayoutEditor(File file) {
        Enumeration enumeration = WindowRegistry.getRegistry().owners();
        String string = file.toString();
        while (enumeration.hasMoreElements()) {
            MWWindowOwner mWWindowOwner = (MWWindowOwner)enumeration.nextElement();
            if (!(mWWindowOwner instanceof LayoutEditor)) continue;
            LayoutEditor layoutEditor = (LayoutEditor)mWWindowOwner;
            File file2 = layoutEditor.fFile;
            if (file2 == null || !LayoutEditor.compareFileNames(string, file2.toString())) continue;
            return layoutEditor;
        }
        return null;
    }

    public static LayoutEditor openLayoutEditor(File file, int n) {
        if (!file.exists()) {
            return null;
        }
        String string = file.getName();
        if (string.endsWith(kDashboardExtension)) {
            n = 1;
        } else if (string.endsWith(kFigureExtension)) {
            n = 2;
        } else if (n == 1) {
            n = 0;
        }
        LayoutEditor layoutEditor = LayoutEditor.findLayoutEditor(file);
        if (layoutEditor != null) {
            layoutEditor.toFront();
        } else {
            try {
                layoutEditor = new LayoutEditor(n);
                layoutEditor.readDocumentFromFile(file);
                if (n != 2 || !LayoutLooper.isAvailable()) {
                    layoutEditor.showWindow();
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{file};
                String string2 = MessageFormat.format(sLayoutBundle.getString("alert.couldnotreadserializeddata"), objectArray);
                layoutEditor = null;
                System.out.println(string2);
                System.out.println(exception);
            }
        }
        return layoutEditor;
    }

    public static LayoutEditor openLayoutEditor(double d) {
        LayoutEditor layoutEditor = LayoutEditor.untitledLayoutEditor(2);
        if (LayoutLooper.isAvailable()) {
            LayoutLooper.snapshotFigure(d, layoutEditor);
        } else {
            layoutEditor.showWindow();
        }
        return layoutEditor;
    }

    private void frameMoved() {
        if (this.fState) {
            Point point = this.fEditorFrame.getContentLocation();
            if (point.x != this.fRuntimeBounds.x || point.y != this.fRuntimeBounds.y) {
                this.fRuntimeBounds.x = point.x;
                this.fRuntimeBounds.y = point.y;
                this.fLayoutBounds.x = this.fRuntimeBounds.x;
                this.fLayoutBounds.y = this.fRuntimeBounds.y;
                this.fireObjectChangedEvent();
            }
            return;
        }
        if (!this.fState) {
            Point point = this.fEditorFrame.getContentLocation();
            if (point.x != this.fLayoutBounds.x || point.y != this.fLayoutBounds.y) {
                this.fLayoutBounds.x = point.x;
                this.fLayoutBounds.y = point.y;
                this.fRuntimeBounds.x = this.fLayoutBounds.x;
                this.fRuntimeBounds.y = this.fLayoutBounds.y;
                this.fireObjectChangedEvent();
            }
        }
    }

    private void frameResized() {
        if (!this.fState) {
            Dimension dimension = ((Component)((Object)this)).getParent().getParent().getSize();
            this.fLayoutBounds.width = dimension.width;
            this.fLayoutBounds.height = dimension.height;
        }
    }

    private void runtimeResized() {
        Dimension dimension = ((Component)((Object)this.fRuntimeArea)).getSize();
        if (dimension.width != this.fRuntimeBounds.width || dimension.height != this.fRuntimeBounds.height) {
            this.fRuntimeBounds.width = dimension.width;
            this.fRuntimeBounds.height = dimension.height;
            this.fireObjectChangedEvent();
        }
        ((Component)((Object)this.fLayoutArea)).setSize(dimension.width, dimension.height);
        if (this.fType == 2) {
            this.fLayoutArea.getVRuler().setLabelStart(dimension.height);
        }
    }

    private void updatePrefs() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.fShowToolBar != Prefs.getBooleanPref((String)"LayoutToolBar")) {
            this.fShowToolBar = Prefs.getBooleanPref((String)"LayoutToolBar");
            bl = true;
        }
        if (this.fShowToolNames != Prefs.getBooleanPref((String)"LayoutToolNames")) {
            this.fShowToolNames = Prefs.getBooleanPref((String)"LayoutToolNames");
            bl2 = true;
        }
        if (this.fShowConnect != Prefs.getBooleanPref((String)"LayoutConnect")) {
            this.fShowConnect = Prefs.getBooleanPref((String)"LayoutConnect");
            bl2 = true;
        }
        if (this.fShowExtension != Prefs.getBooleanPref((String)"LayoutExtension")) {
            this.fShowExtension = Prefs.getBooleanPref((String)"LayoutExtension");
            bl3 = true;
        }
        if (this.fShowFullPath != Prefs.getBooleanPref((String)"LayoutFullPath")) {
            this.fShowFullPath = Prefs.getBooleanPref((String)"LayoutFullPath");
            bl3 = true;
        }
        if (bl) {
            if (this.fToolbar != null) {
                ((Component)((Object)this)).getParent().remove((Component)this.fToolbar);
                this.fToolbar = null;
            } else {
                this.fToolbar = this.buildToolbar();
                ((Component)((Object)this)).getParent().add((Component)this.fToolbar, "North");
            }
        }
        if (bl2) {
            ((Container)((Object)this)).remove((Component)((Object)this.fToolPalette));
            this.fToolPalette = this.buildToolPalette();
            ((Container)((Object)this)).add((Component)((Object)this.fToolPalette), "West");
            this.fLayoutArea.setPalette(this.fToolPalette);
        }
        if (bl || bl2) {
            ((Component)((Object)this)).getParent().validate();
        }
        if (bl3) {
            this.updateTitle();
        }
    }

    public void completed(int n, Object object) {
        if (LayoutLooper.checkStatus(n) == 0 && object != null && object instanceof Object[]) {
            Object object2;
            Object[] objectArray = (Object[])object;
            this.fHandle = objectArray[0];
            this.fBean = objectArray[1];
            this.fLayoutArea.setFigure(this.fHandle);
            this.fLayoutArea.setRootObject(this.fBean);
            this.registerObject(this.fBean);
            double[] dArray = (double[])objectArray[2];
            int n2 = (int)dArray[2];
            int n3 = (int)dArray[3];
            if (n2 != 560 || n3 != 420) {
                ((Component)((Object)this.fRuntimeArea)).setSize(n2, n3);
                ((Component)((Object)this.fLayoutArea)).setSize(n2, n3);
                this.fLayoutArea.getVRuler().setLabelStart(n3);
                object2 = ((Component)((Object)this)).getParent().getPreferredSize();
                this.fEditorFrame.setContentSize(object2.width, object2.height);
            }
            if (objectArray.length == 6) {
                object2 = (double[])objectArray[3];
                Object[] objectArray2 = (Object[])objectArray[4];
                Object[] objectArray3 = (Object[])objectArray[5];
                int n4 = ((double[])object2).length;
                int n5 = 0;
                while (n5 < n4) {
                    this.fLayoutArea.addGObject(object2[n5], objectArray2[n5], (Component)objectArray3[n5], 0);
                    ++n5;
                }
            }
            this.fCenter.updateCommand(305);
            QueueEvent.postQueueEvent((QueueEvent)new ShowWindowEvent());
            return;
        }
        System.out.println(sLayoutBundle.getString("alert.couldnotcreatefigure"));
        System.out.println(LayoutLooper.checkStatus(n));
    }

    public static void main(String[] stringArray) {
        try {
            LayoutEditor.newLayoutEditor(0);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    static {
        sHorizontalLocation = 20;
        sVerticalLocation = 60;
        sRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");
    }

    class ActivateCompleted
    implements CompletionObserver {
        public void completed(int n, Object object) {
            LayoutEditor.this.setCurrentlyRunning(false);
        }

        ActivateCompleted() {
            LayoutEditor.this = LayoutEditor.this;
        }
    }

    private class ConnectDialogClosed
    extends WindowAdapter {
        public void windowClosed(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.removeWindowListener(this);
            LayoutEditor.this.clearConnectDialog();
        }

        ConnectDialogClosed() {
            LayoutEditor.this = LayoutEditor.this;
        }
    }

    private class MenuEditorClosed
    extends WindowAdapter {
        public void windowClosed(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.removeWindowListener(this);
            LayoutEditor.this.setMenuEditor(null);
        }

        MenuEditorClosed() {
            LayoutEditor.this = LayoutEditor.this;
        }
    }

    private class WriteCompleted
    implements CompletionObserver {
        private File fFile;

        WriteCompleted(File file) {
            LayoutEditor.this = LayoutEditor.this;
            this.fFile = file;
        }

        public void completed(int n, Object object) {
            if (LayoutLooper.checkStatus(n) == 0) {
                LayoutEditor.this.writeCompleted(this.fFile);
                return;
            }
            Object[] objectArray = new Object[]{this.fFile};
            String string = MessageFormat.format(sLayoutBundle.getString("alert.couldnotsavefile"), objectArray);
            System.out.println(string);
            System.out.println(LayoutLooper.checkStatus(n));
        }
    }

    private class FrameMoved
    extends ComponentAdapter {
        public void componentMoved(ComponentEvent componentEvent) {
            LayoutEditor.this.frameMoved();
        }

        public void componentResized(ComponentEvent componentEvent) {
            LayoutEditor.this.frameResized();
        }

        FrameMoved() {
            LayoutEditor.this = LayoutEditor.this;
        }
    }

    private class RuntimeResized
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            LayoutEditor.this.runtimeResized();
        }

        RuntimeResized() {
            LayoutEditor.this = LayoutEditor.this;
        }
    }

    private class SnapChanged
    implements LayoutGridTarget {
        private MWMenuItem fItem;

        SnapChanged(MWMenuItem mWMenuItem) {
            LayoutEditor.this = LayoutEditor.this;
            this.fItem = mWMenuItem;
        }

        public void snapToGridChanged(boolean bl) {
            this.fItem.setState(bl);
        }
    }

    private class PrefChanged
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            LayoutEditor.this.updatePrefs();
        }

        PrefChanged() {
            LayoutEditor.this = LayoutEditor.this;
        }
    }

    private class ShowWindowEvent
    extends QueueEvent {
        public void dispatch() {
            LayoutEditor.this.showWindow();
        }

        ShowWindowEvent() {
            LayoutEditor.this = LayoutEditor.this;
        }
    }
}

