/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.beans.ServiceClient;
import com.mathworks.beans.ServiceRegistry;
import com.mathworks.ide.inspector.Inspector;
import com.mathworks.ide.layout.AddDrag;
import com.mathworks.ide.layout.ConnectDrag;
import com.mathworks.ide.layout.CornerDrag;
import com.mathworks.ide.layout.DragTracker;
import com.mathworks.ide.layout.GObjectProxy;
import com.mathworks.ide.layout.GObjectWrapper;
import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LOGlueWrapper;
import com.mathworks.ide.layout.LOTabWrapper;
import com.mathworks.ide.layout.LOWrapperOwner;
import com.mathworks.ide.layout.LayoutFormat;
import com.mathworks.ide.layout.LayoutFormatException;
import com.mathworks.ide.layout.LayoutGrid;
import com.mathworks.ide.layout.LayoutLooper;
import com.mathworks.ide.layout.LayoutRuler;
import com.mathworks.ide.layout.MoveDrag;
import com.mathworks.ide.layout.ResizeDrag;
import com.mathworks.ide.layout.RulerGuide;
import com.mathworks.ide.layout.RulerGuideDrag;
import com.mathworks.ide.layout.RuntimeArea;
import com.mathworks.ide.layout.SelectDrag;
import com.mathworks.ide.layout.TagManager;
import com.mathworks.ide.layout.ToolPalette;
import com.mathworks.ide.layout.UndoAdd;
import com.mathworks.ide.layout.UndoConnect;
import com.mathworks.ide.layout.UndoDelete;
import com.mathworks.ide.layout.UndoMove;
import com.mathworks.ide.layout.UndoReorder;
import com.mathworks.ide.layout.lowidgets.LOGroupbox;
import com.mathworks.ide.layout.lowidgets.LOTabLayer;
import com.mathworks.ide.layout.lowidgets.LOTabPanel;
import com.mathworks.ide.layout.lowidgets.SubpanelOwner;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.undo.UndoManager;
import com.mathworks.mwt.undo.UndoableEdit;
import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.util.IntHashtable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Timer;
import com.mathworks.util.VectorSort;
import com.mathworks.util.jarloader.ObjectInputStreamLoader;
import com.mathworks.util.jarloader.SimpleClassLoader;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class LayoutArea
extends MWCommandPanel
implements MouseListener,
MouseMotionListener,
LOWrapperOwner {
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private static final int AXES_LAYER = 0;
    private static final int CONTROL_LAYER = 1;
    private static final int INVISIBLE_LAYER = 2;
    private static final int BEAN_LAYER = 3;
    private static final int UICONTROL_LAYER = 4;
    private static final int GLUE_LAYER = 5;
    private static final int NUM_LAYERS = 6;
    private static final int V_NO_ALIGN_DIST = 0;
    private static final int V_TOP_JUSTIFY_ALIGN = 1;
    private static final int V_CTR_JUSTIFY_ALIGN = 2;
    private static final int V_BOT_JUSTIFY_ALIGN = 3;
    private static final int V_INSIDE_DIST = 4;
    private static final int V_TOP_DIST = 5;
    private static final int V_CTR_DIST = 6;
    private static final int V_BOT_DIST = 7;
    private static final int H_NO_ALIGN_DIST = 0;
    private static final int H_LEFT_JUSTIFY_ALIGN = 1;
    private static final int H_CTR_JUSTIFY_ALIGN = 2;
    private static final int H_RIGHT_JUSTIFY_ALIGN = 3;
    private static final int H_INSIDE_DIST = 4;
    private static final int H_LEFT_DIST = 5;
    private static final int H_CTR_DIST = 6;
    private static final int H_RIGHT_DIST = 7;
    private static final int BIG_MOVE_INCREMENT = 10;
    private static final int DELAY = 5;
    private static final int DRAG_DIM = 8;
    private static byte[] sClipByteArray;
    private static int sClipNumPastes;
    private static ArrowTimer sArrowTimer;
    public static final String LAYOUT_AREA_SERVICE = "com/mathworks/ide/layout/LayoutArea";
    static final int MIN_DIM = 8;
    private int fSelectionCount;
    private LayoutGrid fLayoutGrid;
    private ToolPalette fToolPalette;
    private LayoutRuler fHRuler;
    private LayoutRuler fVRuler;
    private Vector[] fControlList;
    private int fNumLayers;
    private RuntimeArea fRuntimeArea;
    private Object fHandle;
    private Object fRootObject;
    private Container fHoldingArea;
    private DragTracker fDragTracker;
    private Runnable fKeyTracker;
    private ObjectOwner fObjectOwner;
    private UndoManager fUndoManager;
    private ServiceRegistry fServiceRegistry;
    private ObjectRegistryListener fChangeListener;
    private ItemListener fSelectionListener;
    private MWMenu fObjectPopup;
    private MWMenu fWindowPopup;
    private TagManager fTagManager;
    private Point fLastClick;
    private Point fMouseStart;
    private IntHashtable fMarkerTable;
    private int fArrowID;
    static final int FORWARD = 0;
    static final int BACKWARD = 1;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$java$applet$Applet;
    static /* synthetic */ Class class$com$mathworks$beans$ServiceClient;

    static boolean canPaste() {
        return sClipByteArray != null;
    }

    LayoutArea(int n, int n2, Container container) {
        ((Container)((Object)this)).setLayout(null);
        ((Component)((Object)this)).setSize(n, n2);
        ((Component)((Object)this)).setName("Layout Area");
        this.fRuntimeArea = (RuntimeArea)((Object)container);
        this.fHoldingArea = new HoldingArea(container);
        this.fObjectOwner = new LayoutOwner();
        this.fChangeListener = new ObjectChanged();
        this.fSelectionListener = new SelectionChanged();
        this.fTagManager = new TagManager(this);
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
        ((Component)((Object)this)).addKeyListener(new LayoutKey());
        this.fNumLayers = 6;
        this.fControlList = new Vector[this.fNumLayers];
        int n3 = 0;
        while (n3 < this.fNumLayers) {
            this.fControlList[n3] = new Vector(5, 5);
            ++n3;
        }
        ((Component)((Object)this)).setBackground(Color.white);
        this.fServiceRegistry = new ServiceRegistry();
        this.fServiceRegistry.registerService(LAYOUT_AREA_SERVICE, (Object)this);
    }

    final Object getRootObject() {
        if (this.fRootObject != null) {
            return this.fRootObject;
        }
        return this.fRuntimeArea;
    }

    final void setRootObject(Object object) {
        this.fRootObject = object;
    }

    final void setFigure(Object object) {
        this.fHandle = object;
    }

    public void setPalette(ToolPalette toolPalette) {
        this.fToolPalette = toolPalette;
    }

    public ToolPalette getPalette() {
        return this.fToolPalette;
    }

    public void setHRuler(LayoutRuler layoutRuler) {
        this.fHRuler = layoutRuler;
    }

    public LayoutRuler getHRuler() {
        return this.fHRuler;
    }

    public void setVRuler(LayoutRuler layoutRuler) {
        this.fVRuler = layoutRuler;
    }

    public LayoutRuler getVRuler() {
        return this.fVRuler;
    }

    final void setObjectPopup(MWMenu mWMenu) {
        this.fObjectPopup = mWMenu;
        this.fObjectPopup.attachTo((Component)((Object)this));
    }

    final void setWindowPopup(MWMenu mWMenu) {
        this.fWindowPopup = mWMenu;
        this.fWindowPopup.attachTo((Component)((Object)this));
    }

    final void setGrid(LayoutGrid layoutGrid) {
        this.fLayoutGrid = layoutGrid;
    }

    final LayoutGrid getGrid() {
        return this.fLayoutGrid;
    }

    final void updatePasteCmd() {
        this.getCommandCenter().updateCommand(-205);
    }

    public void doCommand(int n) {
        switch (n) {
            case -203: {
                this.doCut();
                this.updatePasteCmd();
                return;
            }
            case -204: {
                this.doCopy();
                this.updatePasteCmd();
                return;
            }
            case -205: {
                this.doPaste();
                return;
            }
            case -206: {
                this.doClear();
                return;
            }
            case -207: {
                this.selectAllObjects(true);
                return;
            }
            case 201: {
                this.doDuplicate(new Point(10, 10));
                return;
            }
            case 202: {
                this.doDisconnect();
                return;
            }
            case 306: {
                this.MoveToFront();
                return;
            }
            case 307: {
                this.MoveToBack();
                return;
            }
            case 308: {
                this.MoveForward();
                return;
            }
            case 309: {
                this.MoveBackward();
                return;
            }
            case 210: {
                this.editCallback("Callback");
                return;
            }
            case 211: {
                this.editCallback("ButtondownFcn");
                return;
            }
            case 212: {
                this.editCallback("WindowButtondownFcn");
                return;
            }
            case 213: {
                this.editCallback("WindowButtonmotionFcn");
                return;
            }
            case 214: {
                this.editCallback("WindowButtonupFcn");
                return;
            }
            case 215: {
                this.editCallback("CreateFcn");
                return;
            }
            case 216: {
                this.editCallback("DeleteFcn");
                return;
            }
            case 217: {
                this.editCallback("CloseRequestFcn");
                return;
            }
            case 218: {
                this.editCallback("ResizeFcn");
                return;
            }
        }
        super.doCommand(n);
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case -204: 
            case -203: {
                return this.hasSelection();
            }
            case -206: 
            case 201: {
                return this.hasSelection();
            }
            case 306: 
            case 307: 
            case 308: 
            case 309: {
                return this.hasSelection();
            }
            case 202: {
                return this.canDisconnect();
            }
            case -205: {
                if (this.fHandle != null) {
                    return LayoutLooper.canPaste();
                }
                return LayoutArea.canPaste();
            }
            case -207: {
                return true;
            }
        }
        return super.isCommandEnabled(n);
    }

    private Point findObjCenterPoint(LOControlWrapper lOControlWrapper) {
        Point point = new Point(-1, -1);
        point.x = (lOControlWrapper.getLeft() + lOControlWrapper.getRight()) / 2;
        point.y = (lOControlWrapper.getTop() + lOControlWrapper.getBottom()) / 2;
        return point;
    }

    private Point findObjectsMassCtrPt(Vector vector) {
        Point point = new Point(-1, -1);
        LOControlWrapper lOControlWrapper = this.findTopSelectedControl(vector);
        LOControlWrapper lOControlWrapper2 = this.findBottomSelectedControl(vector);
        LOControlWrapper lOControlWrapper3 = this.findLeftSelectedControl(vector);
        LOControlWrapper lOControlWrapper4 = this.findRightSelectedControl(vector);
        point.x = (lOControlWrapper3.getLeft() + lOControlWrapper4.getRight()) / 2;
        point.y = (lOControlWrapper.getTop() + lOControlWrapper2.getBottom()) / 2;
        return point;
    }

    private LOControlWrapper findTopSelectedControl(Vector vector) {
        LOControlWrapper lOControlWrapper = null;
        int n = Short.MAX_VALUE;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getTop()) > n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private LOControlWrapper findBottomSelectedControl(Vector vector) {
        LOControlWrapper lOControlWrapper = null;
        int n = -32767;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getBottom()) < n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private LOControlWrapper findLeftSelectedControl(Vector vector) {
        LOControlWrapper lOControlWrapper = null;
        int n = Short.MAX_VALUE;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getLeft()) > n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private LOControlWrapper findRightSelectedControl(Vector vector) {
        LOControlWrapper lOControlWrapper = null;
        int n = -32767;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper2.isSelected() || (n2 = lOControlWrapper2.getRight()) < n) continue;
            lOControlWrapper = lOControlWrapper2;
            n = n2;
        }
        return lOControlWrapper;
    }

    private Vector sortObjectIndices(int n) {
        Vector vector = this.getSelectedControls();
        VectorSort vectorSort = n == 2 ? new VerticalSort() : new HorizontalSort();
        vectorSort.sort(vector);
        return vector;
    }

    private void distributeMiddleObjects(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = ((Component)((Object)this)).getSize();
        int n5 = this.getSelectedObjectCount();
        if (n5 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    LOControlWrapper lOControlWrapper;
                    int n6 = vector.size();
                    if (n2 == -1) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n6 - 1);
                        int n7 = lOControlWrapper.getTop();
                        int n8 = (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2;
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n9 = lOControlWrapper.getBottom();
                        int n10 = n7 - n9 + (n8 += (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2);
                        n3 = n10 / (n6 - 1);
                        n6 = vector.size() - 1;
                    } else {
                        n3 = n2;
                        n6 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n11 = (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2;
                    n4 = lOControlWrapper.getTop() + n3 + n11;
                    int n12 = 1;
                    while (n12 < n6) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n12);
                        n11 = (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2;
                        int n13 = lOControlWrapper.getBottom() - n11;
                        int n14 = n13 - n4;
                        lOControlWrapper.offsetRect(0, -n14);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n4 = lOControlWrapper.getTop() + n3 + n11;
                        ++n12;
                    }
                    return;
                }
                case 1: {
                    LOControlWrapper lOControlWrapper;
                    int n15 = vector.size();
                    if (n2 == -1) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n15 - 1);
                        int n16 = lOControlWrapper.getLeft();
                        int n17 = (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2;
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n18 = lOControlWrapper.getRight();
                        int n19 = n16 - n18 + (n17 += (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2);
                        n3 = n19 / (n15 - 1);
                        n15 = vector.size() - 1;
                    } else {
                        n3 = n2;
                        n15 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n20 = (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2;
                    n4 = lOControlWrapper.getLeft() + n3 + n20;
                    int n21 = 1;
                    while (n21 < n15) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n21);
                        n20 = (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2;
                        int n22 = lOControlWrapper.getRight() - n20;
                        int n23 = n22 - n4;
                        lOControlWrapper.offsetRect(-n23, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n4 = lOControlWrapper.getLeft() + n3 + n20;
                        ++n21;
                    }
                    return;
                }
            }
        }
    }

    private void distributeBottomRightObjects(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = ((Component)((Object)this)).getSize();
        int n5 = this.getSelectedObjectCount();
        if (n5 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    int n6 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n6 - 1);
                    if (n2 == -1) {
                        int n7 = lOControlWrapper.getBottom();
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n8 = lOControlWrapper.getBottom();
                        int n9 = n7 - n8;
                        n3 = n9 / (n6 - 1);
                    } else {
                        n3 = n2;
                        n6 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n4 = lOControlWrapper.getBottom() + n3;
                    int n10 = 1;
                    while (n10 < n6) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n10);
                        int n11 = lOControlWrapper.getBottom();
                        int n12 = n11 - n4;
                        lOControlWrapper.offsetRect(0, -n12);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n4 = lOControlWrapper.getBottom() + n3;
                        n6 = vector.size() - 1;
                        ++n10;
                    }
                    return;
                }
                case 1: {
                    int n13 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n13 - 1);
                    if (n2 == -1) {
                        int n14 = lOControlWrapper.getRight();
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n15 = lOControlWrapper.getRight();
                        int n16 = n14 - n15;
                        n3 = n16 / (n13 - 1);
                        n13 = vector.size() - 1;
                    } else {
                        n3 = n2;
                        n13 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n4 = lOControlWrapper.getRight() + n3;
                    int n17 = 1;
                    while (n17 < n13) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n17);
                        int n18 = lOControlWrapper.getRight();
                        int n19 = n18 - n4;
                        lOControlWrapper.offsetRect(-n19, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n4 = lOControlWrapper.getRight() + n3;
                        ++n17;
                    }
                    return;
                }
            }
        }
    }

    private void distributeTopLeftObjects(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = ((Component)((Object)this)).getSize();
        int n5 = this.getSelectedObjectCount();
        if (n5 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    int n6 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n6 - 1);
                    int n7 = lOControlWrapper.getTop();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    if (n2 == -1) {
                        int n8 = lOControlWrapper.getTop();
                        int n9 = n7 - n8;
                        n3 = n9 / (n6 - 1);
                        n6 = vector.size() - 1;
                    } else {
                        n3 = n2;
                        n6 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n4 = lOControlWrapper.getTop() + n3;
                    int n10 = 1;
                    while (n10 < n6) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n10);
                        int n11 = lOControlWrapper.getTop();
                        int n12 = n11 - n4;
                        lOControlWrapper.offsetRect(0, -n12);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n4 = lOControlWrapper.getTop() + n3;
                        ++n10;
                    }
                    return;
                }
                case 1: {
                    int n13 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n13 - 1);
                    int n14 = lOControlWrapper.getLeft();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    if (n2 == -1) {
                        int n15 = lOControlWrapper.getLeft();
                        int n16 = n14 - n15;
                        n3 = n16 / (n13 - 1);
                        n13 = vector.size() - 1;
                    } else {
                        n3 = n2;
                        n13 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n4 = lOControlWrapper.getLeft() + n3;
                    int n17 = 1;
                    while (n17 < n13) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n17);
                        int n18 = lOControlWrapper.getLeft();
                        int n19 = n18 - n4;
                        lOControlWrapper.offsetRect(-n19, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n4 = lOControlWrapper.getLeft() + n3;
                        ++n17;
                    }
                    return;
                }
            }
        }
    }

    private void distributeBetweenObjects(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Dimension dimension = ((Component)((Object)this)).getSize();
        int n7 = this.getSelectedObjectCount();
        if (n7 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    LOControlWrapper lOControlWrapper;
                    int n8 = vector.size();
                    int n9 = 0;
                    while (n9 < n8) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n9);
                        n3 += lOControlWrapper.getBottom() - lOControlWrapper.getTop();
                        ++n9;
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(n8 - 1);
                    int n10 = lOControlWrapper.getBottom();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n11 = lOControlWrapper.getTop();
                    int n12 = n10 - n11;
                    if (n2 == -1) {
                        n4 = n12 - n3;
                        n5 = n4 / (n8 - 1);
                        n8 = vector.size() - 1;
                    } else {
                        n5 = n2;
                        n8 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n6 = lOControlWrapper.getBottom() + n5;
                    n8 = vector.size();
                    n9 = 1;
                    while (n9 < n8) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n9);
                        int n13 = lOControlWrapper.getTop();
                        int n14 = n13 - n6;
                        lOControlWrapper.offsetRect(0, -n14);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n6 = lOControlWrapper.getBottom() + n5;
                        ++n9;
                    }
                    return;
                }
                case 1: {
                    LOControlWrapper lOControlWrapper;
                    int n15 = vector.size();
                    int n16 = 0;
                    while (n16 < n15) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n16);
                        n3 += lOControlWrapper.getRight() - lOControlWrapper.getLeft();
                        ++n16;
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(n15 - 1);
                    int n17 = lOControlWrapper.getRight();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n18 = lOControlWrapper.getLeft();
                    int n19 = n17 - n18;
                    if (n2 == -1) {
                        n4 = n19 - n3;
                        n5 = n4 / (n15 - 1);
                        n15 = vector.size() - 1;
                    } else {
                        n5 = n2;
                        n15 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n6 = lOControlWrapper.getRight() + n5;
                    n16 = 1;
                    while (n16 < n15) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n16);
                        int n20 = lOControlWrapper.getLeft();
                        int n21 = n20 - n6;
                        lOControlWrapper.offsetRect(-n21, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n6 = lOControlWrapper.getRight() + n5;
                        ++n16;
                    }
                    return;
                }
            }
        }
    }

    private void alignVerticalTop(Vector vector) {
        LOControlWrapper lOControlWrapper = this.findTopSelectedControl(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            int n = lOControlWrapper2.getTop() - lOControlWrapper.getTop();
            lOControlWrapper2.offsetRect(0, -n);
        }
    }

    private void alignVerticalBottom(Vector vector) {
        LOControlWrapper lOControlWrapper = this.findBottomSelectedControl(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            int n = lOControlWrapper2.getBottom() - lOControlWrapper.getBottom();
            lOControlWrapper2.offsetRect(0, -n);
        }
    }

    private void alignVerticalCenter(Vector vector) {
        Point point = this.findObjectsMassCtrPt(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            Point point2 = this.findObjCenterPoint(lOControlWrapper);
            int n = point2.y - point.y;
            lOControlWrapper.offsetRect(0, -n);
        }
    }

    private void alignHorizontalLeft(Vector vector) {
        LOControlWrapper lOControlWrapper = this.findLeftSelectedControl(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            int n = lOControlWrapper2.getLeft() - lOControlWrapper.getLeft();
            lOControlWrapper2.offsetRect(-n, 0);
        }
    }

    private void alignHorizontalRight(Vector vector) {
        LOControlWrapper lOControlWrapper = this.findRightSelectedControl(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            int n = lOControlWrapper2.getRight() - lOControlWrapper.getRight();
            lOControlWrapper2.offsetRect(-n, 0);
        }
    }

    private void alignHorizontalCenter(Vector vector) {
        Point point = this.findObjectsMassCtrPt(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            Point point2 = this.findObjCenterPoint(lOControlWrapper);
            int n = point2.x - point.x;
            lOControlWrapper.offsetRect(-n, 0);
        }
    }

    void doAlignDist(int n, int n2, int n3, int n4) {
        if (this.getSelectedObjectCount() <= 1) {
            return;
        }
        Vector vector = this.getSelectedControls();
        UndoMove undoMove = new UndoMove(this, vector);
        switch (n) {
            case 1: {
                this.alignVerticalTop(vector);
                break;
            }
            case 2: {
                this.alignVerticalCenter(vector);
                break;
            }
            case 3: {
                this.alignVerticalBottom(vector);
                break;
            }
            case 4: {
                this.distributeBetweenObjects(2, n2);
                break;
            }
            case 5: {
                this.distributeTopLeftObjects(2, n2);
                break;
            }
            case 6: {
                this.distributeMiddleObjects(2, n2);
                break;
            }
            case 7: {
                this.distributeBottomRightObjects(2, n2);
                break;
            }
        }
        switch (n3) {
            case 1: {
                this.alignHorizontalLeft(vector);
                break;
            }
            case 2: {
                this.alignHorizontalCenter(vector);
                break;
            }
            case 3: {
                this.alignHorizontalRight(vector);
                break;
            }
            case 4: {
                this.distributeBetweenObjects(1, n4);
                break;
            }
            case 5: {
                this.distributeTopLeftObjects(1, n4);
                break;
            }
            case 6: {
                this.distributeMiddleObjects(1, n4);
                break;
            }
            case 7: {
                this.distributeBottomRightObjects(1, n4);
                break;
            }
        }
        if (undoMove.moveComplete()) {
            if (this.fHandle != null) {
                GObjectWrapper.updateVector(vector);
            } else {
                this.fireObjectChangedEvent(vector);
            }
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoMove);
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void doCut() {
        this.doCopy();
        this.doClear();
        sClipNumPastes = 0;
    }

    private void doCopy() {
        Vector vector = this.getSelectedControls();
        if (vector.size() == 0) {
            return;
        }
        this.addGlueWrappers(vector);
        if (this.fHandle == null) {
            try {
                sClipByteArray = this.writeObjectsToByteArray(vector);
                sClipNumPastes = 1;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        LayoutLooper.copy(vector, this);
        sClipNumPastes = 1;
    }

    private void doPaste() {
        block5: {
            this.selectAll(false);
            if (this.fHandle == null) {
                try {
                    Vector vector = this.readObjectsFromByteArray(sClipByteArray, null);
                    if (vector != null && !vector.isEmpty()) {
                        int n = 10 * sClipNumPastes;
                        ++sClipNumPastes;
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                            if (lOControlWrapper instanceof LOGlueWrapper) continue;
                            lOControlWrapper.offsetRect(n, n);
                            this.fTagManager.setUniqueName(lOControlWrapper.getBean());
                            this.register(lOControlWrapper);
                            lOControlWrapper.setSelected(true);
                        }
                        this.updateSelection();
                        this.fireContentChangedEvent();
                        this.fireUndoEvent(new UndoAdd(this, vector));
                        ((Component)((Object)this)).repaint(5L);
                        return;
                    }
                    break block5;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            int n = 10 * sClipNumPastes;
            ++sClipNumPastes;
            Point point = new Point(n, n);
            LayoutLooper.paste(this.fHandle, point, new DuplicateObserver());
        }
    }

    byte[] writeAllObjectsToByteArray() throws IOException {
        Vector vector = new Vector(this.getBaseWrapperCount());
        Enumeration enumeration = this.baseWrappers();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return this.writeObjectsToByteArray(vector);
    }

    private byte[] writeObjectsToByteArray(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        LayoutFormat layoutFormat = new LayoutFormat();
        layoutFormat.writeWrappers(objectOutputStream, vector);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ((OutputStream)byteArrayOutputStream).close();
        return byArray;
    }

    private Vector readObjectsFromByteArray(byte[] byArray, Point point) throws OptionalDataException, ClassNotFoundException, IOException, LayoutFormatException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStreamLoader objectInputStreamLoader = new ObjectInputStreamLoader((InputStream)byteArrayInputStream, (ClassLoader)SimpleClassLoader.ourLoader);
        LayoutFormat layoutFormat = new LayoutFormat();
        Vector vector = layoutFormat.readWrappers((ObjectInputStream)objectInputStreamLoader, this, point);
        ((InputStream)byteArrayInputStream).close();
        return vector;
    }

    void doDuplicate(Point point) {
        block6: {
            Vector vector = this.getSelectedControls();
            if (vector.size() == 0) {
                return;
            }
            this.selectAll(false);
            if (this.fHandle == null) {
                this.addGlueWrappers(vector);
                try {
                    byte[] byArray = this.writeObjectsToByteArray(vector);
                    Vector vector2 = this.readObjectsFromByteArray(byArray, point);
                    if (vector2 != null && !vector2.isEmpty()) {
                        Enumeration enumeration = vector2.elements();
                        while (enumeration.hasMoreElements()) {
                            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                            if (lOControlWrapper.getControlType() == 28) continue;
                            this.fTagManager.setUniqueName(lOControlWrapper.getBean());
                            this.register(lOControlWrapper);
                            lOControlWrapper.setSelected(true);
                        }
                        this.updateSelection();
                        this.fireContentChangedEvent();
                        this.fireUndoEvent(new UndoAdd(this, vector2));
                        ((Component)((Object)this)).repaint(5L);
                        return;
                    }
                    break block6;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            LayoutLooper.duplicate(this.fHandle, vector, point, new DuplicateObserver());
        }
    }

    private void duplicateComplete(Object object) {
        if (object != null && object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 3) {
                double[] dArray = (double[])objectArray[0];
                Object[] objectArray2 = (Object[])objectArray[1];
                Object[] objectArray3 = (Object[])objectArray[2];
                int n = dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LOControlWrapper lOControlWrapper = this.addGObject(dArray[n2], objectArray2[n2], (Component)objectArray3[n2], -1);
                    lOControlWrapper.setSelected(true);
                    ++n2;
                }
            }
            this.updateSelection();
            ((Component)((Object)this)).repaint(5L);
        }
    }

    static void forceLayout(Container container) {
        if (!(container instanceof LOGroupbox)) {
            LayoutArea.recursiveLayout(container);
        }
    }

    private static void recursiveLayout(Container container) {
        container.doLayout();
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component = container.getComponent(n);
            if (component != null && component instanceof Container && !(component instanceof LOTabLayer)) {
                Container container2 = (Container)component;
                LayoutArea.recursiveLayout(container2);
            }
            ++n;
        }
    }

    public void addWrapper(LOControlWrapper lOControlWrapper, int n) {
        if (n == -2) {
            Point point = lOControlWrapper.getBaseLocation();
            Dimension dimension = lOControlWrapper.getControl().getSize();
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            LOControlWrapper lOControlWrapper2 = this.findParent(rectangle);
            if (lOControlWrapper2 != null) {
                Point point2 = lOControlWrapper.getBaseLocation();
                lOControlWrapper2.translateFromBaseCoordinates(point2);
                lOControlWrapper.getControl().setLocation(point2);
                lOControlWrapper2.addWrapper(lOControlWrapper, -1);
                return;
            }
            n = -1;
        }
        switch (lOControlWrapper.getControlType()) {
            case 29: {
                if (lOControlWrapper.isLightweight()) {
                    int n2 = this.fControlList[1].size();
                    if (n == -1) {
                        n = n2;
                    }
                    this.fRuntimeArea.addToLayer(lOControlWrapper.getControl(), 1, n2 - n);
                    this.fControlList[1].insertElementAt(lOControlWrapper, n);
                    return;
                }
                int n3 = this.fControlList[3].size();
                if (n == -1) {
                    n = n3;
                }
                this.fHoldingArea.add(lOControlWrapper.getControl(), n3 - n);
                this.fControlList[3].insertElementAt(lOControlWrapper, n);
                return;
            }
            case 30: {
                int n4 = this.fControlList[2].size();
                if (n == -1) {
                    n = n4;
                }
                this.fControlList[2].insertElementAt(lOControlWrapper, n);
                return;
            }
            case 28: {
                if (n == -1) {
                    n = this.fControlList[5].size();
                }
                this.fControlList[5].insertElementAt(lOControlWrapper, n);
                return;
            }
            case 26: {
                int n5 = this.fControlList[0].size();
                if (n == -1) {
                    n = n5;
                }
                this.fRuntimeArea.addToLayer(lOControlWrapper.getControl(), 1, n5 - n);
                this.fControlList[0].insertElementAt(lOControlWrapper, n);
                if (this.fHandle == null || !(lOControlWrapper instanceof GObjectWrapper) || ((GObjectWrapper)lOControlWrapper).getHandle() != null) break;
                LayoutLooper.requestAxes(this.fHandle, (GObjectWrapper)lOControlWrapper, n5 - n + 1 + this.fControlList[4].size());
                return;
            }
            case 27: {
                int n6 = this.fControlList[4].size();
                if (n == -1) {
                    n = n6;
                }
                this.fRuntimeArea.addToLayer(lOControlWrapper.getControl(), 0, n6 - n);
                this.fControlList[4].insertElementAt(lOControlWrapper, n);
                if (this.fHandle == null || !(lOControlWrapper instanceof GObjectWrapper) || ((GObjectWrapper)lOControlWrapper).getHandle() != null) break;
                LayoutLooper.requestUIControl(this.fHandle, (GObjectWrapper)lOControlWrapper, n6 - n + 1);
                return;
            }
            default: {
                int n7 = this.fControlList[1].size();
                if (n == -1) {
                    n = n7;
                }
                this.fRuntimeArea.addToLayer(lOControlWrapper.getControl(), 1, n7 - n);
                this.fControlList[1].insertElementAt(lOControlWrapper, n);
            }
        }
    }

    public void removeWrapper(LOControlWrapper lOControlWrapper) {
        Component component = lOControlWrapper.getControl();
        if (component != null && component.getParent() != null) {
            component.getParent().remove(component);
        }
        switch (lOControlWrapper.getControlType()) {
            case 29: {
                if (lOControlWrapper.isLightweight()) {
                    this.fControlList[1].removeElement(lOControlWrapper);
                    return;
                }
                this.fControlList[3].removeElement(lOControlWrapper);
                return;
            }
            case 30: {
                this.fControlList[2].removeElement(lOControlWrapper);
                return;
            }
            case 28: {
                this.fControlList[5].removeElement(lOControlWrapper);
                return;
            }
            case 26: {
                this.fControlList[0].removeElement(lOControlWrapper);
                LayoutLooper.deleteObject(((GObjectWrapper)lOControlWrapper).getHandle());
                return;
            }
            case 27: {
                this.fControlList[4].removeElement(lOControlWrapper);
                LayoutLooper.deleteObject(((GObjectWrapper)lOControlWrapper).getHandle());
                return;
            }
        }
        this.fControlList[1].removeElement(lOControlWrapper);
    }

    public int getIndexOfWrapper(LOControlWrapper lOControlWrapper) {
        int n = -1;
        switch (lOControlWrapper.getControlType()) {
            case 29: {
                if (lOControlWrapper.isLightweight()) {
                    n = this.fControlList[1].indexOf(lOControlWrapper);
                    break;
                }
                n = this.fControlList[3].indexOf(lOControlWrapper);
                break;
            }
            case 30: {
                n = this.fControlList[2].indexOf(lOControlWrapper);
                break;
            }
            case 28: {
                n = this.fControlList[5].indexOf(lOControlWrapper);
                break;
            }
            case 26: {
                n = this.fControlList[0].indexOf(lOControlWrapper);
                break;
            }
            case 27: {
                n = this.fControlList[4].indexOf(lOControlWrapper);
                break;
            }
            default: {
                n = this.fControlList[1].indexOf(lOControlWrapper);
            }
        }
        return n;
    }

    public LOControlWrapper findWrapper(Object object) {
        LOControlWrapper lOControlWrapper = null;
        Enumeration enumeration = this.baseWrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            lOControlWrapper = lOControlWrapper2.findWrapper(object);
            if (lOControlWrapper != null) break;
        }
        return lOControlWrapper;
    }

    void markWrapper(LOControlWrapper lOControlWrapper, int n) {
        if (this.fMarkerTable == null) {
            this.fMarkerTable = new IntHashtable(2);
        }
        this.fMarkerTable.put(n, (Object)lOControlWrapper);
    }

    LOControlWrapper getMarkedWrapper(int n) {
        LOControlWrapper lOControlWrapper = null;
        if (this.fMarkerTable != null) {
            lOControlWrapper = (LOControlWrapper)this.fMarkerTable.get(n);
        }
        return lOControlWrapper;
    }

    void clearMarkers() {
        if (this.fMarkerTable != null) {
            this.fMarkerTable.clear();
        }
    }

    final void addBeanExternal(Object object, int n, int n2, int n3, int n4) {
        int n5 = Beans.isInstanceOf(object, class$java$awt$Component != null ? class$java$awt$Component : (class$java$awt$Component = LayoutArea.class$("java.awt.Component"))) ? 29 : 30;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.addObject(n5, object, rectangle, this);
    }

    void addObject(int n, Object object, Rectangle rectangle, LOWrapperOwner lOWrapperOwner) {
        Object object2;
        LOControlWrapper lOControlWrapper = LOControlWrapper.buildWrapper(n, object);
        if (lOControlWrapper == null) {
            return;
        }
        if (lOControlWrapper.isGObject()) {
            object2 = (GObjectWrapper)lOControlWrapper;
            ((GObjectWrapper)object2).setRootObject(this.fRootObject);
            ((GObjectWrapper)object2).setObjectOwner(this.fObjectOwner);
        }
        if (lOWrapperOwner == null && lOControlWrapper.isEnclosable()) {
            lOWrapperOwner = this.findParent(rectangle);
        }
        if (lOWrapperOwner == null) {
            lOWrapperOwner = this;
        } else if (lOWrapperOwner != this) {
            object2 = new Point(rectangle.x, rectangle.y);
            ((LOControlWrapper)lOWrapperOwner).translateFromBaseCoordinates((Point)object2);
            rectangle.setLocation((Point)object2);
        }
        object2 = lOControlWrapper.getControl();
        Dimension dimension = ((Component)object2).getPreferredSize();
        if (rectangle.width <= 2) {
            rectangle.width = dimension.width;
        }
        if (rectangle.height <= 2) {
            rectangle.height = dimension.height;
        }
        switch (n) {
            case 11: 
            case 12: 
            case 18: 
            case 21: 
            case 22: {
                rectangle.height = ((Component)object2).getPreferredSize().height;
                break;
            }
            case 14: {
                if (rectangle.width > rectangle.height) {
                    rectangle.width = Math.max(rectangle.width, 50);
                    rectangle.height = 16;
                    break;
                }
                rectangle.width = 16;
                rectangle.height = Math.max(rectangle.height, 50);
                break;
            }
        }
        Dimension dimension2 = ((Component)object2).getMinimumSize();
        if (dimension2.width < 8) {
            dimension2.width = 8;
        }
        if (dimension2.height < 8) {
            dimension2.height = 8;
        }
        if (rectangle.width < dimension2.width) {
            rectangle.width = dimension2.width;
        }
        if (rectangle.height < dimension2.height) {
            rectangle.height = dimension2.height;
        }
        Dimension dimension3 = ((Component)object2).getMaximumSize();
        if (rectangle.width > dimension3.width) {
            rectangle.width = dimension3.width;
        }
        if (rectangle.height > dimension3.height) {
            rectangle.height = dimension3.height;
        }
        ((Component)object2).setBounds(rectangle);
        lOControlWrapper.setSelected(true);
        lOWrapperOwner.addWrapper(lOControlWrapper, -1);
        if (lOControlWrapper.getNeedsLayout()) {
            LayoutArea.recursiveLayout((Container)object2);
        }
        if (!lOControlWrapper.isGObject()) {
            this.fTagManager.setNewUniqueName(lOControlWrapper.getBean());
            this.register(lOControlWrapper);
        }
        if (lOControlWrapper.isBean()) {
            this.addServices(lOControlWrapper);
        }
        if (!lOControlWrapper.isGObject()) {
            this.updateSelection();
        }
        this.fireContentChangedEvent();
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>(1);
        vector.addElement(lOControlWrapper);
        this.fireUndoEvent(new UndoAdd(this, vector));
        Point point = lOControlWrapper.getBaseLocation();
        Dimension dimension4 = ((Component)object2).getSize();
        this.repaint(5L, point.x - 2, point.y - 2, dimension4.width + 4, dimension4.height + 4);
        ((Component)((Object)this)).requestFocus();
    }

    LOControlWrapper addGObject(double d, Object object, Component component, int n) {
        GObjectWrapper gObjectWrapper = null;
        int n2 = ((GObjectProxy)component).getStyle() == 10 ? 26 : 27;
        double[] dArray = new double[]{d};
        gObjectWrapper = new GObjectWrapper(component, n2, dArray, object);
        this.addWrapper(gObjectWrapper, n);
        Object[] objectArray = new Object[]{object};
        ObjectRegistry.getLayoutRegistry().register(objectArray, this.fRootObject, -1, this.fObjectOwner, false);
        return gObjectWrapper;
    }

    void showBeans() {
        Enumeration enumeration = this.fControlList[3].elements();
        while (enumeration.hasMoreElements()) {
            Container container;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            Component component = lOControlWrapper.getControl();
            this.fHoldingArea.remove(component);
            this.fRuntimeArea.addToLayer(component, 0, 0);
            if (Beans.isInstanceOf(component, class$java$awt$Container != null ? class$java$awt$Container : LayoutArea.class$("java.awt.Container"))) {
                container = (Container)Beans.getInstanceOf(component, class$java$awt$Container != null ? class$java$awt$Container : LayoutArea.class$("java.awt.Container"));
                LayoutArea.forceLayout(container);
            }
            if (!Beans.isInstanceOf(component, class$java$applet$Applet != null ? class$java$applet$Applet : LayoutArea.class$("java.applet.Applet"))) continue;
            container = (Applet)Beans.getInstanceOf(component, class$java$applet$Applet != null ? class$java$applet$Applet : LayoutArea.class$("java.applet.Applet"));
            ((Applet)container).start();
        }
    }

    void hideBeans() {
        Enumeration enumeration = this.fControlList[3].elements();
        while (enumeration.hasMoreElements()) {
            Container container;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            Component component = lOControlWrapper.getControl();
            if (Beans.isInstanceOf(component, class$java$applet$Applet != null ? class$java$applet$Applet : LayoutArea.class$("java.applet.Applet"))) {
                container = (Applet)Beans.getInstanceOf(component, class$java$applet$Applet != null ? class$java$applet$Applet : LayoutArea.class$("java.applet.Applet"));
                ((Applet)container).stop();
                Thread.yield();
            }
            if ((container = component.getParent()) != null) {
                container.remove(component);
            }
            this.fHoldingArea.add(component);
        }
    }

    void register(LOControlWrapper lOControlWrapper) {
        if (lOControlWrapper.getBean() != null) {
            this.registerNow(lOControlWrapper);
        }
    }

    private void registerNow(LOControlWrapper lOControlWrapper) {
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        Object object = this.getRootObject();
        int n = lOControlWrapper.getControlType();
        if (lOControlWrapper.getParent() != null) {
            object = lOControlWrapper.getControl().getParent();
        }
        boolean bl = lOControlWrapper.isEnclosure();
        ObjectRegistry.getLayoutRegistry().register(objectArray, object, -1, this.fObjectOwner, bl);
        if (bl) {
            if (n == 19 || n == 64) {
                SubpanelOwner subpanelOwner = (SubpanelOwner)((Object)lOControlWrapper.getControl());
                int n2 = subpanelOwner.getSubpanelCount();
                Object[] objectArray2 = new Object[n2];
                int n3 = 0;
                while (n3 < n2) {
                    objectArray2[n3] = subpanelOwner.getSubpanel(n3);
                    ++n3;
                }
                ObjectRegistry.getLayoutRegistry().register(objectArray2, (Object)subpanelOwner, -1, this.fObjectOwner, true);
                Vector vector = ((LOTabWrapper)lOControlWrapper).getTabLayers();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector2 = (Vector)enumeration.nextElement();
                    Enumeration enumeration2 = vector2.elements();
                    while (enumeration2.hasMoreElements()) {
                        this.register((LOControlWrapper)enumeration2.nextElement());
                    }
                }
                return;
            }
            Vector vector = lOControlWrapper.getSublayer();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.register((LOControlWrapper)enumeration.nextElement());
                }
            }
        }
    }

    void registerAll() {
        Enumeration enumeration = this.baseWrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (lOControlWrapper.getControlType() == 28) continue;
            this.register(lOControlWrapper);
        }
        ObjectRegistry.getLayoutRegistry().addObjectRegistryListener(this.fChangeListener);
        ObjectRegistry.getLayoutRegistry().addItemListener(this.fSelectionListener);
    }

    void unregisterAll() {
        ObjectRegistry.getLayoutRegistry().removeItemListener(this.fSelectionListener);
        ObjectRegistry.getLayoutRegistry().removeObjectRegistryListener(this.fChangeListener);
        if (this.hasSelection()) {
            ObjectRegistry.getLayoutRegistry().setSelected(null, false, true);
        }
    }

    void addService(String string, Object object) {
        this.fServiceRegistry.registerService(string, object);
    }

    void removeServices() {
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Object object;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isBean() || !Beans.isInstanceOf(object = lOControlWrapper.getBean(), class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : LayoutArea.class$("com.mathworks.beans.ServiceClient"))) continue;
            ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : LayoutArea.class$("com.mathworks.beans.ServiceClient"));
            serviceClient.servicesUnavailable(this.fServiceRegistry);
        }
    }

    void addServices() {
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Object object;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isBean() || !Beans.isInstanceOf(object = lOControlWrapper.getBean(), class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : LayoutArea.class$("com.mathworks.beans.ServiceClient"))) continue;
            ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : LayoutArea.class$("com.mathworks.beans.ServiceClient"));
            serviceClient.servicesAvailable(this.fServiceRegistry);
        }
    }

    void removeServices(LOControlWrapper lOControlWrapper) {
        if (lOControlWrapper.isBean()) {
            Object object = lOControlWrapper.getBean();
            if (Beans.isInstanceOf(object, class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : (class$com$mathworks$beans$ServiceClient = LayoutArea.class$("com.mathworks.beans.ServiceClient")))) {
                ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : (class$com$mathworks$beans$ServiceClient = LayoutArea.class$("com.mathworks.beans.ServiceClient")));
                serviceClient.servicesUnavailable(this.fServiceRegistry);
                return;
            }
        } else {
            Vector vector = lOControlWrapper.getSublayer();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
                    this.removeServices(lOControlWrapper2);
                }
            }
        }
    }

    void addServices(LOControlWrapper lOControlWrapper) {
        if (lOControlWrapper.isBean()) {
            Object object = lOControlWrapper.getBean();
            if (Beans.isInstanceOf(object, class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : (class$com$mathworks$beans$ServiceClient = LayoutArea.class$("com.mathworks.beans.ServiceClient")))) {
                ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, class$com$mathworks$beans$ServiceClient != null ? class$com$mathworks$beans$ServiceClient : (class$com$mathworks$beans$ServiceClient = LayoutArea.class$("com.mathworks.beans.ServiceClient")));
                serviceClient.servicesAvailable(this.fServiceRegistry);
                return;
            }
        } else {
            Vector vector = lOControlWrapper.getSublayer();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
                    this.addServices(lOControlWrapper2);
                }
            }
        }
    }

    void unregister(LOControlWrapper lOControlWrapper) {
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        ObjectRegistry.getLayoutRegistry().unregister(objectArray);
    }

    void move(LOControlWrapper lOControlWrapper, int n) {
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        Object object = this.getRootObject();
        LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent();
        if (lOControlWrapper2 != null) {
            object = lOControlWrapper.getControl().getParent();
        }
        ObjectRegistry.getLayoutRegistry().move(objectArray, object, n);
    }

    void updateSelection() {
        Object[] objectArray = this.getSelectedObjects();
        if (objectArray == null) {
            this.fSelectionCount = 0;
            objectArray = new Object[]{this.getRootObject()};
        } else {
            this.fSelectionCount = objectArray.length;
        }
        this.fireSelectionChangedEvent(this.fSelectionCount);
        ObjectRegistry.getLayoutRegistry().setSelected(objectArray, true);
    }

    private Object[] getSelectedObjects() {
        int n = this.getSelectedObjectCount();
        if (n != 0) {
            Object[] objectArray = new Object[n];
            Enumeration enumeration = this.wrappers();
            int n2 = 0;
            while (enumeration.hasMoreElements() && n2 < n) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                if (!lOControlWrapper.isSelected()) continue;
                objectArray[n2++] = lOControlWrapper.getBean();
            }
            return objectArray;
        }
        return null;
    }

    private void editCallback(String string) {
        Object object = this.findControl(this.fMouseStart);
        object = object == null ? this.fHandle : ((GObjectWrapper)object).getHandle();
        if (object != null) {
            LayoutLooper.editCallback(object, string);
        }
    }

    private Vector getSelectedInLayer(Vector vector) {
        Vector<LOControlWrapper> vector2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isSelected()) continue;
            if (vector2 == null) {
                vector2 = new Vector<LOControlWrapper>(vector.size());
            }
            vector2.addElement(lOControlWrapper);
        }
        return vector2;
    }

    private boolean canReorder(Vector vector, int n) {
        block12: {
            int n2;
            block11: {
                n2 = vector.size();
                if (n2 < 2) {
                    return false;
                }
                if (n != 0) break block11;
                boolean bl = false;
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n3);
                    if (bl) {
                        if (lOControlWrapper.isSelected()) {
                            return true;
                        }
                    } else if (!lOControlWrapper.isSelected()) {
                        bl = true;
                    }
                    --n3;
                }
                break block12;
            }
            if (n != 1) break block12;
            boolean bl = false;
            int n4 = 0;
            while (n4 < n2) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n4);
                if (bl) {
                    if (lOControlWrapper.isSelected()) {
                        return true;
                    }
                } else if (!lOControlWrapper.isSelected()) {
                    bl = true;
                }
                ++n4;
            }
        }
        return false;
    }

    private void moveToBack(Vector vector) {
        Vector vector2 = this.getSelectedInLayer(vector);
        int n = vector2.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector2.elementAt(n2);
            vector.removeElement(lOControlWrapper);
            vector.insertElementAt(lOControlWrapper, 0);
            Component component = lOControlWrapper.getControl();
            Container container = component.getParent();
            if (container != null) {
                container.remove(component);
                container.add(component);
            }
            this.move(lOControlWrapper, 0);
            if (lOControlWrapper.isGObject()) {
                LayoutLooper.moveToBack((GObjectWrapper)lOControlWrapper);
            }
            --n2;
        }
    }

    private void MoveToBack() {
        Enumeration enumeration = this.layers();
        UndoReorder undoReorder = new UndoReorder(this, 1);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 1)) continue;
            undoReorder.addLayer(vector);
            this.moveToBack(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void moveBackward(Vector vector) {
        int n = vector.size();
        int n2 = 1;
        while (n2 < n) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n2);
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)vector.elementAt(n2 - 1);
            if (lOControlWrapper.isSelected() && !lOControlWrapper2.isSelected()) {
                vector.removeElementAt(n2);
                vector.insertElementAt(lOControlWrapper, n2 - 1);
                Component component = lOControlWrapper.getControl();
                Container container = component.getParent();
                if (container != null && container.getComponentCount() == n) {
                    int n3 = n - n2 - 1;
                    container.remove(n3);
                    container.add(component, n3 + 1);
                }
                this.move(lOControlWrapper, n2 - 1);
                if (lOControlWrapper.isGObject()) {
                    LayoutLooper.moveBackward((GObjectWrapper)lOControlWrapper);
                }
            }
            ++n2;
        }
    }

    private void MoveBackward() {
        Enumeration enumeration = this.layers();
        UndoReorder undoReorder = new UndoReorder(this, 1);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 1)) continue;
            undoReorder.addLayer(vector);
            this.moveBackward(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void moveToFront(Vector vector) {
        Vector vector2 = this.getSelectedInLayer(vector);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            vector.removeElement(lOControlWrapper);
            vector.addElement(lOControlWrapper);
            Component component = lOControlWrapper.getControl();
            Container container = component.getParent();
            if (container != null) {
                container.remove(component);
                container.add(component, 0);
            }
            this.move(lOControlWrapper, -1);
            if (!lOControlWrapper.isGObject()) continue;
            LayoutLooper.moveToFront((GObjectWrapper)lOControlWrapper);
        }
    }

    private void MoveToFront() {
        Enumeration enumeration = this.layers();
        UndoReorder undoReorder = new UndoReorder(this, 0);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 0)) continue;
            undoReorder.addLayer(vector);
            this.moveToFront(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void moveForward(Vector vector) {
        int n = vector.size();
        int n2 = n - 2;
        while (n2 >= 0) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n2);
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)vector.elementAt(n2 + 1);
            if (lOControlWrapper.isSelected() && !lOControlWrapper2.isSelected()) {
                vector.removeElementAt(n2);
                vector.insertElementAt(lOControlWrapper, n2 + 1);
                Component component = lOControlWrapper.getControl();
                Container container = component.getParent();
                if (container != null && container.getComponentCount() == n) {
                    int n3 = n - n2 - 1;
                    container.remove(n3);
                    container.add(component, n3 - 1);
                }
                this.move(lOControlWrapper, n2 + 1);
                if (lOControlWrapper.isGObject()) {
                    LayoutLooper.moveForward((GObjectWrapper)lOControlWrapper);
                }
            }
            --n2;
        }
    }

    private void MoveForward() {
        Enumeration enumeration = this.layers();
        UndoReorder undoReorder = new UndoReorder(this, 0);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 0)) continue;
            undoReorder.addLayer(vector);
            this.moveForward(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void doClear() {
        LOControlWrapper lOControlWrapper;
        Vector vector = this.getSelectedControls();
        if (vector.isEmpty()) {
            return;
        }
        Vector vector2 = this.getConnectedGlueWrappers(vector);
        UndoDelete undoDelete = new UndoDelete(this, vector, vector2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            this.removeServices(lOControlWrapper);
            this.unregister(lOControlWrapper);
            LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent();
            if (lOControlWrapper2 != null) {
                lOControlWrapper2.removeWrapper(lOControlWrapper);
            } else {
                this.removeWrapper(lOControlWrapper);
            }
            lOControlWrapper.setSelected(false);
        }
        if (vector2 != null) {
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                lOControlWrapper = (LOGlueWrapper)enumeration.nextElement();
                ((LOGlueWrapper)lOControlWrapper).disconnect();
                this.removeWrapper(lOControlWrapper);
            }
        }
        this.updateSelection();
        this.fireContentChangedEvent();
        this.fireUndoEvent(undoDelete);
        ((Component)((Object)this)).repaint(5L);
    }

    private void doDisconnect() {
        Object object;
        if (this.fSelectionCount == 0 || this.fControlList[5].isEmpty()) {
            return;
        }
        Vector<Object> vector = new Vector<Object>(this.fControlList[5].size());
        Enumeration enumeration = this.fControlList[5].elements();
        while (enumeration.hasMoreElements()) {
            object = (LOGlueWrapper)enumeration.nextElement();
            if (!((LOGlueWrapper)object).getSource().isSelected() && !((LOGlueWrapper)object).getTarget().isSelected()) continue;
            vector.addElement(object);
        }
        if (!vector.isEmpty()) {
            object = new UndoConnect(this, false, vector);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LOGlueWrapper lOGlueWrapper = (LOGlueWrapper)enumeration.nextElement();
                lOGlueWrapper.disconnect();
                this.fControlList[5].removeElement(lOGlueWrapper);
            }
            this.fireContentChangedEvent();
            this.fireUndoEvent((UndoableEdit)object);
            ((Component)((Object)this)).repaint(5L);
        }
    }

    boolean canDisconnect() {
        if (this.fSelectionCount == 0 || this.fControlList[5].isEmpty()) {
            return false;
        }
        Enumeration enumeration = this.fControlList[5].elements();
        while (enumeration.hasMoreElements()) {
            LOGlueWrapper lOGlueWrapper = (LOGlueWrapper)enumeration.nextElement();
            if (!lOGlueWrapper.getSource().isSelected() && !lOGlueWrapper.getTarget().isSelected()) continue;
            return true;
        }
        return false;
    }

    boolean selectAll(boolean bl) {
        Enumeration enumeration = this.wrappers();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (lOControlWrapper.isSelected() == bl) continue;
            lOControlWrapper.setSelected(bl);
            bl2 = true;
        }
        return bl2;
    }

    void selectAllObjects(boolean bl) {
        if (this.selectAll(bl)) {
            this.updateSelection();
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private LOControlWrapper findHandleInLayer(Vector vector, Point point) {
        int n = vector.size() - 1;
        while (n >= 0) {
            LOControlWrapper lOControlWrapper;
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)vector.elementAt(n);
            if (lOControlWrapper2.isSelected() && lOControlWrapper2.ptOverResizehandle(point)) {
                return lOControlWrapper2;
            }
            Vector vector2 = lOControlWrapper2.getSublayer();
            if (vector2 != null && (lOControlWrapper = this.findHandleInLayer(vector2, point)) != null) {
                return lOControlWrapper;
            }
            --n;
        }
        return null;
    }

    private LOControlWrapper findHandle(Point point) {
        int n = this.fNumLayers - 1;
        while (n >= 0) {
            LOControlWrapper lOControlWrapper = this.findHandleInLayer(this.fControlList[n], point);
            if (lOControlWrapper != null) {
                return lOControlWrapper;
            }
            --n;
        }
        return null;
    }

    private LOControlWrapper findControlInLayer(Vector vector, Point point) {
        int n = vector.size() - 1;
        while (n >= 0) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n);
            if (lOControlWrapper.ptInControlRect(point)) {
                LOControlWrapper lOControlWrapper2;
                Vector vector2 = lOControlWrapper.getSublayer();
                if (vector2 != null && (lOControlWrapper2 = this.findControlInLayer(vector2, point)) != null) {
                    return lOControlWrapper2;
                }
                return lOControlWrapper;
            }
            --n;
        }
        return null;
    }

    private LOControlWrapper findControl(Point point) {
        int n = this.fNumLayers - 1;
        while (n >= 0) {
            LOControlWrapper lOControlWrapper = this.findControlInLayer(this.fControlList[n], point);
            if (lOControlWrapper != null) {
                return lOControlWrapper;
            }
            --n;
        }
        return null;
    }

    private RulerGuide findGuide(Point point) {
        return this.fLayoutGrid.findGuide(point);
    }

    private static LOControlWrapper findContainerInLayer(Vector vector, Point point) {
        int n = vector.size() - 1;
        while (n >= 0) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n);
            if (lOControlWrapper.isEnclosure() && lOControlWrapper.ptInControlRect(point)) {
                LOControlWrapper lOControlWrapper2;
                Vector vector2 = lOControlWrapper.getSublayer();
                if (vector2 != null && (lOControlWrapper2 = LayoutArea.findContainerInLayer(vector2, point)) != null) {
                    return lOControlWrapper2;
                }
                return lOControlWrapper;
            }
            --n;
        }
        return null;
    }

    LOControlWrapper findContainer(Point point) {
        return LayoutArea.findContainerInLayer(this.fControlList[1], point);
    }

    private LOControlWrapper findParent(Rectangle rectangle) {
        Point point = rectangle.getLocation();
        LOControlWrapper lOControlWrapper = this.findContainer(point);
        if (lOControlWrapper != null) {
            point.translate(rectangle.width, rectangle.height);
            Point point2 = lOControlWrapper.getBaseLocation();
            Dimension dimension = lOControlWrapper.getControl().getSize();
            point2.translate(dimension.width, dimension.height);
            if (point.x <= point2.x && point.y <= point2.y) {
                return lOControlWrapper;
            }
        }
        return null;
    }

    private boolean inCorner(Point point) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        return point.x > dimension.width - 8 && point.x <= dimension.width && point.y > dimension.height - 8 && point.y <= dimension.height;
    }

    public Object getComponentByName(String string) {
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Component component;
            String string2;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!(lOControlWrapper.getBean() instanceof Component) || (string2 = (component = (Component)lOControlWrapper.getBean()).getName()) == null || !string2.equals(string)) continue;
            return component;
        }
        return null;
    }

    public String[] getComponentNames() {
        Object object;
        Vector<String> vector = new Vector<String>(10);
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Component component;
            String string;
            object = (LOControlWrapper)enumeration.nextElement();
            if (!(((LOControlWrapper)object).getBean() instanceof Component) || (string = (component = (Component)((LOControlWrapper)object).getBean()).getName()) == null || string.equals("")) continue;
            vector.addElement(string);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    final LOControlWrapper findBeanAtPoint(Point point) {
        LOControlWrapper lOControlWrapper = this.findControlInLayer(this.fControlList[2], point);
        if (lOControlWrapper != null) {
            return lOControlWrapper;
        }
        lOControlWrapper = this.findControlInLayer(this.fControlList[3], point);
        if (lOControlWrapper != null) {
            return lOControlWrapper;
        }
        lOControlWrapper = this.findControlInLayer(this.fControlList[1], point);
        if (lOControlWrapper != null) {
            return lOControlWrapper;
        }
        return null;
    }

    boolean hasSelection() {
        return this.fSelectionCount != 0;
    }

    public int getSelectedObjectCount() {
        int n = 0;
        Enumeration enumeration = this.wrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isSelected()) continue;
            ++n;
        }
        return n;
    }

    void handleAntTrackingSelection(Rectangle rectangle, boolean bl) {
        LOControlWrapper lOControlWrapper = null;
        Enumeration enumeration = this.wrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
            if (lOControlWrapper2.objInRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                if (bl) {
                    boolean bl2 = lOControlWrapper2.isSelected();
                    lOControlWrapper2.setSelected(!bl2);
                    if (bl2) continue;
                    lOControlWrapper = lOControlWrapper2;
                    continue;
                }
                if (lOControlWrapper2.isSelected()) continue;
                lOControlWrapper = lOControlWrapper2;
                lOControlWrapper2.setSelected(true);
                continue;
            }
            if (bl) continue;
            lOControlWrapper2.setSelected(false);
        }
        this.updateSelection();
        ((Component)((Object)this)).repaint(5L);
    }

    public Point pinRectToBounds(int n, int n2, int n3, int n4) {
        int n5;
        Point point = new Point(n, n2);
        int n6 = ((Component)((Object)this)).getSize().width;
        if (point.x + n3 > n6) {
            point.x = n6 - n3;
        }
        if (point.y + n4 > (n5 = ((Component)((Object)this)).getSize().height)) {
            point.y = n5 - n4;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        return point;
    }

    private void paintControlList(Graphics graphics) {
        Enumeration enumeration = this.baseWrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            lOControlWrapper.paint(graphics);
        }
    }

    private void drawSelectionHandlesInLayer(Graphics graphics, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (lOControlWrapper.isSelected()) {
                lOControlWrapper.drawHandles(graphics);
            }
            if ((vector2 = lOControlWrapper.getSublayer()) == null) continue;
            this.drawSelectionHandlesInLayer(graphics, vector2);
        }
    }

    private void drawSelectionHandles(Graphics graphics) {
        Enumeration enumeration = this.baseLayers();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            this.drawSelectionHandlesInLayer(graphics, vector);
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (((Component)((Object)this)).isShowing()) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void paint(Graphics graphics) {
        this.drawLayoutArea(graphics);
        this.paintControlList(graphics);
        this.drawSelectionHandles(graphics);
    }

    public Dimension getPreferredSize() {
        return ((Component)((Object)this)).getSize();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void print(Graphics graphics) {
        this.paintControlList(graphics);
    }

    void drawNow() {
        Container container = ((Component)((Object)this)).getParent();
        Graphics graphics = container.getGraphics();
        container.paint(graphics);
        graphics.dispose();
        graphics = null;
    }

    void resizeScroller() {
        ((Component)((Object)this)).getParent().getParent().validate();
    }

    void drawDropOutline(Graphics graphics) {
        Point point = ((Component)((Object)this)).getLocation();
        Dimension dimension = ((Component)((Object)this)).getSize();
        Dimension dimension2 = ((Component)((Object)this)).getParent().getSize();
        int n = Math.min(dimension.width, dimension2.width);
        int n2 = Math.min(dimension.height, dimension2.height);
        graphics.drawRect(-point.x, -point.y, n - 1, n2 - 1);
        graphics.drawRect(-point.x + 1, -point.y + 1, n - 3, n2 - 3);
    }

    private void drawLayoutArea(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.fLayoutGrid.paintGrid(graphics);
        graphics.setColor(Color.black);
        Dimension dimension = ((Component)((Object)this)).getSize();
        if (rectangle.x + rectangle.width > dimension.width - 8 && rectangle.y + rectangle.height > dimension.height - 8) {
            graphics.drawRect(dimension.width - 8, dimension.height - 8, 8, 8);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private void doSetCursor(MouseEvent mouseEvent) {
        int n = this.fToolPalette.getSelectedButtonIndex();
        if (PlatformInfo.getVendor() == 2 && mouseEvent.isControlDown()) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            n = 0;
        }
        if (LayoutArea.isConnectTrigger(mouseEvent)) {
            n = 1;
        }
        if (n == 0) {
            LOControlWrapper lOControlWrapper = this.findHandle(mouseEvent.getPoint());
            if (lOControlWrapper != null) {
                switch (lOControlWrapper.findResizeHandle(mouseEvent.getPoint())) {
                    case 1: {
                        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(5));
                        return;
                    }
                    case 2: {
                        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(7));
                        return;
                    }
                    case 3: {
                        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(6));
                        return;
                    }
                    case 4: {
                        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(4));
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (this.findGuide(mouseEvent.getPoint()) != null) {
                ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(13));
                return;
            }
            if (this.findControl(mouseEvent.getPoint()) != null) {
                ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(13));
                return;
            }
            if (this.inCorner(mouseEvent.getPoint())) {
                ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(5));
                return;
            }
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (n == 1) {
            if (this.findBeanAtPoint(mouseEvent.getPoint()) != null) {
                ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(1));
    }

    private static boolean pointsAreClose(Point point, Point point2) {
        return Math.abs(point.x - point2.x) <= 3 && Math.abs(point.y - point2.y) <= 3;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.fLastClick != null && LayoutArea.pointsAreClose(this.fLastClick, mouseEvent.getPoint())) {
            Inspector.activateInspector();
            return;
        }
        this.fLastClick = mouseEvent.getPoint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.fLastClick = null;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.fHRuler.doMouseTrackXOROff();
        this.fVRuler.doMouseTrackXOROff();
        this.fLastClick = null;
    }

    private void doPopup(MouseEvent mouseEvent) {
        if (this.fSelectionCount != 0) {
            this.fObjectPopup.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        this.fWindowPopup.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
    }

    private static boolean isMouseDownPopupTrigger(MouseEvent mouseEvent) {
        switch (PlatformInfo.getPlatform()) {
            case 0: {
                return (mouseEvent.getModifiers() & 0xF) == 2;
            }
            case 1: {
                return false;
            }
        }
        return mouseEvent.isPopupTrigger();
    }

    private boolean isMouseUpPopupTrigger(MouseEvent mouseEvent) {
        return PlatformInfo.getPlatform() == 1 && LayoutArea.pointsAreClose(mouseEvent.getPoint(), this.fMouseStart) && mouseEvent.isPopupTrigger();
    }

    private static boolean isConnectTrigger(MouseEvent mouseEvent) {
        boolean bl = false;
        return bl;
    }

    private static boolean isDuplicateTrigger(MouseEvent mouseEvent) {
        if (PlatformInfo.getPlatform() == 1) {
            return mouseEvent.isMetaDown();
        }
        return mouseEvent.isAltDown();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fMouseStart = mouseEvent.getPoint();
        if (LayoutArea.isMouseDownPopupTrigger(mouseEvent)) {
            LOControlWrapper lOControlWrapper = this.findControl(mouseEvent.getPoint());
            boolean bl = false;
            if (!(lOControlWrapper != null && lOControlWrapper.isSelected() || this.fSelectionCount == 0)) {
                bl = this.selectAll(false);
            }
            if (lOControlWrapper != null && !lOControlWrapper.isSelected()) {
                bl = true;
                lOControlWrapper.setSelected(true);
            }
            if (bl) {
                this.updateSelection();
                this.drawNow();
            }
            this.doPopup(mouseEvent);
            return;
        }
        int n = this.fToolPalette.getSelectedButtonIndex();
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            n = 0;
        }
        if (LayoutArea.isConnectTrigger(mouseEvent)) {
            n = 1;
        }
        if (n == 0) {
            LOControlWrapper lOControlWrapper = this.findHandle(mouseEvent.getPoint());
            if (lOControlWrapper != null) {
                this.fDragTracker = new ResizeDrag(this, lOControlWrapper);
                this.fDragTracker.mousePressed(mouseEvent);
                return;
            }
            RulerGuide rulerGuide = this.findGuide(mouseEvent.getPoint());
            if (rulerGuide != null) {
                this.fDragTracker = new RulerGuideDrag(this, rulerGuide);
                this.fDragTracker.mousePressed(mouseEvent);
                return;
            }
            lOControlWrapper = this.findControl(mouseEvent.getPoint());
            if (lOControlWrapper != null) {
                if ((mouseEvent.isShiftDown() || mouseEvent.isControlDown()) && lOControlWrapper.isSelected()) {
                    lOControlWrapper.setSelected(false);
                    this.updateSelection();
                    ((Component)((Object)this)).repaint(5L);
                    return;
                }
                if (lOControlWrapper.getControlType() == 19) {
                    Point point = lOControlWrapper.getBaseLocation();
                    LOTabPanel lOTabPanel = (LOTabPanel)((Object)lOControlWrapper.getControl());
                    int n2 = lOTabPanel.getSelectedIndex();
                    mouseEvent.translatePoint(-point.x, -point.y);
                    ((Component)((Object)lOTabPanel)).dispatchEvent(mouseEvent);
                    mouseEvent.translatePoint(point.x, point.y);
                    if (lOTabPanel.getSelectedIndex() != n2) {
                        this.fireObjectChangedEvent(lOControlWrapper);
                    }
                }
                this.fDragTracker = new MoveDrag(this, lOControlWrapper, LayoutArea.isDuplicateTrigger(mouseEvent));
                this.fDragTracker.mousePressed(mouseEvent);
                return;
            }
            if (this.inCorner(mouseEvent.getPoint())) {
                this.fDragTracker = this.fHandle != null ? new CornerDrag(this, this.fHandle, this.fRootObject) : new CornerDrag(this, (Component)((Object)this.fRuntimeArea));
                this.fDragTracker.mousePressed(mouseEvent);
                return;
            }
            this.fDragTracker = new SelectDrag(this);
            this.fDragTracker.mousePressed(mouseEvent);
            return;
        }
        if (n == 1) {
            LOControlWrapper lOControlWrapper = this.findBeanAtPoint(mouseEvent.getPoint());
            if (lOControlWrapper != null) {
                this.fDragTracker = new ConnectDrag(this, lOControlWrapper);
                this.fDragTracker.mousePressed(mouseEvent);
                return;
            }
            this.fDragTracker = new SelectDrag(this);
            this.fDragTracker.mousePressed(mouseEvent);
            return;
        }
        this.fDragTracker = new AddDrag(this, this.fToolPalette.getSelectedButtonIndex());
        this.fDragTracker.mousePressed(mouseEvent);
    }

    void constrainPoint(Point point) {
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        Dimension dimension = ((Component)((Object)this)).getSize();
        if (point.x > dimension.width) {
            point.x = dimension.width;
        }
        if (point.y > dimension.height) {
            point.y = dimension.height;
        }
    }

    void constrainBounds(Point point) {
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        Dimension dimension = ((Component)((Object)this)).getSize();
        if (point.x >= dimension.width) {
            point.x = dimension.width - 1;
        }
        if (point.y >= dimension.height) {
            point.y = dimension.height - 1;
        }
    }

    void snapToGrid(Point point, int n, int n2) {
        this.fLayoutGrid.snapToGrid(point, n, n2);
    }

    Point getSnapRect(Rectangle rectangle) {
        Point point;
        Dimension dimension = ((Component)((Object)this)).getSize();
        Point point2 = new Point(0, 0);
        if (this.fLayoutGrid.getSnapToGrid()) {
            point = this.fLayoutGrid.getGridSnapRect(rectangle, dimension.width, dimension.height);
            point2.translate(point.x, point.y);
            rectangle.translate(point.x, point.y);
        }
        point = this.fLayoutGrid.getGuideSnapRect(rectangle, dimension.width, dimension.height);
        point2.translate(point.x, point.y);
        rectangle.translate(point.x, point.y);
        return point2;
    }

    Vector getSelectedControls() {
        LOControlWrapper lOControlWrapper;
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>();
        Enumeration enumeration = this.wrappers();
        while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isSelected() || lOControlWrapper.getParent() != null && lOControlWrapper.getParent().isSelected()) continue;
            vector.addElement(lOControlWrapper);
        }
        enumeration = vector.elements();
        block1: while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent();
            while (lOControlWrapper2 != null) {
                if (vector.contains(lOControlWrapper2)) {
                    vector.removeElement(lOControlWrapper);
                    continue block1;
                }
                lOControlWrapper2 = lOControlWrapper2.getParent();
            }
        }
        return vector;
    }

    private Vector getConnectedGlueWrappers(Vector vector) {
        if (this.fControlList[5].isEmpty()) {
            return null;
        }
        Vector<LOGlueWrapper> vector2 = new Vector<LOGlueWrapper>(this.fControlList[5].size());
        Enumeration enumeration = this.fControlList[5].elements();
        while (enumeration.hasMoreElements()) {
            LOGlueWrapper lOGlueWrapper = (LOGlueWrapper)enumeration.nextElement();
            if (!vector.contains(lOGlueWrapper.getSource()) && !vector.contains(lOGlueWrapper.getTarget()) && !LayoutArea.recursiveContains(vector, lOGlueWrapper.getSource()) && !LayoutArea.recursiveContains(vector, lOGlueWrapper.getTarget())) continue;
            vector2.addElement(lOGlueWrapper);
        }
        if (vector2.isEmpty()) {
            vector2 = null;
        }
        return vector2;
    }

    private void addGlueWrappers(Vector vector) {
        if (this.fControlList[5].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.fControlList[5].elements();
        while (enumeration.hasMoreElements()) {
            LOGlueWrapper lOGlueWrapper = (LOGlueWrapper)enumeration.nextElement();
            if ((!vector.contains(lOGlueWrapper.getSource()) || !vector.contains(lOGlueWrapper.getTarget())) && (!LayoutArea.recursiveContains(vector, lOGlueWrapper.getSource()) || !LayoutArea.recursiveContains(vector, lOGlueWrapper.getTarget()))) continue;
            vector.addElement(lOGlueWrapper);
        }
    }

    private static boolean recursiveContains(Vector vector, LOControlWrapper lOControlWrapper) {
        while (lOControlWrapper != null) {
            if (vector.contains(lOControlWrapper)) {
                return true;
            }
            lOControlWrapper = lOControlWrapper.getParent();
        }
        return false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (this.fDragTracker != null) {
            this.fDragTracker.mouseReleased(mouseEvent);
            this.fDragTracker = null;
        }
        if (this.fToolPalette != null && (n = this.fToolPalette.getSelectedButtonIndex()) != 0 && n != 1) {
            this.fToolPalette.resetToSelectTool();
        }
        if (this.isMouseUpPopupTrigger(mouseEvent)) {
            this.doPopup(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fDragTracker != null) {
            this.fDragTracker.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.fHRuler.doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.fVRuler.doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.doSetCursor(mouseEvent);
    }

    private void doKeyDown(KeyEvent keyEvent) {
        Point point = new Point(0, 0);
        int n = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                switch (n) {
                    case 38: {
                        point.y = -10;
                        this.ArrowKeyObjectMove(point);
                        return;
                    }
                    case 40: {
                        point.y = 10;
                        this.ArrowKeyObjectMove(point);
                        return;
                    }
                    case 37: {
                        point.x = -10;
                        this.ArrowKeyObjectMove(point);
                        return;
                    }
                    case 39: {
                        point.x = 10;
                        this.ArrowKeyObjectMove(point);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (n) {
                case 38: {
                    point.y = -1;
                    this.ArrowKeyObjectMove(point);
                    return;
                }
                case 40: {
                    point.y = 1;
                    this.ArrowKeyObjectMove(point);
                    return;
                }
                case 37: {
                    point.x = -1;
                    this.ArrowKeyObjectMove(point);
                    return;
                }
                case 39: {
                    point.x = 1;
                    this.ArrowKeyObjectMove(point);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (n) {
            case 8: 
            case 127: {
                this.doClear();
                return;
            }
        }
    }

    private void ArrowKeyObjectMove(Point point) {
        Vector vector = this.getSelectedControls();
        if (vector.isEmpty()) {
            return;
        }
        boolean bl = this.fLayoutGrid.getSnapToGrid();
        this.fLayoutGrid.setSnapToGrid(false);
        UndoMove undoMove = new UndoMove(this, vector);
        Rectangle rectangle = this.getLayerBounds(vector);
        Rectangle rectangle2 = new Rectangle(rectangle);
        Dimension dimension = ((Component)((Object)this)).getSize();
        rectangle2.translate(point.x, point.y);
        if (rectangle2.x < 0) {
            point.translate(-rectangle2.x, 0);
        }
        if (rectangle2.y < 0) {
            point.translate(0, -rectangle2.y);
        }
        if (rectangle2.x + rectangle2.width > dimension.width) {
            point.translate(dimension.width - (rectangle2.x + rectangle2.width), 0);
        }
        if (rectangle2.y + rectangle2.height > dimension.height) {
            point.translate(0, dimension.height - (rectangle2.y + rectangle2.height));
        }
        if (point.x != 0 || point.y != 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                lOControlWrapper.offsetRect(point.x, point.y);
            }
        }
        undoMove.moveComplete();
        if (this.fHandle != null) {
            ++this.fArrowID;
            if (this.fKeyTracker == null) {
                this.fKeyTracker = new KeyTracker(vector);
            }
            ((Component)((Object)this)).repaint(5L);
        } else {
            this.fireObjectChangedEvent(vector);
        }
        this.fireContentChangedEvent();
        this.fireUndoEvent(undoMove);
        this.fLayoutGrid.setSnapToGrid(bl);
    }

    private Rectangle getLayerBounds(Vector vector) {
        LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.firstElement();
        Point point = lOControlWrapper.getBaseLocation();
        Dimension dimension = lOControlWrapper.getControl().getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            point = lOControlWrapper.getBaseLocation();
            dimension = lOControlWrapper.getControl().getSize();
            rectangle.add(point);
            rectangle.add(point.x + dimension.width, point.y + dimension.height);
        }
        return rectangle;
    }

    private void doKeyUp(KeyEvent keyEvent) {
        if (this.fHandle == null) {
            return;
        }
        if (keyEvent.isActionKey()) {
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    if (this.fKeyTracker == null) break;
                    if (PlatformInfo.isUnix()) {
                        if (sArrowTimer == null) {
                            sArrowTimer = new ArrowTimer();
                        }
                        sArrowTimer.setTarget(this, this.fArrowID);
                        return;
                    }
                    this.fKeyTracker.run();
                    this.fKeyTracker = null;
                    return;
                }
            }
        }
    }

    private void checkArrowKey(int n) {
        if (this.fKeyTracker != null && n == this.fArrowID) {
            this.fKeyTracker.run();
            this.fKeyTracker = null;
        }
    }

    private void fireSelectionChangedEvent(int n) {
        this.doCommand(1001);
    }

    void fireContentChangedEvent() {
        this.doCommand(1002);
    }

    void fireObjectChangedEvent(LOControlWrapper lOControlWrapper) {
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        ObjectRegistry.getLayoutRegistry().change(objectArray);
    }

    void fireObjectChangedEvent(Vector vector) {
        int n = vector.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n2);
            objectArray[n2] = lOControlWrapper.getBean();
            ++n2;
        }
        ObjectRegistry.getLayoutRegistry().change(objectArray);
    }

    void setUndoManager(UndoManager undoManager) {
        this.fUndoManager = undoManager;
    }

    void fireUndoEvent(UndoableEdit undoableEdit) {
        UndoManager undoManager = this.fUndoManager;
        if (undoManager != null) {
            undoManager.addEdit(undoableEdit);
        }
    }

    Enumeration wrappers() {
        return new WrapperEnumerator(new LayerEnumerator(this.fControlList));
    }

    private Enumeration baseWrappers() {
        return new WrapperEnumerator(new BaseLayerEnumerator(this.fControlList));
    }

    private int getBaseWrapperCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fControlList.length) {
            n += this.fControlList[n2].size();
            ++n2;
        }
        return n;
    }

    Enumeration allWrappers() {
        Vector vector = new Vector(10);
        int n = 0;
        while (n < this.fControlList.length) {
            this.addAllSublayers(vector, this.fControlList[n]);
            ++n;
        }
        return new WrapperEnumerator(vector.elements());
    }

    private void addAllSublayers(Vector vector, Vector vector2) {
        vector.addElement(vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (lOControlWrapper instanceof LOTabWrapper) {
                object = (LOTabWrapper)lOControlWrapper;
                Enumeration enumeration2 = ((LOTabWrapper)object).getTabLayers().elements();
                while (enumeration2.hasMoreElements()) {
                    Vector vector3 = (Vector)enumeration2.nextElement();
                    this.addAllSublayers(vector, vector3);
                }
                continue;
            }
            object = lOControlWrapper.getSublayer();
            if (object == null) continue;
            this.addAllSublayers(vector, (Vector)object);
        }
    }

    Enumeration baseLayers() {
        return new BaseLayerEnumerator(this.fControlList);
    }

    private Enumeration layers() {
        return new LayerEnumerator(this.fControlList);
    }

    private void selectObjects(Object[] objectArray, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < objectArray.length) {
            LOControlWrapper lOControlWrapper = this.findWrapper(objectArray[n]);
            if (lOControlWrapper != null && lOControlWrapper.isSelected() != bl) {
                lOControlWrapper.setSelected(bl);
                bl2 = true;
            }
            ++n;
        }
        if (bl2) {
            ((Component)((Object)this)).repaint(5L);
        }
        this.fSelectionCount = this.getSelectedObjectCount();
        this.fireSelectionChangedEvent(this.fSelectionCount);
    }

    /*
     * Exception decompiling
     */
    void changeObjects(Object[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void tabPanelChanged(LOControlWrapper lOControlWrapper) {
        Vector vector;
        int n;
        SubpanelOwner subpanelOwner = (SubpanelOwner)((Object)lOControlWrapper.getControl());
        int n2 = subpanelOwner.getSubpanelCount();
        if (n2 == (n = (vector = ObjectRegistry.getLayoutRegistry().getChildren((Object)subpanelOwner)).size())) {
            Object[] objectArray = new Object[n];
            vector.copyInto(objectArray);
            ObjectRegistry.getLayoutRegistry().change(objectArray, (Object)subpanelOwner);
        } else if (n2 > n) {
            Object[] objectArray = new Object[n];
            vector.copyInto(objectArray);
            ObjectRegistry.getLayoutRegistry().change(objectArray, (Object)subpanelOwner);
            int n3 = n2 - n;
            objectArray = new Object[n3];
            int n4 = 0;
            while (n4 < n3) {
                objectArray[n4] = subpanelOwner.getSubpanel(n4 + n);
                ++n4;
            }
            ObjectRegistry.getLayoutRegistry().register(objectArray, (Object)subpanelOwner, -1, this.fObjectOwner, true);
        } else if (n2 < n) {
            Object[] objectArray = new Object[n2];
            int n5 = 0;
            while (n5 < n2) {
                objectArray[n5] = subpanelOwner.getSubpanel(n5);
                ++n5;
            }
            ObjectRegistry.getLayoutRegistry().change(objectArray, (Object)subpanelOwner);
            int n6 = n - n2;
            objectArray = new Object[n6];
            int n7 = 0;
            while (n7 < n6) {
                objectArray[n7] = vector.elementAt(n7 + n2);
                ++n7;
            }
            ObjectRegistry.getLayoutRegistry().unregister(objectArray);
        }
        ((LOTabWrapper)lOControlWrapper).setCurLayer(subpanelOwner.getSubpanelIndex());
    }

    private void gObjectChanged(LOControlWrapper lOControlWrapper) {
        Object object = lOControlWrapper.getBean();
        GObjectProxy gObjectProxy = (GObjectProxy)lOControlWrapper.getControl();
        LayoutLooper.updateObject(object, gObjectProxy, (Component)((Object)this));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class VerticalSort
    extends VectorSort {
        protected int compare(Object object, Object object2) {
            return ((LOControlWrapper)object).getTop() - ((LOControlWrapper)object2).getTop();
        }

        VerticalSort() {
        }
    }

    private static class HorizontalSort
    extends VectorSort {
        protected int compare(Object object, Object object2) {
            return ((LOControlWrapper)object).getLeft() - ((LOControlWrapper)object2).getLeft();
        }

        HorizontalSort() {
        }
    }

    private class DuplicateObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            LayoutArea.this.duplicateComplete(object);
        }

        DuplicateObserver() {
            LayoutArea.this = LayoutArea.this;
        }
    }

    private class LayoutKey
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            LayoutArea.this.doKeyDown(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            LayoutArea.this.doKeyUp(keyEvent);
        }

        LayoutKey() {
            LayoutArea.this = LayoutArea.this;
        }
    }

    private class KeyTracker
    implements Runnable {
        private Vector fSelection;

        KeyTracker(Vector vector) {
            LayoutArea.this = LayoutArea.this;
            this.fSelection = vector;
        }

        public void run() {
            GObjectWrapper.updateVector(this.fSelection);
        }
    }

    private static class ArrowTimer
    extends Timer
    implements ActionListener {
        private LayoutArea fTarget;
        private int fArrowID;

        ArrowTimer() {
            super(100, null, 2, "layout arrow key");
            this.addActionListener(this);
        }

        void setTarget(LayoutArea layoutArea, int n) {
            this.fTarget = layoutArea;
            this.fArrowID = n;
            this.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fTarget.checkArrowKey(this.fArrowID);
        }
    }

    private class WrapperEnumerator
    implements Enumeration {
        Enumeration fLayers;
        Enumeration fWrappers;

        WrapperEnumerator(Enumeration enumeration) {
            LayoutArea.this = LayoutArea.this;
            this.fLayers = enumeration;
            this.fWrappers = ((Vector)this.fLayers.nextElement()).elements();
            this.advance();
        }

        private void advance() {
            while (!this.fWrappers.hasMoreElements() && this.fLayers.hasMoreElements()) {
                this.fWrappers = ((Vector)this.fLayers.nextElement()).elements();
            }
        }

        public boolean hasMoreElements() {
            return this.fWrappers.hasMoreElements();
        }

        public Object nextElement() {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)this.fWrappers.nextElement();
            this.advance();
            return lOControlWrapper;
        }
    }

    private class BaseLayerEnumerator
    implements Enumeration {
        Vector[] fLayers;
        int fIndex;

        BaseLayerEnumerator(Vector[] vectorArray) {
            LayoutArea.this = LayoutArea.this;
            this.fLayers = vectorArray;
            this.fIndex = 0;
        }

        public boolean hasMoreElements() {
            return this.fIndex < this.fLayers.length;
        }

        public Object nextElement() {
            if (this.fIndex < this.fLayers.length) {
                return this.fLayers[this.fIndex++];
            }
            throw new NoSuchElementException("BaseLayerEnumerator");
        }
    }

    private class LayerEnumerator
    implements Enumeration {
        Vector[] fLayers;
        Vector fStack;
        int fIndex;
        Enumeration fEnum;

        LayerEnumerator(Vector[] vectorArray) {
            LayoutArea.this = LayoutArea.this;
            this.fLayers = vectorArray;
            this.fIndex = 0;
            this.fEnum = null;
        }

        public boolean hasMoreElements() {
            return this.fIndex < this.fLayers.length;
        }

        public Object nextElement() {
            if (this.fEnum == null || !this.fEnum.hasMoreElements()) {
                this.fEnum = new SublayerEnumerator(this.fLayers[this.fIndex]);
                return this.fLayers[this.fIndex++];
            }
            return this.fEnum.nextElement();
        }
    }

    private class SublayerEnumerator
    implements Enumeration {
        private Vector[] fLayer = new Vector[4];
        private int[] fIndex = new int[4];
        private int fDepth = 0;

        SublayerEnumerator(Vector vector) {
            LayoutArea.this = LayoutArea.this;
            this.fLayer[this.fDepth] = vector;
            this.fIndex[this.fDepth] = 0;
        }

        public boolean hasMoreElements() {
            int n = this.findSublayerIndex(this.fLayer[this.fDepth], this.fIndex[this.fDepth]);
            if (n != -1) {
                return true;
            }
            if (this.fDepth > 0) {
                --this.fDepth;
                return this.hasMoreElements();
            }
            return false;
        }

        public Object nextElement() {
            int n = this.findSublayerIndex(this.fLayer[this.fDepth], this.fIndex[this.fDepth]);
            if (n != -1) {
                this.fIndex[this.fDepth] = n + 1;
                LOControlWrapper lOControlWrapper = (LOControlWrapper)this.fLayer[this.fDepth].elementAt(n);
                Vector vector = lOControlWrapper.getSublayer();
                if (vector != null) {
                    if (this.fDepth == this.fLayer.length - 1) {
                        this.increaseCapacity();
                    }
                    ++this.fDepth;
                    this.fLayer[this.fDepth] = vector;
                    this.fIndex[this.fDepth] = 0;
                    return vector;
                }
                if (this.fDepth > 0) {
                    --this.fDepth;
                    return this.nextElement();
                }
            }
            throw new NoSuchElementException("SublayerEnumerator");
        }

        private int findSublayerIndex(Vector vector, int n) {
            int n2 = vector.size();
            int n3 = n;
            while (n3 < n2) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n3);
                Vector vector2 = lOControlWrapper.getSublayer();
                if (vector2 != null) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }

        private void increaseCapacity() {
            int n = this.fLayer.length;
            int n2 = n + 4;
            Vector[] vectorArray = this.fLayer;
            int[] nArray = this.fIndex;
            this.fLayer = new Vector[n2];
            this.fIndex = new int[n2];
            System.arraycopy(vectorArray, 0, this.fLayer, 0, n);
            System.arraycopy(nArray, 0, this.fIndex, 0, n);
        }
    }

    private static class HoldingArea
    extends MWPanel {
        private Component fOwner;

        HoldingArea(Component component) {
            super(null);
            this.fOwner = component;
        }

        public Font getFont() {
            return this.fOwner.getFont();
        }

        public Color getForeground() {
            return this.fOwner.getForeground();
        }

        public Color getBackground() {
            return this.fOwner.getBackground();
        }
    }

    private class LayoutOwner
    implements ObjectOwner {
        public void add(Object[] objectArray, Object object, int n) {
        }

        public void remove(Object[] objectArray) {
        }

        public void move(Object[] objectArray, Object object, int n) {
        }

        public void copy(Object[] objectArray) {
        }

        public void paste(Object object, int n) {
        }

        public void refresh(Object[] objectArray) {
        }

        public void setSelected(Object[] objectArray, boolean bl, boolean bl2) {
        }

        public void setSelected(Object[] objectArray, boolean bl) {
        }

        LayoutOwner() {
            LayoutArea.this = LayoutArea.this;
        }
    }

    private class SelectionChanged
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object[] objectArray = (Object[])itemEvent.getItem();
            boolean bl = itemEvent.getStateChange() == 1;
            LayoutArea.this.selectObjects(objectArray, bl);
        }

        SelectionChanged() {
            LayoutArea.this = LayoutArea.this;
        }
    }

    private class ObjectChanged
    implements ObjectRegistryListener {
        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            LayoutArea.this.changeObjects(objectRegistryEvent.getObjects());
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }

        ObjectChanged() {
            LayoutArea.this = LayoutArea.this;
        }
    }
}

