/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.GObjectProxy;
import com.mathworks.ide.layout.GObjectWrapper;
import com.mathworks.ide.layout.LOBeanWrapper;
import com.mathworks.ide.layout.LOTabWrapper;
import com.mathworks.ide.layout.LOWrapperOwner;
import com.mathworks.ide.layout.RuntimeArea;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Vector;

class LOControlWrapper
implements LOWrapperOwner {
    private Component fControl;
    private int fType;
    private boolean fSelected;
    private Vector fConnections;
    private LOControlWrapper fParent;
    private Vector fSublayer;
    static final int NO_HANDLE = 0;
    static final int BR_HANDLE = 1;
    static final int TR_HANDLE = 2;
    static final int TL_HANDLE = 3;
    static final int BL_HANDLE = 4;
    private static final int HANDLE_INSET = 2;
    private static final int HANDLE_OUTSET = 3;
    private static final int HANDLE_SIZE = 5;
    static /* synthetic */ Class class$java$awt$Component;

    LOControlWrapper(Component component, boolean bl, int n) {
        this.fSelected = bl;
        this.fControl = component;
        this.fType = n;
    }

    int getTop() {
        return this.getBaseLocation().y;
    }

    int getLeft() {
        return this.getBaseLocation().x;
    }

    int getBottom() {
        return this.getBaseLocation().y + this.fControl.getSize().height;
    }

    int getRight() {
        return this.getBaseLocation().x + this.fControl.getSize().width;
    }

    int getControlType() {
        return this.fType;
    }

    boolean ptInControlRect(Point point) {
        Point point2 = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        int n = point2.x;
        int n2 = point2.y;
        int n3 = n + dimension.width;
        int n4 = n2 + dimension.height;
        return point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4;
    }

    void offsetRect(int n, int n2) {
        Point point = this.fControl.getLocation();
        point.translate(n, n2);
        this.fControl.setLocation(point.x, point.y);
    }

    boolean objInRect(int n, int n2, int n3, int n4) {
        boolean bl = true;
        int n5 = n + n3;
        int n6 = n2 + n4;
        Point point = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        int n7 = point.x;
        int n8 = point.y;
        int n9 = n7 + dimension.width;
        int n10 = n8 + dimension.height;
        if (n7 < n || n7 > n5) {
            bl = false;
        }
        if (n9 < n || n9 > n5) {
            bl = false;
        }
        if (n10 < n2 || n10 > n6) {
            bl = false;
        }
        if (n8 < n2 || n8 > n6) {
            bl = false;
        }
        return bl;
    }

    void setControl(Component component) {
        this.fControl = component;
    }

    Component getControl() {
        return this.fControl;
    }

    Object getBean() {
        return this.getControl();
    }

    final boolean getNeedsLayout() {
        return this.fControl != null && this.fControl instanceof Container;
    }

    boolean isLightweight() {
        return true;
    }

    boolean isBean() {
        return false;
    }

    boolean isGObject() {
        return false;
    }

    void setSelected(boolean bl) {
        this.fSelected = bl;
    }

    boolean isSelected() {
        return this.fSelected;
    }

    int findResizeHandle(Point point) {
        Point point2 = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        int n = point2.x + dimension.width - 2;
        int n2 = point2.y + dimension.height - 2;
        int n3 = n + 5;
        int n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return 1;
        }
        n = point2.x + dimension.width - 2;
        n2 = point2.y - 3;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return 2;
        }
        n = point2.x - 3;
        n2 = point2.y - 3;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return 3;
        }
        n = point2.x - 3;
        n2 = point2.y + dimension.height - 2;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return 4;
        }
        return 0;
    }

    boolean ptOverResizehandle(Point point) {
        return this.findResizeHandle(point) != 0;
    }

    void drawHandles(Graphics graphics) {
        int n = 5;
        Point point = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        graphics.fillRect(point.x - 2, point.y - 2, n, n);
        graphics.fillRect(point.x + dimension.width - 3, point.y - 2, n, n);
        graphics.fillRect(point.x - 2, point.y + dimension.height - 3, n, n);
        graphics.fillRect(point.x + dimension.width - 3, point.y + dimension.height - 3, n, n);
    }

    void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.fControl != null) {
            Rectangle rectangle2 = this.fControl.getBounds();
            if (rectangle == null || rectangle2.intersects(rectangle)) {
                Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics2.setColor(Color.black);
                try {
                    this.fControl.paint(graphics2);
                    return;
                }
                finally {
                    Object var6_5 = null;
                    graphics2.dispose();
                }
            }
        }
    }

    void addConnection(LOControlWrapper lOControlWrapper) {
        if (this.fConnections == null) {
            this.fConnections = new Vector();
        }
        this.fConnections.addElement(lOControlWrapper);
    }

    void removeConnection(LOControlWrapper lOControlWrapper) {
        if (this.fConnections != null) {
            this.fConnections.removeElement(lOControlWrapper);
        }
    }

    Enumeration connections() {
        Enumeration enumeration = null;
        if (this.fConnections != null) {
            enumeration = this.fConnections.elements();
        }
        return enumeration;
    }

    void setParent(LOControlWrapper lOControlWrapper) {
        this.fParent = lOControlWrapper;
    }

    final LOControlWrapper getParent() {
        return this.fParent;
    }

    Point getBaseLocation() {
        if (this.getParent() == null) {
            return this.getControl().getLocation();
        }
        Point point = this.getControl().getLocation();
        Container container = this.getControl().getParent();
        while (container != null && !(container instanceof RuntimeArea.RuntimeLayer)) {
            Point point2 = container.getLocation();
            point.translate(point2.x, point2.y);
            container = container.getParent();
        }
        return point;
    }

    void translateFromBaseCoordinates(Point point) {
        Point point2 = this.getBaseLocation();
        point.translate(-point2.x, -point2.y);
    }

    final Vector getSublayer() {
        return this.fSublayer;
    }

    final void setSublayer(Vector vector) {
        this.fSublayer = vector;
    }

    public void addWrapper(LOControlWrapper lOControlWrapper, int n) {
        if (lOControlWrapper.getParent() != null) {
            lOControlWrapper.getParent().removeWrapper(lOControlWrapper);
        }
        if (this.fSublayer == null) {
            this.fSublayer = new Vector(1);
        }
        if (n == -1) {
            n = this.fSublayer.size();
        }
        this.fSublayer.insertElementAt(lOControlWrapper, n);
        lOControlWrapper.setParent(this);
        Component component = lOControlWrapper.getControl();
        Container container = (Container)this.getControl();
        if (component != null) {
            container.add(component, container.getComponentCount() - n);
            if (lOControlWrapper.getControlType() == 12) {
                LOControlWrapper.addToExclusiveGroup(lOControlWrapper, container);
            }
        }
    }

    public void removeWrapper(LOControlWrapper lOControlWrapper) {
        Component component;
        if (lOControlWrapper.getControlType() == 12) {
            LOControlWrapper.removeFromExclusiveGroup(lOControlWrapper);
        }
        if ((component = lOControlWrapper.getControl()) != null) {
            Container container = component.getParent();
            container.remove(component);
        }
        if (this.fSublayer != null) {
            this.fSublayer.removeElement(lOControlWrapper);
            lOControlWrapper.setParent(null);
        }
    }

    public int getIndexOfWrapper(LOControlWrapper lOControlWrapper) {
        return this.fSublayer.indexOf(lOControlWrapper);
    }

    public LOControlWrapper findWrapper(Object object) {
        LOControlWrapper lOControlWrapper = null;
        if (object == this.getBean()) {
            lOControlWrapper = this;
        } else if (this.fSublayer != null) {
            Enumeration enumeration = this.fSublayer.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
                lOControlWrapper = lOControlWrapper2.findWrapper(object);
                if (lOControlWrapper != null) break;
            }
        }
        return lOControlWrapper;
    }

    private static void addToExclusiveGroup(LOControlWrapper lOControlWrapper, Container container) {
        MWCheckbox mWCheckbox = (MWCheckbox)lOControlWrapper.getControl();
        mWCheckbox.setBehavior(1);
        MWExclusiveGroup mWExclusiveGroup = null;
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof MWExclusiveGroupItem && (mWExclusiveGroup = ((MWExclusiveGroupItem)componentArray[n]).getGroup()) != null) break;
            ++n;
        }
        if (mWExclusiveGroup == null) {
            mWExclusiveGroup = new MWExclusiveGroup();
            mWCheckbox.setGroup(mWExclusiveGroup);
            if (mWCheckbox.getState()) {
                mWExclusiveGroup.setSelectedItem((MWExclusiveGroupItem)mWCheckbox);
                return;
            }
        } else {
            MWExclusiveGroupItem mWExclusiveGroupItem = mWExclusiveGroup.getSelectedItem();
            mWCheckbox.setGroup(mWExclusiveGroup);
            if (mWExclusiveGroupItem == null) {
                if (mWCheckbox.getState()) {
                    mWExclusiveGroup.setSelectedItem((MWExclusiveGroupItem)mWCheckbox);
                    return;
                }
            } else {
                if (mWCheckbox.getState()) {
                    mWCheckbox.setState(false);
                }
                mWExclusiveGroup.setSelectedItem(mWExclusiveGroupItem);
            }
        }
    }

    private static void removeFromExclusiveGroup(LOControlWrapper lOControlWrapper) {
        MWCheckbox mWCheckbox = (MWCheckbox)lOControlWrapper.getControl();
        MWExclusiveGroup mWExclusiveGroup = mWCheckbox.getGroup();
        if (mWExclusiveGroup != null) {
            MWExclusiveGroupItem mWExclusiveGroupItem = mWExclusiveGroup.getSelectedItem();
            mWCheckbox.setGroup(null);
            if (mWExclusiveGroupItem != null && mWExclusiveGroupItem != mWCheckbox) {
                mWExclusiveGroup.setSelectedItem(mWExclusiveGroupItem);
            }
        }
        mWCheckbox.setBehavior(0);
    }

    boolean isEnclosure() {
        return this.fType == 17 || this.fType == 19 || this.fType == 64;
    }

    boolean isEnclosable() {
        return this.fType == 29 && this.isLightweight() || this.fType < 23 || this.fType > 63;
    }

    static LOControlWrapper buildWrapper(int n, Object object) {
        LOControlWrapper lOControlWrapper = null;
        switch (n) {
            case 29: {
                Component component = (Component)Beans.getInstanceOf(object, class$java$awt$Component != null ? class$java$awt$Component : (class$java$awt$Component = LOControlWrapper.class$("java.awt.Component")));
                lOControlWrapper = new LOBeanWrapper(component, object, false, n);
                break;
            }
            case 30: {
                InvisibleProxy invisibleProxy = new InvisibleProxy();
                lOControlWrapper = new LOBeanWrapper((Component)((Object)invisibleProxy), object, false, n);
                break;
            }
            case 19: 
            case 64: {
                Component component = (Component)object;
                lOControlWrapper = new LOTabWrapper(component, false, n);
                break;
            }
            case 26: 
            case 27: {
                GObjectProxy gObjectProxy = (GObjectProxy)object;
                lOControlWrapper = new GObjectWrapper(gObjectProxy, n);
                gObjectProxy.setWrapper((GObjectWrapper)lOControlWrapper);
                break;
            }
            default: {
                Component component = (Component)object;
                lOControlWrapper = new LOControlWrapper(component, false, n);
            }
            case 28: 
        }
        return lOControlWrapper;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class InvisibleProxy
    extends MWCanvas {
        public Dimension getPreferredSize() {
            return new Dimension(72, 24);
        }

        public Dimension getMinimumSize() {
            return new Dimension(8, 8);
        }

        InvisibleProxy() {
        }
    }
}

