/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.LayoutEditor;
import com.mathworks.ide.layout.LayoutGridTarget;
import com.mathworks.ide.layout.LayoutRuler;
import com.mathworks.ide.layout.RaggedLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

final class GridDialog
extends MWPanel
implements ActionListener,
ItemListener,
LayoutGridTarget {
    private static final String GRID_DLG_WIND_TITLE = LayoutEditor.sLayoutBundle.getString("frame.grid_and_rulers");
    private LayoutArea fLayoutArea;
    private LayoutRuler fHRuler;
    private LayoutRuler fVRuler;
    private MWButton fOKButton;
    private MWButton fCancelButton;
    private MWCheckbox fShowGridCB;
    private MWCheckbox fSnapGridCB;
    private MWCheckbox fShowRulersCB;
    private MWCheckbox fShowGuidesCB;
    private MWChoice fGridPopup;
    private boolean fShowRulersState;
    private boolean fShowGridState;
    private boolean fShowGuidesState;
    private int fGridWidthState;
    private boolean fSnapGridState;

    protected GridDialog(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
        this.fHRuler = this.fLayoutArea.getHRuler();
        this.fVRuler = this.fLayoutArea.getVRuler();
        this.fLayoutArea.getGrid().addLayoutGridTarget(this);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ButtonPanel buttonPanel = new ButtonPanel();
        ((Container)((Object)buttonPanel)).setLayout(new FlowLayout(2));
        this.fCancelButton = new MWButton(LayoutEditor.sLayoutBundle.getString("button.cancel"));
        this.fCancelButton.addActionListener((ActionListener)this);
        this.fCancelButton.setActionCommand("Cancel");
        this.fOKButton = new MWButton(LayoutEditor.sLayoutBundle.getString("button.ok"));
        this.fOKButton.addActionListener((ActionListener)this);
        this.fOKButton.setActionCommand("OK");
        if (PlatformInfo.getAppearance() == 0) {
            ((Container)((Object)buttonPanel)).add((Component)this.fCancelButton);
            ((Container)((Object)buttonPanel)).add((Component)this.fOKButton);
        } else {
            ((Container)((Object)buttonPanel)).add((Component)this.fOKButton);
            ((Container)((Object)buttonPanel)).add((Component)this.fCancelButton);
        }
        ((Container)((Object)this)).add((Component)((Object)buttonPanel), "South");
        MWPanel mWPanel = new MWPanel((LayoutManager)new RaggedLayout(12));
        this.fShowRulersCB = new MWCheckbox(LayoutEditor.sLayoutBundle.getString("checkbox.show_rulers"));
        this.fShowRulersCB.addItemListener((ItemListener)this);
        mWPanel.add((Component)this.fShowRulersCB);
        this.fShowGuidesCB = new MWCheckbox(LayoutEditor.sLayoutBundle.getString("checkbox.show_guides"));
        this.fShowGuidesCB.addItemListener((ItemListener)this);
        mWPanel.add((Component)this.fShowGuidesCB);
        this.fShowGridCB = new MWCheckbox(LayoutEditor.sLayoutBundle.getString("checkbox.show_grid"));
        this.fShowGridCB.addItemListener((ItemListener)this);
        mWPanel.add((Component)this.fShowGridCB);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(0, 4, 0));
        mWPanel2.add((Component)new MWLabel(LayoutEditor.sLayoutBundle.getString("label.grid_size")));
        this.fGridPopup = new MWChoice();
        this.buildPopup();
        this.fGridPopup.addItemListener((ItemListener)this);
        mWPanel2.add((Component)this.fGridPopup);
        mWPanel.add((Component)mWPanel2);
        this.fSnapGridCB = new MWCheckbox(LayoutEditor.sLayoutBundle.getString("checkbox.snap_to_grid"));
        this.fSnapGridCB.addItemListener((ItemListener)this);
        mWPanel.add((Component)this.fSnapGridCB);
        ((Container)((Object)this)).add((Component)mWPanel, "Center");
    }

    void updateState() {
        this.fShowRulersState = this.fHRuler.getRulerState();
        this.fShowRulersCB.setState(this.fShowRulersState);
        this.fShowGridState = this.fLayoutArea.getGrid().getShowGrid();
        this.fShowGridCB.setState(this.fShowGridState);
        this.fShowGuidesState = this.fLayoutArea.getGrid().getShowGuides();
        this.fShowGuidesCB.setState(this.fShowGuidesState);
        this.fGridWidthState = this.fHRuler.getGridWidth();
        this.fGridPopup.select(this.fGridWidthState / 10 - 1);
        this.fSnapGridState = this.fLayoutArea.getGrid().getSnapToGrid();
        this.fSnapGridCB.setState(this.fSnapGridState);
    }

    String getWindowTitle() {
        return GRID_DLG_WIND_TITLE;
    }

    private void buildPopup() {
        this.fGridPopup.removeAll();
        this.fGridPopup.add("10");
        this.fGridPopup.add("20");
        this.fGridPopup.add("30");
        this.fGridPopup.add("40");
        this.fGridPopup.add("50");
        this.fGridPopup.add("60");
        this.fGridPopup.add("70");
        this.fGridPopup.add("80");
        this.fGridPopup.add("90");
        this.fGridPopup.add("100");
        this.fGridPopup.add("110");
        this.fGridPopup.add("120");
        this.fGridPopup.add("130");
        this.fGridPopup.add("140");
        this.fGridPopup.add("150");
        this.fGridPopup.add("160");
        this.fGridPopup.add("170");
        this.fGridPopup.add("180");
        this.fGridPopup.add("190");
        this.fGridPopup.add("200");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        itemEvent.getStateChange();
        if (itemSelectable instanceof MWCheckbox) {
            MWCheckbox mWCheckbox = (MWCheckbox)itemSelectable;
            if (mWCheckbox == this.fShowRulersCB) {
                this.fHRuler.setRulerState(this.fShowRulersCB.getState());
                this.fVRuler.setRulerState(this.fShowRulersCB.getState());
                this.fLayoutArea.resizeScroller();
                return;
            }
            if (mWCheckbox == this.fShowGridCB) {
                this.fLayoutArea.getGrid().setShowGrid(this.fShowGridCB.getState());
                ((Component)((Object)this.fLayoutArea)).repaint(2L);
                return;
            }
            if (mWCheckbox == this.fShowGuidesCB) {
                this.fLayoutArea.getGrid().setShowGuides(this.fShowGuidesCB.getState());
                ((Component)((Object)this.fLayoutArea)).repaint(2L);
                return;
            }
            if (mWCheckbox == this.fSnapGridCB) {
                this.fLayoutArea.getGrid().setSnapToGrid(this.fSnapGridCB.getState());
                return;
            }
        } else if (itemSelectable instanceof MWChoice) {
            int n = (this.fGridPopup.getSelectedIndex() + 1) * 10;
            this.fHRuler.setGridWidth(n);
            this.fVRuler.setGridWidth(n);
            this.fLayoutArea.getGrid().setGridWidth(n);
            ((Component)((Object)this.fLayoutArea)).repaint(2L);
            ((Component)((Object)this.fHRuler)).repaint(2L);
            ((Component)((Object)this.fVRuler)).repaint(2L);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            Window window = MWUtils.getTopLevelWindow((Component)((Object)this));
            ((Component)window).setVisible(false);
            return;
        }
        if (string == "Cancel") {
            Window window = MWUtils.getTopLevelWindow((Component)((Object)this));
            ((Component)window).setVisible(false);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.fShowRulersState != this.fHRuler.getRulerState()) {
                this.fHRuler.setRulerState(this.fShowRulersState);
                this.fVRuler.setRulerState(this.fShowRulersState);
                bl3 = true;
            }
            if (this.fShowGridState != this.fLayoutArea.getGrid().getShowGrid()) {
                this.fLayoutArea.getGrid().setShowGrid(this.fShowGridState);
                bl = true;
            }
            if (this.fShowGuidesState != this.fLayoutArea.getGrid().getShowGuides()) {
                this.fLayoutArea.getGrid().setShowGuides(this.fShowGuidesState);
                bl = true;
            }
            if (this.fGridWidthState != this.fHRuler.getGridWidth()) {
                this.fHRuler.setGridWidth(this.fGridWidthState);
                this.fVRuler.setGridWidth(this.fGridWidthState);
                this.fLayoutArea.getGrid().setGridWidth(this.fGridWidthState);
                bl = true;
                bl2 = true;
            }
            if (this.fSnapGridState != this.fLayoutArea.getGrid().getSnapToGrid()) {
                this.fLayoutArea.getGrid().setSnapToGrid(this.fSnapGridState);
            }
            if (bl3) {
                this.fLayoutArea.resizeScroller();
                return;
            }
            if (bl) {
                ((Component)((Object)this.fLayoutArea)).repaint(2L);
            }
            if (bl2) {
                ((Component)((Object)this.fHRuler)).repaint(2L);
                ((Component)((Object)this.fVRuler)).repaint(2L);
            }
        }
    }

    public void snapToGridChanged(boolean bl) {
        this.fSnapGridCB.setState(bl);
    }

    private static class ButtonPanel
    extends MWPanel {
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = dimension.width * 5 / 4;
            return dimension;
        }

        ButtonPanel() {
        }
    }
}

