/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.ide.layout.GObjectWrapper;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.lowidgets.LOAxis;
import com.mathworks.ide.layout.proxy.ButtonProxy;
import com.mathworks.ide.layout.proxy.EditProxy;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;

public class GObjectProxy
extends Container {
    static final int STYLE_PUSHBUTTON = 0;
    static final int STYLE_SLIDER = 1;
    static final int STYLE_RADIOBUTTON = 2;
    static final int STYLE_CHECKBOX = 3;
    static final int STYLE_EDIT = 4;
    static final int STYLE_TEXT = 5;
    static final int STYLE_FRAME = 6;
    static final int STYLE_POPUPMENU = 7;
    static final int STYLE_LISTBOX = 8;
    static final int STYLE_TOGGLEBUTTON = 9;
    static final int STYLE_AXES = 10;
    static final int ALIGN_LEFT = -1;
    static final int ALIGN_CENTER = 0;
    static final int ALIGN_RIGHT = 1;
    static final String CONSTRAINTS = "Center";
    private static final String[] DEFAULT_STRING_ARRAY = new String[]{""};
    private static final Font DEFAULT_FONT = new Font("Helvetica", 0, 10);
    private int fStyle;
    private String[] fStringArray;
    private Component fComponent;
    private int fParentHeight;
    private GObjectWrapper fWrapper;
    private boolean fAutoAdjustSizeFirstTime = false;

    public GObjectProxy(int n, String[] stringArray, Object object, double[] dArray) {
        this.init(n, stringArray);
        this.fParentHeight = (int)dArray[0];
        this.updateProxy(object);
    }

    GObjectProxy(int n, String string) {
        String[] stringArray = DEFAULT_STRING_ARRAY;
        if (string != null) {
            stringArray = new String[]{string};
        }
        this.init(n, stringArray);
        this.fComponent.setFont(DEFAULT_FONT);
    }

    private void init(int n, String[] stringArray) {
        this.fStyle = n;
        this.fStringArray = stringArray != null ? stringArray : DEFAULT_STRING_ARRAY;
        this.fComponent = GObjectProxy.buildComponent(this.fStyle, this.fStringArray, 0);
        this.setLayout(new BorderLayout());
        this.add(this.fComponent, CONSTRAINTS);
    }

    public GObjectWrapper getWrapper() {
        return this.fWrapper;
    }

    public void setWrapper(GObjectWrapper gObjectWrapper) {
        this.fWrapper = gObjectWrapper;
        if (this.fWrapper != null) {
            this.fAutoAdjustSizeFirstTime = true;
        }
    }

    int getStyle() {
        return this.fStyle;
    }

    String[] getStringArray() {
        return this.fStringArray;
    }

    String getStyleString() {
        switch (this.fStyle) {
            case 0: {
                return "pushbutton";
            }
            case 1: {
                return "slider";
            }
            case 2: {
                return "radiobutton";
            }
            case 3: {
                return "checkbox";
            }
            case 4: {
                return "edit";
            }
            case 5: {
                return "text";
            }
            case 6: {
                return "frame";
            }
            case 7: {
                return "popupmenu";
            }
            case 8: {
                return "listbox";
            }
            case 9: {
                return "togglebutton";
            }
            case 10: {
                return "axes";
            }
        }
        return null;
    }

    public void updateProxy(Object object) {
        if (object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            switch (this.fStyle) {
                case 10: {
                    this.updateAxes(uDDObject);
                    return;
                }
            }
            this.updateUIControl(uDDObject);
            return;
        }
    }

    void updatePosition(UDDObject uDDObject) {
        int n = 4;
        Object object = uDDObject.getPropertyValue("Units");
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        if (n != 4) {
            uDDObject.setPropertyValue("Units", (Object)new Integer(4));
        }
        Rectangle rectangle = this.getBounds();
        object = uDDObject.getPropertyValue("Position");
        if (object != null && object instanceof HGRectangle) {
            HGRectangle hGRectangle = (HGRectangle)object;
            Container container = this.getParent();
            if (container != null) {
                this.fParentHeight = container.getSize().height;
            }
            rectangle.x = (int)hGRectangle.getX();
            rectangle.y = this.fParentHeight - (int)(hGRectangle.getY() + hGRectangle.getHeight());
            rectangle.width = (int)hGRectangle.getWidth();
            rectangle.height = (int)hGRectangle.getHeight();
        }
        if (n != 4) {
            uDDObject.setPropertyValue("Units", (Object)new Integer(n));
        }
        if (!rectangle.equals(this.getBounds())) {
            this.setBounds(rectangle);
            LayoutArea.forceLayout(this);
        }
    }

    private void updateFont(UDDObject uDDObject) {
        String string = "Helvetica";
        Object object = uDDObject.getPropertyValue("FontName");
        if (object != null && object instanceof String) {
            string = (String)object;
        }
        int n = 0;
        object = uDDObject.getPropertyValue("FontAngle");
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        int n2 = 0;
        object = uDDObject.getPropertyValue("FontWeight");
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        int n3 = 4;
        object = uDDObject.getPropertyValue("FontUnits");
        if (object != null && object instanceof Integer) {
            n3 = (Integer)object;
        }
        if (n3 != 4) {
            uDDObject.setPropertyValue("FontUnits", (Object)new Integer(4));
        }
        int n4 = 10;
        object = uDDObject.getPropertyValue("FontSize");
        if (object != null && object instanceof Double) {
            n4 = Math.round(((Double)object).floatValue());
        }
        if (n3 != 4) {
            uDDObject.setPropertyValue("FontUnits", (Object)new Integer(n3));
        }
        int n5 = (n > 0 ? 2 : 0) + (n2 > 1 ? 1 : 0);
        Font font = new Font(string, n5, n4);
        if (this.fAutoAdjustSizeFirstTime && !this.fComponent.getSize().equals(this.fComponent.getPreferredSize())) {
            this.fAutoAdjustSizeFirstTime = false;
        }
        this.fComponent.setFont(font);
        if (this.fAutoAdjustSizeFirstTime) {
            this.setSize(this.fComponent.getPreferredSize());
            this.fComponent.invalidate();
            this.validate();
            this.fWrapper.updatePosition();
            this.fAutoAdjustSizeFirstTime = false;
        }
    }

    private void updateAxes(UDDObject uDDObject) {
        this.updatePosition(uDDObject);
        this.updateFont(uDDObject);
    }

    private void updateUIControl(UDDObject uDDObject) {
        int n = this.fStyle;
        Object object = uDDObject.getPropertyValue("Style");
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String[] stringArray = this.fStringArray;
        object = uDDObject.getPropertyValue("String");
        if (object instanceof String) {
            stringArray = new String[]{(String)object};
        } else if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        int n2 = 0;
        object = uDDObject.getPropertyValue("HorizontalAlignment");
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object - 1;
        }
        if (this.fStyle != n) {
            this.fStyle = n;
            this.fStringArray = stringArray;
            this.remove(this.fComponent);
            this.fComponent = GObjectProxy.buildComponent(this.fStyle, this.fStringArray, n2);
            this.add(this.fComponent, CONSTRAINTS);
            LayoutArea.forceLayout(this);
        } else {
            this.fStringArray = stringArray;
            GObjectProxy.updateAppearance(this.fComponent, this.fStyle, this.fStringArray, n2);
        }
        double d = (Double)uDDObject.getPropertyValue("Min");
        double[] dArray = (double[])uDDObject.getPropertyValue("Value");
        boolean bl = dArray[0] != d;
        switch (this.fStyle) {
            case 2: 
            case 3: {
                ((MWCheckbox)this.fComponent).setState(bl);
                break;
            }
            case 9: {
                ((ButtonProxy)((Object)this.fComponent)).setState(bl);
                break;
            }
        }
        this.updatePosition(uDDObject);
        this.updateFont(uDDObject);
        object = uDDObject.getPropertyValue("BackgroundColor");
        if (object != null && object instanceof HGColor) {
            this.fComponent.setBackground(HGColor.getColor((HGColor)((HGColor)object)));
        }
        if ((object = uDDObject.getPropertyValue("ForegroundColor")) != null && object instanceof HGColor) {
            this.fComponent.setForeground(HGColor.getColor((HGColor)((HGColor)object)));
        }
    }

    private static Component buildComponent(int n, String[] stringArray, int n2) {
        switch (n) {
            case 0: 
            case 9: {
                ButtonProxy buttonProxy = new ButtonProxy(GObjectProxy.extractString(stringArray));
                switch (n2) {
                    case -1: {
                        buttonProxy.setAlignment(0);
                        break;
                    }
                    case 1: {
                        buttonProxy.setAlignment(2);
                        break;
                    }
                    default: {
                        buttonProxy.setAlignment(1);
                    }
                }
                return buttonProxy;
            }
            case 1: {
                return new ProxyScrollbar();
            }
            case 2: {
                MWCheckbox mWCheckbox = new MWCheckbox(GObjectProxy.extractString(stringArray));
                mWCheckbox.setAppearance(1);
                return mWCheckbox;
            }
            case 3: {
                return new MWCheckbox(GObjectProxy.extractString(stringArray));
            }
            case 4: {
                return new EditProxy(GObjectProxy.extractMultilineString(stringArray));
            }
            case 5: {
                MWLabel mWLabel = new MWLabel(GObjectProxy.extractMultilineString(stringArray));
                switch (n2) {
                    case -1: {
                        mWLabel.setAlignment(0);
                        break;
                    }
                    case 1: {
                        mWLabel.setAlignment(2);
                        break;
                    }
                    default: {
                        mWLabel.setAlignment(1);
                    }
                }
                mWLabel.setVerticalAlignment(0);
                return mWLabel;
            }
            case 6: {
                MWGroupbox mWGroupbox = new MWGroupbox();
                mWGroupbox.setOpaque(true);
                if (PlatformInfo.isUnix()) {
                    mWGroupbox.setStyle(0);
                } else {
                    mWGroupbox.setStyle(4);
                }
                return mWGroupbox;
            }
            case 7: {
                MWChoice mWChoice = new MWChoice();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    mWChoice.add(stringArray[n3]);
                    ++n3;
                }
                return mWChoice;
            }
            case 8: {
                MWListbox mWListbox = new MWListbox();
                mWListbox.setItems(stringArray);
                return mWListbox;
            }
            case 10: {
                return new LOAxis(0.0, 1.0, 0.0, 1.0);
            }
        }
        MWCanvas mWCanvas = new MWCanvas();
        mWCanvas.setBackground(Color.yellow);
        return mWCanvas;
    }

    private static void updateAppearance(Component component, int n, String[] stringArray, int n2) {
        switch (n) {
            case 0: 
            case 9: {
                ButtonProxy buttonProxy = (ButtonProxy)((Object)component);
                int n3 = 1;
                switch (n2) {
                    case -1: {
                        n3 = 0;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                buttonProxy.setLabel(GObjectProxy.extractString(stringArray));
                buttonProxy.setAlignment(n3);
                return;
            }
            case 2: 
            case 3: {
                ((MWCheckbox)component).setLabel(GObjectProxy.extractString(stringArray));
                return;
            }
            case 4: {
                EditProxy editProxy = (EditProxy)((Object)component);
                int n4 = 1;
                switch (n2) {
                    case -1: {
                        n4 = 0;
                        break;
                    }
                    case 1: {
                        n4 = 2;
                        break;
                    }
                }
                editProxy.setText(GObjectProxy.extractMultilineString(stringArray));
                editProxy.setAlignment(n4);
                return;
            }
            case 5: {
                MWLabel mWLabel = (MWLabel)component;
                int n5 = 1;
                switch (n2) {
                    case -1: {
                        n5 = 0;
                        break;
                    }
                    case 1: {
                        n5 = 2;
                        break;
                    }
                }
                mWLabel.setText(GObjectProxy.extractMultilineString(stringArray));
                mWLabel.setAlignment(n5);
                return;
            }
            case 7: {
                MWChoice mWChoice = (MWChoice)component;
                mWChoice.removeAll();
                int n6 = 0;
                while (n6 < stringArray.length) {
                    mWChoice.add(stringArray[n6]);
                    ++n6;
                }
                return;
            }
            case 8: {
                ((MWListbox)component).setItems(stringArray);
                return;
            }
        }
    }

    private static String extractString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return "";
        }
        return stringArray[0];
    }

    private static String extractMultilineString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0] != null ? stringArray[0] : "";
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                string = String.valueOf(string) + "\n" + stringArray[n];
            }
            ++n;
        }
        return string;
    }

    private static class ProxyScrollbar
    extends MWScrollbar {
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (n3 > n4) {
                this.setOrientation(1);
                this.setValue(this.getMinimum());
                return;
            }
            this.setOrientation(0);
            this.setValue(this.getMaximum());
        }

        ProxyScrollbar() {
        }
    }
}

